# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import JobType

if TYPE_CHECKING:
    from .. import models as _models


class AvailableSolutionTemplateVersion(_Model):
    """Available Solution template Version along with latest revision.

    :ivar solution_template_version: Solution template Version. Required.
    :vartype solution_template_version: str
    :ivar latest_config_revision: Latest Configuration Revision. Required.
    :vartype latest_config_revision: str
    :ivar is_configured: Has this solution template version been configured. Required.
    :vartype is_configured: bool
    """

    solution_template_version: str = rest_field(
        name="solutionTemplateVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution template Version. Required."""
    latest_config_revision: str = rest_field(
        name="latestConfigRevision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Latest Configuration Revision. Required."""
    is_configured: bool = rest_field(name="isConfigured", visibility=["read", "create", "update", "delete", "query"])
    """Has this solution template version been configured. Required."""

    @overload
    def __init__(
        self,
        *,
        solution_template_version: str,
        latest_config_revision: str,
        is_configured: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BulkDeploySolutionParameter(_Model):
    """Bulk deploy solution parameter.

    :ivar targets: Targets to which solution needs to be deployed. Required.
    :vartype targets: list[~azure.mgmt.workloadorchestration.models.BulkDeployTargetDetails]
    """

    targets: List["_models.BulkDeployTargetDetails"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Targets to which solution needs to be deployed. Required."""

    @overload
    def __init__(
        self,
        *,
        targets: List["_models.BulkDeployTargetDetails"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BulkDeployTargetDetails(_Model):
    """Bulk deploy target details.

    :ivar solution_version_id: ArmId of Target Solution Version. Required.
    :vartype solution_version_id: str
    """

    solution_version_id: str = rest_field(
        name="solutionVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ArmId of Target Solution Version. Required."""

    @overload
    def __init__(
        self,
        *,
        solution_version_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BulkPublishSolutionParameter(_Model):
    """Bulk publish solution parameter.

    :ivar targets: Targets to which solution needs to be published. Required.
    :vartype targets: list[~azure.mgmt.workloadorchestration.models.BulkPublishTargetDetails]
    :ivar solution_instance_name: Name of the solution instance.
    :vartype solution_instance_name: str
    :ivar solution_dependencies: Solution dependencies.
    :vartype solution_dependencies:
     list[~azure.mgmt.workloadorchestration.models.SolutionDependencyParameter]
    """

    targets: List["_models.BulkPublishTargetDetails"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Targets to which solution needs to be published. Required."""
    solution_instance_name: Optional[str] = rest_field(
        name="solutionInstanceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the solution instance."""
    solution_dependencies: Optional[List["_models.SolutionDependencyParameter"]] = rest_field(
        name="solutionDependencies", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution dependencies."""

    @overload
    def __init__(
        self,
        *,
        targets: List["_models.BulkPublishTargetDetails"],
        solution_instance_name: Optional[str] = None,
        solution_dependencies: Optional[List["_models.SolutionDependencyParameter"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BulkPublishTargetDetails(_Model):
    """Bulk publish target details.

    :ivar target_id: ArmId of Target. Required.
    :vartype target_id: str
    :ivar solution_instance_name: Name of the solution instance.
    :vartype solution_instance_name: str
    """

    target_id: str = rest_field(name="targetId", visibility=["read", "create", "update", "delete", "query"])
    """ArmId of Target. Required."""
    solution_instance_name: Optional[str] = rest_field(
        name="solutionInstanceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the solution instance."""

    @overload
    def __init__(
        self,
        *,
        target_id: str,
        solution_instance_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Capability(_Model):
    """Capability, to match in Solution Templates & Targets.

    :ivar name: Name of Capability. Required.
    :vartype name: str
    :ivar description: Description of Capability. Required.
    :vartype description: str
    :ivar state: State of resource. Known values are: "active" and "inactive".
    :vartype state: str or ~azure.mgmt.workloadorchestration.models.ResourceState
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of Capability. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of Capability. Required."""
    state: Optional[Union[str, "_models.ResourceState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """State of resource. Known values are: \"active\" and \"inactive\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: str,
        state: Optional[Union[str, "_models.ResourceState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ComponentStatus(_Model):
    """Component Status.

    :ivar name: Component name.
    :vartype name: str
    :ivar status: Component status.
    :vartype status: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Component name."""
    status: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Component status."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        status: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfigTemplate(TrackedResource):
    """Config Template Resource. Contains configuration expressions using the predefined expression
    language.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.ConfigTemplateProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.ConfigTemplateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ConfigTemplateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfigTemplateProperties(_Model):
    """Config Template Properties.

    :ivar description: Description of config template. Required.
    :vartype description: str
    :ivar latest_version: Latest config template version.
    :vartype latest_version: str
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of config template. Required."""
    latest_version: Optional[str] = rest_field(name="latestVersion", visibility=["read"])
    """Latest config template version."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        description: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    """


class ConfigTemplateVersion(ProxyResource):
    """Config Template Version Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.ConfigTemplateVersionProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.ConfigTemplateVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ConfigTemplateVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfigTemplateVersionProperties(_Model):
    """Config Template Version Properties.

    :ivar configurations: Configuration values. Required.
    :vartype configurations: str
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    configurations: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Configuration values. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        configurations: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfigTemplateVersionWithUpdateType(_Model):
    """Config Template Version With Update Type.

    :ivar update_type: Update type. Known values are: "Major", "Minor", and "Patch".
    :vartype update_type: str or ~azure.mgmt.workloadorchestration.models.UpdateType
    :ivar version: Version to create.
    :vartype version: str
    :ivar config_template_version: Config Template Version. Required.
    :vartype config_template_version:
     ~azure.mgmt.workloadorchestration.models.ConfigTemplateVersion
    """

    update_type: Optional[Union[str, "_models.UpdateType"]] = rest_field(
        name="updateType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Update type. Known values are: \"Major\", \"Minor\", and \"Patch\"."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version to create."""
    config_template_version: "_models.ConfigTemplateVersion" = rest_field(
        name="configTemplateVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Config Template Version. Required."""

    @overload
    def __init__(
        self,
        *,
        config_template_version: "_models.ConfigTemplateVersion",
        update_type: Optional[Union[str, "_models.UpdateType"]] = None,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Context(TrackedResource):
    """Context Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.ContextProperties
    """

    properties: Optional["_models.ContextProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ContextProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContextProperties(_Model):
    """Context Properties.

    :ivar capabilities: List of Capabilities. Required.
    :vartype capabilities: list[~azure.mgmt.workloadorchestration.models.Capability]
    :ivar hierarchies: List of Hierarchies. Required.
    :vartype hierarchies: list[~azure.mgmt.workloadorchestration.models.Hierarchy]
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    capabilities: List["_models.Capability"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of Capabilities. Required."""
    hierarchies: List["_models.Hierarchy"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of Hierarchies. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        capabilities: List["_models.Capability"],
        hierarchies: List["_models.Hierarchy"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobParameterBase(_Model):
    """Base Job Parameter.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DeployJobParameter

    :ivar job_type: Job type discriminator value. Required. Known values are: "deploy", "staging",
     and "externalValidation".
    :vartype job_type: str or ~azure.mgmt.workloadorchestration.models.JobType
    """

    __mapping__: Dict[str, _Model] = {}
    job_type: str = rest_discriminator(name="jobType", visibility=["read", "create", "update", "delete", "query"])
    """Job type discriminator value. Required. Known values are: \"deploy\", \"staging\", and
     \"externalValidation\"."""

    @overload
    def __init__(
        self,
        *,
        job_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeployJobParameter(JobParameterBase, discriminator="deploy"):
    """Parameters for a deployment job.

    :ivar job_type: Job type discriminator value. Required. A deployment job.
    :vartype job_type: str or ~azure.mgmt.workloadorchestration.models.DEPLOY
    :ivar parameter:
    :vartype parameter: ~azure.mgmt.workloadorchestration.models.InstallSolutionParameter
    """

    job_type: Literal[JobType.DEPLOY] = rest_discriminator(name="jobType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Job type discriminator value. Required. A deployment job."""
    parameter: Optional["_models.InstallSolutionParameter"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        parameter: Optional["_models.InstallSolutionParameter"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, job_type=JobType.DEPLOY, **kwargs)


class JobStepStatisticsBase(_Model):
    """Base Job Step Statistics.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DeployJobStepStatistics

    :ivar statistics_type: Statistics type discriminator value. Required. Known values are:
     "deploy", "staging", and "externalValidation".
    :vartype statistics_type: str or ~azure.mgmt.workloadorchestration.models.JobType
    """

    __mapping__: Dict[str, _Model] = {}
    statistics_type: str = rest_discriminator(
        name="statisticsType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Statistics type discriminator value. Required. Known values are: \"deploy\", \"staging\", and
     \"externalValidation\"."""

    @overload
    def __init__(
        self,
        *,
        statistics_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeployJobStepStatistics(JobStepStatisticsBase, discriminator="deploy"):
    """Deploy statistics for a job step, including total, success, and failed counts.

    :ivar statistics_type: Statistics type discriminator value. Required. A deployment job.
    :vartype statistics_type: str or ~azure.mgmt.workloadorchestration.models.DEPLOY
    :ivar total_count: Total count of items processed in this step.
    :vartype total_count: int
    :ivar success_count: Count of successful items in this step.
    :vartype success_count: int
    :ivar failed_count: Count of failed items in this step.
    :vartype failed_count: int
    """

    statistics_type: Literal[JobType.DEPLOY] = rest_discriminator(name="statisticsType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Statistics type discriminator value. Required. A deployment job."""
    total_count: Optional[int] = rest_field(
        name="totalCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total count of items processed in this step."""
    success_count: Optional[int] = rest_field(
        name="successCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of successful items in this step."""
    failed_count: Optional[int] = rest_field(
        name="failedCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of failed items in this step."""

    @overload
    def __init__(
        self,
        *,
        total_count: Optional[int] = None,
        success_count: Optional[int] = None,
        failed_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, statistics_type=JobType.DEPLOY, **kwargs)


class DeploymentStatus(_Model):
    """Deployment Status.

    :ivar last_modified: The lastModified of the Status.
    :vartype last_modified: ~datetime.datetime
    :ivar deployed: Indicates if Instance is deployed.
    :vartype deployed: int
    :ivar expected_running_job_id: The expected running job id.
    :vartype expected_running_job_id: int
    :ivar running_job_id: The running job id.
    :vartype running_job_id: int
    :ivar status: Deployment status.
    :vartype status: str
    :ivar status_details: Status details.
    :vartype status_details: str
    :ivar generation: Deployment Generation.
    :vartype generation: int
    :ivar target_statuses: Target resource statuses.
    :vartype target_statuses: list[~azure.mgmt.workloadorchestration.models.TargetStatus]
    """

    last_modified: Optional[datetime.datetime] = rest_field(
        name="lastModified", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The lastModified of the Status."""
    deployed: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates if Instance is deployed."""
    expected_running_job_id: Optional[int] = rest_field(
        name="expectedRunningJobId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The expected running job id."""
    running_job_id: Optional[int] = rest_field(
        name="runningJobId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The running job id."""
    status: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Deployment status."""
    status_details: Optional[str] = rest_field(
        name="statusDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Status details."""
    generation: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Deployment Generation."""
    target_statuses: Optional[List["_models.TargetStatus"]] = rest_field(
        name="targetStatuses", visibility=["read", "create", "update", "delete", "query"]
    )
    """Target resource statuses."""

    @overload
    def __init__(
        self,
        *,
        last_modified: Optional[datetime.datetime] = None,
        deployed: Optional[int] = None,
        expected_running_job_id: Optional[int] = None,
        running_job_id: Optional[int] = None,
        status: Optional[str] = None,
        status_details: Optional[str] = None,
        generation: Optional[int] = None,
        target_statuses: Optional[List["_models.TargetStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Diagnostic(TrackedResource):
    """A Diagnostic resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.DiagnosticProperties
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.workloadorchestration.models.ExtendedLocation
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.DiagnosticProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.DiagnosticProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiagnosticProperties(_Model):
    """The properties of a Diagnostic resource.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""


class DynamicSchema(ProxyResource):
    """DynamicSchema Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.DynamicSchemaProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.DynamicSchemaProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DynamicSchemaProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DynamicSchemaProperties(_Model):
    """DynamicSchema Properties.

    :ivar configuration_type: Type of configuration. Known values are: "Shared" and "Hierarchy".
    :vartype configuration_type: str or ~azure.mgmt.workloadorchestration.models.ConfigurationType
    :ivar configuration_model: Type of configuration model. Known values are: "Application" and
     "Common".
    :vartype configuration_model: str or
     ~azure.mgmt.workloadorchestration.models.ConfigurationModel
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = rest_field(
        name="configurationType", visibility=["read"]
    )
    """Type of configuration. Known values are: \"Shared\" and \"Hierarchy\"."""
    configuration_model: Optional[Union[str, "_models.ConfigurationModel"]] = rest_field(
        name="configurationModel", visibility=["read"]
    )
    """Type of configuration model. Known values are: \"Application\" and \"Common\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""


class DynamicSchemaVersion(ProxyResource):
    """Dynamic Schema Version Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.SchemaVersionProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.SchemaVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SchemaVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAction(_Model):
    """Error Action Properties.

    :ivar mode: Error action mode. Known values are: "stopOnAnyFailure", "stopOnNFailures", and
     "silentlyContinue".
    :vartype mode: str or ~azure.mgmt.workloadorchestration.models.ErrorActionMode
    :ivar max_tolerated_failures: Max tolerated failures.
    :vartype max_tolerated_failures: int
    """

    mode: Optional[Union[str, "_models.ErrorActionMode"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Error action mode. Known values are: \"stopOnAnyFailure\", \"stopOnNFailures\", and
     \"silentlyContinue\"."""
    max_tolerated_failures: Optional[int] = rest_field(
        name="maxToleratedFailures", visibility=["read", "create", "update", "delete", "query"]
    )
    """Max tolerated failures."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.ErrorActionMode"]] = None,
        max_tolerated_failures: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.workloadorchestration.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.workloadorchestration.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.workloadorchestration.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Execution(ProxyResource):
    """Execution Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.ExecutionProperties
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.workloadorchestration.models.ExtendedLocation
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.ExecutionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ExecutionProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExecutionProperties(_Model):
    """Execution Properties.

    :ivar workflow_version_id: Workflow version of execution. Required.
    :vartype workflow_version_id: str
    :ivar specification: Execution specification.
    :vartype specification: dict[str, any]
    :ivar status: Status of Execution.
    :vartype status: ~azure.mgmt.workloadorchestration.models.ExecutionStatus
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    workflow_version_id: str = rest_field(
        name="workflowVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Workflow version of execution. Required."""
    specification: Optional[Dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Execution specification."""
    status: Optional["_models.ExecutionStatus"] = rest_field(visibility=["read"])
    """Status of Execution."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        workflow_version_id: str,
        specification: Optional[Dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExecutionStatus(_Model):
    """Execution Status.

    :ivar update_time: The lastModified timestamp of the Status.
    :vartype update_time: ~datetime.datetime
    :ivar status: Deployment status.
    :vartype status: int
    :ivar status_message: status details.
    :vartype status_message: str
    :ivar stage_history: target resource statuses.
    :vartype stage_history: list[~azure.mgmt.workloadorchestration.models.StageStatus]
    """

    update_time: Optional[datetime.datetime] = rest_field(
        name="updateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The lastModified timestamp of the Status."""
    status: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Deployment status."""
    status_message: Optional[str] = rest_field(
        name="statusMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """status details."""
    stage_history: Optional[List["_models.StageStatus"]] = rest_field(
        name="stageHistory", visibility=["read", "create", "update", "delete", "query"]
    )
    """target resource statuses."""

    @overload
    def __init__(
        self,
        *,
        update_time: Optional[datetime.datetime] = None,
        status: Optional[int] = None,
        status_message: Optional[str] = None,
        stage_history: Optional[List["_models.StageStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExtendedLocation(_Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location. Required.
    :vartype name: str
    :ivar type: The type of the extended location. Required. Known values are: "EdgeZone" and
     "CustomLocation".
    :vartype type: str or ~azure.mgmt.workloadorchestration.models.ExtendedLocationType
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the extended location. Required."""
    type: Union[str, "_models.ExtendedLocationType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the extended location. Required. Known values are: \"EdgeZone\" and
     \"CustomLocation\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.ExtendedLocationType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExtensionResource(Resource):
    """The base extension resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    """


class Hierarchy(_Model):
    """Hierarchy, to tag Sites / Hierarchy Provider nodes with what they represent.

    :ivar name: Name of Hierarchy. Required.
    :vartype name: str
    :ivar description: Description of Hierarchy. Required.
    :vartype description: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of Hierarchy. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of Hierarchy. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstallSolutionParameter(_Model):
    """Install Solution Parameter.

    :ivar solution_version_id: Solution Version ARM Id. Required.
    :vartype solution_version_id: str
    """

    solution_version_id: str = rest_field(
        name="solutionVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Version ARM Id. Required."""

    @overload
    def __init__(
        self,
        *,
        solution_version_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Instance(ProxyResource):
    """Instance Resource. Represents a deployment object.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.InstanceProperties
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.workloadorchestration.models.ExtendedLocation
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.InstanceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.InstanceProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstanceHistory(ProxyResource):
    """InstanceHistory Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.InstanceHistoryProperties
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.workloadorchestration.models.ExtendedLocation
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.InstanceHistoryProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.InstanceHistoryProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstanceHistoryProperties(_Model):
    """Instance History Properties.

    :ivar solution_version: Solution version of instance. Required.
    :vartype solution_version: ~azure.mgmt.workloadorchestration.models.SolutionVersionSnapshot
    :ivar target: Target of instance. Required.
    :vartype target: ~azure.mgmt.workloadorchestration.models.TargetSnapshot
    :ivar solution_scope: Scope of instance.
    :vartype solution_scope: str
    :ivar active_state: State of instance. Known values are: "active" and "inactive".
    :vartype active_state: str or ~azure.mgmt.workloadorchestration.models.ActiveState
    :ivar reconciliation_policy: Reconciliation policy of instance.
    :vartype reconciliation_policy:
     ~azure.mgmt.workloadorchestration.models.ReconciliationPolicyProperties
    :ivar status: Deployment Status of instance.
    :vartype status: ~azure.mgmt.workloadorchestration.models.DeploymentStatus
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    solution_version: "_models.SolutionVersionSnapshot" = rest_field(name="solutionVersion", visibility=["read"])
    """Solution version of instance. Required."""
    target: "_models.TargetSnapshot" = rest_field(visibility=["read"])
    """Target of instance. Required."""
    solution_scope: Optional[str] = rest_field(name="solutionScope", visibility=["read"])
    """Scope of instance."""
    active_state: Optional[Union[str, "_models.ActiveState"]] = rest_field(
        name="activeState", visibility=["read", "create", "update", "delete", "query"]
    )
    """State of instance. Known values are: \"active\" and \"inactive\"."""
    reconciliation_policy: Optional["_models.ReconciliationPolicyProperties"] = rest_field(
        name="reconciliationPolicy", visibility=["read"]
    )
    """Reconciliation policy of instance."""
    status: Optional["_models.DeploymentStatus"] = rest_field(visibility=["read"])
    """Deployment Status of instance."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        active_state: Optional[Union[str, "_models.ActiveState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstanceProperties(_Model):
    """Instance Properties.

    :ivar solution_version_id: Solution version of instance. Required.
    :vartype solution_version_id: str
    :ivar target_id: Target of instance. Required.
    :vartype target_id: str
    :ivar active_state: State of instance. Known values are: "active" and "inactive".
    :vartype active_state: str or ~azure.mgmt.workloadorchestration.models.ActiveState
    :ivar reconciliation_policy: Reconciliation policy of instance.
    :vartype reconciliation_policy:
     ~azure.mgmt.workloadorchestration.models.ReconciliationPolicyProperties
    :ivar solution_scope: Scope of instance.
    :vartype solution_scope: str
    :ivar status: Status of instance.
    :vartype status: ~azure.mgmt.workloadorchestration.models.DeploymentStatus
    :ivar deployment_timestamp_epoch: Deployment timestamp of instance.
    :vartype deployment_timestamp_epoch: int
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    solution_version_id: str = rest_field(
        name="solutionVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution version of instance. Required."""
    target_id: str = rest_field(name="targetId", visibility=["read", "create", "update", "delete", "query"])
    """Target of instance. Required."""
    active_state: Optional[Union[str, "_models.ActiveState"]] = rest_field(
        name="activeState", visibility=["read", "create", "update", "delete", "query"]
    )
    """State of instance. Known values are: \"active\" and \"inactive\"."""
    reconciliation_policy: Optional["_models.ReconciliationPolicyProperties"] = rest_field(
        name="reconciliationPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reconciliation policy of instance."""
    solution_scope: Optional[str] = rest_field(
        name="solutionScope", visibility=["read", "create", "update", "delete", "query"]
    )
    """Scope of instance."""
    status: Optional["_models.DeploymentStatus"] = rest_field(visibility=["read"])
    """Status of instance."""
    deployment_timestamp_epoch: Optional[int] = rest_field(name="deploymentTimestampEpoch", visibility=["read"])
    """Deployment timestamp of instance."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        solution_version_id: str,
        target_id: str,
        active_state: Optional[Union[str, "_models.ActiveState"]] = None,
        reconciliation_policy: Optional["_models.ReconciliationPolicyProperties"] = None,
        solution_scope: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Job(ExtensionResource):
    """Job extension resource for tracking job execution and substatuses.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.JobProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.JobProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.JobProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobProperties(_Model):
    """Properties of a Job resource, including type, status, parameters, steps, and error details.

    :ivar job_type: The type of job. Required. Known values are: "deploy", "staging", and
     "externalValidation".
    :vartype job_type: str or ~azure.mgmt.workloadorchestration.models.JobType
    :ivar start_time: Start time of the job (ISO8601).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the job (ISO8601).
    :vartype end_time: ~datetime.datetime
    :ivar status: Status of the job. Required. Known values are: "NotStarted", "InProgress",
     "Succeeded", and "Failed".
    :vartype status: str or ~azure.mgmt.workloadorchestration.models.JobStatus
    :ivar job_parameter: Parameters for the job.
    :vartype job_parameter: ~azure.mgmt.workloadorchestration.models.JobParameterBase
    :ivar correlation_id: Correlation ID for tracking.
    :vartype correlation_id: str
    :ivar steps: Steps and substatuses for the job.
    :vartype steps: list[~azure.mgmt.workloadorchestration.models.JobStep]
    :ivar triggered_by: The OID or identity that triggered the job.
    :vartype triggered_by: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    :ivar error_details: Error Details if any failure is there.
    :vartype error_details: ~azure.mgmt.workloadorchestration.models.ErrorDetail
    """

    job_type: Union[str, "_models.JobType"] = rest_field(
        name="jobType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of job. Required. Known values are: \"deploy\", \"staging\", and
     \"externalValidation\"."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time of the job (ISO8601)."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time of the job (ISO8601)."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Status of the job. Required. Known values are: \"NotStarted\", \"InProgress\", \"Succeeded\",
     and \"Failed\"."""
    job_parameter: Optional["_models.JobParameterBase"] = rest_field(
        name="jobParameter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters for the job."""
    correlation_id: Optional[str] = rest_field(
        name="correlationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Correlation ID for tracking."""
    steps: Optional[List["_models.JobStep"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Steps and substatuses for the job."""
    triggered_by: Optional[str] = rest_field(
        name="triggeredBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The OID or identity that triggered the job."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""
    error_details: Optional["_models.ErrorDetail"] = rest_field(name="errorDetails", visibility=["read"])
    """Error Details if any failure is there."""

    @overload
    def __init__(
        self,
        *,
        job_type: Union[str, "_models.JobType"],
        status: Union[str, "_models.JobStatus"],
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        job_parameter: Optional["_models.JobParameterBase"] = None,
        correlation_id: Optional[str] = None,
        steps: Optional[List["_models.JobStep"]] = None,
        triggered_by: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobStep(_Model):
    """Job Step.

    :ivar name: Name of the step. Required.
    :vartype name: str
    :ivar status: Status of the step. Required. Known values are: "NotStarted", "InProgress",
     "Succeeded", and "Failed".
    :vartype status: str or ~azure.mgmt.workloadorchestration.models.JobStatus
    :ivar start_time: Start time of the step (ISO8601).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the step (ISO8601).
    :vartype end_time: ~datetime.datetime
    :ivar message: Message for the step.
    :vartype message: str
    :ivar statistics: Statistics for the step.
    :vartype statistics: ~azure.mgmt.workloadorchestration.models.JobStepStatisticsBase
    :ivar steps: Nested substeps for this step.
    :vartype steps: list[~azure.mgmt.workloadorchestration.models.JobStep]
    :ivar error_details: Error Details if any failure is there.
    :vartype error_details: ~azure.mgmt.workloadorchestration.models.ErrorDetail
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the step. Required."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Status of the step. Required. Known values are: \"NotStarted\", \"InProgress\", \"Succeeded\",
     and \"Failed\"."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time of the step (ISO8601)."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time of the step (ISO8601)."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Message for the step."""
    statistics: Optional["_models.JobStepStatisticsBase"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Statistics for the step."""
    steps: Optional[List["_models.JobStep"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Nested substeps for this step."""
    error_details: Optional["_models.ErrorDetail"] = rest_field(name="errorDetails", visibility=["read"])
    """Error Details if any failure is there."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        status: Union[str, "_models.JobStatus"],
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        statistics: Optional["_models.JobStepStatisticsBase"] = None,
        steps: Optional[List["_models.JobStep"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReconciliationPolicyProperties(_Model):
    """Defines a ReconciliationPolicy.

    :ivar state: The state of the ReconciliationPolicy. Required. Known values are: "inactive" and
     "active".
    :vartype state: str or ~azure.mgmt.workloadorchestration.models.ReconciliationState
    :ivar interval: Policy interval. Required.
    :vartype interval: str
    """

    state: Union[str, "_models.ReconciliationState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The state of the ReconciliationPolicy. Required. Known values are: \"inactive\" and \"active\"."""
    interval: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Policy interval. Required."""

    @overload
    def __init__(
        self,
        *,
        state: Union[str, "_models.ReconciliationState"],
        interval: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RemoveRevisionParameter(_Model):
    """Install Solution Parameter.

    :ivar solution_template_id: Solution Template ARM Id. Required.
    :vartype solution_template_id: str
    :ivar solution_version: Solution Version Name. Required.
    :vartype solution_version: str
    """

    solution_template_id: str = rest_field(
        name="solutionTemplateId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Template ARM Id. Required."""
    solution_version: str = rest_field(
        name="solutionVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Version Name. Required."""

    @overload
    def __init__(
        self,
        *,
        solution_template_id: str,
        solution_version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RemoveVersionResponse(_Model):
    """Remove Version response.

    :ivar status: Status for remove version response. Required.
    :vartype status: str
    """

    status: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Status for remove version response. Required."""

    @overload
    def __init__(
        self,
        *,
        status: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResolvedConfiguration(_Model):
    """Resolved Configuration.

    :ivar configuration: Resolved Configuration as string. Required.
    :vartype configuration: str
    """

    configuration: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resolved Configuration as string. Required."""

    @overload
    def __init__(
        self,
        *,
        configuration: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Schema(TrackedResource):
    """Schema Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.SchemaProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.SchemaProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SchemaProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SchemaProperties(_Model):
    """Schema Properties.

    :ivar current_version: Current Version of schema.
    :vartype current_version: str
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    current_version: Optional[str] = rest_field(name="currentVersion", visibility=["read"])
    """Current Version of schema."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""


class SchemaReference(ExtensionResource):
    """Schema Reference Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.SchemaReferenceProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.SchemaReferenceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SchemaReferenceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SchemaReferenceProperties(_Model):
    """Schema Reference Properties.

    :ivar schema_id: Schema Id of schema reference. Required.
    :vartype schema_id: str
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    schema_id: str = rest_field(name="schemaId", visibility=["read", "create", "update", "delete", "query"])
    """Schema Id of schema reference. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        schema_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SchemaVersion(ProxyResource):
    """Schema Version Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.SchemaVersionProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.SchemaVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SchemaVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SchemaVersionProperties(_Model):
    """Schema Version Properties.

    :ivar value: Value of schema version. Required.
    :vartype value: str
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Value of schema version. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SchemaVersionWithUpdateType(_Model):
    """Schema Version With Update Type.

    :ivar update_type: Update type. Known values are: "Major", "Minor", and "Patch".
    :vartype update_type: str or ~azure.mgmt.workloadorchestration.models.UpdateType
    :ivar version: Version to create.
    :vartype version: str
    :ivar schema_version: Schema Version. Required.
    :vartype schema_version: ~azure.mgmt.workloadorchestration.models.SchemaVersion
    """

    update_type: Optional[Union[str, "_models.UpdateType"]] = rest_field(
        name="updateType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Update type. Known values are: \"Major\", \"Minor\", and \"Patch\"."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version to create."""
    schema_version: "_models.SchemaVersion" = rest_field(
        name="schemaVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Schema Version. Required."""

    @overload
    def __init__(
        self,
        *,
        schema_version: "_models.SchemaVersion",
        update_type: Optional[Union[str, "_models.UpdateType"]] = None,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SiteReference(ProxyResource):
    """Site Reference Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.SiteReferenceProperties
    """

    properties: Optional["_models.SiteReferenceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SiteReferenceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SiteReferenceProperties(_Model):
    """Site Reference Properties.

    :ivar site_id: Azure Resource ID for Site. Required.
    :vartype site_id: str
    :ivar provisioning_state: Provisioning State. Known values are: "Succeeded", "Failed",
     "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    site_id: str = rest_field(name="siteId", visibility=["read", "create", "update", "delete", "query"])
    """Azure Resource ID for Site. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State. Known values are: \"Succeeded\", \"Failed\", \"Canceled\", \"Initialized\",
     \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        site_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Solution(ProxyResource):
    """Solution Resource attached to a Target.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.SolutionProperties
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.workloadorchestration.models.ExtendedLocation
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.SolutionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SolutionProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionDependency(_Model):
    """Solution Dependency Context.

    :ivar solution_version_id: Solution Version Id. Required.
    :vartype solution_version_id: str
    :ivar solution_instance_name: Solution Instance Name.
    :vartype solution_instance_name: str
    :ivar solution_template_version_id: Solution Template Version Id. Required.
    :vartype solution_template_version_id: str
    :ivar target_id: Target Id. Required.
    :vartype target_id: str
    :ivar dependencies: Solution dependencies.
    :vartype dependencies: list[~azure.mgmt.workloadorchestration.models.SolutionDependency]
    """

    solution_version_id: str = rest_field(
        name="solutionVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Version Id. Required."""
    solution_instance_name: Optional[str] = rest_field(
        name="solutionInstanceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Instance Name."""
    solution_template_version_id: str = rest_field(
        name="solutionTemplateVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Template Version Id. Required."""
    target_id: str = rest_field(name="targetId", visibility=["read", "create", "update", "delete", "query"])
    """Target Id. Required."""
    dependencies: Optional[List["_models.SolutionDependency"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution dependencies."""

    @overload
    def __init__(
        self,
        *,
        solution_version_id: str,
        solution_template_version_id: str,
        target_id: str,
        solution_instance_name: Optional[str] = None,
        dependencies: Optional[List["_models.SolutionDependency"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionDependencyParameter(_Model):
    """Solution Dependency Context.

    :ivar solution_version_id: Solution Version Id.
    :vartype solution_version_id: str
    :ivar solution_template_id: Solution Template Id.
    :vartype solution_template_id: str
    :ivar solution_template_version: Solution Template Version.
    :vartype solution_template_version: str
    :ivar solution_instance_name: Solution Instance Name.
    :vartype solution_instance_name: str
    :ivar target_id: Target Id.
    :vartype target_id: str
    :ivar dependencies: Solution dependencies.
    :vartype dependencies:
     list[~azure.mgmt.workloadorchestration.models.SolutionDependencyParameter]
    """

    solution_version_id: Optional[str] = rest_field(
        name="solutionVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Version Id."""
    solution_template_id: Optional[str] = rest_field(
        name="solutionTemplateId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Template Id."""
    solution_template_version: Optional[str] = rest_field(
        name="solutionTemplateVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Template Version."""
    solution_instance_name: Optional[str] = rest_field(
        name="solutionInstanceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Instance Name."""
    target_id: Optional[str] = rest_field(name="targetId", visibility=["read", "create", "update", "delete", "query"])
    """Target Id."""
    dependencies: Optional[List["_models.SolutionDependencyParameter"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution dependencies."""

    @overload
    def __init__(
        self,
        *,
        solution_version_id: Optional[str] = None,
        solution_template_id: Optional[str] = None,
        solution_template_version: Optional[str] = None,
        solution_instance_name: Optional[str] = None,
        target_id: Optional[str] = None,
        dependencies: Optional[List["_models.SolutionDependencyParameter"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionProperties(_Model):
    """Solution Properties.

    :ivar solution_template_id: Solution template Id.
    :vartype solution_template_id: str
    :ivar available_solution_template_versions: List of latest revisions for available solution
     template versions.
    :vartype available_solution_template_versions:
     list[~azure.mgmt.workloadorchestration.models.AvailableSolutionTemplateVersion]
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    solution_template_id: Optional[str] = rest_field(name="solutionTemplateId", visibility=["read"])
    """Solution template Id."""
    available_solution_template_versions: Optional[List["_models.AvailableSolutionTemplateVersion"]] = rest_field(
        name="availableSolutionTemplateVersions", visibility=["read"]
    )
    """List of latest revisions for available solution template versions."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""


class SolutionTemplate(TrackedResource):
    """Solution Template Resource. Contains capabilities and operations for creating versions.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.SolutionTemplateProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.SolutionTemplateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SolutionTemplateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionTemplateParameter(_Model):
    """Solution Template Parameter.

    :ivar solution_template_version_id: Solution Template Version ARM Id. Required.
    :vartype solution_template_version_id: str
    :ivar solution_instance_name: Solution Instance Name.
    :vartype solution_instance_name: str
    :ivar solution_dependencies: Solution Dependencies.
    :vartype solution_dependencies:
     list[~azure.mgmt.workloadorchestration.models.SolutionDependencyParameter]
    """

    solution_template_version_id: str = rest_field(
        name="solutionTemplateVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Template Version ARM Id. Required."""
    solution_instance_name: Optional[str] = rest_field(
        name="solutionInstanceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Instance Name."""
    solution_dependencies: Optional[List["_models.SolutionDependencyParameter"]] = rest_field(
        name="solutionDependencies", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Dependencies."""

    @overload
    def __init__(
        self,
        *,
        solution_template_version_id: str,
        solution_instance_name: Optional[str] = None,
        solution_dependencies: Optional[List["_models.SolutionDependencyParameter"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionTemplateProperties(_Model):
    """Solution Template Properties.

    :ivar description: Description of Solution template. Required.
    :vartype description: str
    :ivar capabilities: List of capabilities. Required.
    :vartype capabilities: list[str]
    :ivar latest_version: Latest solution template version.
    :vartype latest_version: str
    :ivar state: State of resource. Known values are: "active" and "inactive".
    :vartype state: str or ~azure.mgmt.workloadorchestration.models.ResourceState
    :ivar enable_external_validation: Flag to enable external validation.
    :vartype enable_external_validation: bool
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of Solution template. Required."""
    capabilities: List[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of capabilities. Required."""
    latest_version: Optional[str] = rest_field(name="latestVersion", visibility=["read"])
    """Latest solution template version."""
    state: Optional[Union[str, "_models.ResourceState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """State of resource. Known values are: \"active\" and \"inactive\"."""
    enable_external_validation: Optional[bool] = rest_field(
        name="enableExternalValidation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag to enable external validation."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        capabilities: List[str],
        state: Optional[Union[str, "_models.ResourceState"]] = None,
        enable_external_validation: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionTemplateVersion(ProxyResource):
    """Solution Template Version Resource. Contains configurations that use expressions which can be
    resolved hierarchically along with edge specifications.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.SolutionTemplateVersionProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.SolutionTemplateVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SolutionTemplateVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionTemplateVersionProperties(_Model):
    """Solution Template Version Properties.

    :ivar configurations: Config expressions for this solution version. Required.
    :vartype configurations: str
    :ivar specification: App components spec. Required.
    :vartype specification: dict[str, any]
    :ivar orchestrator_type: Orchestrator type. "TO"
    :vartype orchestrator_type: str or ~azure.mgmt.workloadorchestration.models.OrchestratorType
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    configurations: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Config expressions for this solution version. Required."""
    specification: Dict[str, Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """App components spec. Required."""
    orchestrator_type: Optional[Union[str, "_models.OrchestratorType"]] = rest_field(
        name="orchestratorType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Orchestrator type. \"TO\""""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        configurations: str,
        specification: Dict[str, Any],
        orchestrator_type: Optional[Union[str, "_models.OrchestratorType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionTemplateVersionWithUpdateType(_Model):
    """Solution Template Version With Update Type.

    :ivar update_type: Update type. Known values are: "Major", "Minor", and "Patch".
    :vartype update_type: str or ~azure.mgmt.workloadorchestration.models.UpdateType
    :ivar version: Version to create.
    :vartype version: str
    :ivar solution_template_version: Solution Template Version. Required.
    :vartype solution_template_version:
     ~azure.mgmt.workloadorchestration.models.SolutionTemplateVersion
    """

    update_type: Optional[Union[str, "_models.UpdateType"]] = rest_field(
        name="updateType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Update type. Known values are: \"Major\", \"Minor\", and \"Patch\"."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version to create."""
    solution_template_version: "_models.SolutionTemplateVersion" = rest_field(
        name="solutionTemplateVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Template Version. Required."""

    @overload
    def __init__(
        self,
        *,
        solution_template_version: "_models.SolutionTemplateVersion",
        update_type: Optional[Union[str, "_models.UpdateType"]] = None,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionVersion(ProxyResource):
    """Solution Version Resource. It has the resolved configuration along with edge specification.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.SolutionVersionProperties
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.workloadorchestration.models.ExtendedLocation
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.SolutionVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SolutionVersionProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionVersionParameter(_Model):
    """Solution Version Parameter.

    :ivar solution_version_id: Solution Version ARM Id. Required.
    :vartype solution_version_id: str
    """

    solution_version_id: str = rest_field(
        name="solutionVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Version ARM Id. Required."""

    @overload
    def __init__(
        self,
        *,
        solution_version_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionVersionProperties(_Model):
    """Solution Version Properties.

    :ivar solution_template_version_id: Solution Template Version Id.
    :vartype solution_template_version_id: str
    :ivar revision: Revision number of resolved config for this solution version.
    :vartype revision: int
    :ivar target_display_name: Name of applicable target's display name.
    :vartype target_display_name: str
    :ivar configuration: Resolved configuration values.
    :vartype configuration: str
    :ivar target_level_configuration: Configuration on the line level across all solution template
     versions.
    :vartype target_level_configuration: str
    :ivar specification: App components spec. Required.
    :vartype specification: dict[str, any]
    :ivar review_id: Review id of resolved config for this solution version.
    :vartype review_id: str
    :ivar external_validation_id: External validation id.
    :vartype external_validation_id: str
    :ivar state: State of solution instance. Known values are: "InReview", "UpgradeInReview",
     "ReadyToDeploy", "ReadyToUpgrade", "Deploying", "Deployed", "Failed", "Undeployed",
     "PendingExternalValidation", "ExternalValidationFailed", and "Staging".
    :vartype state: str or ~azure.mgmt.workloadorchestration.models.State
    :ivar solution_instance_name: Solution instance name.
    :vartype solution_instance_name: str
    :ivar solution_dependencies: Solution Dependency Context.
    :vartype solution_dependencies:
     list[~azure.mgmt.workloadorchestration.models.SolutionDependency]
    :ivar error_details: Error Details if any failure is there.
    :vartype error_details: ~azure.mgmt.workloadorchestration.models.ErrorDetail
    :ivar latest_action_tracking_uri: The URI for tracking the latest action performed on this
     solution version.
    :vartype latest_action_tracking_uri: str
    :ivar action_type: The type of the latest action performed on this solution version. Known
     values are: "deploy", "staging", and "externalValidation".
    :vartype action_type: str or ~azure.mgmt.workloadorchestration.models.JobType
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    solution_template_version_id: Optional[str] = rest_field(name="solutionTemplateVersionId", visibility=["read"])
    """Solution Template Version Id."""
    revision: Optional[int] = rest_field(visibility=["read"])
    """Revision number of resolved config for this solution version."""
    target_display_name: Optional[str] = rest_field(name="targetDisplayName", visibility=["read"])
    """Name of applicable target's display name."""
    configuration: Optional[str] = rest_field(visibility=["read"])
    """Resolved configuration values."""
    target_level_configuration: Optional[str] = rest_field(name="targetLevelConfiguration", visibility=["read"])
    """Configuration on the line level across all solution template versions."""
    specification: Dict[str, Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """App components spec. Required."""
    review_id: Optional[str] = rest_field(name="reviewId", visibility=["read"])
    """Review id of resolved config for this solution version."""
    external_validation_id: Optional[str] = rest_field(name="externalValidationId", visibility=["read"])
    """External validation id."""
    state: Optional[Union[str, "_models.State"]] = rest_field(visibility=["read"])
    """State of solution instance. Known values are: \"InReview\", \"UpgradeInReview\",
     \"ReadyToDeploy\", \"ReadyToUpgrade\", \"Deploying\", \"Deployed\", \"Failed\", \"Undeployed\",
     \"PendingExternalValidation\", \"ExternalValidationFailed\", and \"Staging\"."""
    solution_instance_name: Optional[str] = rest_field(name="solutionInstanceName", visibility=["read"])
    """Solution instance name."""
    solution_dependencies: Optional[List["_models.SolutionDependency"]] = rest_field(
        name="solutionDependencies", visibility=["read"]
    )
    """Solution Dependency Context."""
    error_details: Optional["_models.ErrorDetail"] = rest_field(name="errorDetails", visibility=["read"])
    """Error Details if any failure is there."""
    latest_action_tracking_uri: Optional[str] = rest_field(name="latestActionTrackingUri", visibility=["read"])
    """The URI for tracking the latest action performed on this solution version."""
    action_type: Optional[Union[str, "_models.JobType"]] = rest_field(name="actionType", visibility=["read"])
    """The type of the latest action performed on this solution version. Known values are: \"deploy\",
     \"staging\", and \"externalValidation\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        specification: Dict[str, Any],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionVersionSnapshot(_Model):
    """Solution Version Snapshot.

    :ivar solution_version_id: Solution version of instance.
    :vartype solution_version_id: str
    :ivar specification: App components spec.
    :vartype specification: dict[str, any]
    """

    solution_version_id: Optional[str] = rest_field(
        name="solutionVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution version of instance."""
    specification: Optional[Dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """App components spec."""

    @overload
    def __init__(
        self,
        *,
        solution_version_id: Optional[str] = None,
        specification: Optional[Dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StageSpec(_Model):
    """Stage Properties.

    :ivar name: Name of Stage. Required.
    :vartype name: str
    :ivar specification: Stage specification.
    :vartype specification: dict[str, any]
    :ivar tasks: List of tasks in the stage.
    :vartype tasks: list[~azure.mgmt.workloadorchestration.models.TaskSpec]
    :ivar task_option: Task option for the stage.
    :vartype task_option: ~azure.mgmt.workloadorchestration.models.TaskOption
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of Stage. Required."""
    specification: Optional[Dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Stage specification."""
    tasks: Optional[List["_models.TaskSpec"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of tasks in the stage."""
    task_option: Optional["_models.TaskOption"] = rest_field(
        name="taskOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Task option for the stage."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        specification: Optional[Dict[str, Any]] = None,
        tasks: Optional[List["_models.TaskSpec"]] = None,
        task_option: Optional["_models.TaskOption"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StageStatus(_Model):
    """Result of Stage execution.

    :ivar status: Deployment status.
    :vartype status: int
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar stage: Current stage.
    :vartype stage: str
    :ivar nextstage: Next stage.
    :vartype nextstage: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar is_active: whether this stage is active or inactive. Known values are: "active" and
     "inactive".
    :vartype is_active: str or ~azure.mgmt.workloadorchestration.models.ActiveState
    :ivar inputs: The inputs of the StageHistory, Inputs holds a key-value map of user-defined
     parameters for the initial stage.
    :vartype inputs: dict[str, any]
    :ivar outputs: The outputs of the StageHistory, it is different as the different input stages.
    :vartype outputs: dict[str, any]
    """

    status: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Deployment status."""
    status_message: Optional[str] = rest_field(
        name="statusMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Status message."""
    stage: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Current stage."""
    nextstage: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Next stage."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Error message."""
    is_active: Optional[Union[str, "_models.ActiveState"]] = rest_field(
        name="isActive", visibility=["read", "create", "update", "delete", "query"]
    )
    """whether this stage is active or inactive. Known values are: \"active\" and \"inactive\"."""
    inputs: Optional[Dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The inputs of the StageHistory, Inputs holds a key-value map of user-defined parameters for the
     initial stage."""
    outputs: Optional[Dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The outputs of the StageHistory, it is different as the different input stages."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[int] = None,
        status_message: Optional[str] = None,
        stage: Optional[str] = None,
        nextstage: Optional[str] = None,
        error_message: Optional[str] = None,
        is_active: Optional[Union[str, "_models.ActiveState"]] = None,
        inputs: Optional[Dict[str, Any]] = None,
        outputs: Optional[Dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.workloadorchestration.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.workloadorchestration.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Target(TrackedResource):
    """Target Resource. Represents a resource to be deployed on the edge.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.TargetProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.workloadorchestration.models.ExtendedLocation
    """

    properties: Optional["_models.TargetProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.TargetProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetProperties(_Model):
    """Target Properties.

    :ivar description: Description of target. Required.
    :vartype description: str
    :ivar display_name: Display name of target. Required.
    :vartype display_name: str
    :ivar context_id: ArmId of Context. Required.
    :vartype context_id: str
    :ivar target_specification: target spec. Required.
    :vartype target_specification: dict[str, any]
    :ivar capabilities: List of capabilities. Required.
    :vartype capabilities: list[str]
    :ivar hierarchy_level: Hierarchy Level. Required.
    :vartype hierarchy_level: str
    :ivar status: Status of target.
    :vartype status: ~azure.mgmt.workloadorchestration.models.DeploymentStatus
    :ivar solution_scope: Scope of the target resource.
    :vartype solution_scope: str
    :ivar state: State of resource. Known values are: "active" and "inactive".
    :vartype state: str or ~azure.mgmt.workloadorchestration.models.ResourceState
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of target. Required."""
    display_name: str = rest_field(name="displayName", visibility=["read", "create", "update", "delete", "query"])
    """Display name of target. Required."""
    context_id: str = rest_field(name="contextId", visibility=["read", "create", "update", "delete", "query"])
    """ArmId of Context. Required."""
    target_specification: Dict[str, Any] = rest_field(
        name="targetSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """target spec. Required."""
    capabilities: List[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of capabilities. Required."""
    hierarchy_level: str = rest_field(name="hierarchyLevel", visibility=["read", "create", "update", "delete", "query"])
    """Hierarchy Level. Required."""
    status: Optional["_models.DeploymentStatus"] = rest_field(visibility=["read"])
    """Status of target."""
    solution_scope: Optional[str] = rest_field(
        name="solutionScope", visibility=["read", "create", "update", "delete", "query"]
    )
    """Scope of the target resource."""
    state: Optional[Union[str, "_models.ResourceState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """State of resource. Known values are: \"active\" and \"inactive\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        display_name: str,
        context_id: str,
        target_specification: Dict[str, Any],
        capabilities: List[str],
        hierarchy_level: str,
        solution_scope: Optional[str] = None,
        state: Optional[Union[str, "_models.ResourceState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetSnapshot(_Model):
    """Target Snapshot.

    :ivar target_id: Target of instance.
    :vartype target_id: str
    :ivar target_specification: target spec.
    :vartype target_specification: dict[str, any]
    :ivar solution_scope: Scope of the target resource.
    :vartype solution_scope: str
    """

    target_id: Optional[str] = rest_field(name="targetId", visibility=["read", "create", "update", "delete", "query"])
    """Target of instance."""
    target_specification: Optional[Dict[str, Any]] = rest_field(
        name="targetSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """target spec."""
    solution_scope: Optional[str] = rest_field(
        name="solutionScope", visibility=["read", "create", "update", "delete", "query"]
    )
    """Scope of the target resource."""

    @overload
    def __init__(
        self,
        *,
        target_id: Optional[str] = None,
        target_specification: Optional[Dict[str, Any]] = None,
        solution_scope: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetStatus(_Model):
    """Target Status.

    :ivar name: Target name.
    :vartype name: str
    :ivar status: Target status.
    :vartype status: str
    :ivar component_statuses: Component statuses.
    :vartype component_statuses: list[~azure.mgmt.workloadorchestration.models.ComponentStatus]
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Target name."""
    status: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Target status."""
    component_statuses: Optional[List["_models.ComponentStatus"]] = rest_field(
        name="componentStatuses", visibility=["read", "create", "update", "delete", "query"]
    )
    """Component statuses."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        status: Optional[str] = None,
        component_statuses: Optional[List["_models.ComponentStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaskOption(_Model):
    """Task Option Properties.

    :ivar concurrency: Parallel worker numbers of the tasks.
    :vartype concurrency: int
    :ivar error_action: Error action for the tasks.
    :vartype error_action: ~azure.mgmt.workloadorchestration.models.ErrorAction
    """

    concurrency: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Parallel worker numbers of the tasks."""
    error_action: Optional["_models.ErrorAction"] = rest_field(
        name="errorAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Error action for the tasks."""

    @overload
    def __init__(
        self,
        *,
        concurrency: Optional[int] = None,
        error_action: Optional["_models.ErrorAction"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaskSpec(_Model):
    """Task Spec.

    :ivar name: Name of Task. Required.
    :vartype name: str
    :ivar target_id: Target ARM id.
    :vartype target_id: str
    :ivar specification: Task specification. Required.
    :vartype specification: dict[str, any]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of Task. Required."""
    target_id: Optional[str] = rest_field(name="targetId", visibility=["read", "create", "update", "delete", "query"])
    """Target ARM id."""
    specification: Dict[str, Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Task specification. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        specification: Dict[str, Any],
        target_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UninstallSolutionParameter(_Model):
    """Uninstall Solution Parameter.

    :ivar solution_template_id: Solution Template ARM Id. Required.
    :vartype solution_template_id: str
    :ivar solution_instance_name: Solution Instance Name.
    :vartype solution_instance_name: str
    """

    solution_template_id: str = rest_field(
        name="solutionTemplateId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Template ARM Id. Required."""
    solution_instance_name: Optional[str] = rest_field(
        name="solutionInstanceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Instance Name."""

    @overload
    def __init__(
        self,
        *,
        solution_template_id: str,
        solution_instance_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateExternalValidationStatusParameter(_Model):
    """Update External Validation Status Parameter.

    :ivar solution_version_id: Solution Version Id. Required.
    :vartype solution_version_id: str
    :ivar error_details: Error Details if any failure is there.
    :vartype error_details: ~azure.mgmt.workloadorchestration.models.ErrorDetail
    :ivar external_validation_id: External validation id. Required.
    :vartype external_validation_id: str
    :ivar validation_status: Validation Status of external validation. Required. Known values are:
     "Valid" and "Invalid".
    :vartype validation_status: str or ~azure.mgmt.workloadorchestration.models.ValidationStatus
    """

    solution_version_id: str = rest_field(
        name="solutionVersionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution Version Id. Required."""
    error_details: Optional["_models.ErrorDetail"] = rest_field(
        name="errorDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Error Details if any failure is there."""
    external_validation_id: str = rest_field(
        name="externalValidationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """External validation id. Required."""
    validation_status: Union[str, "_models.ValidationStatus"] = rest_field(
        name="validationStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Validation Status of external validation. Required. Known values are: \"Valid\" and
     \"Invalid\"."""

    @overload
    def __init__(
        self,
        *,
        solution_version_id: str,
        external_validation_id: str,
        validation_status: Union[str, "_models.ValidationStatus"],
        error_details: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VersionParameter(_Model):
    """Version Parameter.

    :ivar version: Version of the Resource. Required.
    :vartype version: str
    """

    version: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version of the Resource. Required."""

    @overload
    def __init__(
        self,
        *,
        version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Workflow(ProxyResource):
    """Workflow Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.WorkflowProperties
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.workloadorchestration.models.ExtendedLocation
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.WorkflowProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkflowProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkflowProperties(_Model):
    """Workflow Properties.

    :ivar workflow_template_id: Workflow template Id.
    :vartype workflow_template_id: str
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    workflow_template_id: Optional[str] = rest_field(name="workflowTemplateId", visibility=["read"])
    """Workflow template Id."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""


class WorkflowVersion(ProxyResource):
    """Workflow Version Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadorchestration.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadorchestration.models.WorkflowVersionProperties
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.workloadorchestration.models.ExtendedLocation
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.WorkflowVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkflowVersionProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkflowVersionProperties(_Model):
    """Workflow Version Properties.

    :ivar revision: Revision number of resolved config for this workflow version.
    :vartype revision: int
    :ivar configuration: Resolved configuration values.
    :vartype configuration: str
    :ivar stage_spec: A list of stage specs. Required.
    :vartype stage_spec: list[~azure.mgmt.workloadorchestration.models.StageSpec]
    :ivar review_id: Review id of resolved config for this workflow version.
    :vartype review_id: str
    :ivar state: State of workflow version. Known values are: "InReview", "UpgradeInReview",
     "ReadyToDeploy", "ReadyToUpgrade", "Deploying", "Deployed", "Failed", "Undeployed",
     "PendingExternalValidation", "ExternalValidationFailed", and "Staging".
    :vartype state: str or ~azure.mgmt.workloadorchestration.models.State
    :ivar specification: Execution specification.
    :vartype specification: dict[str, any]
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Initialized", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.workloadorchestration.models.ProvisioningState
    """

    revision: Optional[int] = rest_field(visibility=["read"])
    """Revision number of resolved config for this workflow version."""
    configuration: Optional[str] = rest_field(visibility=["read"])
    """Resolved configuration values."""
    stage_spec: List["_models.StageSpec"] = rest_field(
        name="stageSpec", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of stage specs. Required."""
    review_id: Optional[str] = rest_field(name="reviewId", visibility=["read"])
    """Review id of resolved config for this workflow version."""
    state: Optional[Union[str, "_models.State"]] = rest_field(visibility=["read"])
    """State of workflow version. Known values are: \"InReview\", \"UpgradeInReview\",
     \"ReadyToDeploy\", \"ReadyToUpgrade\", \"Deploying\", \"Deployed\", \"Failed\", \"Undeployed\",
     \"PendingExternalValidation\", \"ExternalValidationFailed\", and \"Staging\"."""
    specification: Optional[Dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Execution specification."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Initialized\", \"InProgress\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        stage_spec: List["_models.StageSpec"],
        specification: Optional[Dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
