// Array includes objects with duplicate keys and integer keys.
let json = `[
    {"x1": 1},
    {"x2": 2},
    {"x3": 3},
    {"x1": 1, "y": 0},
    {"x2": 1, "y": 0},
    {"x3": 1, "y": 0},
    {"x1": 1, "x1": 2, "y": 0},
    {"x1": 1, "x1": 2, "y": 0},
    {"x1": 1, "x1": 2, "y": 0},
    {"0": 1, "x1": 1},
    {"0": 1, "0": 2, "x1": 1},
    {"0": 1, "0": 2, "x1": 1},
    {"2147483648": 1},
    {"2147483648": 2},
    {"2147483648": 0, "x": 0, "2147483648": 3},
    {"4294967295": 4},
    {"4294967295": 5},
    {"-1": 6},
    {"-1": 7},
    {"__proto__": 1},
    {"__proto__": 2}
]`;
for (let i = 0; i < 3; i++) {
    let res = JSON.parse(json);
    assertEq(JSON.stringify(res),
            `[{"x1":1},` +
            `{"x2":2},` +
            `{"x3":3},` +
            `{"x1":1,"y":0},` +
            `{"x2":1,"y":0},` +
            `{"x3":1,"y":0},` +
            `{"x1":2,"y":0},` +
            `{"x1":2,"y":0},` +
            `{"x1":2,"y":0},` +
            `{"0":1,"x1":1},` +
            `{"0":2,"x1":1},` +
            `{"0":2,"x1":1},` +
            `{"2147483648":1},` +
            `{"2147483648":2},` +
            `{"2147483648":3,"x":0},` +
            `{"4294967295":4},` +
            `{"4294967295":5},` +
            `{"-1":6},` +
            `{"-1":7},` +
            `{"__proto__":1},` +
            `{"__proto__":2}]`);
}
