// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package forgejo

import (
	"context"
	"fmt"

	f3_tree "code.forgejo.org/f3/gof3/v3/tree/f3"
	"code.forgejo.org/f3/gof3/v3/tree/generic"

	forgejo_sdk "code.forgejo.org/f3/gof3/v3/forges/forgejo/sdk"
)

type labels struct {
	container
}

func (o *labels) ListPage(ctx context.Context, page int) generic.ChildrenSlice {
	pageSize := o.getPageSize()

	var err error
	var forgejoLabels []*forgejo_sdk.Label

	owner := f3_tree.GetOwnerName(o.GetNode())
	project := f3_tree.GetProjectName(o.GetNode())

	forgejoLabels, _, err = o.getClient().ListRepoLabels(owner, project, forgejo_sdk.ListLabelsOptions{
		ListOptions: forgejo_sdk.ListOptions{Page: page, PageSize: pageSize},
	})
	if err != nil {
		panic(fmt.Errorf("error while listing labels: %v", err))
	}

	return f3_tree.ConvertListed(ctx, o.GetNode(), f3_tree.ConvertToAny(forgejoLabels...)...)
}

func newLabels() generic.NodeDriverInterface {
	return &labels{}
}
