// Copyright (c) 2010-2025, Lawrence Livermore National Security, LLC. Produced
// at the Lawrence Livermore National Laboratory. All Rights reserved. See files
// LICENSE and NOTICE for details. LLNL-CODE-443271.
//
// This file is part of the GLVis visualization tool and library. For more
// information and source code availability see https://glvis.org.
//
// GLVis is free software; you can redistribute it and/or modify it under the
// terms of the BSD-3 license. We welcome feedback and contributions, see file
// CONTRIBUTING.md for details.


const Palette BPAL_1 = Palette("5-color",
{
   {0, 0, 1, 1},
   {0, 1, 1, 1},
   {0, 1, 0, 1},
   {1, 1, 0, 1},
   {1, 0, 0, 1},
});

const Palette BPAL_2 = Palette("red",
{
   {1, 0, 0, 1},
   {1, 0, 0, 1},
});

const Palette BPAL_3 = Palette("jet-like",
{
   {0, 0, 0.5, 1},
   {0, 0, 0.5625, 1},
   {0, 0, 0.625, 1},
   {0, 0, 0.6875, 1},
   {0, 0, 0.75, 1},
   {0, 0, 0.8125, 1},
   {0, 0, 0.875, 1},
   {0, 0, 0.9375, 1},
   {0, 0, 1, 1},
   {0, 0.0625, 1, 1},
   {0, 0.125, 1, 1},
   {0, 0.1875, 1, 1},
   {0, 0.25, 1, 1},
   {0, 0.3125, 1, 1},
   {0, 0.375, 1, 1},
   {0, 0.4375, 1, 1},
   {0, 0.5, 1, 1},
   {0, 0.5625, 1, 1},
   {0, 0.625, 1, 1},
   {0, 0.6875, 1, 1},
   {0, 0.75, 1, 1},
   {0, 0.8125, 1, 1},
   {0, 0.875, 1, 1},
   {0, 0.9375, 1, 1},
   {0, 1, 1, 1},
   {0, 0.975, 0.875, 1},
   {0, 0.95, 0.75, 1},
   {0, 0.925, 0.625, 1},
   {0, 0.9, 0.5, 1},
   {0, 0.875, 0.375, 1},
   {0, 0.85, 0.25, 1},
   {0, 0.825, 0.125, 1},
   {0, 0.8, 0, 1},
   {0.2872, 0.825, 0, 1},
   {0.4353, 0.85, 0, 1},
   {0.5552, 0.875, 0, 1},
   {0.6598, 0.9, 0, 1},
   {0.7543, 0.925, 0, 1},
   {0.8415, 0.95, 0, 1},
   {0.923, 0.975, 0, 1},
   {1, 1, 0, 1},
   {1, 0.9375, 0, 1},
   {1, 0.875, 0, 1},
   {1, 0.8125, 0, 1},
   {1, 0.75, 0, 1},
   {1, 0.6875, 0, 1},
   {1, 0.625, 0, 1},
   {1, 0.5625, 0, 1},
   {1, 0.5, 0, 1},
   {1, 0.4375, 0, 1},
   {1, 0.375, 0, 1},
   {1, 0.3125, 0, 1},
   {1, 0.25, 0, 1},
   {1, 0.1875, 0, 1},
   {1, 0.125, 0, 1},
   {1, 0.0625, 0, 1},
   {1, 0, 0, 1},
   {0.9375, 0, 0, 1},
   {0.875, 0, 0, 1},
   {0.8125, 0, 0, 1},
   {0.75, 0, 0, 1},
   {0.6875, 0, 0, 1},
   {0.625, 0, 0, 1},
   {0.5625, 0, 0, 1},
   {0.5, 0, 0, 1},
});

const Palette BPAL_4 = Palette("coldhot",
{
   {0.019531, 0.1875, 0.378906, 1},
   {0.128906, 0.398438, 0.671875, 1},
   {0.261719, 0.574219, 0.761719, 1},
   {0.570312, 0.769531, 0.867188, 1},
   {0.816406, 0.894531, 0.9375, 1},
   {0.964844, 0.964844, 0.964844, 1},
   {0.992188, 0.855469, 0.777344, 1},
   {0.953125, 0.644531, 0.507812, 1},
   {0.835938, 0.375, 0.300781, 1},
   {0.695312, 0.09375, 0.167969, 1},
   {0.402344, 0, 0.121094, 1},
});

const Palette BPAL_5 = Palette("bone",
{
   {0, 0, 0.00520833, 1},
   {0.0138889, 0.0138889, 0.0243056, 1},
   {0.0277778, 0.0277778, 0.0434028, 1},
   {0.0416667, 0.0416667, 0.0625, 1},
   {0.0555556, 0.0555556, 0.0815972, 1},
   {0.0694444, 0.0694444, 0.100694, 1},
   {0.0833333, 0.0833333, 0.119792, 1},
   {0.0972222, 0.0972222, 0.138889, 1},
   {0.111111, 0.111111, 0.157986, 1},
   {0.125, 0.125, 0.177083, 1},
   {0.138889, 0.138889, 0.196181, 1},
   {0.152778, 0.152778, 0.215278, 1},
   {0.166667, 0.166667, 0.234375, 1},
   {0.180556, 0.180556, 0.253472, 1},
   {0.194444, 0.194444, 0.272569, 1},
   {0.208333, 0.208333, 0.291667, 1},
   {0.222222, 0.222222, 0.310764, 1},
   {0.236111, 0.236111, 0.329861, 1},
   {0.25, 0.25, 0.348958, 1},
   {0.263889, 0.263889, 0.368056, 1},
   {0.277778, 0.277778, 0.387153, 1},
   {0.291667, 0.291667, 0.40625, 1},
   {0.305556, 0.305556, 0.425347, 1},
   {0.319444, 0.319444, 0.444444, 1},
   {0.333333, 0.338542, 0.458333, 1},
   {0.347222, 0.357639, 0.472222, 1},
   {0.361111, 0.376736, 0.486111, 1},
   {0.375, 0.395833, 0.5, 1},
   {0.388889, 0.414931, 0.513889, 1},
   {0.402778, 0.434028, 0.527778, 1},
   {0.416667, 0.453125, 0.541667, 1},
   {0.430556, 0.472222, 0.555556, 1},
   {0.444444, 0.491319, 0.569444, 1},
   {0.458333, 0.510417, 0.583333, 1},
   {0.472222, 0.529514, 0.597222, 1},
   {0.486111, 0.548611, 0.611111, 1},
   {0.5, 0.567708, 0.625, 1},
   {0.513889, 0.586806, 0.638889, 1},
   {0.527778, 0.605903, 0.652778, 1},
   {0.541667, 0.625, 0.666667, 1},
   {0.555556, 0.644097, 0.680556, 1},
   {0.569444, 0.663194, 0.694444, 1},
   {0.583333, 0.682292, 0.708333, 1},
   {0.597222, 0.701389, 0.722222, 1},
   {0.611111, 0.720486, 0.736111, 1},
   {0.625, 0.739583, 0.75, 1},
   {0.638889, 0.758681, 0.763889, 1},
   {0.652778, 0.777778, 0.777778, 1},
   {0.674479, 0.791667, 0.791667, 1},
   {0.696181, 0.805556, 0.805556, 1},
   {0.717882, 0.819444, 0.819444, 1},
   {0.739583, 0.833333, 0.833333, 1},
   {0.761285, 0.847222, 0.847222, 1},
   {0.782986, 0.861111, 0.861111, 1},
   {0.804688, 0.875, 0.875, 1},
   {0.826389, 0.888889, 0.888889, 1},
   {0.84809, 0.902778, 0.902778, 1},
   {0.869792, 0.916667, 0.916667, 1},
   {0.891493, 0.930556, 0.930556, 1},
   {0.913194, 0.944444, 0.944444, 1},
   {0.934896, 0.958333, 0.958333, 1},
   {0.956597, 0.972222, 0.972222, 1},
   {0.978299, 0.986111, 0.986111, 1},
   {1, 1, 1, 1},
});

const Palette BPAL_6 = Palette("hot",
{
   {0.0416667, 0, 0, 1},
   {0.0833333, 0, 0, 1},
   {0.125, 0, 0, 1},
   {0.166667, 0, 0, 1},
   {0.208333, 0, 0, 1},
   {0.25, 0, 0, 1},
   {0.291667, 0, 0, 1},
   {0.333333, 0, 0, 1},
   {0.375, 0, 0, 1},
   {0.416667, 0, 0, 1},
   {0.458333, 0, 0, 1},
   {0.5, 0, 0, 1},
   {0.541667, 0, 0, 1},
   {0.583333, 0, 0, 1},
   {0.625, 0, 0, 1},
   {0.666667, 0, 0, 1},
   {0.708333, 0, 0, 1},
   {0.75, 0, 0, 1},
   {0.791667, 0, 0, 1},
   {0.833333, 0, 0, 1},
   {0.875, 0, 0, 1},
   {0.916667, 0, 0, 1},
   {0.958333, 0, 0, 1},
   {1, 0, 0, 1},
   {1, 0.0416667, 0, 1},
   {1, 0.0833333, 0, 1},
   {1, 0.125, 0, 1},
   {1, 0.166667, 0, 1},
   {1, 0.208333, 0, 1},
   {1, 0.25, 0, 1},
   {1, 0.291667, 0, 1},
   {1, 0.333333, 0, 1},
   {1, 0.375, 0, 1},
   {1, 0.416667, 0, 1},
   {1, 0.458333, 0, 1},
   {1, 0.5, 0, 1},
   {1, 0.541667, 0, 1},
   {1, 0.583333, 0, 1},
   {1, 0.625, 0, 1},
   {1, 0.666667, 0, 1},
   {1, 0.708333, 0, 1},
   {1, 0.75, 0, 1},
   {1, 0.791667, 0, 1},
   {1, 0.833333, 0, 1},
   {1, 0.875, 0, 1},
   {1, 0.916667, 0, 1},
   {1, 0.958333, 0, 1},
   {1, 1, 0, 1},
   {1, 1, 0.0625, 1},
   {1, 1, 0.125, 1},
   {1, 1, 0.1875, 1},
   {1, 1, 0.25, 1},
   {1, 1, 0.3125, 1},
   {1, 1, 0.375, 1},
   {1, 1, 0.4375, 1},
   {1, 1, 0.5, 1},
   {1, 1, 0.5625, 1},
   {1, 1, 0.625, 1},
   {1, 1, 0.6875, 1},
   {1, 1, 0.75, 1},
   {1, 1, 0.8125, 1},
   {1, 1, 0.875, 1},
   {1, 1, 0.9375, 1},
   {1, 1, 1, 1},
});

const Palette BPAL_7 = Palette("pink",
{
   {0.117851, 0, 0, 1},
   {0.195857, 0.102869, 0.102869, 1},
   {0.250661, 0.145479, 0.145479, 1},
   {0.295468, 0.178174, 0.178174, 1},
   {0.334324, 0.205738, 0.205738, 1},
   {0.369112, 0.230022, 0.230022, 1},
   {0.400892, 0.251976, 0.251976, 1},
   {0.430331, 0.272166, 0.272166, 1},
   {0.457882, 0.290957, 0.290957, 1},
   {0.483867, 0.308607, 0.308607, 1},
   {0.508525, 0.3253, 0.3253, 1},
   {0.532042, 0.341178, 0.341178, 1},
   {0.554563, 0.356348, 0.356348, 1},
   {0.576204, 0.370899, 0.370899, 1},
   {0.597061, 0.3849, 0.3849, 1},
   {0.617213, 0.39841, 0.39841, 1},
   {0.636729, 0.411476, 0.411476, 1},
   {0.655663, 0.424139, 0.424139, 1},
   {0.674066, 0.436436, 0.436436, 1},
   {0.69198, 0.448395, 0.448395, 1},
   {0.709441, 0.460044, 0.460044, 1},
   {0.726483, 0.471405, 0.471405, 1},
   {0.743134, 0.482498, 0.482498, 1},
   {0.759421, 0.493342, 0.493342, 1},
   {0.766356, 0.517549, 0.503953, 1},
   {0.773229, 0.540674, 0.514344, 1},
   {0.780042, 0.562849, 0.524531, 1},
   {0.786796, 0.584183, 0.534522, 1},
   {0.793492, 0.604765, 0.544331, 1},
   {0.800132, 0.624669, 0.553966, 1},
   {0.806718, 0.643958, 0.563436, 1},
   {0.81325, 0.662687, 0.57275, 1},
   {0.81973, 0.6809, 0.581914, 1},
   {0.82616, 0.698638, 0.590937, 1},
   {0.832539, 0.715937, 0.599824, 1},
   {0.83887, 0.732828, 0.608581, 1},
   {0.845154, 0.749338, 0.617213, 1},
   {0.851392, 0.765493, 0.625727, 1},
   {0.857584, 0.781313, 0.634126, 1},
   {0.863731, 0.796819, 0.642416, 1},
   {0.869835, 0.812029, 0.6506, 1},
   {0.875897, 0.82696, 0.658682, 1},
   {0.881917, 0.841625, 0.666667, 1},
   {0.887896, 0.85604, 0.674556, 1},
   {0.893835, 0.870216, 0.682355, 1},
   {0.899735, 0.884164, 0.690066, 1},
   {0.905597, 0.897896, 0.697691, 1},
   {0.911421, 0.911421, 0.705234, 1},
   {0.917208, 0.917208, 0.727166, 1},
   {0.922958, 0.922958, 0.748455, 1},
   {0.928673, 0.928673, 0.769156, 1},
   {0.934353, 0.934353, 0.789314, 1},
   {0.939999, 0.939999, 0.808969, 1},
   {0.945611, 0.945611, 0.828159, 1},
   {0.95119, 0.95119, 0.846913, 1},
   {0.956736, 0.956736, 0.865261, 1},
   {0.96225, 0.96225, 0.883229, 1},
   {0.967733, 0.967733, 0.900837, 1},
   {0.973185, 0.973185, 0.918109, 1},
   {0.978607, 0.978607, 0.935061, 1},
   {0.983999, 0.983999, 0.951711, 1},
   {0.989361, 0.989361, 0.968075, 1},
   {0.994695, 0.994695, 0.984167, 1},
   {1, 1, 1, 1},
});

const Palette BPAL_8 = Palette("cool",
{
   {0, 1, 1, 1},
   {0.015873, 0.984127, 1, 1},
   {0.031746, 0.968254, 1, 1},
   {0.047619, 0.952381, 1, 1},
   {0.0634921, 0.936508, 1, 1},
   {0.0793651, 0.920635, 1, 1},
   {0.0952381, 0.904762, 1, 1},
   {0.111111, 0.888889, 1, 1},
   {0.126984, 0.873016, 1, 1},
   {0.142857, 0.857143, 1, 1},
   {0.15873, 0.84127, 1, 1},
   {0.174603, 0.825397, 1, 1},
   {0.190476, 0.809524, 1, 1},
   {0.206349, 0.793651, 1, 1},
   {0.222222, 0.777778, 1, 1},
   {0.238095, 0.761905, 1, 1},
   {0.253968, 0.746032, 1, 1},
   {0.269841, 0.730159, 1, 1},
   {0.285714, 0.714286, 1, 1},
   {0.301587, 0.698413, 1, 1},
   {0.31746, 0.68254, 1, 1},
   {0.333333, 0.666667, 1, 1},
   {0.349206, 0.650794, 1, 1},
   {0.365079, 0.634921, 1, 1},
   {0.380952, 0.619048, 1, 1},
   {0.396825, 0.603175, 1, 1},
   {0.412698, 0.587302, 1, 1},
   {0.428571, 0.571429, 1, 1},
   {0.444444, 0.555556, 1, 1},
   {0.460317, 0.539683, 1, 1},
   {0.47619, 0.52381, 1, 1},
   {0.492063, 0.507937, 1, 1},
   {0.507937, 0.492063, 1, 1},
   {0.52381, 0.47619, 1, 1},
   {0.539683, 0.460317, 1, 1},
   {0.555556, 0.444444, 1, 1},
   {0.571429, 0.428571, 1, 1},
   {0.587302, 0.412698, 1, 1},
   {0.603175, 0.396825, 1, 1},
   {0.619048, 0.380952, 1, 1},
   {0.634921, 0.365079, 1, 1},
   {0.650794, 0.349206, 1, 1},
   {0.666667, 0.333333, 1, 1},
   {0.68254, 0.31746, 1, 1},
   {0.698413, 0.301587, 1, 1},
   {0.714286, 0.285714, 1, 1},
   {0.730159, 0.269841, 1, 1},
   {0.746032, 0.253968, 1, 1},
   {0.761905, 0.238095, 1, 1},
   {0.777778, 0.222222, 1, 1},
   {0.793651, 0.206349, 1, 1},
   {0.809524, 0.190476, 1, 1},
   {0.825397, 0.174603, 1, 1},
   {0.84127, 0.15873, 1, 1},
   {0.857143, 0.142857, 1, 1},
   {0.873016, 0.126984, 1, 1},
   {0.888889, 0.111111, 1, 1},
   {0.904762, 0.0952381, 1, 1},
   {0.920635, 0.0793651, 1, 1},
   {0.936508, 0.0634921, 1, 1},
   {0.952381, 0.047619, 1, 1},
   {0.968254, 0.031746, 1, 1},
   {0.984127, 0.015873, 1, 1},
   {1, 0, 1, 1},
});

const Palette BPAL_9 = Palette("summer",
{
   {0, 0.5, 0.4, 1},
   {0.015873, 0.507937, 0.4, 1},
   {0.031746, 0.515873, 0.4, 1},
   {0.047619, 0.52381, 0.4, 1},
   {0.0634921, 0.531746, 0.4, 1},
   {0.0793651, 0.539683, 0.4, 1},
   {0.0952381, 0.547619, 0.4, 1},
   {0.111111, 0.555556, 0.4, 1},
   {0.126984, 0.563492, 0.4, 1},
   {0.142857, 0.571429, 0.4, 1},
   {0.15873, 0.579365, 0.4, 1},
   {0.174603, 0.587302, 0.4, 1},
   {0.190476, 0.595238, 0.4, 1},
   {0.206349, 0.603175, 0.4, 1},
   {0.222222, 0.611111, 0.4, 1},
   {0.238095, 0.619048, 0.4, 1},
   {0.253968, 0.626984, 0.4, 1},
   {0.269841, 0.634921, 0.4, 1},
   {0.285714, 0.642857, 0.4, 1},
   {0.301587, 0.650794, 0.4, 1},
   {0.31746, 0.65873, 0.4, 1},
   {0.333333, 0.666667, 0.4, 1},
   {0.349206, 0.674603, 0.4, 1},
   {0.365079, 0.68254, 0.4, 1},
   {0.380952, 0.690476, 0.4, 1},
   {0.396825, 0.698413, 0.4, 1},
   {0.412698, 0.706349, 0.4, 1},
   {0.428571, 0.714286, 0.4, 1},
   {0.444444, 0.722222, 0.4, 1},
   {0.460317, 0.730159, 0.4, 1},
   {0.47619, 0.738095, 0.4, 1},
   {0.492063, 0.746032, 0.4, 1},
   {0.507937, 0.753968, 0.4, 1},
   {0.52381, 0.761905, 0.4, 1},
   {0.539683, 0.769841, 0.4, 1},
   {0.555556, 0.777778, 0.4, 1},
   {0.571429, 0.785714, 0.4, 1},
   {0.587302, 0.793651, 0.4, 1},
   {0.603175, 0.801587, 0.4, 1},
   {0.619048, 0.809524, 0.4, 1},
   {0.634921, 0.81746, 0.4, 1},
   {0.650794, 0.825397, 0.4, 1},
   {0.666667, 0.833333, 0.4, 1},
   {0.68254, 0.84127, 0.4, 1},
   {0.698413, 0.849206, 0.4, 1},
   {0.714286, 0.857143, 0.4, 1},
   {0.730159, 0.865079, 0.4, 1},
   {0.746032, 0.873016, 0.4, 1},
   {0.761905, 0.880952, 0.4, 1},
   {0.777778, 0.888889, 0.4, 1},
   {0.793651, 0.896825, 0.4, 1},
   {0.809524, 0.904762, 0.4, 1},
   {0.825397, 0.912698, 0.4, 1},
   {0.84127, 0.920635, 0.4, 1},
   {0.857143, 0.928571, 0.4, 1},
   {0.873016, 0.936508, 0.4, 1},
   {0.888889, 0.944444, 0.4, 1},
   {0.904762, 0.952381, 0.4, 1},
   {0.920635, 0.960317, 0.4, 1},
   {0.936508, 0.968254, 0.4, 1},
   {0.952381, 0.97619, 0.4, 1},
   {0.968254, 0.984127, 0.4, 1},
   {0.984127, 0.992063, 0.4, 1},
   {1, 1, 0.4, 1},
});

const Palette BPAL_10 = Palette("hsv",
{
   {1, 0, 0, 1},
   {1, 0.09375, 0, 1},
   {1, 0.1875, 0, 1},
   {1, 0.28125, 0, 1},
   {1, 0.375, 0, 1},
   {1, 0.46875, 0, 1},
   {1, 0.5625, 0, 1},
   {1, 0.65625, 0, 1},
   {1, 0.75, 0, 1},
   {1, 0.84375, 0, 1},
   {1, 0.9375, 0, 1},
   {0.96875, 1, 0, 1},
   {0.875, 1, 0, 1},
   {0.78125, 1, 0, 1},
   {0.6875, 1, 0, 1},
   {0.59375, 1, 0, 1},
   {0.5, 1, 0, 1},
   {0.40625, 1, 0, 1},
   {0.3125, 1, 0, 1},
   {0.21875, 1, 0, 1},
   {0.125, 1, 0, 1},
   {0.03125, 1, 0, 1},
   {0, 1, 0.0625, 1},
   {0, 1, 0.15625, 1},
   {0, 1, 0.25, 1},
   {0, 1, 0.34375, 1},
   {0, 1, 0.4375, 1},
   {0, 1, 0.53125, 1},
   {0, 1, 0.625, 1},
   {0, 1, 0.71875, 1},
   {0, 1, 0.8125, 1},
   {0, 1, 0.90625, 1},
   {0, 1, 1, 1},
   {0, 0.90625, 1, 1},
   {0, 0.8125, 1, 1},
   {0, 0.71875, 1, 1},
   {0, 0.625, 1, 1},
   {0, 0.53125, 1, 1},
   {0, 0.4375, 1, 1},
   {0, 0.34375, 1, 1},
   {0, 0.25, 1, 1},
   {0, 0.15625, 1, 1},
   {0, 0.0625, 1, 1},
   {0.03125, 0, 1, 1},
   {0.125, 0, 1, 1},
   {0.21875, 0, 1, 1},
   {0.3125, 0, 1, 1},
   {0.40625, 0, 1, 1},
   {0.5, 0, 1, 1},
   {0.59375, 0, 1, 1},
   {0.6875, 0, 1, 1},
   {0.78125, 0, 1, 1},
   {0.875, 0, 1, 1},
   {0.96875, 0, 1, 1},
   {1, 0, 0.9375, 1},
   {1, 0, 0.84375, 1},
   {1, 0, 0.75, 1},
   {1, 0, 0.65625, 1},
   {1, 0, 0.5625, 1},
   {1, 0, 0.46875, 1},
   {1, 0, 0.375, 1},
   {1, 0, 0.28125, 1},
   {1, 0, 0.1875, 1},
   {1, 0, 0.09375, 1},
});

const Palette BPAL_11 = Palette("copper",
{
   {0, 0, 0, 1},
   {0.0198413, 0.0124, 0.00789683, 1},
   {0.0396825, 0.0248, 0.0157937, 1},
   {0.0595238, 0.0372, 0.0236905, 1},
   {0.0793651, 0.0496, 0.0315873, 1},
   {0.0992063, 0.062, 0.0394841, 1},
   {0.119048, 0.0744, 0.047381, 1},
   {0.138889, 0.0868, 0.0552778, 1},
   {0.15873, 0.0992, 0.0631746, 1},
   {0.178571, 0.1116, 0.0710714, 1},
   {0.198413, 0.124, 0.0789683, 1},
   {0.218254, 0.1364, 0.0868651, 1},
   {0.238095, 0.1488, 0.0947619, 1},
   {0.257937, 0.1612, 0.102659, 1},
   {0.277778, 0.1736, 0.110556, 1},
   {0.297619, 0.186, 0.118452, 1},
   {0.31746, 0.1984, 0.126349, 1},
   {0.337302, 0.2108, 0.134246, 1},
   {0.357143, 0.2232, 0.142143, 1},
   {0.376984, 0.2356, 0.15004, 1},
   {0.396825, 0.248, 0.157937, 1},
   {0.416667, 0.2604, 0.165833, 1},
   {0.436508, 0.2728, 0.17373, 1},
   {0.456349, 0.2852, 0.181627, 1},
   {0.47619, 0.2976, 0.189524, 1},
   {0.496032, 0.31, 0.197421, 1},
   {0.515873, 0.3224, 0.205317, 1},
   {0.535714, 0.3348, 0.213214, 1},
   {0.555556, 0.3472, 0.221111, 1},
   {0.575397, 0.3596, 0.229008, 1},
   {0.595238, 0.372, 0.236905, 1},
   {0.615079, 0.3844, 0.244802, 1},
   {0.634921, 0.3968, 0.252698, 1},
   {0.654762, 0.4092, 0.260595, 1},
   {0.674603, 0.4216, 0.268492, 1},
   {0.694444, 0.434, 0.276389, 1},
   {0.714286, 0.4464, 0.284286, 1},
   {0.734127, 0.4588, 0.292183, 1},
   {0.753968, 0.4712, 0.300079, 1},
   {0.77381, 0.4836, 0.307976, 1},
   {0.793651, 0.496, 0.315873, 1},
   {0.813492, 0.5084, 0.32377, 1},
   {0.833333, 0.5208, 0.331667, 1},
   {0.853175, 0.5332, 0.339563, 1},
   {0.873016, 0.5456, 0.34746, 1},
   {0.892857, 0.558, 0.355357, 1},
   {0.912698, 0.5704, 0.363254, 1},
   {0.93254, 0.5828, 0.371151, 1},
   {0.952381, 0.5952, 0.379048, 1},
   {0.972222, 0.6076, 0.386944, 1},
   {0.992063, 0.62, 0.394841, 1},
   {1, 0.6324, 0.402738, 1},
   {1, 0.6448, 0.410635, 1},
   {1, 0.6572, 0.418532, 1},
   {1, 0.6696, 0.426429, 1},
   {1, 0.682, 0.434325, 1},
   {1, 0.6944, 0.442222, 1},
   {1, 0.7068, 0.450119, 1},
   {1, 0.7192, 0.458016, 1},
   {1, 0.7316, 0.465913, 1},
   {1, 0.744, 0.47381, 1},
   {1, 0.7564, 0.481706, 1},
   {1, 0.7688, 0.489603, 1},
   {1, 0.7812, 0.4975, 1},
});

const Palette BPAL_12 = Palette("white",
{
   {1, 1, 1, 1},
   {1, 1, 1, 1},
});

const Palette BPAL_13 = Palette("vivid",
{
   {0, 0, 1, 1},
   {0, 0.115756, 1, 1},
   {0, 0.223602, 1, 1},
   {0, 0.324324, 1, 1},
   {0, 0.418605, 1, 1},
   {0, 0.507042, 1, 1},
   {0, 0.590164, 1, 1},
   {0, 0.668435, 1, 1},
   {0, 0.742268, 1, 1},
   {0, 0.81203, 1, 1},
   {0, 0.878049, 1, 1},
   {0, 0.940618, 1, 1},
   {0, 1, 1, 1},
   {0, 0.975, 0.75, 1},
   {0, 0.95, 0.5, 1},
   {0, 0.925, 0.25, 1},
   {0, 0.9, 0, 1},
   {0.101258, 0.90625, 0, 1},
   {0.194476, 0.9125, 0, 1},
   {0.280576, 0.91875, 0, 1},
   {0.360341, 0.925, 0, 1},
   {0.434447, 0.93125, 0, 1},
   {0.503476, 0.9375, 0, 1},
   {0.567931, 0.94375, 0, 1},
   {0.628253, 0.95, 0, 1},
   {0.684827, 0.95625, 0, 1},
   {0.737991, 0.9625, 0, 1},
   {0.788046, 0.96875, 0, 1},
   {0.835255, 0.975, 0, 1},
   {0.879856, 0.98125, 0, 1},
   {0.922058, 0.9875, 0, 1},
   {0.962049, 0.99375, 0, 1},
   {1, 1, 0, 1},
   {0.99375, 0.967105, 0, 1},
   {0.9875, 0.932065, 0, 1},
   {0.98125, 0.894663, 0, 1},
   {0.975, 0.854651, 0, 1},
   {0.96875, 0.811747, 0, 1},
   {0.9625, 0.765625, 0, 1},
   {0.95625, 0.715909, 0, 1},
   {0.95, 0.662162, 0, 1},
   {0.94375, 0.603873, 0, 1},
   {0.9375, 0.540441, 0, 1},
   {0.93125, 0.471154, 0, 1},
   {0.925, 0.395161, 0, 1},
   {0.91875, 0.311441, 0, 1},
   {0.9125, 0.21875, 0, 1},
   {0.90625, 0.115566, 0, 1},
   {0.9, 0, 0, 1},
   {0.925, 0, 0.460432, 1},
   {0.95, 0, 0.719101, 1},
   {0.975, 0, 0.884793, 1},
   {1, 0, 1, 1},
   {0.965326, 0, 1, 1},
   {0.929577, 0, 1, 1},
   {0.892704, 0, 1, 1},
   {0.854651, 0, 1, 1},
   {0.815362, 0, 1, 1},
   {0.774775, 0, 1, 1},
   {0.732824, 0, 1, 1},
   {0.689441, 0, 1, 1},
   {0.64455, 0, 1, 1},
   {0.598071, 0, 1, 1},
   {0.549918, 0, 1, 1},
   {0.5, 0, 1, 1},
});

const Palette BPAL_14 = Palette("aluminum",
{
   {0.429688, 0.445312, 0.410156, 1},
   {0.4375, 0.445312, 0.414062, 1},
   {0.441406, 0.449219, 0.417969, 1},
   {0.445312, 0.453125, 0.421875, 1},
   {0.449219, 0.457031, 0.425781, 1},
   {0.453125, 0.460938, 0.429688, 1},
   {0.457031, 0.464844, 0.433594, 1},
   {0.460938, 0.46875, 0.4375, 1},
   {0.464844, 0.472656, 0.441406, 1},
   {0.476562, 0.484375, 0.453125, 1},
   {0.488281, 0.496094, 0.464844, 1},
   {0.496094, 0.503906, 0.472656, 1},
   {0.496094, 0.507812, 0.476562, 1},
   {0.5, 0.511719, 0.480469, 1},
   {0.503906, 0.511719, 0.484375, 1},
   {0.503906, 0.515625, 0.484375, 1},
   {0.507812, 0.515625, 0.488281, 1},
   {0.511719, 0.519531, 0.492188, 1},
   {0.519531, 0.53125, 0.5, 1},
   {0.546875, 0.554688, 0.527344, 1},
   {0.546875, 0.558594, 0.53125, 1},
   {0.550781, 0.558594, 0.53125, 1},
   {0.550781, 0.558594, 0.53125, 1},
   {0.550781, 0.558594, 0.535156, 1},
   {0.550781, 0.5625, 0.535156, 1},
   {0.554688, 0.5625, 0.535156, 1},
   {0.554688, 0.5625, 0.535156, 1},
   {0.554688, 0.5625, 0.535156, 1},
   {0.554688, 0.5625, 0.535156, 1},
   {0.554688, 0.5625, 0.539062, 1},
   {0.554688, 0.5625, 0.539062, 1},
   {0.554688, 0.566406, 0.539062, 1},
   {0.558594, 0.570312, 0.542969, 1},
   {0.582031, 0.589844, 0.566406, 1},
   {0.59375, 0.601562, 0.574219, 1},
   {0.597656, 0.605469, 0.582031, 1},
   {0.601562, 0.609375, 0.585938, 1},
   {0.605469, 0.613281, 0.589844, 1},
   {0.613281, 0.621094, 0.597656, 1},
   {0.617188, 0.625, 0.601562, 1},
   {0.621094, 0.628906, 0.605469, 1},
   {0.625, 0.632812, 0.609375, 1},
   {0.628906, 0.636719, 0.613281, 1},
   {0.632812, 0.640625, 0.617188, 1},
   {0.636719, 0.644531, 0.621094, 1},
   {0.640625, 0.648438, 0.628906, 1},
   {0.644531, 0.652344, 0.632812, 1},
   {0.648438, 0.65625, 0.636719, 1},
   {0.652344, 0.660156, 0.640625, 1},
   {0.660156, 0.667969, 0.648438, 1},
   {0.667969, 0.675781, 0.65625, 1},
   {0.675781, 0.683594, 0.664062, 1},
   {0.683594, 0.6875, 0.671875, 1},
   {0.683594, 0.691406, 0.671875, 1},
   {0.683594, 0.691406, 0.671875, 1},
   {0.6875, 0.691406, 0.675781, 1},
   {0.6875, 0.695312, 0.675781, 1},
   {0.691406, 0.695312, 0.679688, 1},
   {0.691406, 0.699219, 0.679688, 1},
   {0.695312, 0.699219, 0.683594, 1},
   {0.695312, 0.699219, 0.683594, 1},
   {0.695312, 0.703125, 0.6875, 1},
   {0.699219, 0.703125, 0.6875, 1},
   {0.699219, 0.707031, 0.6875, 1},
   {0.703125, 0.707031, 0.691406, 1},
   {0.703125, 0.707031, 0.691406, 1},
   {0.703125, 0.710938, 0.695312, 1},
   {0.707031, 0.710938, 0.695312, 1},
   {0.707031, 0.714844, 0.699219, 1},
   {0.710938, 0.714844, 0.699219, 1},
   {0.710938, 0.714844, 0.699219, 1},
   {0.710938, 0.71875, 0.703125, 1},
   {0.730469, 0.734375, 0.71875, 1},
   {0.746094, 0.75, 0.734375, 1},
   {0.746094, 0.75, 0.734375, 1},
   {0.746094, 0.75, 0.734375, 1},
   {0.746094, 0.75, 0.738281, 1},
   {0.746094, 0.75, 0.738281, 1},
   {0.746094, 0.75, 0.738281, 1},
   {0.75, 0.753906, 0.738281, 1},
   {0.75, 0.753906, 0.742188, 1},
   {0.75, 0.753906, 0.742188, 1},
   {0.753906, 0.757812, 0.746094, 1},
   {0.761719, 0.765625, 0.753906, 1},
   {0.773438, 0.777344, 0.765625, 1},
   {0.792969, 0.796875, 0.789062, 1},
   {0.800781, 0.800781, 0.796875, 1},
   {0.804688, 0.804688, 0.800781, 1},
   {0.808594, 0.8125, 0.808594, 1},
   {0.816406, 0.816406, 0.8125, 1},
   {0.820312, 0.824219, 0.816406, 1},
   {0.828125, 0.828125, 0.824219, 1},
   {0.832031, 0.832031, 0.828125, 1},
   {0.835938, 0.839844, 0.832031, 1},
   {0.835938, 0.835938, 0.828125, 1},
   {0.832031, 0.835938, 0.824219, 1},
   {0.828125, 0.832031, 0.816406, 1},
   {0.828125, 0.828125, 0.8125, 1},
   {0.824219, 0.824219, 0.808594, 1},
   {0.820312, 0.820312, 0.800781, 1},
   {0.816406, 0.816406, 0.796875, 1},
   {0.808594, 0.808594, 0.777344, 1},
   {0.800781, 0.796875, 0.761719, 1},
   {0.824219, 0.820312, 0.792969, 1},
   {0.835938, 0.832031, 0.804688, 1},
   {0.84375, 0.84375, 0.816406, 1},
   {0.851562, 0.851562, 0.828125, 1},
   {0.859375, 0.855469, 0.835938, 1},
   {0.863281, 0.863281, 0.84375, 1},
   {0.871094, 0.867188, 0.851562, 1},
   {0.875, 0.871094, 0.855469, 1},
   {0.878906, 0.875, 0.863281, 1},
   {0.882812, 0.882812, 0.867188, 1},
   {0.886719, 0.882812, 0.871094, 1},
   {0.890625, 0.886719, 0.875, 1},
   {0.894531, 0.890625, 0.878906, 1},
   {0.894531, 0.894531, 0.882812, 1},
   {0.898438, 0.898438, 0.886719, 1},
   {0.902344, 0.898438, 0.890625, 1},
   {0.902344, 0.902344, 0.894531, 1},
   {0.90625, 0.90625, 0.898438, 1},
   {0.90625, 0.90625, 0.902344, 1},
   {0.910156, 0.910156, 0.902344, 1},
   {0.910156, 0.910156, 0.90625, 1},
   {0.914062, 0.914062, 0.910156, 1},
   {0.917969, 0.917969, 0.914062, 1},
   {0.921875, 0.921875, 0.917969, 1},
   {0.925781, 0.925781, 0.921875, 1},
   {0.929688, 0.925781, 0.925781, 1},
   {0.929688, 0.929688, 0.929688, 1},
   {0.929688, 0.929688, 0.929688, 1},
   {0.933594, 0.929688, 0.929688, 1},
   {0.933594, 0.933594, 0.933594, 1},
   {0.929688, 0.929688, 0.929688, 1},
   {0.925781, 0.925781, 0.925781, 1},
   {0.914062, 0.914062, 0.914062, 1},
   {0.90625, 0.90625, 0.90625, 1},
   {0.894531, 0.894531, 0.894531, 1},
   {0.878906, 0.878906, 0.878906, 1},
   {0.859375, 0.859375, 0.859375, 1},
   {0.832031, 0.832031, 0.832031, 1},
   {0.679688, 0.679688, 0.683594, 1},
   {0.730469, 0.730469, 0.738281, 1},
   {0.753906, 0.753906, 0.765625, 1},
   {0.769531, 0.769531, 0.785156, 1},
   {0.777344, 0.777344, 0.792969, 1},
   {0.785156, 0.785156, 0.796875, 1},
   {0.796875, 0.792969, 0.800781, 1},
   {0.804688, 0.796875, 0.800781, 1},
   {0.8125, 0.804688, 0.804688, 1},
   {0.816406, 0.804688, 0.804688, 1},
   {0.808594, 0.800781, 0.800781, 1},
   {0.804688, 0.792969, 0.792969, 1},
   {0.796875, 0.789062, 0.789062, 1},
   {0.792969, 0.785156, 0.785156, 1},
   {0.785156, 0.777344, 0.78125, 1},
   {0.78125, 0.773438, 0.773438, 1},
   {0.773438, 0.769531, 0.769531, 1},
   {0.761719, 0.757812, 0.761719, 1},
   {0.738281, 0.738281, 0.738281, 1},
   {0.722656, 0.726562, 0.726562, 1},
   {0.722656, 0.730469, 0.726562, 1},
   {0.726562, 0.734375, 0.722656, 1},
   {0.726562, 0.738281, 0.722656, 1},
   {0.726562, 0.742188, 0.722656, 1},
   {0.730469, 0.742188, 0.71875, 1},
   {0.730469, 0.746094, 0.71875, 1},
   {0.730469, 0.75, 0.71875, 1},
   {0.730469, 0.753906, 0.71875, 1},
   {0.730469, 0.753906, 0.71875, 1},
   {0.71875, 0.738281, 0.703125, 1},
   {0.699219, 0.714844, 0.683594, 1},
   {0.679688, 0.695312, 0.667969, 1},
   {0.652344, 0.664062, 0.640625, 1},
   {0.621094, 0.628906, 0.613281, 1},
   {0.617188, 0.625, 0.609375, 1},
   {0.617188, 0.621094, 0.609375, 1},
   {0.613281, 0.621094, 0.605469, 1},
   {0.609375, 0.617188, 0.601562, 1},
   {0.605469, 0.613281, 0.597656, 1},
   {0.601562, 0.605469, 0.59375, 1},
   {0.59375, 0.597656, 0.589844, 1},
   {0.582031, 0.589844, 0.578125, 1},
   {0.570312, 0.574219, 0.566406, 1},
   {0.546875, 0.546875, 0.542969, 1},
   {0.523438, 0.523438, 0.523438, 1},
   {0.523438, 0.523438, 0.523438, 1},
   {0.523438, 0.523438, 0.523438, 1},
   {0.523438, 0.523438, 0.523438, 1},
   {0.523438, 0.523438, 0.519531, 1},
   {0.523438, 0.519531, 0.519531, 1},
   {0.519531, 0.519531, 0.515625, 1},
   {0.515625, 0.511719, 0.503906, 1},
   {0.507812, 0.503906, 0.492188, 1},
   {0.464844, 0.457031, 0.449219, 1},
   {0.507812, 0.492188, 0.492188, 1},
   {0.542969, 0.519531, 0.527344, 1},
   {0.507812, 0.511719, 0.496094, 1},
   {0.507812, 0.511719, 0.496094, 1},
   {0.507812, 0.511719, 0.496094, 1},
   {0.507812, 0.511719, 0.496094, 1},
   {0.507812, 0.511719, 0.496094, 1},
   {0.507812, 0.511719, 0.496094, 1},
   {0.507812, 0.507812, 0.496094, 1},
   {0.507812, 0.507812, 0.496094, 1},
   {0.503906, 0.507812, 0.492188, 1},
   {0.503906, 0.503906, 0.492188, 1},
   {0.5, 0.503906, 0.492188, 1},
   {0.5, 0.5, 0.488281, 1},
   {0.496094, 0.496094, 0.488281, 1},
   {0.492188, 0.488281, 0.484375, 1},
   {0.484375, 0.480469, 0.476562, 1},
   {0.476562, 0.46875, 0.46875, 1},
   {0.476562, 0.464844, 0.46875, 1},
   {0.472656, 0.464844, 0.464844, 1},
   {0.472656, 0.464844, 0.464844, 1},
   {0.472656, 0.464844, 0.464844, 1},
   {0.472656, 0.464844, 0.464844, 1},
   {0.472656, 0.460938, 0.464844, 1},
   {0.472656, 0.460938, 0.464844, 1},
   {0.472656, 0.460938, 0.464844, 1},
   {0.472656, 0.460938, 0.464844, 1},
   {0.472656, 0.457031, 0.464844, 1},
   {0.46875, 0.457031, 0.460938, 1},
   {0.46875, 0.457031, 0.460938, 1},
   {0.46875, 0.457031, 0.460938, 1},
   {0.46875, 0.453125, 0.460938, 1},
   {0.464844, 0.453125, 0.460938, 1},
   {0.464844, 0.453125, 0.457031, 1},
   {0.464844, 0.453125, 0.457031, 1},
   {0.464844, 0.453125, 0.457031, 1},
   {0.464844, 0.453125, 0.457031, 1},
   {0.464844, 0.453125, 0.457031, 1},
   {0.464844, 0.453125, 0.460938, 1},
   {0.464844, 0.453125, 0.460938, 1},
   {0.464844, 0.453125, 0.460938, 1},
   {0.464844, 0.453125, 0.460938, 1},
   {0.464844, 0.453125, 0.460938, 1},
   {0.464844, 0.453125, 0.460938, 1},
   {0.46875, 0.453125, 0.460938, 1},
   {0.472656, 0.457031, 0.464844, 1},
   {0.46875, 0.453125, 0.460938, 1},
   {0.476562, 0.457031, 0.46875, 1},
   {0.484375, 0.464844, 0.476562, 1},
   {0.488281, 0.472656, 0.484375, 1},
   {0.496094, 0.480469, 0.492188, 1},
   {0.503906, 0.488281, 0.5, 1},
   {0.511719, 0.492188, 0.503906, 1},
   {0.515625, 0.496094, 0.511719, 1},
   {0.519531, 0.503906, 0.515625, 1},
   {0.527344, 0.507812, 0.523438, 1},
   {0.53125, 0.511719, 0.527344, 1},
   {0.535156, 0.519531, 0.53125, 1},
   {0.542969, 0.523438, 0.539062, 1},
   {0.546875, 0.527344, 0.542969, 1},
   {0.554688, 0.535156, 0.546875, 1},
});

const Palette BPAL_15 = Palette("sunrise",
{
   {0.859375, 0.859375, 0.859375, 1},
   {0.859375, 0.859375, 0.855469, 1},
   {0.863281, 0.863281, 0.855469, 1},
   {0.863281, 0.863281, 0.855469, 1},
   {0.863281, 0.867188, 0.855469, 1},
   {0.867188, 0.867188, 0.851562, 1},
   {0.867188, 0.871094, 0.851562, 1},
   {0.871094, 0.871094, 0.851562, 1},
   {0.871094, 0.875, 0.851562, 1},
   {0.871094, 0.875, 0.847656, 1},
   {0.875, 0.878906, 0.847656, 1},
   {0.875, 0.878906, 0.847656, 1},
   {0.878906, 0.882812, 0.847656, 1},
   {0.878906, 0.882812, 0.84375, 1},
   {0.882812, 0.886719, 0.84375, 1},
   {0.882812, 0.890625, 0.84375, 1},
   {0.882812, 0.890625, 0.84375, 1},
   {0.886719, 0.894531, 0.839844, 1},
   {0.886719, 0.894531, 0.839844, 1},
   {0.890625, 0.898438, 0.839844, 1},
   {0.890625, 0.898438, 0.839844, 1},
   {0.890625, 0.902344, 0.835938, 1},
   {0.894531, 0.902344, 0.835938, 1},
   {0.894531, 0.90625, 0.835938, 1},
   {0.898438, 0.90625, 0.835938, 1},
   {0.898438, 0.910156, 0.832031, 1},
   {0.902344, 0.910156, 0.832031, 1},
   {0.902344, 0.914062, 0.832031, 1},
   {0.90625, 0.917969, 0.828125, 1},
   {0.910156, 0.921875, 0.828125, 1},
   {0.914062, 0.925781, 0.824219, 1},
   {0.917969, 0.929688, 0.824219, 1},
   {0.917969, 0.9375, 0.820312, 1},
   {0.921875, 0.941406, 0.820312, 1},
   {0.925781, 0.945312, 0.816406, 1},
   {0.929688, 0.949219, 0.816406, 1},
   {0.933594, 0.953125, 0.8125, 1},
   {0.9375, 0.957031, 0.8125, 1},
   {0.9375, 0.960938, 0.808594, 1},
   {0.941406, 0.964844, 0.808594, 1},
   {0.945312, 0.953125, 0.789062, 1},
   {0.945312, 0.9375, 0.773438, 1},
   {0.945312, 0.925781, 0.757812, 1},
   {0.949219, 0.914062, 0.742188, 1},
   {0.949219, 0.898438, 0.722656, 1},
   {0.953125, 0.886719, 0.707031, 1},
   {0.953125, 0.875, 0.691406, 1},
   {0.957031, 0.863281, 0.671875, 1},
   {0.957031, 0.847656, 0.65625, 1},
   {0.957031, 0.835938, 0.640625, 1},
   {0.960938, 0.824219, 0.625, 1},
   {0.960938, 0.808594, 0.605469, 1},
   {0.964844, 0.796875, 0.589844, 1},
   {0.964844, 0.785156, 0.574219, 1},
   {0.964844, 0.769531, 0.558594, 1},
   {0.96875, 0.757812, 0.539062, 1},
   {0.96875, 0.742188, 0.519531, 1},
   {0.972656, 0.722656, 0.496094, 1},
   {0.972656, 0.707031, 0.472656, 1},
   {0.976562, 0.6875, 0.449219, 1},
   {0.980469, 0.671875, 0.425781, 1},
   {0.980469, 0.652344, 0.40625, 1},
   {0.984375, 0.636719, 0.382812, 1},
   {0.984375, 0.621094, 0.359375, 1},
   {0.988281, 0.601562, 0.335938, 1},
   {0.988281, 0.585938, 0.3125, 1},
   {0.992188, 0.566406, 0.289062, 1},
   {0.992188, 0.550781, 0.269531, 1},
   {0.988281, 0.539062, 0.265625, 1},
   {0.980469, 0.53125, 0.261719, 1},
   {0.972656, 0.523438, 0.261719, 1},
   {0.964844, 0.515625, 0.257812, 1},
   {0.957031, 0.507812, 0.257812, 1},
   {0.949219, 0.496094, 0.253906, 1},
   {0.941406, 0.488281, 0.253906, 1},
   {0.933594, 0.480469, 0.253906, 1},
   {0.925781, 0.472656, 0.25, 1},
   {0.914062, 0.464844, 0.25, 1},
   {0.90625, 0.453125, 0.246094, 1},
   {0.898438, 0.445312, 0.246094, 1},
   {0.890625, 0.4375, 0.242188, 1},
   {0.882812, 0.429688, 0.242188, 1},
   {0.875, 0.421875, 0.238281, 1},
   {0.867188, 0.410156, 0.238281, 1},
   {0.859375, 0.402344, 0.234375, 1},
   {0.851562, 0.394531, 0.234375, 1},
   {0.84375, 0.386719, 0.230469, 1},
   {0.835938, 0.378906, 0.230469, 1},
   {0.828125, 0.367188, 0.226562, 1},
   {0.820312, 0.359375, 0.226562, 1},
   {0.8125, 0.351562, 0.222656, 1},
   {0.804688, 0.34375, 0.222656, 1},
   {0.796875, 0.335938, 0.21875, 1},
   {0.789062, 0.328125, 0.21875, 1},
   {0.777344, 0.3125, 0.214844, 1},
   {0.757812, 0.292969, 0.210938, 1},
   {0.742188, 0.273438, 0.207031, 1},
   {0.722656, 0.25, 0.203125, 1},
   {0.703125, 0.230469, 0.199219, 1},
   {0.683594, 0.210938, 0.191406, 1},
   {0.664062, 0.191406, 0.1875, 1},
   {0.648438, 0.167969, 0.183594, 1},
   {0.628906, 0.148438, 0.179688, 1},
   {0.609375, 0.128906, 0.175781, 1},
   {0.589844, 0.109375, 0.171875, 1},
   {0.574219, 0.09375, 0.164062, 1},
   {0.5625, 0.0976562, 0.160156, 1},
   {0.550781, 0.0976562, 0.15625, 1},
   {0.539062, 0.101562, 0.152344, 1},
   {0.527344, 0.105469, 0.148438, 1},
   {0.515625, 0.105469, 0.140625, 1},
   {0.503906, 0.109375, 0.136719, 1},
   {0.492188, 0.109375, 0.132812, 1},
   {0.480469, 0.113281, 0.128906, 1},
   {0.46875, 0.117188, 0.125, 1},
   {0.457031, 0.117188, 0.117188, 1},
   {0.445312, 0.121094, 0.113281, 1},
   {0.433594, 0.121094, 0.109375, 1},
   {0.421875, 0.125, 0.105469, 1},
   {0.410156, 0.128906, 0.0976562, 1},
   {0.398438, 0.128906, 0.09375, 1},
   {0.382812, 0.132812, 0.0898438, 1},
   {0.371094, 0.136719, 0.0820312, 1},
   {0.359375, 0.136719, 0.078125, 1},
   {0.34375, 0.140625, 0.0742188, 1},
   {0.332031, 0.144531, 0.0664062, 1},
   {0.320312, 0.144531, 0.0625, 1},
   {0.304688, 0.148438, 0.0546875, 1},
   {0.292969, 0.152344, 0.0507812, 1},
   {0.285156, 0.15625, 0.0507812, 1},
   {0.285156, 0.160156, 0.0664062, 1},
   {0.285156, 0.164062, 0.078125, 1},
   {0.289062, 0.167969, 0.09375, 1},
   {0.289062, 0.175781, 0.105469, 1},
   {0.289062, 0.179688, 0.121094, 1},
   {0.289062, 0.183594, 0.132812, 1},
   {0.292969, 0.1875, 0.148438, 1},
   {0.292969, 0.195312, 0.160156, 1},
   {0.292969, 0.199219, 0.175781, 1},
   {0.292969, 0.203125, 0.1875, 1},
   {0.292969, 0.207031, 0.203125, 1},
   {0.296875, 0.214844, 0.214844, 1},
   {0.296875, 0.21875, 0.230469, 1},
   {0.296875, 0.222656, 0.242188, 1},
   {0.296875, 0.226562, 0.257812, 1},
   {0.300781, 0.234375, 0.269531, 1},
   {0.300781, 0.238281, 0.285156, 1},
   {0.300781, 0.242188, 0.296875, 1},
   {0.300781, 0.25, 0.3125, 1},
   {0.300781, 0.253906, 0.324219, 1},
   {0.304688, 0.257812, 0.339844, 1},
   {0.304688, 0.261719, 0.351562, 1},
   {0.304688, 0.269531, 0.367188, 1},
   {0.304688, 0.273438, 0.378906, 1},
   {0.308594, 0.277344, 0.394531, 1},
   {0.308594, 0.28125, 0.40625, 1},
   {0.308594, 0.289062, 0.421875, 1},
   {0.308594, 0.296875, 0.441406, 1},
   {0.3125, 0.304688, 0.464844, 1},
   {0.3125, 0.3125, 0.484375, 1},
   {0.3125, 0.320312, 0.507812, 1},
   {0.316406, 0.328125, 0.53125, 1},
   {0.316406, 0.335938, 0.550781, 1},
   {0.320312, 0.34375, 0.574219, 1},
   {0.320312, 0.351562, 0.59375, 1},
   {0.320312, 0.359375, 0.617188, 1},
   {0.324219, 0.367188, 0.636719, 1},
   {0.324219, 0.375, 0.660156, 1},
   {0.324219, 0.382812, 0.679688, 1},
   {0.328125, 0.390625, 0.703125, 1},
   {0.328125, 0.398438, 0.722656, 1},
   {0.328125, 0.40625, 0.746094, 1},
   {0.332031, 0.414062, 0.765625, 1},
   {0.332031, 0.421875, 0.789062, 1},
   {0.335938, 0.425781, 0.796875, 1},
   {0.34375, 0.433594, 0.800781, 1},
   {0.347656, 0.441406, 0.800781, 1},
   {0.355469, 0.445312, 0.804688, 1},
   {0.363281, 0.453125, 0.804688, 1},
   {0.367188, 0.460938, 0.808594, 1},
   {0.375, 0.464844, 0.8125, 1},
   {0.378906, 0.472656, 0.8125, 1},
   {0.386719, 0.480469, 0.816406, 1},
   {0.390625, 0.488281, 0.816406, 1},
   {0.398438, 0.492188, 0.820312, 1},
   {0.402344, 0.5, 0.824219, 1},
   {0.410156, 0.507812, 0.824219, 1},
   {0.417969, 0.511719, 0.828125, 1},
   {0.421875, 0.519531, 0.828125, 1},
   {0.429688, 0.527344, 0.832031, 1},
   {0.433594, 0.53125, 0.835938, 1},
   {0.441406, 0.539062, 0.835938, 1},
   {0.445312, 0.546875, 0.839844, 1},
   {0.453125, 0.550781, 0.839844, 1},
   {0.457031, 0.558594, 0.84375, 1},
   {0.464844, 0.566406, 0.847656, 1},
   {0.472656, 0.574219, 0.847656, 1},
   {0.476562, 0.578125, 0.851562, 1},
   {0.484375, 0.585938, 0.851562, 1},
   {0.488281, 0.59375, 0.855469, 1},
   {0.496094, 0.597656, 0.859375, 1},
   {0.5, 0.605469, 0.859375, 1},
   {0.507812, 0.613281, 0.863281, 1},
   {0.515625, 0.617188, 0.863281, 1},
   {0.519531, 0.625, 0.867188, 1},
   {0.527344, 0.632812, 0.871094, 1},
   {0.53125, 0.636719, 0.871094, 1},
   {0.539062, 0.644531, 0.875, 1},
   {0.542969, 0.652344, 0.875, 1},
   {0.550781, 0.660156, 0.878906, 1},
   {0.554688, 0.664062, 0.882812, 1},
   {0.5625, 0.671875, 0.882812, 1},
   {0.570312, 0.679688, 0.886719, 1},
   {0.574219, 0.683594, 0.886719, 1},
   {0.582031, 0.691406, 0.890625, 1},
   {0.585938, 0.699219, 0.894531, 1},
   {0.59375, 0.703125, 0.894531, 1},
   {0.601562, 0.710938, 0.898438, 1},
   {0.605469, 0.71875, 0.902344, 1},
   {0.613281, 0.726562, 0.902344, 1},
   {0.621094, 0.734375, 0.90625, 1},
   {0.625, 0.738281, 0.910156, 1},
   {0.632812, 0.746094, 0.910156, 1},
   {0.636719, 0.753906, 0.914062, 1},
   {0.644531, 0.761719, 0.914062, 1},
   {0.652344, 0.769531, 0.917969, 1},
   {0.65625, 0.777344, 0.921875, 1},
   {0.664062, 0.78125, 0.921875, 1},
   {0.671875, 0.789062, 0.925781, 1},
   {0.675781, 0.796875, 0.929688, 1},
   {0.683594, 0.804688, 0.929688, 1},
   {0.691406, 0.8125, 0.933594, 1},
   {0.695312, 0.816406, 0.9375, 1},
   {0.703125, 0.824219, 0.9375, 1},
   {0.710938, 0.832031, 0.941406, 1},
   {0.714844, 0.839844, 0.945312, 1},
   {0.722656, 0.847656, 0.945312, 1},
   {0.730469, 0.851562, 0.949219, 1},
   {0.734375, 0.859375, 0.953125, 1},
   {0.742188, 0.867188, 0.953125, 1},
   {0.75, 0.875, 0.957031, 1},
   {0.753906, 0.882812, 0.957031, 1},
   {0.761719, 0.886719, 0.960938, 1},
   {0.769531, 0.894531, 0.964844, 1},
   {0.773438, 0.902344, 0.964844, 1},
   {0.78125, 0.910156, 0.96875, 1},
   {0.789062, 0.917969, 0.972656, 1},
   {0.792969, 0.921875, 0.972656, 1},
   {0.800781, 0.929688, 0.976562, 1},
   {0.808594, 0.9375, 0.980469, 1},
   {0.8125, 0.945312, 0.980469, 1},
   {0.820312, 0.953125, 0.984375, 1},
   {0.828125, 0.957031, 0.988281, 1},
   {0.832031, 0.964844, 0.988281, 1},
   {0.839844, 0.972656, 0.992188, 1},
   {0.847656, 0.980469, 0.992188, 1},
});

const Palette BPAL_16 = Palette("horizon",
{
   {0.046875, 0.355469, 0.566406, 1},
   {0.0546875, 0.363281, 0.570312, 1},
   {0.0625, 0.367188, 0.574219, 1},
   {0.0703125, 0.371094, 0.578125, 1},
   {0.078125, 0.378906, 0.582031, 1},
   {0.0859375, 0.382812, 0.585938, 1},
   {0.09375, 0.386719, 0.589844, 1},
   {0.101562, 0.394531, 0.59375, 1},
   {0.109375, 0.398438, 0.597656, 1},
   {0.117188, 0.402344, 0.597656, 1},
   {0.125, 0.410156, 0.601562, 1},
   {0.132812, 0.414062, 0.605469, 1},
   {0.140625, 0.417969, 0.609375, 1},
   {0.148438, 0.425781, 0.613281, 1},
   {0.15625, 0.429688, 0.617188, 1},
   {0.164062, 0.433594, 0.621094, 1},
   {0.171875, 0.441406, 0.625, 1},
   {0.179688, 0.445312, 0.625, 1},
   {0.1875, 0.449219, 0.628906, 1},
   {0.195312, 0.457031, 0.632812, 1},
   {0.203125, 0.460938, 0.636719, 1},
   {0.210938, 0.464844, 0.640625, 1},
   {0.21875, 0.472656, 0.644531, 1},
   {0.226562, 0.476562, 0.648438, 1},
   {0.234375, 0.480469, 0.652344, 1},
   {0.242188, 0.488281, 0.652344, 1},
   {0.25, 0.492188, 0.65625, 1},
   {0.257812, 0.496094, 0.660156, 1},
   {0.265625, 0.503906, 0.664062, 1},
   {0.273438, 0.507812, 0.667969, 1},
   {0.28125, 0.511719, 0.671875, 1},
   {0.289062, 0.519531, 0.675781, 1},
   {0.296875, 0.523438, 0.679688, 1},
   {0.308594, 0.527344, 0.679688, 1},
   {0.316406, 0.535156, 0.683594, 1},
   {0.324219, 0.539062, 0.6875, 1},
   {0.332031, 0.542969, 0.691406, 1},
   {0.339844, 0.550781, 0.695312, 1},
   {0.347656, 0.554688, 0.699219, 1},
   {0.355469, 0.558594, 0.703125, 1},
   {0.363281, 0.566406, 0.707031, 1},
   {0.371094, 0.570312, 0.707031, 1},
   {0.378906, 0.574219, 0.710938, 1},
   {0.386719, 0.582031, 0.714844, 1},
   {0.394531, 0.585938, 0.71875, 1},
   {0.402344, 0.589844, 0.722656, 1},
   {0.410156, 0.597656, 0.726562, 1},
   {0.417969, 0.601562, 0.730469, 1},
   {0.425781, 0.605469, 0.734375, 1},
   {0.433594, 0.613281, 0.738281, 1},
   {0.441406, 0.617188, 0.738281, 1},
   {0.449219, 0.621094, 0.742188, 1},
   {0.457031, 0.628906, 0.746094, 1},
   {0.464844, 0.632812, 0.75, 1},
   {0.472656, 0.636719, 0.753906, 1},
   {0.480469, 0.644531, 0.757812, 1},
   {0.488281, 0.648438, 0.761719, 1},
   {0.496094, 0.652344, 0.765625, 1},
   {0.503906, 0.660156, 0.765625, 1},
   {0.511719, 0.664062, 0.769531, 1},
   {0.519531, 0.667969, 0.773438, 1},
   {0.527344, 0.671875, 0.777344, 1},
   {0.535156, 0.679688, 0.78125, 1},
   {0.542969, 0.683594, 0.78125, 1},
   {0.546875, 0.6875, 0.785156, 1},
   {0.554688, 0.691406, 0.789062, 1},
   {0.5625, 0.695312, 0.792969, 1},
   {0.570312, 0.699219, 0.792969, 1},
   {0.574219, 0.703125, 0.796875, 1},
   {0.582031, 0.710938, 0.800781, 1},
   {0.589844, 0.714844, 0.804688, 1},
   {0.597656, 0.71875, 0.804688, 1},
   {0.601562, 0.722656, 0.808594, 1},
   {0.609375, 0.726562, 0.8125, 1},
   {0.617188, 0.730469, 0.816406, 1},
   {0.625, 0.734375, 0.816406, 1},
   {0.628906, 0.742188, 0.820312, 1},
   {0.636719, 0.746094, 0.824219, 1},
   {0.644531, 0.75, 0.828125, 1},
   {0.652344, 0.753906, 0.832031, 1},
   {0.65625, 0.757812, 0.832031, 1},
   {0.664062, 0.761719, 0.835938, 1},
   {0.671875, 0.765625, 0.839844, 1},
   {0.679688, 0.773438, 0.84375, 1},
   {0.683594, 0.777344, 0.84375, 1},
   {0.691406, 0.78125, 0.847656, 1},
   {0.699219, 0.785156, 0.851562, 1},
   {0.707031, 0.789062, 0.855469, 1},
   {0.710938, 0.792969, 0.855469, 1},
   {0.71875, 0.796875, 0.859375, 1},
   {0.726562, 0.804688, 0.863281, 1},
   {0.734375, 0.808594, 0.867188, 1},
   {0.738281, 0.8125, 0.867188, 1},
   {0.746094, 0.816406, 0.871094, 1},
   {0.753906, 0.820312, 0.875, 1},
   {0.761719, 0.824219, 0.878906, 1},
   {0.765625, 0.828125, 0.878906, 1},
   {0.773438, 0.835938, 0.882812, 1},
   {0.78125, 0.839844, 0.886719, 1},
   {0.789062, 0.84375, 0.890625, 1},
   {0.792969, 0.847656, 0.890625, 1},
   {0.800781, 0.851562, 0.894531, 1},
   {0.808594, 0.855469, 0.898438, 1},
   {0.816406, 0.859375, 0.902344, 1},
   {0.820312, 0.867188, 0.902344, 1},
   {0.828125, 0.871094, 0.90625, 1},
   {0.835938, 0.875, 0.910156, 1},
   {0.839844, 0.878906, 0.914062, 1},
   {0.847656, 0.882812, 0.914062, 1},
   {0.855469, 0.886719, 0.917969, 1},
   {0.863281, 0.890625, 0.921875, 1},
   {0.867188, 0.898438, 0.925781, 1},
   {0.875, 0.902344, 0.925781, 1},
   {0.882812, 0.90625, 0.929688, 1},
   {0.890625, 0.910156, 0.933594, 1},
   {0.894531, 0.914062, 0.9375, 1},
   {0.902344, 0.917969, 0.9375, 1},
   {0.910156, 0.921875, 0.941406, 1},
   {0.917969, 0.925781, 0.945312, 1},
   {0.921875, 0.933594, 0.949219, 1},
   {0.929688, 0.9375, 0.949219, 1},
   {0.9375, 0.941406, 0.953125, 1},
   {0.945312, 0.945312, 0.957031, 1},
   {0.949219, 0.949219, 0.960938, 1},
   {0.957031, 0.953125, 0.960938, 1},
   {0.964844, 0.957031, 0.964844, 1},
   {0.972656, 0.964844, 0.96875, 1},
   {0.976562, 0.96875, 0.972656, 1},
   {0.984375, 0.972656, 0.972656, 1},
   {0.992188, 0.976562, 0.976562, 1},
   {0.992188, 0.988281, 0.988281, 1},
   {0.988281, 0.980469, 0.976562, 1},
   {0.984375, 0.972656, 0.964844, 1},
   {0.984375, 0.964844, 0.953125, 1},
   {0.980469, 0.957031, 0.945312, 1},
   {0.976562, 0.949219, 0.933594, 1},
   {0.972656, 0.941406, 0.925781, 1},
   {0.972656, 0.933594, 0.914062, 1},
   {0.96875, 0.925781, 0.90625, 1},
   {0.964844, 0.917969, 0.894531, 1},
   {0.964844, 0.914062, 0.886719, 1},
   {0.960938, 0.90625, 0.875, 1},
   {0.957031, 0.898438, 0.867188, 1},
   {0.957031, 0.890625, 0.859375, 1},
   {0.953125, 0.886719, 0.847656, 1},
   {0.949219, 0.878906, 0.839844, 1},
   {0.949219, 0.871094, 0.832031, 1},
   {0.945312, 0.863281, 0.824219, 1},
   {0.941406, 0.859375, 0.8125, 1},
   {0.941406, 0.851562, 0.804688, 1},
   {0.9375, 0.84375, 0.796875, 1},
   {0.9375, 0.839844, 0.789062, 1},
   {0.933594, 0.832031, 0.777344, 1},
   {0.929688, 0.824219, 0.769531, 1},
   {0.925781, 0.816406, 0.757812, 1},
   {0.925781, 0.808594, 0.746094, 1},
   {0.921875, 0.800781, 0.738281, 1},
   {0.917969, 0.792969, 0.726562, 1},
   {0.914062, 0.785156, 0.714844, 1},
   {0.914062, 0.777344, 0.703125, 1},
   {0.910156, 0.765625, 0.691406, 1},
   {0.90625, 0.757812, 0.683594, 1},
   {0.902344, 0.75, 0.671875, 1},
   {0.898438, 0.742188, 0.660156, 1},
   {0.898438, 0.734375, 0.652344, 1},
   {0.894531, 0.726562, 0.640625, 1},
   {0.890625, 0.71875, 0.632812, 1},
   {0.890625, 0.714844, 0.621094, 1},
   {0.886719, 0.707031, 0.613281, 1},
   {0.882812, 0.699219, 0.601562, 1},
   {0.878906, 0.691406, 0.59375, 1},
   {0.878906, 0.683594, 0.582031, 1},
   {0.875, 0.675781, 0.570312, 1},
   {0.871094, 0.667969, 0.5625, 1},
   {0.871094, 0.660156, 0.550781, 1},
   {0.871094, 0.660156, 0.550781, 1},
   {0.867188, 0.660156, 0.550781, 1},
   {0.867188, 0.65625, 0.546875, 1},
   {0.867188, 0.65625, 0.546875, 1},
   {0.867188, 0.65625, 0.542969, 1},
   {0.867188, 0.652344, 0.542969, 1},
   {0.867188, 0.652344, 0.542969, 1},
   {0.867188, 0.652344, 0.539062, 1},
   {0.867188, 0.652344, 0.539062, 1},
   {0.867188, 0.648438, 0.535156, 1},
   {0.863281, 0.648438, 0.535156, 1},
   {0.863281, 0.648438, 0.535156, 1},
   {0.863281, 0.644531, 0.53125, 1},
   {0.863281, 0.644531, 0.53125, 1},
   {0.863281, 0.644531, 0.53125, 1},
   {0.863281, 0.640625, 0.527344, 1},
   {0.863281, 0.640625, 0.527344, 1},
   {0.863281, 0.640625, 0.523438, 1},
   {0.863281, 0.640625, 0.523438, 1},
   {0.859375, 0.636719, 0.523438, 1},
   {0.859375, 0.636719, 0.519531, 1},
   {0.859375, 0.636719, 0.519531, 1},
   {0.859375, 0.632812, 0.515625, 1},
   {0.859375, 0.632812, 0.515625, 1},
   {0.859375, 0.632812, 0.515625, 1},
   {0.859375, 0.632812, 0.511719, 1},
   {0.859375, 0.628906, 0.511719, 1},
   {0.859375, 0.628906, 0.507812, 1},
   {0.855469, 0.628906, 0.507812, 1},
   {0.855469, 0.625, 0.507812, 1},
   {0.855469, 0.625, 0.503906, 1},
   {0.855469, 0.625, 0.503906, 1},
   {0.855469, 0.621094, 0.5, 1},
   {0.855469, 0.621094, 0.5, 1},
   {0.855469, 0.621094, 0.5, 1},
   {0.855469, 0.621094, 0.496094, 1},
   {0.855469, 0.617188, 0.496094, 1},
   {0.851562, 0.617188, 0.496094, 1},
   {0.851562, 0.617188, 0.492188, 1},
   {0.851562, 0.613281, 0.492188, 1},
   {0.851562, 0.613281, 0.488281, 1},
   {0.851562, 0.613281, 0.488281, 1},
   {0.851562, 0.613281, 0.488281, 1},
   {0.851562, 0.609375, 0.484375, 1},
   {0.851562, 0.609375, 0.484375, 1},
   {0.851562, 0.609375, 0.480469, 1},
   {0.847656, 0.605469, 0.480469, 1},
   {0.847656, 0.605469, 0.476562, 1},
   {0.847656, 0.601562, 0.476562, 1},
   {0.847656, 0.601562, 0.472656, 1},
   {0.847656, 0.597656, 0.46875, 1},
   {0.847656, 0.597656, 0.46875, 1},
   {0.84375, 0.597656, 0.464844, 1},
   {0.84375, 0.59375, 0.464844, 1},
   {0.84375, 0.59375, 0.460938, 1},
   {0.84375, 0.589844, 0.460938, 1},
   {0.84375, 0.589844, 0.457031, 1},
   {0.84375, 0.585938, 0.457031, 1},
   {0.839844, 0.585938, 0.453125, 1},
   {0.839844, 0.585938, 0.449219, 1},
   {0.839844, 0.582031, 0.449219, 1},
   {0.839844, 0.582031, 0.445312, 1},
   {0.839844, 0.578125, 0.445312, 1},
   {0.839844, 0.578125, 0.441406, 1},
   {0.839844, 0.574219, 0.441406, 1},
   {0.835938, 0.574219, 0.4375, 1},
   {0.835938, 0.574219, 0.433594, 1},
   {0.835938, 0.570312, 0.433594, 1},
   {0.835938, 0.570312, 0.429688, 1},
   {0.835938, 0.566406, 0.429688, 1},
   {0.835938, 0.566406, 0.425781, 1},
   {0.832031, 0.566406, 0.425781, 1},
   {0.832031, 0.5625, 0.421875, 1},
   {0.832031, 0.5625, 0.421875, 1},
   {0.832031, 0.558594, 0.417969, 1},
   {0.832031, 0.558594, 0.414062, 1},
   {0.832031, 0.554688, 0.414062, 1},
   {0.828125, 0.554688, 0.410156, 1},
   {0.828125, 0.554688, 0.410156, 1},
   {0.828125, 0.550781, 0.40625, 1},
   {0.828125, 0.550781, 0.40625, 1},
});

const Palette BPAL_17 = Palette("byr",
{
   {0.019531, 0.136719, 0.3125, 1},
   {0.019531, 0.144531, 0.324219, 1},
   {0.019531, 0.152344, 0.335938, 1},
   {0.019531, 0.15625, 0.347656, 1},
   {0.019531, 0.164062, 0.359375, 1},
   {0.023438, 0.171875, 0.371094, 1},
   {0.023438, 0.179688, 0.382812, 1},
   {0.023438, 0.1875, 0.390625, 1},
   {0.023438, 0.191406, 0.402344, 1},
   {0.023438, 0.199219, 0.414062, 1},
   {0.023438, 0.207031, 0.425781, 1},
   {0.023438, 0.214844, 0.4375, 1},
   {0.023438, 0.222656, 0.449219, 1},
   {0.027344, 0.230469, 0.460938, 1},
   {0.027344, 0.234375, 0.472656, 1},
   {0.027344, 0.242188, 0.484375, 1},
   {0.027344, 0.25, 0.496094, 1},
   {0.027344, 0.257812, 0.507812, 1},
   {0.027344, 0.265625, 0.519531, 1},
   {0.027344, 0.269531, 0.53125, 1},
   {0.027344, 0.277344, 0.539062, 1},
   {0.027344, 0.285156, 0.550781, 1},
   {0.03125, 0.292969, 0.5625, 1},
   {0.03125, 0.300781, 0.574219, 1},
   {0.03125, 0.304688, 0.585938, 1},
   {0.03125, 0.320312, 0.609375, 1},
   {0.039062, 0.328125, 0.617188, 1},
   {0.046875, 0.339844, 0.621094, 1},
   {0.058594, 0.347656, 0.628906, 1},
   {0.066406, 0.359375, 0.636719, 1},
   {0.074219, 0.367188, 0.640625, 1},
   {0.082031, 0.378906, 0.648438, 1},
   {0.09375, 0.386719, 0.65625, 1},
   {0.101562, 0.398438, 0.660156, 1},
   {0.109375, 0.40625, 0.667969, 1},
   {0.117188, 0.417969, 0.675781, 1},
   {0.128906, 0.425781, 0.679688, 1},
   {0.136719, 0.4375, 0.6875, 1},
   {0.144531, 0.445312, 0.695312, 1},
   {0.152344, 0.453125, 0.699219, 1},
   {0.160156, 0.464844, 0.707031, 1},
   {0.171875, 0.472656, 0.710938, 1},
   {0.179688, 0.484375, 0.71875, 1},
   {0.1875, 0.492188, 0.726562, 1},
   {0.195312, 0.503906, 0.730469, 1},
   {0.207031, 0.511719, 0.738281, 1},
   {0.214844, 0.523438, 0.746094, 1},
   {0.222656, 0.53125, 0.75, 1},
   {0.230469, 0.542969, 0.757812, 1},
   {0.242188, 0.550781, 0.765625, 1},
   {0.257812, 0.570312, 0.777344, 1},
   {0.265625, 0.574219, 0.78125, 1},
   {0.269531, 0.582031, 0.78125, 1},
   {0.277344, 0.585938, 0.785156, 1},
   {0.28125, 0.59375, 0.785156, 1},
   {0.289062, 0.597656, 0.789062, 1},
   {0.296875, 0.605469, 0.789062, 1},
   {0.300781, 0.609375, 0.792969, 1},
   {0.308594, 0.613281, 0.796875, 1},
   {0.316406, 0.621094, 0.796875, 1},
   {0.320312, 0.625, 0.800781, 1},
   {0.328125, 0.632812, 0.800781, 1},
   {0.332031, 0.636719, 0.804688, 1},
   {0.339844, 0.644531, 0.808594, 1},
   {0.347656, 0.648438, 0.808594, 1},
   {0.351562, 0.652344, 0.8125, 1},
   {0.359375, 0.660156, 0.8125, 1},
   {0.363281, 0.664062, 0.816406, 1},
   {0.371094, 0.671875, 0.816406, 1},
   {0.378906, 0.675781, 0.820312, 1},
   {0.382812, 0.679688, 0.824219, 1},
   {0.390625, 0.6875, 0.824219, 1},
   {0.398438, 0.691406, 0.828125, 1},
   {0.402344, 0.699219, 0.828125, 1},
   {0.410156, 0.703125, 0.832031, 1},
   {0.414062, 0.710938, 0.832031, 1},
   {0.421875, 0.714844, 0.835938, 1},
   {0.429688, 0.71875, 0.839844, 1},
   {0.441406, 0.726562, 0.839844, 1},
   {0.449219, 0.730469, 0.84375, 1},
   {0.460938, 0.738281, 0.84375, 1},
   {0.46875, 0.742188, 0.847656, 1},
   {0.476562, 0.75, 0.851562, 1},
   {0.488281, 0.753906, 0.851562, 1},
   {0.496094, 0.757812, 0.855469, 1},
   {0.503906, 0.765625, 0.859375, 1},
   {0.515625, 0.769531, 0.859375, 1},
   {0.523438, 0.777344, 0.863281, 1},
   {0.535156, 0.78125, 0.863281, 1},
   {0.542969, 0.789062, 0.867188, 1},
   {0.550781, 0.792969, 0.871094, 1},
   {0.5625, 0.796875, 0.871094, 1},
   {0.570312, 0.804688, 0.875, 1},
   {0.582031, 0.808594, 0.875, 1},
   {0.589844, 0.816406, 0.878906, 1},
   {0.597656, 0.820312, 0.882812, 1},
   {0.609375, 0.824219, 0.882812, 1},
   {0.617188, 0.832031, 0.886719, 1},
   {0.625, 0.835938, 0.890625, 1},
   {0.636719, 0.84375, 0.890625, 1},
   {0.644531, 0.847656, 0.894531, 1},
   {0.664062, 0.859375, 0.898438, 1},
   {0.671875, 0.863281, 0.902344, 1},
   {0.679688, 0.867188, 0.90625, 1},
   {0.6875, 0.871094, 0.910156, 1},
   {0.695312, 0.875, 0.914062, 1},
   {0.699219, 0.878906, 0.917969, 1},
   {0.707031, 0.882812, 0.921875, 1},
   {0.714844, 0.886719, 0.925781, 1},
   {0.722656, 0.890625, 0.929688, 1},
   {0.730469, 0.894531, 0.933594, 1},
   {0.738281, 0.898438, 0.9375, 1},
   {0.746094, 0.902344, 0.941406, 1},
   {0.753906, 0.90625, 0.945312, 1},
   {0.761719, 0.910156, 0.949219, 1},
   {0.765625, 0.910156, 0.949219, 1},
   {0.773438, 0.914062, 0.953125, 1},
   {0.78125, 0.917969, 0.957031, 1},
   {0.789062, 0.921875, 0.960938, 1},
   {0.796875, 0.925781, 0.964844, 1},
   {0.804688, 0.929688, 0.96875, 1},
   {0.8125, 0.933594, 0.972656, 1},
   {0.820312, 0.9375, 0.976562, 1},
   {0.824219, 0.941406, 0.980469, 1},
   {0.832031, 0.945312, 0.984375, 1},
   {0.839844, 0.949219, 0.988281, 1},
   {0.855469, 0.957031, 0.996094, 1},
   {0.996094, 0.996094, 0.78125, 1},
   {0.996094, 0.992188, 0.769531, 1},
   {0.996094, 0.988281, 0.753906, 1},
   {0.996094, 0.984375, 0.742188, 1},
   {0.996094, 0.980469, 0.730469, 1},
   {0.996094, 0.976562, 0.71875, 1},
   {0.996094, 0.972656, 0.703125, 1},
   {0.996094, 0.96875, 0.691406, 1},
   {0.996094, 0.964844, 0.679688, 1},
   {0.996094, 0.960938, 0.667969, 1},
   {0.996094, 0.957031, 0.652344, 1},
   {0.996094, 0.953125, 0.640625, 1},
   {0.996094, 0.949219, 0.628906, 1},
   {0.996094, 0.949219, 0.617188, 1},
   {0.996094, 0.945312, 0.601562, 1},
   {0.996094, 0.941406, 0.589844, 1},
   {0.996094, 0.9375, 0.578125, 1},
   {0.996094, 0.933594, 0.5625, 1},
   {0.996094, 0.929688, 0.550781, 1},
   {0.996094, 0.925781, 0.539062, 1},
   {0.996094, 0.921875, 0.527344, 1},
   {0.996094, 0.917969, 0.511719, 1},
   {0.996094, 0.914062, 0.5, 1},
   {0.996094, 0.910156, 0.488281, 1},
   {0.996094, 0.90625, 0.476562, 1},
   {0.996094, 0.898438, 0.449219, 1},
   {0.996094, 0.894531, 0.441406, 1},
   {0.992188, 0.886719, 0.433594, 1},
   {0.992188, 0.882812, 0.425781, 1},
   {0.988281, 0.878906, 0.421875, 1},
   {0.988281, 0.875, 0.414062, 1},
   {0.984375, 0.867188, 0.40625, 1},
   {0.984375, 0.863281, 0.398438, 1},
   {0.980469, 0.859375, 0.390625, 1},
   {0.980469, 0.855469, 0.382812, 1},
   {0.976562, 0.847656, 0.378906, 1},
   {0.976562, 0.84375, 0.371094, 1},
   {0.972656, 0.839844, 0.363281, 1},
   {0.972656, 0.835938, 0.355469, 1},
   {0.96875, 0.828125, 0.347656, 1},
   {0.96875, 0.824219, 0.339844, 1},
   {0.964844, 0.820312, 0.332031, 1},
   {0.964844, 0.8125, 0.328125, 1},
   {0.960938, 0.808594, 0.320312, 1},
   {0.960938, 0.804688, 0.3125, 1},
   {0.957031, 0.800781, 0.304688, 1},
   {0.957031, 0.792969, 0.296875, 1},
   {0.953125, 0.789062, 0.289062, 1},
   {0.953125, 0.785156, 0.285156, 1},
   {0.949219, 0.78125, 0.277344, 1},
   {0.945312, 0.769531, 0.261719, 1},
   {0.945312, 0.757812, 0.253906, 1},
   {0.941406, 0.746094, 0.246094, 1},
   {0.941406, 0.734375, 0.242188, 1},
   {0.9375, 0.722656, 0.234375, 1},
   {0.9375, 0.710938, 0.226562, 1},
   {0.933594, 0.699219, 0.21875, 1},
   {0.933594, 0.6875, 0.210938, 1},
   {0.929688, 0.675781, 0.207031, 1},
   {0.929688, 0.664062, 0.199219, 1},
   {0.925781, 0.652344, 0.191406, 1},
   {0.925781, 0.640625, 0.183594, 1},
   {0.921875, 0.628906, 0.175781, 1},
   {0.921875, 0.621094, 0.171875, 1},
   {0.921875, 0.609375, 0.164062, 1},
   {0.917969, 0.597656, 0.15625, 1},
   {0.917969, 0.585938, 0.148438, 1},
   {0.914062, 0.574219, 0.140625, 1},
   {0.914062, 0.5625, 0.132812, 1},
   {0.910156, 0.550781, 0.128906, 1},
   {0.910156, 0.539062, 0.121094, 1},
   {0.90625, 0.527344, 0.113281, 1},
   {0.90625, 0.515625, 0.105469, 1},
   {0.902344, 0.503906, 0.097656, 1},
   {0.902344, 0.492188, 0.09375, 1},
   {0.898438, 0.480469, 0.085938, 1},
   {0.898438, 0.46875, 0.078125, 1},
   {0.894531, 0.460938, 0.074219, 1},
   {0.890625, 0.453125, 0.070312, 1},
   {0.886719, 0.445312, 0.070312, 1},
   {0.878906, 0.4375, 0.066406, 1},
   {0.875, 0.429688, 0.0625, 1},
   {0.871094, 0.421875, 0.058594, 1},
   {0.867188, 0.417969, 0.058594, 1},
   {0.863281, 0.410156, 0.054688, 1},
   {0.859375, 0.402344, 0.050781, 1},
   {0.851562, 0.394531, 0.046875, 1},
   {0.847656, 0.386719, 0.046875, 1},
   {0.84375, 0.378906, 0.042969, 1},
   {0.839844, 0.371094, 0.039062, 1},
   {0.835938, 0.363281, 0.035156, 1},
   {0.832031, 0.355469, 0.03125, 1},
   {0.828125, 0.347656, 0.03125, 1},
   {0.820312, 0.339844, 0.027344, 1},
   {0.816406, 0.332031, 0.023438, 1},
   {0.8125, 0.324219, 0.019531, 1},
   {0.808594, 0.320312, 0.019531, 1},
   {0.804688, 0.3125, 0.015625, 1},
   {0.800781, 0.304688, 0.011719, 1},
   {0.792969, 0.296875, 0.007812, 1},
   {0.789062, 0.289062, 0.007812, 1},
   {0.78125, 0.273438, 0, 1},
   {0.773438, 0.269531, 0.003906, 1},
   {0.761719, 0.265625, 0.007812, 1},
   {0.753906, 0.261719, 0.011719, 1},
   {0.742188, 0.253906, 0.015625, 1},
   {0.734375, 0.25, 0.015625, 1},
   {0.722656, 0.246094, 0.019531, 1},
   {0.714844, 0.242188, 0.023438, 1},
   {0.703125, 0.238281, 0.027344, 1},
   {0.695312, 0.234375, 0.03125, 1},
   {0.683594, 0.226562, 0.035156, 1},
   {0.675781, 0.222656, 0.039062, 1},
   {0.664062, 0.21875, 0.042969, 1},
   {0.65625, 0.214844, 0.046875, 1},
   {0.644531, 0.210938, 0.046875, 1},
   {0.636719, 0.207031, 0.050781, 1},
   {0.625, 0.203125, 0.054688, 1},
   {0.617188, 0.195312, 0.058594, 1},
   {0.605469, 0.191406, 0.0625, 1},
   {0.597656, 0.1875, 0.066406, 1},
   {0.585938, 0.183594, 0.070312, 1},
   {0.578125, 0.179688, 0.074219, 1},
   {0.566406, 0.175781, 0.074219, 1},
   {0.558594, 0.167969, 0.078125, 1},
   {0.546875, 0.164062, 0.082031, 1},
   {0.527344, 0.15625, 0.089844, 1},
});

const Palette BPAL_18 = Palette("ocean",
{
   {0.110363, 0.00169078, 0.253026, 1},
   {0.112295, 0.00603321, 0.257538, 1},
   {0.11418, 0.0106084, 0.262052, 1},
   {0.11602, 0.0154203, 0.266566, 1},
   {0.117813, 0.0204727, 0.271076, 1},
   {0.119559, 0.0257694, 0.275581, 1},
   {0.121258, 0.0313141, 0.280079, 1},
   {0.12291, 0.0371103, 0.284567, 1},
   {0.124516, 0.043066, 0.289045, 1},
   {0.126074, 0.0488032, 0.293509, 1},
   {0.127585, 0.0543413, 0.29796, 1},
   {0.129049, 0.0597148, 0.302396, 1},
   {0.130467, 0.0649499, 0.306815, 1},
   {0.131837, 0.0700677, 0.311216, 1},
   {0.13316, 0.0750846, 0.315599, 1},
   {0.134436, 0.0800143, 0.319962, 1},
   {0.135665, 0.084868, 0.324305, 1},
   {0.136846, 0.0896551, 0.328626, 1},
   {0.137981, 0.0943834, 0.332924, 1},
   {0.139069, 0.0990597, 0.337199, 1},
   {0.14011, 0.10369, 0.341449, 1},
   {0.141104, 0.108279, 0.345674, 1},
   {0.142051, 0.112831, 0.349873, 1},
   {0.142951, 0.11735, 0.354045, 1},
   {0.143805, 0.121839, 0.35819, 1},
   {0.144612, 0.126301, 0.362305, 1},
   {0.145372, 0.130739, 0.366392, 1},
   {0.146087, 0.135155, 0.370448, 1},
   {0.146756, 0.139551, 0.374473, 1},
   {0.147379, 0.14393, 0.378466, 1},
   {0.147956, 0.148292, 0.382427, 1},
   {0.148488, 0.152639, 0.386354, 1},
   {0.148976, 0.156972, 0.390248, 1},
   {0.149419, 0.161293, 0.394106, 1},
   {0.149818, 0.165603, 0.39793, 1},
   {0.150174, 0.169902, 0.401717, 1},
   {0.150488, 0.174192, 0.405468, 1},
   {0.150759, 0.178473, 0.409181, 1},
   {0.150989, 0.182746, 0.412857, 1},
   {0.151178, 0.187011, 0.416494, 1},
   {0.151327, 0.191269, 0.420093, 1},
   {0.151437, 0.19552, 0.423652, 1},
   {0.15151, 0.199766, 0.427171, 1},
   {0.151545, 0.204005, 0.43065, 1},
   {0.151545, 0.208239, 0.434088, 1},
   {0.15151, 0.212467, 0.437486, 1},
   {0.151442, 0.21669, 0.440842, 1},
   {0.151342, 0.220909, 0.444157, 1},
   {0.151211, 0.225122, 0.44743, 1},
   {0.151052, 0.229331, 0.450662, 1},
   {0.150865, 0.233535, 0.453852, 1},
   {0.150653, 0.237734, 0.457, 1},
   {0.150417, 0.241929, 0.460107, 1},
   {0.150158, 0.246119, 0.463171, 1},
   {0.14988, 0.250304, 0.466194, 1},
   {0.149584, 0.254485, 0.469176, 1},
   {0.149271, 0.258662, 0.472116, 1},
   {0.148945, 0.262833, 0.475016, 1},
   {0.148608, 0.267, 0.477874, 1},
   {0.148261, 0.271161, 0.480693, 1},
   {0.147907, 0.275318, 0.483471, 1},
   {0.147548, 0.27947, 0.48621, 1},
   {0.147188, 0.283617, 0.48891, 1},
   {0.146828, 0.287759, 0.491572, 1},
   {0.146471, 0.291895, 0.494196, 1},
   {0.14612, 0.296026, 0.496782, 1},
   {0.145777, 0.300152, 0.499331, 1},
   {0.145445, 0.304272, 0.501845, 1},
   {0.145126, 0.308387, 0.504323, 1},
   {0.144824, 0.312496, 0.506766, 1},
   {0.144541, 0.3166, 0.509175, 1},
   {0.14428, 0.320698, 0.511551, 1},
   {0.144043, 0.32479, 0.513894, 1},
   {0.143834, 0.328876, 0.516205, 1},
   {0.143654, 0.332957, 0.518485, 1},
   {0.143507, 0.337032, 0.520735, 1},
   {0.143394, 0.341102, 0.522955, 1},
   {0.14332, 0.345165, 0.525146, 1},
   {0.143285, 0.349223, 0.527309, 1},
   {0.143293, 0.353275, 0.529445, 1},
   {0.143346, 0.357322, 0.531555, 1},
   {0.143446, 0.361363, 0.533639, 1},
   {0.143595, 0.365398, 0.535697, 1},
   {0.143796, 0.369428, 0.537732, 1},
   {0.144051, 0.373452, 0.539743, 1},
   {0.144361, 0.377471, 0.541731, 1},
   {0.144727, 0.381484, 0.543697, 1},
   {0.145153, 0.385493, 0.545641, 1},
   {0.145639, 0.389496, 0.547565, 1},
   {0.146187, 0.393494, 0.549469, 1},
   {0.146798, 0.397487, 0.551354, 1},
   {0.147474, 0.401475, 0.55322, 1},
   {0.148215, 0.405458, 0.555068, 1},
   {0.149022, 0.409437, 0.556898, 1},
   {0.149896, 0.413411, 0.558711, 1},
   {0.150838, 0.417381, 0.560508, 1},
   {0.151848, 0.421347, 0.562289, 1},
   {0.152927, 0.425308, 0.564055, 1},
   {0.154075, 0.429265, 0.565806, 1},
   {0.155292, 0.433218, 0.567543, 1},
   {0.156579, 0.437168, 0.569266, 1},
   {0.157935, 0.441113, 0.570976, 1},
   {0.15936, 0.445055, 0.572673, 1},
   {0.160854, 0.448994, 0.574357, 1},
   {0.162417, 0.452929, 0.57603, 1},
   {0.164048, 0.456862, 0.577691, 1},
   {0.165748, 0.460791, 0.57934, 1},
   {0.167515, 0.464717, 0.580978, 1},
   {0.169349, 0.46864, 0.582606, 1},
   {0.171249, 0.47256, 0.584224, 1},
   {0.173216, 0.476478, 0.585831, 1},
   {0.175248, 0.480393, 0.587429, 1},
   {0.177344, 0.484306, 0.589017, 1},
   {0.179505, 0.488217, 0.590596, 1},
   {0.181729, 0.492125, 0.592166, 1},
   {0.184016, 0.496031, 0.593728, 1},
   {0.186365, 0.499935, 0.59528, 1},
   {0.188775, 0.503838, 0.596825, 1},
   {0.191246, 0.507738, 0.598361, 1},
   {0.193777, 0.511637, 0.599889, 1},
   {0.196368, 0.515533, 0.601409, 1},
   {0.199019, 0.519429, 0.602921, 1},
   {0.201727, 0.523322, 0.604426, 1},
   {0.204494, 0.527214, 0.605923, 1},
   {0.207319, 0.531105, 0.607413, 1},
   {0.210201, 0.534994, 0.608895, 1},
   {0.21314, 0.538881, 0.61037, 1},
   {0.216136, 0.542767, 0.611838, 1},
   {0.219188, 0.546652, 0.613299, 1},
   {0.222296, 0.550535, 0.614753, 1},
   {0.225461, 0.554417, 0.6162, 1},
   {0.228682, 0.558297, 0.617639, 1},
   {0.231959, 0.562176, 0.619072, 1},
   {0.235293, 0.566053, 0.620498, 1},
   {0.238683, 0.569928, 0.621917, 1},
   {0.242129, 0.573802, 0.62333, 1},
   {0.245633, 0.577674, 0.624735, 1},
   {0.249194, 0.581544, 0.626134, 1},
   {0.252812, 0.585411, 0.627526, 1},
   {0.256489, 0.589277, 0.628911, 1},
   {0.260225, 0.593141, 0.630289, 1},
   {0.26402, 0.597002, 0.631661, 1},
   {0.267876, 0.60086, 0.633027, 1},
   {0.271793, 0.604715, 0.634385, 1},
   {0.275772, 0.608567, 0.635738, 1},
   {0.279814, 0.612416, 0.637084, 1},
   {0.283921, 0.616261, 0.638424, 1},
   {0.288092, 0.620102, 0.639758, 1},
   {0.292331, 0.623939, 0.641085, 1},
   {0.296638, 0.627771, 0.642408, 1},
   {0.301014, 0.631598, 0.643724, 1},
   {0.305461, 0.635419, 0.645036, 1},
   {0.309981, 0.639234, 0.646343, 1},
   {0.314576, 0.643043, 0.647645, 1},
   {0.319247, 0.646845, 0.648943, 1},
   {0.323996, 0.650639, 0.650237, 1},
   {0.328826, 0.654426, 0.651529, 1},
   {0.333738, 0.658203, 0.652818, 1},
   {0.338735, 0.661971, 0.654106, 1},
   {0.343819, 0.665728, 0.655393, 1},
   {0.348992, 0.669475, 0.656681, 1},
   {0.354256, 0.673209, 0.65797, 1},
   {0.359614, 0.676931, 0.659262, 1},
   {0.365068, 0.680639, 0.660558, 1},
   {0.370621, 0.684332, 0.661861, 1},
   {0.376275, 0.68801, 0.663171, 1},
   {0.382031, 0.691671, 0.664492, 1},
   {0.387893, 0.695314, 0.665825, 1},
   {0.393862, 0.698939, 0.667173, 1},
   {0.399939, 0.702544, 0.66854, 1},
   {0.406126, 0.706127, 0.669928, 1},
   {0.412423, 0.709689, 0.671341, 1},
   {0.418832, 0.713228, 0.672783, 1},
   {0.425351, 0.716743, 0.674258, 1},
   {0.43198, 0.720233, 0.67577, 1},
   {0.438718, 0.723698, 0.677325, 1},
   {0.445561, 0.727137, 0.678928, 1},
   {0.452508, 0.730549, 0.680584, 1},
   {0.459553, 0.733935, 0.682297, 1},
   {0.466691, 0.737294, 0.684074, 1},
   {0.473918, 0.740628, 0.685919, 1},
   {0.481225, 0.743936, 0.687837, 1},
   {0.488606, 0.747219, 0.689834, 1},
   {0.496053, 0.750479, 0.691913, 1},
   {0.503557, 0.753717, 0.694078, 1},
   {0.51111, 0.756934, 0.696333, 1},
   {0.518702, 0.760132, 0.698679, 1},
   {0.526326, 0.763313, 0.701119, 1},
   {0.533972, 0.76648, 0.703654, 1},
   {0.541633, 0.769633, 0.706284, 1},
   {0.549302, 0.772776, 0.70901, 1},
   {0.556972, 0.775909, 0.71183, 1},
   {0.564637, 0.779036, 0.714743, 1},
   {0.572291, 0.782158, 0.717748, 1},
   {0.579929, 0.785277, 0.720843, 1},
   {0.587548, 0.788395, 0.724025, 1},
   {0.595145, 0.791512, 0.727293, 1},
   {0.602716, 0.794632, 0.730643, 1},
   {0.610258, 0.797754, 0.734073, 1},
   {0.617772, 0.800881, 0.73758, 1},
   {0.625254, 0.804013, 0.741162, 1},
   {0.632704, 0.807153, 0.744815, 1},
   {0.640122, 0.810299, 0.748537, 1},
   {0.647507, 0.813455, 0.752325, 1},
   {0.654858, 0.816619, 0.756177, 1},
   {0.662177, 0.819794, 0.76009, 1},
   {0.669464, 0.82298, 0.764062, 1},
   {0.676718, 0.826177, 0.768091, 1},
   {0.68394, 0.829386, 0.772174, 1},
   {0.691131, 0.832607, 0.776309, 1},
   {0.698292, 0.835842, 0.780494, 1},
   {0.705423, 0.839089, 0.784728, 1},
   {0.712525, 0.842351, 0.789009, 1},
   {0.719599, 0.845627, 0.793334, 1},
   {0.726646, 0.848917, 0.797703, 1},
   {0.733666, 0.852223, 0.802113, 1},
   {0.74066, 0.855544, 0.806563, 1},
   {0.74763, 0.85888, 0.811052, 1},
   {0.754576, 0.862232, 0.815579, 1},
   {0.761499, 0.8656, 0.820142, 1},
   {0.768399, 0.868985, 0.824739, 1},
   {0.775279, 0.872386, 0.829371, 1},
   {0.782137, 0.875804, 0.834035, 1},
   {0.788975, 0.87924, 0.83873, 1},
   {0.795795, 0.882692, 0.843456, 1},
   {0.802596, 0.886163, 0.848212, 1},
   {0.809379, 0.889651, 0.852996, 1},
   {0.816145, 0.893157, 0.857808, 1},
   {0.822895, 0.896682, 0.862646, 1},
   {0.829629, 0.900225, 0.86751, 1},
   {0.836347, 0.903787, 0.872399, 1},
   {0.843051, 0.907368, 0.877312, 1},
   {0.849741, 0.910968, 0.882248, 1},
   {0.856417, 0.914588, 0.887207, 1},
   {0.86308, 0.918227, 0.892187, 1},
   {0.869731, 0.921887, 0.897188, 1},
   {0.876369, 0.925567, 0.902209, 1},
   {0.882995, 0.929268, 0.907248, 1},
   {0.889609, 0.932989, 0.912306, 1},
   {0.896212, 0.936732, 0.917381, 1},
   {0.902803, 0.940497, 0.922471, 1},
   {0.909383, 0.944284, 0.927577, 1},
   {0.915952, 0.948093, 0.932697, 1},
   {0.92251, 0.951926, 0.93783, 1},
   {0.929056, 0.955782, 0.942975, 1},
   {0.93559, 0.959662, 0.94813, 1},
   {0.942112, 0.963567, 0.953295, 1},
   {0.94862, 0.967497, 0.958467, 1},
   {0.955115, 0.971454, 0.963646, 1},
   {0.961594, 0.975438, 0.968831, 1},
   {0.968055, 0.979451, 0.974019, 1},
   {0.974497, 0.983494, 0.97921, 1},
   {0.980916, 0.987569, 0.984403, 1},
   {0.987309, 0.991677, 0.989598, 1},
   {0.993672, 0.99582, 0.994796, 1},
   {1, 1, 1, 1},
});

const Palette BPAL_19 = Palette("pastel",
{
   {0.996094, 0.746094, 0.746094, 1},
   {0.996094, 0.75, 0.746094, 1},
   {0.996094, 0.757812, 0.746094, 1},
   {0.996094, 0.761719, 0.746094, 1},
   {0.996094, 0.769531, 0.746094, 1},
   {0.996094, 0.773438, 0.746094, 1},
   {0.996094, 0.78125, 0.746094, 1},
   {0.996094, 0.785156, 0.746094, 1},
   {0.996094, 0.792969, 0.746094, 1},
   {0.996094, 0.796875, 0.746094, 1},
   {0.996094, 0.804688, 0.746094, 1},
   {0.996094, 0.808594, 0.746094, 1},
   {0.996094, 0.816406, 0.746094, 1},
   {0.996094, 0.820312, 0.746094, 1},
   {0.996094, 0.828125, 0.746094, 1},
   {0.996094, 0.832031, 0.746094, 1},
   {0.996094, 0.839844, 0.746094, 1},
   {0.996094, 0.84375, 0.746094, 1},
   {0.996094, 0.851562, 0.746094, 1},
   {0.996094, 0.855469, 0.746094, 1},
   {0.996094, 0.863281, 0.746094, 1},
   {0.996094, 0.867188, 0.746094, 1},
   {0.996094, 0.875, 0.746094, 1},
   {0.996094, 0.878906, 0.746094, 1},
   {0.996094, 0.886719, 0.746094, 1},
   {0.996094, 0.890625, 0.746094, 1},
   {0.996094, 0.898438, 0.746094, 1},
   {0.996094, 0.902344, 0.746094, 1},
   {0.996094, 0.910156, 0.746094, 1},
   {0.996094, 0.914062, 0.746094, 1},
   {0.996094, 0.921875, 0.746094, 1},
   {0.996094, 0.925781, 0.746094, 1},
   {0.996094, 0.933594, 0.746094, 1},
   {0.996094, 0.9375, 0.746094, 1},
   {0.996094, 0.945312, 0.746094, 1},
   {0.996094, 0.949219, 0.746094, 1},
   {0.996094, 0.957031, 0.746094, 1},
   {0.996094, 0.960938, 0.746094, 1},
   {0.996094, 0.96875, 0.746094, 1},
   {0.996094, 0.972656, 0.746094, 1},
   {0.996094, 0.980469, 0.746094, 1},
   {0.996094, 0.984375, 0.746094, 1},
   {0.996094, 0.992188, 0.746094, 1},
   {0.992188, 0.996094, 0.746094, 1},
   {0.984375, 0.996094, 0.746094, 1},
   {0.980469, 0.996094, 0.746094, 1},
   {0.972656, 0.996094, 0.746094, 1},
   {0.96875, 0.996094, 0.746094, 1},
   {0.960938, 0.996094, 0.746094, 1},
   {0.957031, 0.996094, 0.746094, 1},
   {0.949219, 0.996094, 0.746094, 1},
   {0.945312, 0.996094, 0.746094, 1},
   {0.9375, 0.996094, 0.746094, 1},
   {0.933594, 0.996094, 0.746094, 1},
   {0.925781, 0.996094, 0.746094, 1},
   {0.921875, 0.996094, 0.746094, 1},
   {0.914062, 0.996094, 0.746094, 1},
   {0.910156, 0.996094, 0.746094, 1},
   {0.902344, 0.996094, 0.746094, 1},
   {0.898438, 0.996094, 0.746094, 1},
   {0.890625, 0.996094, 0.746094, 1},
   {0.886719, 0.996094, 0.746094, 1},
   {0.878906, 0.996094, 0.746094, 1},
   {0.875, 0.996094, 0.746094, 1},
   {0.867188, 0.996094, 0.746094, 1},
   {0.863281, 0.996094, 0.746094, 1},
   {0.855469, 0.996094, 0.746094, 1},
   {0.851562, 0.996094, 0.746094, 1},
   {0.84375, 0.996094, 0.746094, 1},
   {0.839844, 0.996094, 0.746094, 1},
   {0.832031, 0.996094, 0.746094, 1},
   {0.828125, 0.996094, 0.746094, 1},
   {0.820312, 0.996094, 0.746094, 1},
   {0.816406, 0.996094, 0.746094, 1},
   {0.808594, 0.996094, 0.746094, 1},
   {0.804688, 0.996094, 0.746094, 1},
   {0.796875, 0.996094, 0.746094, 1},
   {0.792969, 0.996094, 0.746094, 1},
   {0.785156, 0.996094, 0.746094, 1},
   {0.78125, 0.996094, 0.746094, 1},
   {0.773438, 0.996094, 0.746094, 1},
   {0.769531, 0.996094, 0.746094, 1},
   {0.761719, 0.996094, 0.746094, 1},
   {0.757812, 0.996094, 0.746094, 1},
   {0.75, 0.996094, 0.746094, 1},
   {0.746094, 0.996094, 0.746094, 1},
   {0.746094, 0.996094, 0.75, 1},
   {0.746094, 0.996094, 0.757812, 1},
   {0.746094, 0.996094, 0.761719, 1},
   {0.746094, 0.996094, 0.769531, 1},
   {0.746094, 0.996094, 0.773438, 1},
   {0.746094, 0.996094, 0.78125, 1},
   {0.746094, 0.996094, 0.785156, 1},
   {0.746094, 0.996094, 0.792969, 1},
   {0.746094, 0.996094, 0.796875, 1},
   {0.746094, 0.996094, 0.804688, 1},
   {0.746094, 0.996094, 0.808594, 1},
   {0.746094, 0.996094, 0.816406, 1},
   {0.746094, 0.996094, 0.820312, 1},
   {0.746094, 0.996094, 0.828125, 1},
   {0.746094, 0.996094, 0.832031, 1},
   {0.746094, 0.996094, 0.839844, 1},
   {0.746094, 0.996094, 0.84375, 1},
   {0.746094, 0.996094, 0.851562, 1},
   {0.746094, 0.996094, 0.855469, 1},
   {0.746094, 0.996094, 0.863281, 1},
   {0.746094, 0.996094, 0.867188, 1},
   {0.746094, 0.996094, 0.875, 1},
   {0.746094, 0.996094, 0.878906, 1},
   {0.746094, 0.996094, 0.886719, 1},
   {0.746094, 0.996094, 0.890625, 1},
   {0.746094, 0.996094, 0.898438, 1},
   {0.746094, 0.996094, 0.902344, 1},
   {0.746094, 0.996094, 0.910156, 1},
   {0.746094, 0.996094, 0.914062, 1},
   {0.746094, 0.996094, 0.921875, 1},
   {0.746094, 0.996094, 0.925781, 1},
   {0.746094, 0.996094, 0.933594, 1},
   {0.746094, 0.996094, 0.9375, 1},
   {0.746094, 0.996094, 0.945312, 1},
   {0.746094, 0.996094, 0.949219, 1},
   {0.746094, 0.996094, 0.957031, 1},
   {0.746094, 0.996094, 0.960938, 1},
   {0.746094, 0.996094, 0.96875, 1},
   {0.746094, 0.996094, 0.972656, 1},
   {0.746094, 0.996094, 0.980469, 1},
   {0.746094, 0.996094, 0.984375, 1},
   {0.746094, 0.996094, 0.992188, 1},
   {0.746094, 0.992188, 0.996094, 1},
   {0.746094, 0.984375, 0.996094, 1},
   {0.746094, 0.980469, 0.996094, 1},
   {0.746094, 0.972656, 0.996094, 1},
   {0.746094, 0.96875, 0.996094, 1},
   {0.746094, 0.960938, 0.996094, 1},
   {0.746094, 0.957031, 0.996094, 1},
   {0.746094, 0.949219, 0.996094, 1},
   {0.746094, 0.945312, 0.996094, 1},
   {0.746094, 0.9375, 0.996094, 1},
   {0.746094, 0.933594, 0.996094, 1},
   {0.746094, 0.925781, 0.996094, 1},
   {0.746094, 0.921875, 0.996094, 1},
   {0.746094, 0.914062, 0.996094, 1},
   {0.746094, 0.910156, 0.996094, 1},
   {0.746094, 0.902344, 0.996094, 1},
   {0.746094, 0.898438, 0.996094, 1},
   {0.746094, 0.890625, 0.996094, 1},
   {0.746094, 0.886719, 0.996094, 1},
   {0.746094, 0.878906, 0.996094, 1},
   {0.746094, 0.875, 0.996094, 1},
   {0.746094, 0.867188, 0.996094, 1},
   {0.746094, 0.863281, 0.996094, 1},
   {0.746094, 0.855469, 0.996094, 1},
   {0.746094, 0.851562, 0.996094, 1},
   {0.746094, 0.84375, 0.996094, 1},
   {0.746094, 0.839844, 0.996094, 1},
   {0.746094, 0.832031, 0.996094, 1},
   {0.746094, 0.828125, 0.996094, 1},
   {0.746094, 0.820312, 0.996094, 1},
   {0.746094, 0.816406, 0.996094, 1},
   {0.746094, 0.808594, 0.996094, 1},
   {0.746094, 0.804688, 0.996094, 1},
   {0.746094, 0.796875, 0.996094, 1},
   {0.746094, 0.792969, 0.996094, 1},
   {0.746094, 0.785156, 0.996094, 1},
   {0.746094, 0.78125, 0.996094, 1},
   {0.746094, 0.773438, 0.996094, 1},
   {0.746094, 0.769531, 0.996094, 1},
   {0.746094, 0.761719, 0.996094, 1},
   {0.746094, 0.757812, 0.996094, 1},
   {0.746094, 0.75, 0.996094, 1},
   {0.746094, 0.746094, 0.996094, 1},
   {0.75, 0.746094, 0.996094, 1},
   {0.757812, 0.746094, 0.996094, 1},
   {0.761719, 0.746094, 0.996094, 1},
   {0.769531, 0.746094, 0.996094, 1},
   {0.773438, 0.746094, 0.996094, 1},
   {0.78125, 0.746094, 0.996094, 1},
   {0.785156, 0.746094, 0.996094, 1},
   {0.792969, 0.746094, 0.996094, 1},
   {0.796875, 0.746094, 0.996094, 1},
   {0.804688, 0.746094, 0.996094, 1},
   {0.808594, 0.746094, 0.996094, 1},
   {0.816406, 0.746094, 0.996094, 1},
   {0.820312, 0.746094, 0.996094, 1},
   {0.828125, 0.746094, 0.996094, 1},
   {0.832031, 0.746094, 0.996094, 1},
   {0.839844, 0.746094, 0.996094, 1},
   {0.84375, 0.746094, 0.996094, 1},
   {0.851562, 0.746094, 0.996094, 1},
   {0.855469, 0.746094, 0.996094, 1},
   {0.863281, 0.746094, 0.996094, 1},
   {0.867188, 0.746094, 0.996094, 1},
   {0.875, 0.746094, 0.996094, 1},
   {0.878906, 0.746094, 0.996094, 1},
   {0.886719, 0.746094, 0.996094, 1},
   {0.890625, 0.746094, 0.996094, 1},
   {0.898438, 0.746094, 0.996094, 1},
   {0.902344, 0.746094, 0.996094, 1},
   {0.910156, 0.746094, 0.996094, 1},
   {0.914062, 0.746094, 0.996094, 1},
   {0.921875, 0.746094, 0.996094, 1},
   {0.925781, 0.746094, 0.996094, 1},
   {0.933594, 0.746094, 0.996094, 1},
   {0.9375, 0.746094, 0.996094, 1},
   {0.945312, 0.746094, 0.996094, 1},
   {0.949219, 0.746094, 0.996094, 1},
   {0.957031, 0.746094, 0.996094, 1},
   {0.960938, 0.746094, 0.996094, 1},
   {0.96875, 0.746094, 0.996094, 1},
   {0.972656, 0.746094, 0.996094, 1},
   {0.980469, 0.746094, 0.996094, 1},
   {0.984375, 0.746094, 0.996094, 1},
   {0.992188, 0.746094, 0.996094, 1},
   {0.996094, 0.746094, 0.992188, 1},
   {0.996094, 0.746094, 0.984375, 1},
   {0.996094, 0.746094, 0.980469, 1},
   {0.996094, 0.746094, 0.972656, 1},
   {0.996094, 0.746094, 0.96875, 1},
   {0.996094, 0.746094, 0.960938, 1},
   {0.996094, 0.746094, 0.957031, 1},
   {0.996094, 0.746094, 0.949219, 1},
   {0.996094, 0.746094, 0.945312, 1},
   {0.996094, 0.746094, 0.9375, 1},
   {0.996094, 0.746094, 0.933594, 1},
   {0.996094, 0.746094, 0.925781, 1},
   {0.996094, 0.746094, 0.921875, 1},
   {0.996094, 0.746094, 0.914062, 1},
   {0.996094, 0.746094, 0.910156, 1},
   {0.996094, 0.746094, 0.902344, 1},
   {0.996094, 0.746094, 0.898438, 1},
   {0.996094, 0.746094, 0.890625, 1},
   {0.996094, 0.746094, 0.886719, 1},
   {0.996094, 0.746094, 0.878906, 1},
   {0.996094, 0.746094, 0.875, 1},
   {0.996094, 0.746094, 0.867188, 1},
   {0.996094, 0.746094, 0.863281, 1},
   {0.996094, 0.746094, 0.855469, 1},
   {0.996094, 0.746094, 0.851562, 1},
   {0.996094, 0.746094, 0.84375, 1},
   {0.996094, 0.746094, 0.839844, 1},
   {0.996094, 0.746094, 0.832031, 1},
   {0.996094, 0.746094, 0.828125, 1},
   {0.996094, 0.746094, 0.820312, 1},
   {0.996094, 0.746094, 0.816406, 1},
   {0.996094, 0.746094, 0.808594, 1},
   {0.996094, 0.746094, 0.804688, 1},
   {0.996094, 0.746094, 0.796875, 1},
   {0.996094, 0.746094, 0.792969, 1},
   {0.996094, 0.746094, 0.785156, 1},
   {0.996094, 0.746094, 0.78125, 1},
   {0.996094, 0.746094, 0.773438, 1},
   {0.996094, 0.746094, 0.769531, 1},
   {0.996094, 0.746094, 0.761719, 1},
   {0.996094, 0.746094, 0.757812, 1},
   {0.996094, 0.746094, 0.75, 1},
   {0.996094, 0.746094, 0.746094, 1},
});

const Palette BPAL_20 = Palette("tropical",
{
   {0.0351562, 0.15625, 0.0117188, 1},
   {0.0351562, 0.160156, 0.0117188, 1},
   {0.03125, 0.167969, 0.0117188, 1},
   {0.03125, 0.171875, 0.0117188, 1},
   {0.03125, 0.179688, 0.0117188, 1},
   {0.03125, 0.183594, 0.0117188, 1},
   {0.0273438, 0.1875, 0.0117188, 1},
   {0.0273438, 0.195312, 0.0078125, 1},
   {0.0273438, 0.199219, 0.0078125, 1},
   {0.0273438, 0.203125, 0.0078125, 1},
   {0.0234375, 0.210938, 0.0078125, 1},
   {0.0234375, 0.214844, 0.0078125, 1},
   {0.0234375, 0.21875, 0.0078125, 1},
   {0.0195312, 0.226562, 0.0078125, 1},
   {0.0195312, 0.230469, 0.00390625, 1},
   {0.0195312, 0.242188, 0.00390625, 1},
   {0.015625, 0.25, 0.00390625, 1},
   {0.015625, 0.261719, 0.00390625, 1},
   {0.0117188, 0.269531, 0, 1},
   {0.0117188, 0.28125, 0, 1},
   {0.0078125, 0.289062, 0, 1},
   {0.0078125, 0.300781, 0, 1},
   {0.0078125, 0.308594, 0, 1},
   {0.015625, 0.320312, 0.00390625, 1},
   {0.0234375, 0.328125, 0.00390625, 1},
   {0.0273438, 0.339844, 0.0078125, 1},
   {0.0351562, 0.347656, 0.0117188, 1},
   {0.0429688, 0.359375, 0.015625, 1},
   {0.0507812, 0.367188, 0.0195312, 1},
   {0.0546875, 0.378906, 0.0195312, 1},
   {0.0625, 0.386719, 0.0234375, 1},
   {0.0703125, 0.398438, 0.0273438, 1},
   {0.078125, 0.40625, 0.03125, 1},
   {0.0820312, 0.417969, 0.0351562, 1},
   {0.0898438, 0.425781, 0.0351562, 1},
   {0.0976562, 0.4375, 0.0390625, 1},
   {0.105469, 0.445312, 0.0429688, 1},
   {0.109375, 0.457031, 0.046875, 1},
   {0.117188, 0.464844, 0.046875, 1},
   {0.125, 0.472656, 0.0507812, 1},
   {0.128906, 0.484375, 0.0546875, 1},
   {0.136719, 0.492188, 0.0585938, 1},
   {0.144531, 0.503906, 0.0625, 1},
   {0.152344, 0.511719, 0.0625, 1},
   {0.15625, 0.519531, 0.0664062, 1},
   {0.164062, 0.53125, 0.0703125, 1},
   {0.171875, 0.539062, 0.0742188, 1},
   {0.175781, 0.550781, 0.0742188, 1},
   {0.183594, 0.558594, 0.078125, 1},
   {0.191406, 0.566406, 0.0820312, 1},
   {0.214844, 0.578125, 0.0859375, 1},
   {0.25, 0.585938, 0.0898438, 1},
   {0.285156, 0.59375, 0.0976562, 1},
   {0.320312, 0.601562, 0.101562, 1},
   {0.355469, 0.609375, 0.105469, 1},
   {0.394531, 0.621094, 0.113281, 1},
   {0.429688, 0.628906, 0.117188, 1},
   {0.464844, 0.636719, 0.121094, 1},
   {0.5, 0.644531, 0.128906, 1},
   {0.535156, 0.652344, 0.132812, 1},
   {0.570312, 0.660156, 0.136719, 1},
   {0.601562, 0.667969, 0.144531, 1},
   {0.636719, 0.679688, 0.148438, 1},
   {0.667969, 0.6875, 0.152344, 1},
   {0.703125, 0.695312, 0.15625, 1},
   {0.734375, 0.703125, 0.164062, 1},
   {0.769531, 0.710938, 0.167969, 1},
   {0.800781, 0.71875, 0.171875, 1},
   {0.835938, 0.726562, 0.175781, 1},
   {0.867188, 0.734375, 0.183594, 1},
   {0.902344, 0.742188, 0.1875, 1},
   {0.917969, 0.738281, 0.1875, 1},
   {0.921875, 0.71875, 0.1875, 1},
   {0.921875, 0.703125, 0.183594, 1},
   {0.921875, 0.683594, 0.183594, 1},
   {0.921875, 0.664062, 0.179688, 1},
   {0.925781, 0.648438, 0.179688, 1},
   {0.925781, 0.628906, 0.175781, 1},
   {0.925781, 0.613281, 0.175781, 1},
   {0.925781, 0.59375, 0.171875, 1},
   {0.929688, 0.574219, 0.167969, 1},
   {0.929688, 0.558594, 0.167969, 1},
   {0.929688, 0.539062, 0.164062, 1},
   {0.933594, 0.523438, 0.164062, 1},
   {0.933594, 0.503906, 0.160156, 1},
   {0.933594, 0.484375, 0.160156, 1},
   {0.933594, 0.46875, 0.15625, 1},
   {0.9375, 0.449219, 0.15625, 1},
   {0.9375, 0.433594, 0.152344, 1},
   {0.9375, 0.414062, 0.152344, 1},
   {0.9375, 0.394531, 0.148438, 1},
   {0.941406, 0.378906, 0.144531, 1},
   {0.941406, 0.359375, 0.144531, 1},
   {0.941406, 0.34375, 0.140625, 1},
   {0.945312, 0.324219, 0.140625, 1},
   {0.945312, 0.304688, 0.136719, 1},
   {0.945312, 0.289062, 0.136719, 1},
   {0.945312, 0.269531, 0.132812, 1},
   {0.949219, 0.253906, 0.132812, 1},
   {0.949219, 0.238281, 0.128906, 1},
   {0.941406, 0.238281, 0.132812, 1},
   {0.933594, 0.238281, 0.132812, 1},
   {0.925781, 0.242188, 0.136719, 1},
   {0.921875, 0.242188, 0.136719, 1},
   {0.914062, 0.242188, 0.136719, 1},
   {0.90625, 0.246094, 0.140625, 1},
   {0.902344, 0.246094, 0.140625, 1},
   {0.894531, 0.246094, 0.144531, 1},
   {0.886719, 0.25, 0.144531, 1},
   {0.878906, 0.25, 0.144531, 1},
   {0.875, 0.25, 0.148438, 1},
   {0.867188, 0.253906, 0.148438, 1},
   {0.859375, 0.253906, 0.152344, 1},
   {0.855469, 0.253906, 0.152344, 1},
   {0.847656, 0.257812, 0.15625, 1},
   {0.839844, 0.257812, 0.15625, 1},
   {0.832031, 0.257812, 0.15625, 1},
   {0.828125, 0.261719, 0.160156, 1},
   {0.820312, 0.261719, 0.160156, 1},
   {0.8125, 0.261719, 0.164062, 1},
   {0.808594, 0.261719, 0.164062, 1},
   {0.800781, 0.265625, 0.167969, 1},
   {0.792969, 0.265625, 0.167969, 1},
   {0.785156, 0.265625, 0.167969, 1},
   {0.78125, 0.269531, 0.171875, 1},
   {0.773438, 0.269531, 0.171875, 1},
   {0.765625, 0.269531, 0.175781, 1},
   {0.757812, 0.273438, 0.175781, 1},
   {0.753906, 0.273438, 0.175781, 1},
   {0.746094, 0.273438, 0.179688, 1},
   {0.738281, 0.277344, 0.179688, 1},
   {0.722656, 0.277344, 0.183594, 1},
   {0.707031, 0.28125, 0.1875, 1},
   {0.6875, 0.285156, 0.195312, 1},
   {0.667969, 0.289062, 0.199219, 1},
   {0.648438, 0.292969, 0.203125, 1},
   {0.632812, 0.296875, 0.207031, 1},
   {0.613281, 0.300781, 0.210938, 1},
   {0.59375, 0.304688, 0.214844, 1},
   {0.574219, 0.308594, 0.222656, 1},
   {0.558594, 0.308594, 0.226562, 1},
   {0.539062, 0.3125, 0.230469, 1},
   {0.527344, 0.316406, 0.242188, 1},
   {0.523438, 0.316406, 0.269531, 1},
   {0.523438, 0.3125, 0.296875, 1},
   {0.519531, 0.3125, 0.324219, 1},
   {0.515625, 0.3125, 0.347656, 1},
   {0.515625, 0.3125, 0.375, 1},
   {0.511719, 0.3125, 0.402344, 1},
   {0.511719, 0.308594, 0.429688, 1},
   {0.507812, 0.308594, 0.457031, 1},
   {0.507812, 0.308594, 0.484375, 1},
   {0.503906, 0.308594, 0.511719, 1},
   {0.503906, 0.308594, 0.539062, 1},
   {0.5, 0.304688, 0.5625, 1},
   {0.5, 0.304688, 0.589844, 1},
   {0.496094, 0.304688, 0.617188, 1},
   {0.496094, 0.304688, 0.644531, 1},
   {0.492188, 0.300781, 0.671875, 1},
   {0.492188, 0.300781, 0.699219, 1},
   {0.488281, 0.300781, 0.726562, 1},
   {0.488281, 0.300781, 0.753906, 1},
   {0.484375, 0.300781, 0.777344, 1},
   {0.484375, 0.296875, 0.804688, 1},
   {0.480469, 0.296875, 0.832031, 1},
   {0.480469, 0.296875, 0.859375, 1},
   {0.476562, 0.296875, 0.886719, 1},
   {0.476562, 0.296875, 0.914062, 1},
   {0.472656, 0.292969, 0.941406, 1},
   {0.472656, 0.292969, 0.96875, 1},
   {0.46875, 0.292969, 0.992188, 1},
   {0.472656, 0.304688, 0.992188, 1},
   {0.476562, 0.320312, 0.992188, 1},
   {0.476562, 0.332031, 0.992188, 1},
   {0.480469, 0.34375, 0.992188, 1},
   {0.484375, 0.355469, 0.992188, 1},
   {0.488281, 0.371094, 0.988281, 1},
   {0.492188, 0.382812, 0.988281, 1},
   {0.492188, 0.394531, 0.988281, 1},
   {0.496094, 0.410156, 0.988281, 1},
   {0.5, 0.421875, 0.988281, 1},
   {0.503906, 0.433594, 0.984375, 1},
   {0.507812, 0.449219, 0.984375, 1},
   {0.511719, 0.460938, 0.984375, 1},
   {0.511719, 0.472656, 0.984375, 1},
   {0.515625, 0.488281, 0.984375, 1},
   {0.519531, 0.5, 0.980469, 1},
   {0.523438, 0.511719, 0.980469, 1},
   {0.527344, 0.527344, 0.980469, 1},
   {0.527344, 0.539062, 0.980469, 1},
   {0.53125, 0.550781, 0.980469, 1},
   {0.535156, 0.5625, 0.976562, 1},
   {0.539062, 0.578125, 0.976562, 1},
   {0.542969, 0.589844, 0.976562, 1},
   {0.542969, 0.601562, 0.976562, 1},
   {0.546875, 0.617188, 0.976562, 1},
   {0.550781, 0.628906, 0.972656, 1},
   {0.554688, 0.640625, 0.972656, 1},
   {0.558594, 0.667969, 0.972656, 1},
   {0.566406, 0.691406, 0.96875, 1},
   {0.574219, 0.71875, 0.96875, 1},
   {0.578125, 0.742188, 0.96875, 1},
   {0.585938, 0.769531, 0.964844, 1},
   {0.589844, 0.796875, 0.964844, 1},
   {0.597656, 0.820312, 0.960938, 1},
   {0.605469, 0.847656, 0.960938, 1},
   {0.609375, 0.871094, 0.960938, 1},
   {0.617188, 0.898438, 0.957031, 1},
   {0.621094, 0.925781, 0.957031, 1},
   {0.628906, 0.949219, 0.953125, 1},
   {0.636719, 0.976562, 0.953125, 1},
   {0.636719, 0.992188, 0.941406, 1},
   {0.625, 0.984375, 0.910156, 1},
   {0.613281, 0.980469, 0.875, 1},
   {0.601562, 0.972656, 0.84375, 1},
   {0.589844, 0.96875, 0.808594, 1},
   {0.578125, 0.960938, 0.777344, 1},
   {0.566406, 0.953125, 0.746094, 1},
   {0.554688, 0.949219, 0.710938, 1},
   {0.542969, 0.941406, 0.679688, 1},
   {0.535156, 0.933594, 0.644531, 1},
   {0.519531, 0.929688, 0.609375, 1},
   {0.496094, 0.914062, 0.539062, 1},
   {0.472656, 0.902344, 0.464844, 1},
   {0.445312, 0.886719, 0.394531, 1},
   {0.421875, 0.875, 0.320312, 1},
   {0.40625, 0.863281, 0.273438, 1},
   {0.40625, 0.859375, 0.269531, 1},
   {0.402344, 0.851562, 0.265625, 1},
   {0.402344, 0.84375, 0.261719, 1},
   {0.402344, 0.835938, 0.253906, 1},
   {0.402344, 0.828125, 0.246094, 1},
   {0.398438, 0.816406, 0.238281, 1},
   {0.398438, 0.804688, 0.230469, 1},
   {0.398438, 0.796875, 0.222656, 1},
   {0.394531, 0.785156, 0.214844, 1},
   {0.394531, 0.773438, 0.207031, 1},
   {0.390625, 0.761719, 0.195312, 1},
   {0.390625, 0.75, 0.1875, 1},
   {0.390625, 0.734375, 0.179688, 1},
   {0.386719, 0.722656, 0.167969, 1},
   {0.386719, 0.710938, 0.160156, 1},
   {0.382812, 0.695312, 0.148438, 1},
   {0.382812, 0.679688, 0.136719, 1},
   {0.382812, 0.667969, 0.125, 1},
   {0.378906, 0.652344, 0.117188, 1},
   {0.378906, 0.636719, 0.105469, 1},
   {0.375, 0.625, 0.09375, 1},
   {0.375, 0.609375, 0.0820312, 1},
   {0.371094, 0.59375, 0.0703125, 1},
   {0.371094, 0.578125, 0.0585938, 1},
   {0.367188, 0.5625, 0.046875, 1},
   {0.367188, 0.546875, 0.0351562, 1},
   {0.363281, 0.527344, 0.0234375, 1},
   {0.363281, 0.511719, 0.0117188, 1},
   {0.359375, 0.496094, 0, 1},
});

const Palette BPAL_21 = Palette("wood",
{
   {0.996094, 0.695312, 0.398438, 1},
   {0.980469, 0.675781, 0.367188, 1},
   {0.976562, 0.667969, 0.359375, 1},
   {0.972656, 0.660156, 0.351562, 1},
   {0.96875, 0.65625, 0.34375, 1},
   {0.964844, 0.652344, 0.335938, 1},
   {0.960938, 0.648438, 0.332031, 1},
   {0.960938, 0.644531, 0.328125, 1},
   {0.957031, 0.640625, 0.324219, 1},
   {0.957031, 0.636719, 0.320312, 1},
   {0.953125, 0.636719, 0.316406, 1},
   {0.953125, 0.632812, 0.3125, 1},
   {0.953125, 0.628906, 0.308594, 1},
   {0.949219, 0.628906, 0.308594, 1},
   {0.949219, 0.625, 0.304688, 1},
   {0.949219, 0.625, 0.304688, 1},
   {0.945312, 0.625, 0.300781, 1},
   {0.945312, 0.621094, 0.296875, 1},
   {0.945312, 0.621094, 0.296875, 1},
   {0.945312, 0.621094, 0.296875, 1},
   {0.941406, 0.617188, 0.292969, 1},
   {0.941406, 0.617188, 0.292969, 1},
   {0.941406, 0.617188, 0.292969, 1},
   {0.941406, 0.617188, 0.289062, 1},
   {0.941406, 0.613281, 0.289062, 1},
   {0.941406, 0.613281, 0.289062, 1},
   {0.941406, 0.613281, 0.289062, 1},
   {0.941406, 0.613281, 0.289062, 1},
   {0.941406, 0.613281, 0.285156, 1},
   {0.9375, 0.613281, 0.285156, 1},
   {0.9375, 0.613281, 0.285156, 1},
   {0.9375, 0.613281, 0.285156, 1},
   {0.804688, 0.523438, 0.242188, 1},
   {0.828125, 0.535156, 0.246094, 1},
   {0.839844, 0.542969, 0.246094, 1},
   {0.851562, 0.546875, 0.246094, 1},
   {0.859375, 0.554688, 0.246094, 1},
   {0.863281, 0.554688, 0.25, 1},
   {0.871094, 0.558594, 0.25, 1},
   {0.875, 0.5625, 0.25, 1},
   {0.878906, 0.566406, 0.25, 1},
   {0.886719, 0.566406, 0.25, 1},
   {0.890625, 0.570312, 0.25, 1},
   {0.890625, 0.570312, 0.25, 1},
   {0.894531, 0.574219, 0.25, 1},
   {0.898438, 0.574219, 0.25, 1},
   {0.902344, 0.578125, 0.253906, 1},
   {0.902344, 0.578125, 0.253906, 1},
   {0.90625, 0.578125, 0.253906, 1},
   {0.910156, 0.582031, 0.253906, 1},
   {0.910156, 0.582031, 0.253906, 1},
   {0.914062, 0.582031, 0.253906, 1},
   {0.914062, 0.582031, 0.253906, 1},
   {0.914062, 0.585938, 0.253906, 1},
   {0.917969, 0.585938, 0.253906, 1},
   {0.917969, 0.585938, 0.253906, 1},
   {0.917969, 0.585938, 0.253906, 1},
   {0.921875, 0.585938, 0.253906, 1},
   {0.921875, 0.585938, 0.253906, 1},
   {0.921875, 0.585938, 0.253906, 1},
   {0.921875, 0.589844, 0.253906, 1},
   {0.921875, 0.589844, 0.253906, 1},
   {0.921875, 0.589844, 0.253906, 1},
   {0.921875, 0.589844, 0.253906, 1},
   {0.828125, 0.527344, 0.226562, 1},
   {0.84375, 0.535156, 0.230469, 1},
   {0.851562, 0.542969, 0.230469, 1},
   {0.859375, 0.546875, 0.230469, 1},
   {0.867188, 0.550781, 0.230469, 1},
   {0.871094, 0.550781, 0.234375, 1},
   {0.875, 0.554688, 0.234375, 1},
   {0.878906, 0.558594, 0.234375, 1},
   {0.882812, 0.558594, 0.234375, 1},
   {0.886719, 0.5625, 0.234375, 1},
   {0.890625, 0.5625, 0.234375, 1},
   {0.890625, 0.566406, 0.238281, 1},
   {0.894531, 0.566406, 0.238281, 1},
   {0.898438, 0.566406, 0.238281, 1},
   {0.898438, 0.570312, 0.238281, 1},
   {0.902344, 0.570312, 0.238281, 1},
   {0.902344, 0.570312, 0.238281, 1},
   {0.90625, 0.570312, 0.238281, 1},
   {0.90625, 0.574219, 0.238281, 1},
   {0.910156, 0.574219, 0.238281, 1},
   {0.910156, 0.574219, 0.238281, 1},
   {0.910156, 0.574219, 0.238281, 1},
   {0.910156, 0.574219, 0.238281, 1},
   {0.914062, 0.578125, 0.238281, 1},
   {0.914062, 0.578125, 0.238281, 1},
   {0.914062, 0.578125, 0.238281, 1},
   {0.914062, 0.578125, 0.242188, 1},
   {0.914062, 0.578125, 0.242188, 1},
   {0.914062, 0.578125, 0.242188, 1},
   {0.917969, 0.578125, 0.242188, 1},
   {0.917969, 0.578125, 0.242188, 1},
   {0.917969, 0.578125, 0.242188, 1},
   {0.789062, 0.496094, 0.207031, 1},
   {0.808594, 0.507812, 0.210938, 1},
   {0.820312, 0.519531, 0.214844, 1},
   {0.832031, 0.523438, 0.214844, 1},
   {0.839844, 0.53125, 0.21875, 1},
   {0.847656, 0.535156, 0.21875, 1},
   {0.855469, 0.539062, 0.222656, 1},
   {0.859375, 0.542969, 0.222656, 1},
   {0.867188, 0.546875, 0.226562, 1},
   {0.871094, 0.546875, 0.226562, 1},
   {0.875, 0.550781, 0.226562, 1},
   {0.878906, 0.554688, 0.226562, 1},
   {0.882812, 0.554688, 0.230469, 1},
   {0.886719, 0.558594, 0.230469, 1},
   {0.890625, 0.558594, 0.230469, 1},
   {0.894531, 0.5625, 0.230469, 1},
   {0.894531, 0.5625, 0.230469, 1},
   {0.898438, 0.566406, 0.230469, 1},
   {0.898438, 0.566406, 0.234375, 1},
   {0.902344, 0.566406, 0.234375, 1},
   {0.90625, 0.570312, 0.234375, 1},
   {0.90625, 0.570312, 0.234375, 1},
   {0.90625, 0.570312, 0.234375, 1},
   {0.910156, 0.570312, 0.234375, 1},
   {0.910156, 0.574219, 0.234375, 1},
   {0.910156, 0.574219, 0.234375, 1},
   {0.914062, 0.574219, 0.234375, 1},
   {0.914062, 0.574219, 0.234375, 1},
   {0.914062, 0.574219, 0.234375, 1},
   {0.914062, 0.574219, 0.234375, 1},
   {0.914062, 0.574219, 0.234375, 1},
   {0.914062, 0.574219, 0.234375, 1},
   {0.773438, 0.488281, 0.199219, 1},
   {0.773438, 0.488281, 0.199219, 1},
   {0.773438, 0.488281, 0.199219, 1},
   {0.777344, 0.488281, 0.199219, 1},
   {0.777344, 0.488281, 0.199219, 1},
   {0.777344, 0.488281, 0.199219, 1},
   {0.777344, 0.488281, 0.199219, 1},
   {0.777344, 0.488281, 0.199219, 1},
   {0.78125, 0.492188, 0.203125, 1},
   {0.78125, 0.492188, 0.203125, 1},
   {0.78125, 0.492188, 0.203125, 1},
   {0.785156, 0.492188, 0.203125, 1},
   {0.785156, 0.492188, 0.203125, 1},
   {0.785156, 0.496094, 0.203125, 1},
   {0.789062, 0.496094, 0.203125, 1},
   {0.789062, 0.496094, 0.203125, 1},
   {0.792969, 0.5, 0.203125, 1},
   {0.796875, 0.5, 0.207031, 1},
   {0.796875, 0.5, 0.207031, 1},
   {0.800781, 0.503906, 0.207031, 1},
   {0.804688, 0.503906, 0.207031, 1},
   {0.808594, 0.507812, 0.207031, 1},
   {0.8125, 0.511719, 0.210938, 1},
   {0.816406, 0.511719, 0.210938, 1},
   {0.820312, 0.515625, 0.210938, 1},
   {0.824219, 0.519531, 0.210938, 1},
   {0.828125, 0.523438, 0.214844, 1},
   {0.835938, 0.527344, 0.214844, 1},
   {0.84375, 0.53125, 0.21875, 1},
   {0.851562, 0.535156, 0.21875, 1},
   {0.863281, 0.542969, 0.222656, 1},
   {0.878906, 0.554688, 0.226562, 1},
   {0.804688, 0.507812, 0.207031, 1},
   {0.804688, 0.507812, 0.207031, 1},
   {0.804688, 0.507812, 0.207031, 1},
   {0.804688, 0.507812, 0.207031, 1},
   {0.804688, 0.507812, 0.207031, 1},
   {0.804688, 0.507812, 0.207031, 1},
   {0.804688, 0.507812, 0.207031, 1},
   {0.804688, 0.507812, 0.207031, 1},
   {0.804688, 0.507812, 0.207031, 1},
   {0.808594, 0.507812, 0.207031, 1},
   {0.808594, 0.507812, 0.207031, 1},
   {0.808594, 0.507812, 0.207031, 1},
   {0.808594, 0.507812, 0.207031, 1},
   {0.808594, 0.507812, 0.207031, 1},
   {0.808594, 0.507812, 0.210938, 1},
   {0.808594, 0.507812, 0.210938, 1},
   {0.8125, 0.511719, 0.210938, 1},
   {0.8125, 0.511719, 0.210938, 1},
   {0.8125, 0.511719, 0.210938, 1},
   {0.8125, 0.511719, 0.210938, 1},
   {0.8125, 0.511719, 0.210938, 1},
   {0.816406, 0.511719, 0.210938, 1},
   {0.816406, 0.515625, 0.210938, 1},
   {0.816406, 0.515625, 0.210938, 1},
   {0.820312, 0.515625, 0.210938, 1},
   {0.820312, 0.515625, 0.210938, 1},
   {0.824219, 0.519531, 0.210938, 1},
   {0.824219, 0.519531, 0.214844, 1},
   {0.828125, 0.519531, 0.214844, 1},
   {0.832031, 0.523438, 0.214844, 1},
   {0.832031, 0.523438, 0.214844, 1},
   {0.839844, 0.527344, 0.21875, 1},
   {0.753906, 0.476562, 0.195312, 1},
   {0.753906, 0.476562, 0.195312, 1},
   {0.753906, 0.476562, 0.195312, 1},
   {0.753906, 0.476562, 0.195312, 1},
   {0.753906, 0.476562, 0.195312, 1},
   {0.753906, 0.472656, 0.195312, 1},
   {0.753906, 0.472656, 0.195312, 1},
   {0.753906, 0.472656, 0.195312, 1},
   {0.753906, 0.472656, 0.195312, 1},
   {0.753906, 0.472656, 0.195312, 1},
   {0.753906, 0.472656, 0.195312, 1},
   {0.75, 0.472656, 0.195312, 1},
   {0.75, 0.472656, 0.195312, 1},
   {0.75, 0.472656, 0.195312, 1},
   {0.75, 0.472656, 0.195312, 1},
   {0.75, 0.472656, 0.191406, 1},
   {0.746094, 0.46875, 0.191406, 1},
   {0.746094, 0.46875, 0.191406, 1},
   {0.746094, 0.46875, 0.191406, 1},
   {0.742188, 0.46875, 0.191406, 1},
   {0.742188, 0.46875, 0.191406, 1},
   {0.742188, 0.464844, 0.191406, 1},
   {0.738281, 0.464844, 0.191406, 1},
   {0.738281, 0.464844, 0.191406, 1},
   {0.734375, 0.464844, 0.191406, 1},
   {0.734375, 0.460938, 0.1875, 1},
   {0.730469, 0.460938, 0.1875, 1},
   {0.730469, 0.457031, 0.1875, 1},
   {0.726562, 0.457031, 0.1875, 1},
   {0.722656, 0.453125, 0.1875, 1},
   {0.71875, 0.453125, 0.183594, 1},
   {0.707031, 0.445312, 0.183594, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
   {0.617188, 0.386719, 0.160156, 1},
});

const Palette BPAL_22 = Palette("mars",
{
   {0, 0, 0, 1},
   {0, 0, 0, 1},
   {0, 0, 0, 1},
   {0.00392157, 0, 0.00392157, 1},
   {0.0156863, 0.00784314, 0.0156863, 1},
   {0.027451, 0.0156863, 0.027451, 1},
   {0.0392157, 0.027451, 0.0392157, 1},
   {0.054902, 0.0313725, 0.054902, 1},
   {0.0862745, 0.054902, 0.0941176, 1},
   {0.137255, 0.105882, 0.168627, 1},
   {0.196078, 0.14902, 0.243137, 1},
   {0.25098, 0.196078, 0.317647, 1},
   {0.305882, 0.243137, 0.396078, 1},
   {0.329412, 0.270588, 0.45098, 1},
   {0.32549, 0.278431, 0.486275, 1},
   {0.32549, 0.290196, 0.529412, 1},
   {0.313725, 0.294118, 0.564706, 1},
   {0.309804, 0.301961, 0.6, 1},
   {0.305882, 0.321569, 0.631373, 1},
   {0.298039, 0.352941, 0.658824, 1},
   {0.294118, 0.392157, 0.686275, 1},
   {0.286275, 0.419608, 0.709804, 1},
   {0.278431, 0.45098, 0.729412, 1},
   {0.266667, 0.486275, 0.752941, 1},
   {0.258824, 0.52549, 0.788235, 1},
   {0.243137, 0.560784, 0.807843, 1},
   {0.231373, 0.592157, 0.835294, 1},
   {0.223529, 0.631373, 0.858824, 1},
   {0.211765, 0.670588, 0.839216, 1},
   {0.211765, 0.717647, 0.772549, 1},
   {0.211765, 0.760784, 0.709804, 1},
   {0.211765, 0.807843, 0.643137, 1},
   {0.211765, 0.85098, 0.572549, 1},
   {0.211765, 0.870588, 0.513725, 1},
   {0.211765, 0.87451, 0.458824, 1},
   {0.211765, 0.870588, 0.407843, 1},
   {0.211765, 0.87451, 0.345098, 1},
   {0.211765, 0.870588, 0.290196, 1},
   {0.235294, 0.870588, 0.254902, 1},
   {0.27451, 0.87451, 0.247059, 1},
   {0.317647, 0.870588, 0.239216, 1},
   {0.364706, 0.87451, 0.227451, 1},
   {0.4, 0.870588, 0.219608, 1},
   {0.466667, 0.870588, 0.196078, 1},
   {0.564706, 0.87451, 0.160784, 1},
   {0.647059, 0.870588, 0.129412, 1},
   {0.737255, 0.87451, 0.0941176, 1},
   {0.827451, 0.870588, 0.0588235, 1},
   {0.870588, 0.854902, 0.0470588, 1},
   {0.87451, 0.811765, 0.0588235, 1},
   {0.870588, 0.776471, 0.0745098, 1},
   {0.87451, 0.737255, 0.0823529, 1},
   {0.870588, 0.698039, 0.0941176, 1},
   {0.878431, 0.666667, 0.113725, 1},
   {0.890196, 0.631373, 0.137255, 1},
   {0.905882, 0.603922, 0.168627, 1},
   {0.917647, 0.568627, 0.188235, 1},
   {0.92549, 0.541176, 0.211765, 1},
   {0.933333, 0.501961, 0.223529, 1},
   {0.933333, 0.454902, 0.211765, 1},
   {0.941176, 0.407843, 0.2, 1},
   {0.933333, 0.364706, 0.188235, 1},
   {0.933333, 0.317647, 0.176471, 1},
   {0.933333, 0.298039, 0.196078, 1},
   {0.933333, 0.309804, 0.239216, 1},
   {0.941176, 0.317647, 0.278431, 1},
   {0.933333, 0.329412, 0.32549, 1},
   {0.933333, 0.341176, 0.372549, 1},
   {0.921569, 0.352941, 0.4, 1},
   {0.894118, 0.360784, 0.411765, 1},
   {0.87451, 0.372549, 0.431373, 1},
   {0.843137, 0.380392, 0.447059, 1},
   {0.823529, 0.396078, 0.462745, 1},
   {0.803922, 0.396078, 0.454902, 1},
   {0.788235, 0.388235, 0.439216, 1},
   {0.776471, 0.384314, 0.419608, 1},
   {0.764706, 0.380392, 0.4, 1},
   {0.74902, 0.372549, 0.376471, 1},
   {0.729412, 0.372549, 0.360784, 1},
   {0.709804, 0.384314, 0.352941, 1},
   {0.686275, 0.388235, 0.341176, 1},
   {0.658824, 0.396078, 0.32549, 1},
   {0.631373, 0.4, 0.309804, 1},
   {0.615686, 0.411765, 0.305882, 1},
   {0.6, 0.419608, 0.309804, 1},
   {0.592157, 0.427451, 0.313725, 1},
   {0.576471, 0.439216, 0.309804, 1},
   {0.560784, 0.447059, 0.309804, 1},
   {0.545098, 0.447059, 0.309804, 1},
   {0.537255, 0.435294, 0.309804, 1},
   {0.52549, 0.423529, 0.313725, 1},
   {0.509804, 0.411765, 0.309804, 1},
   {0.501961, 0.407843, 0.305882, 1},
   {0.490196, 0.396078, 0.309804, 1},
   {0.478431, 0.388235, 0.313725, 1},
   {0.470588, 0.388235, 0.321569, 1},
   {0.458824, 0.384314, 0.32549, 1},
   {0.447059, 0.380392, 0.329412, 1},
   {0.447059, 0.380392, 0.341176, 1},
   {0.458824, 0.392157, 0.352941, 1},
   {0.470588, 0.4, 0.364706, 1},
   {0.478431, 0.407843, 0.376471, 1},
   {0.490196, 0.415686, 0.396078, 1},
   {0.498039, 0.427451, 0.407843, 1},
   {0.505882, 0.439216, 0.419608, 1},
   {0.521569, 0.45098, 0.439216, 1},
   {0.52549, 0.458824, 0.45098, 1},
   {0.533333, 0.470588, 0.470588, 1},
   {0.545098, 0.486275, 0.486275, 1},
   {0.556863, 0.498039, 0.498039, 1},
   {0.568627, 0.517647, 0.517647, 1},
   {0.576471, 0.533333, 0.533333, 1},
   {0.588235, 0.545098, 0.545098, 1},
   {0.596078, 0.560784, 0.560784, 1},
   {0.603922, 0.580392, 0.580392, 1},
   {0.615686, 0.6, 0.6, 1},
   {0.627451, 0.615686, 0.615686, 1},
   {0.635294, 0.635294, 0.635294, 1},
   {0.647059, 0.647059, 0.647059, 1},
   {0.658824, 0.658824, 0.658824, 1},
   {0.666667, 0.666667, 0.666667, 1},
   {0.67451, 0.67451, 0.67451, 1},
   {0.686275, 0.686275, 0.686275, 1},
   {0.698039, 0.698039, 0.698039, 1},
   {0.709804, 0.709804, 0.709804, 1},
   {0.717647, 0.717647, 0.717647, 1},
   {0.733333, 0.733333, 0.733333, 1},
   {0.737255, 0.737255, 0.737255, 1},
   {0.74902, 0.74902, 0.74902, 1},
   {0.760784, 0.760784, 0.760784, 1},
   {0.768627, 0.768627, 0.768627, 1},
   {0.776471, 0.776471, 0.776471, 1},
   {0.788235, 0.788235, 0.788235, 1},
   {0.8, 0.8, 0.8, 1},
   {0.803922, 0.803922, 0.803922, 1},
   {0.815686, 0.815686, 0.815686, 1},
   {0.827451, 0.827451, 0.827451, 1},
   {0.839216, 0.839216, 0.839216, 1},
   {0.847059, 0.847059, 0.847059, 1},
   {0.858824, 0.858824, 0.858824, 1},
   {0.866667, 0.866667, 0.866667, 1},
   {0.878431, 0.878431, 0.878431, 1},
   {0.890196, 0.890196, 0.890196, 1},
   {0.901961, 0.901961, 0.901961, 1},
   {0.909804, 0.909804, 0.909804, 1},
   {0.921569, 0.921569, 0.921569, 1},
   {0.933333, 0.933333, 0.933333, 1},
   {0.941176, 0.941176, 0.941176, 1},
   {0.94902, 0.94902, 0.94902, 1},
   {0.94902, 0.94902, 0.94902, 1},
   {0.94902, 0.94902, 0.94902, 1},
});

const Palette BPAL_23 = Palette("rainbow",
{
   {1, 0, 0, 1},
   {1, 0.0408947, 0, 1},
   {1, 0.0817211, 0, 1},
   {1, 0.122411, 0, 1},
   {1, 0.162895, 0, 1},
   {1, 0.203108, 0, 1},
   {1, 0.24298, 0, 1},
   {1, 0.282446, 0, 1},
   {1, 0.321439, 0, 1},
   {1, 0.359895, 0, 1},
   {1, 0.397748, 0, 1},
   {1, 0.434936, 0, 1},
   {1, 0.471397, 0, 1},
   {1, 0.507068, 0, 1},
   {1, 0.541892, 0, 1},
   {1, 0.575808, 0, 1},
   {1, 0.608761, 0, 1},
   {1, 0.640696, 0, 1},
   {1, 0.671559, 0, 1},
   {1, 0.701298, 0, 1},
   {1, 0.729864, 0, 1},
   {1, 0.757209, 0, 1},
   {1, 0.783287, 0, 1},
   {1, 0.808054, 0, 1},
   {1, 0.83147, 0, 1},
   {1, 0.853494, 0, 1},
   {1, 0.87409, 0, 1},
   {1, 0.893224, 0, 1},
   {1, 0.910864, 0, 1},
   {1, 0.926979, 0, 1},
   {1, 0.941544, 0, 1},
   {1, 0.954533, 0, 1},
   {1, 0.965926, 0, 1},
   {1, 0.975702, 0, 1},
   {1, 0.983846, 0, 1},
   {1, 0.990344, 0, 1},
   {1, 0.995185, 0, 1},
   {1, 0.998361, 0, 1},
   {1, 0.999866, 0, 1},
   {0.999699, 1, 0, 1},
   {0.997859, 1, 0, 1},
   {0.99435, 1, 0, 1},
   {0.989177, 1, 0, 1},
   {0.982349, 1, 0, 1},
   {0.973877, 1, 0, 1},
   {0.963776, 1, 0, 1},
   {0.952063, 1, 0, 1},
   {0.938756, 1, 0, 1},
   {0.92388, 1, 0, 1},
   {0.907457, 1, 0, 1},
   {0.889516, 1, 0, 1},
   {0.870087, 1, 0, 1},
   {0.849202, 1, 0, 1},
   {0.826897, 1, 0, 1},
   {0.803208, 1, 0, 1},
   {0.778175, 1, 0, 1},
   {0.75184, 1, 0, 1},
   {0.724247, 1, 0, 1},
   {0.695443, 1, 0, 1},
   {0.665475, 1, 0, 1},
   {0.634393, 1, 0, 1},
   {0.602251, 1, 0, 1},
   {0.5691, 1, 0, 1},
   {0.534998, 1, 0, 1},
   {0.5, 1, 0, 1},
   {0.464166, 1, 0, 1},
   {0.427555, 1, 0, 1},
   {0.390229, 1, 0, 1},
   {0.35225, 1, 0, 1},
   {0.313682, 1, 0, 1},
   {0.274589, 1, 0, 1},
   {0.235036, 1, 0, 1},
   {0.19509, 1, 0, 1},
   {0.154818, 1, 0, 1},
   {0.114287, 1, 0, 1},
   {0.0735646, 1, 0, 1},
   {0.0327191, 1, 0, 1},
   {0, 1, 0.00818114, 1},
   {0, 1, 0.0490677, 1},
   {0, 1, 0.0898721, 1},
   {0, 1, 0.130526, 1},
   {0, 1, 0.170962, 1},
   {0, 1, 0.211112, 1},
   {0, 1, 0.250908, 1},
   {0, 1, 0.290285, 1},
   {0, 1, 0.329176, 1},
   {0, 1, 0.367516, 1},
   {0, 1, 0.405241, 1},
   {0, 1, 0.442289, 1},
   {0, 1, 0.478596, 1},
   {0, 1, 0.514103, 1},
   {0, 1, 0.548749, 1},
   {0, 1, 0.582478, 1},
   {0, 1, 0.615232, 1},
   {0, 1, 0.646956, 1},
   {0, 1, 0.677598, 1},
   {0, 1, 0.707107, 1},
   {0, 1, 0.735432, 1},
   {0, 1, 0.762527, 1},
   {0, 1, 0.788346, 1},
   {0, 1, 0.812847, 1},
   {0, 1, 0.835987, 1},
   {0, 1, 0.857729, 1},
   {0, 1, 0.878035, 1},
   {0, 1, 0.896873, 1},
   {0, 1, 0.91421, 1},
   {0, 1, 0.930017, 1},
   {0, 1, 0.944269, 1},
   {0, 1, 0.95694, 1},
   {0, 1, 0.968011, 1},
   {0, 1, 0.977462, 1},
   {0, 1, 0.985278, 1},
   {0, 1, 0.991445, 1},
   {0, 1, 0.995953, 1},
   {0, 1, 0.998795, 1},
   {0, 1, 0.999967, 1},
   {0, 0.999465, 1, 1},
   {0, 0.99729, 1, 1},
   {0, 0.993448, 1, 1},
   {0, 0.987943, 1, 1},
   {0, 0.980785, 1, 1},
   {0, 0.971987, 1, 1},
   {0, 0.961562, 1, 1},
   {0, 0.949528, 1, 1},
   {0, 0.935906, 1, 1},
   {0, 0.920718, 1, 1},
   {0, 0.903989, 1, 1},
   {0, 0.885748, 1, 1},
   {0, 0.866025, 1, 1},
   {0, 0.844854, 1, 1},
   {0, 0.822268, 1, 1},
   {0, 0.798307, 1, 1},
   {0, 0.77301, 1, 1},
   {0, 0.74642, 1, 1},
   {0, 0.718582, 1, 1},
   {0, 0.689541, 1, 1},
   {0, 0.659346, 1, 1},
   {0, 0.628048, 1, 1},
   {0, 0.595699, 1, 1},
   {0, 0.562354, 1, 1},
   {0, 0.528068, 1, 1},
   {0, 0.492898, 1, 1},
   {0, 0.456904, 1, 1},
   {0, 0.420145, 1, 1},
   {0, 0.382683, 1, 1},
   {0, 0.344581, 1, 1},
   {0, 0.305903, 1, 1},
   {0, 0.266713, 1, 1},
   {0, 0.227076, 1, 1},
   {0, 0.18706, 1, 1},
   {0, 0.14673, 1, 1},
   {0, 0.106156, 1, 1},
   {0, 0.0654031, 1, 1},
   {0, 0.0245412, 1, 1},
   {0.0163617, 0, 1, 1},
   {0.0572373, 0, 1, 1},
   {0.0980171, 0, 1, 1},
   {0.138633, 0, 1, 1},
   {0.179017, 0, 1, 1},
   {0.219101, 0, 1, 1},
   {0.258819, 0, 1, 1},
   {0.298104, 0, 1, 1},
   {0.33689, 0, 1, 1},
   {0.375112, 0, 1, 1},
   {0.412707, 0, 1, 1},
   {0.449611, 0, 1, 1},
   {0.485763, 0, 1, 1},
   {0.521103, 0, 1, 1},
   {0.55557, 0, 1, 1},
   {0.589108, 0, 1, 1},
   {0.621661, 0, 1, 1},
   {0.653173, 0, 1, 1},
   {0.683592, 0, 1, 1},
   {0.712868, 0, 1, 1},
   {0.740951, 0, 1, 1},
   {0.767795, 0, 1, 1},
   {0.793353, 0, 1, 1},
   {0.817585, 0, 1, 1},
   {0.840448, 0, 1, 1},
   {0.861906, 0, 1, 1},
   {0.881921, 0, 1, 1},
   {0.900461, 0, 1, 1},
   {0.917494, 0, 1, 1},
   {0.932993, 0, 1, 1},
   {0.94693, 0, 1, 1},
   {0.959283, 0, 1, 1},
   {0.970031, 0, 1, 1},
   {0.979156, 0, 1, 1},
   {0.986643, 0, 1, 1},
   {0.99248, 0, 1, 1},
   {0.996655, 0, 1, 1},
   {0.999163, 0, 1, 1},
   {1, 0, 1, 1},
});

const Palette BPAL_24 = Palette("cmyk",
{
   {0.300725, 0.680491, 0.901701, 1},
   {0.343564, 0.712004, 0.917969, 1},
   {0.386403, 0.743518, 0.934237, 1},
   {0.441409, 0.694656, 0.899639, 1},
   {0.496414, 0.645794, 0.86504, 1},
   {0.550366, 0.581752, 0.822636, 1},
   {0.604318, 0.51771, 0.780231, 1},
   {0.651771, 0.474934, 0.743461, 1},
   {0.699224, 0.432157, 0.70669, 1},
   {0.738903, 0.424989, 0.675772, 1},
   {0.778582, 0.417821, 0.644854, 1},
   {0.810852, 0.444937, 0.617053, 1},
   {0.843122, 0.472052, 0.589251, 1},
   {0.868355, 0.522424, 0.564101, 1},
   {0.893588, 0.572795, 0.538951, 1},
   {0.91124, 0.630943, 0.519525, 1},
   {0.928891, 0.68909, 0.500098, 1},
   {0.937118, 0.739358, 0.491394, 1},
   {0.945344, 0.789625, 0.482689, 1},
   {0.940976, 0.819233, 0.488234, 1},
   {0.936608, 0.84884, 0.493779, 1},
   {0.915305, 0.849461, 0.511525, 1},
   {0.894001, 0.850082, 0.529271, 1},
   {0.850401, 0.817693, 0.547873, 1},
   {0.806801, 0.785304, 0.566474, 1},
   {0.734503, 0.71805, 0.563027, 1},
   {0.662204, 0.650797, 0.559579, 1},
   {0.553381, 0.54463, 0.499912, 1},
   {0.444557, 0.438462, 0.440244, 1},
   {0.289045, 0.280283, 0.282844, 1},
   {0.133532, 0.122103, 0.125444, 1},
});

const Palette BPAL_25 = Palette("calewhite",
{
   {1, 1, 1, 1},
   {0.90625, 0.90625, 1, 1},
   {0.8125, 0.8125, 1, 1},
   {0.71875, 0.71875, 1, 1},
   {0.625, 0.625, 1, 1},
   {0.53125, 0.53125, 1, 1},
   {0.4375, 0.4375, 1, 1},
   {0.34375, 0.34375, 1, 1},
   {0.25, 0.25, 1, 1},
   {0.15625, 0.15625, 1, 1},
   {0.0625, 0.0625, 1, 1},
   {0, 0.03125, 1, 1},
   {0, 0.125, 1, 1},
   {0, 0.21875, 1, 1},
   {0, 0.3125, 1, 1},
   {0, 0.40625, 1, 1},
   {0, 0.5, 1, 1},
   {0, 0.59375, 1, 1},
   {0, 0.6875, 1, 1},
   {0, 0.78125, 1, 1},
   {0, 0.875, 1, 1},
   {0, 0.96875, 1, 1},
   {0, 1, 0.9375, 1},
   {0, 1, 0.84375, 1},
   {0, 1, 0.75, 1},
   {0, 1, 0.65625, 1},
   {0, 1, 0.5625, 1},
   {0, 1, 0.46875, 1},
   {0, 1, 0.375, 1},
   {0, 1, 0.28125, 1},
   {0, 1, 0.1875, 1},
   {0, 1, 0.09375, 1},
   {0, 1, 0, 1},
   {0.09375, 1, 0, 1},
   {0.1875, 1, 0, 1},
   {0.28125, 1, 0, 1},
   {0.375, 1, 0, 1},
   {0.46875, 1, 0, 1},
   {0.5625, 1, 0, 1},
   {0.65625, 1, 0, 1},
   {0.75, 1, 0, 1},
   {0.84375, 1, 0, 1},
   {0.9375, 1, 0, 1},
   {1, 0.96875, 0, 1},
   {1, 0.875, 0, 1},
   {1, 0.78125, 0, 1},
   {1, 0.6875, 0, 1},
   {1, 0.59375, 0, 1},
   {1, 0.5, 0, 1},
   {1, 0.40625, 0, 1},
   {1, 0.3125, 0, 1},
   {1, 0.21875, 0, 1},
   {1, 0.125, 0, 1},
   {1, 0.03125, 0, 1},
   {1, 0, 0.0625, 1},
   {1, 0, 0.15625, 1},
   {1, 0, 0.25, 1},
   {1, 0, 0.34375, 1},
   {1, 0, 0.4375, 1},
   {1, 0, 0.53125, 1},
   {1, 0, 0.625, 1},
   {1, 0, 0.71875, 1},
   {1, 0, 0.8125, 1},
   {1, 0, 0.90625, 1},
   {1, 0, 1, 1},
});

const Palette BPAL_26 = Palette("haxby",
{
   {0.039216, 0, 0.47451, 1},
   {0.156863, 0, 0.588235, 1},
   {0.078431, 0.019608, 0.686275, 1},
   {0, 0.039216, 0.784314, 1},
   {0, 0.098039, 0.831373, 1},
   {0, 0.156863, 0.878431, 1},
   {0.101961, 0.4, 0.941176, 1},
   {0.05098, 0.505882, 0.972549, 1},
   {0.098039, 0.686275, 1, 1},
   {0.196078, 0.745098, 1, 1},
   {0.266667, 0.792157, 1, 1},
   {0.380392, 0.882353, 0.941176, 1},
   {0.415686, 0.921569, 0.882353, 1},
   {0.486275, 0.921569, 0.784314, 1},
   {0.541176, 0.92549, 0.682353, 1},
   {0.67451, 0.960784, 0.658824, 1},
   {0.803922, 1, 0.635294, 1},
   {0.87451, 0.960784, 0.552941, 1},
   {0.941176, 0.92549, 0.47451, 1},
   {0.968627, 0.843137, 0.407843, 1},
   {1, 0.741176, 0.341176, 1},
   {1, 0.627451, 0.270588, 1},
   {0.956863, 0.458824, 0.294118, 1},
   {0.933333, 0.313725, 0.305882, 1},
   {1, 0.352941, 0.352941, 1},
   {1, 0.486275, 0.486275, 1},
   {1, 0.619608, 0.619608, 1},
   {0.960784, 0.701961, 0.682353, 1},
   {1, 0.768627, 0.768627, 1},
   {1, 0.843137, 0.843137, 1},
   {1, 0.921569, 0.921569, 1},
   {1, 1, 1, 1},
});

const Palette BPAL_27 = Palette("manga",
{
   {0.183594, 0.214844, 0.621094, 1},
   {0.167969, 0.203125, 0.625, 1},
   {0.128906, 0.167969, 0.632812, 1},
   {0.082031, 0.125, 0.636719, 1},
   {0.042969, 0.089844, 0.644531, 1},
   {0.019531, 0.070312, 0.648438, 1},
   {0.007812, 0.0625, 0.65625, 1},
   {0, 0.058594, 0.660156, 1},
   {0, 0.0625, 0.664062, 1},
   {0, 0.0625, 0.664062, 1},
   {0, 0.0625, 0.664062, 1},
   {0, 0.0625, 0.648438, 1},
   {0, 0.0625, 0.617188, 1},
   {0, 0.058594, 0.5625, 1},
   {0, 0.050781, 0.488281, 1},
   {0, 0.046875, 0.429688, 1},
   {0, 0.046875, 0.410156, 1},
   {0, 0.050781, 0.445312, 1},
   {0, 0.0625, 0.519531, 1},
   {0, 0.074219, 0.601562, 1},
   {0, 0.085938, 0.664062, 1},
   {0, 0.09375, 0.703125, 1},
   {0, 0.101562, 0.726562, 1},
   {0, 0.105469, 0.738281, 1},
   {0, 0.113281, 0.746094, 1},
   {0.003906, 0.121094, 0.753906, 1},
   {0.011719, 0.128906, 0.757812, 1},
   {0.027344, 0.148438, 0.761719, 1},
   {0.058594, 0.175781, 0.765625, 1},
   {0.105469, 0.222656, 0.769531, 1},
   {0.167969, 0.277344, 0.777344, 1},
   {0.21875, 0.320312, 0.78125, 1},
   {0.234375, 0.339844, 0.785156, 1},
   {0.210938, 0.324219, 0.789062, 1},
   {0.15625, 0.285156, 0.792969, 1},
   {0.097656, 0.242188, 0.796875, 1},
   {0.054688, 0.214844, 0.800781, 1},
   {0.027344, 0.199219, 0.804688, 1},
   {0.011719, 0.195312, 0.808594, 1},
   {0.007812, 0.195312, 0.8125, 1},
   {0.007812, 0.203125, 0.816406, 1},
   {0.007812, 0.207031, 0.816406, 1},
   {0.007812, 0.214844, 0.808594, 1},
   {0.007812, 0.214844, 0.792969, 1},
   {0.007812, 0.210938, 0.757812, 1},
   {0.007812, 0.199219, 0.695312, 1},
   {0.007812, 0.1875, 0.625, 1},
   {0.007812, 0.171875, 0.566406, 1},
   {0.007812, 0.175781, 0.550781, 1},
   {0.011719, 0.195312, 0.59375, 1},
   {0.015625, 0.226562, 0.667969, 1},
   {0.019531, 0.261719, 0.746094, 1},
   {0.023438, 0.289062, 0.804688, 1},
   {0.027344, 0.3125, 0.839844, 1},
   {0.03125, 0.328125, 0.859375, 1},
   {0.03125, 0.34375, 0.867188, 1},
   {0.039062, 0.359375, 0.875, 1},
   {0.046875, 0.375, 0.878906, 1},
   {0.058594, 0.394531, 0.882812, 1},
   {0.082031, 0.417969, 0.886719, 1},
   {0.121094, 0.449219, 0.890625, 1},
   {0.179688, 0.496094, 0.890625, 1},
   {0.25, 0.542969, 0.894531, 1},
   {0.304688, 0.582031, 0.898438, 1},
   {0.320312, 0.597656, 0.902344, 1},
   {0.292969, 0.59375, 0.90625, 1},
   {0.238281, 0.578125, 0.90625, 1},
   {0.183594, 0.5625, 0.910156, 1},
   {0.148438, 0.558594, 0.914062, 1},
   {0.128906, 0.5625, 0.914062, 1},
   {0.125, 0.574219, 0.917969, 1},
   {0.128906, 0.589844, 0.917969, 1},
   {0.136719, 0.605469, 0.921875, 1},
   {0.148438, 0.621094, 0.917969, 1},
   {0.15625, 0.628906, 0.910156, 1},
   {0.160156, 0.632812, 0.890625, 1},
   {0.164062, 0.617188, 0.847656, 1},
   {0.160156, 0.585938, 0.785156, 1},
   {0.15625, 0.542969, 0.710938, 1},
   {0.152344, 0.511719, 0.65625, 1},
   {0.160156, 0.519531, 0.644531, 1},
   {0.179688, 0.566406, 0.691406, 1},
   {0.214844, 0.640625, 0.765625, 1},
   {0.246094, 0.71875, 0.84375, 1},
   {0.277344, 0.78125, 0.894531, 1},
   {0.304688, 0.824219, 0.929688, 1},
   {0.328125, 0.855469, 0.945312, 1},
   {0.347656, 0.878906, 0.953125, 1},
   {0.367188, 0.898438, 0.957031, 1},
   {0.390625, 0.914062, 0.960938, 1},
   {0.414062, 0.929688, 0.960938, 1},
   {0.445312, 0.945312, 0.964844, 1},
   {0.488281, 0.960938, 0.964844, 1},
   {0.542969, 0.964844, 0.960938, 1},
   {0.597656, 0.96875, 0.953125, 1},
   {0.640625, 0.96875, 0.949219, 1},
   {0.660156, 0.972656, 0.945312, 1},
   {0.652344, 0.972656, 0.9375, 1},
   {0.640625, 0.972656, 0.929688, 1},
   {0.628906, 0.976562, 0.921875, 1},
   {0.632812, 0.976562, 0.914062, 1},
   {0.640625, 0.976562, 0.90625, 1},
   {0.660156, 0.980469, 0.902344, 1},
   {0.675781, 0.980469, 0.898438, 1},
   {0.695312, 0.976562, 0.894531, 1},
   {0.714844, 0.972656, 0.890625, 1},
   {0.726562, 0.964844, 0.878906, 1},
   {0.726562, 0.9375, 0.859375, 1},
   {0.707031, 0.894531, 0.816406, 1},
   {0.667969, 0.828125, 0.757812, 1},
   {0.621094, 0.75, 0.691406, 1},
   {0.589844, 0.699219, 0.644531, 1},
   {0.597656, 0.695312, 0.644531, 1},
   {0.652344, 0.746094, 0.695312, 1},
   {0.734375, 0.820312, 0.769531, 1},
   {0.808594, 0.890625, 0.839844, 1},
   {0.867188, 0.941406, 0.894531, 1},
   {0.90625, 0.96875, 0.925781, 1},
   {0.929688, 0.984375, 0.945312, 1},
   {0.945312, 0.988281, 0.957031, 1},
   {0.957031, 0.992188, 0.964844, 1},
   {0.96875, 0.992188, 0.972656, 1},
   {0.976562, 0.992188, 0.976562, 1},
   {0.980469, 0.992188, 0.984375, 1},
   {0.988281, 0.992188, 0.988281, 1},
   {0.992188, 0.992188, 0.992188, 1},
   {0.992188, 0.992188, 0.992188, 1},
   {0.992188, 0.992188, 0.992188, 1},
   {0.992188, 0.992188, 0.992188, 1},
   {0.992188, 0.992188, 0.992188, 1},
   {0.992188, 0.992188, 0.992188, 1},
   {0.988281, 0.992188, 0.988281, 1},
   {0.984375, 0.992188, 0.980469, 1},
   {0.976562, 0.992188, 0.976562, 1},
   {0.972656, 0.992188, 0.96875, 1},
   {0.964844, 0.992188, 0.957031, 1},
   {0.957031, 0.988281, 0.945312, 1},
   {0.945312, 0.984375, 0.929688, 1},
   {0.925781, 0.96875, 0.90625, 1},
   {0.894531, 0.941406, 0.867188, 1},
   {0.839844, 0.890625, 0.808594, 1},
   {0.769531, 0.820312, 0.734375, 1},
   {0.695312, 0.746094, 0.652344, 1},
   {0.644531, 0.695312, 0.597656, 1},
   {0.644531, 0.699219, 0.589844, 1},
   {0.691406, 0.75, 0.621094, 1},
   {0.757812, 0.828125, 0.667969, 1},
   {0.816406, 0.894531, 0.707031, 1},
   {0.859375, 0.9375, 0.726562, 1},
   {0.878906, 0.964844, 0.726562, 1},
   {0.890625, 0.972656, 0.714844, 1},
   {0.894531, 0.976562, 0.695312, 1},
   {0.898438, 0.980469, 0.675781, 1},
   {0.902344, 0.980469, 0.660156, 1},
   {0.90625, 0.976562, 0.640625, 1},
   {0.914062, 0.976562, 0.632812, 1},
   {0.921875, 0.976562, 0.628906, 1},
   {0.929688, 0.972656, 0.640625, 1},
   {0.9375, 0.972656, 0.652344, 1},
   {0.945312, 0.972656, 0.660156, 1},
   {0.949219, 0.96875, 0.640625, 1},
   {0.953125, 0.96875, 0.597656, 1},
   {0.960938, 0.964844, 0.542969, 1},
   {0.964844, 0.960938, 0.488281, 1},
   {0.964844, 0.945312, 0.445312, 1},
   {0.960938, 0.929688, 0.414062, 1},
   {0.960938, 0.914062, 0.390625, 1},
   {0.957031, 0.898438, 0.367188, 1},
   {0.953125, 0.878906, 0.347656, 1},
   {0.945312, 0.855469, 0.328125, 1},
   {0.929688, 0.824219, 0.304688, 1},
   {0.894531, 0.78125, 0.277344, 1},
   {0.84375, 0.71875, 0.246094, 1},
   {0.765625, 0.640625, 0.214844, 1},
   {0.691406, 0.566406, 0.179688, 1},
   {0.644531, 0.519531, 0.160156, 1},
   {0.65625, 0.511719, 0.152344, 1},
   {0.710938, 0.542969, 0.15625, 1},
   {0.785156, 0.585938, 0.160156, 1},
   {0.847656, 0.617188, 0.164062, 1},
   {0.890625, 0.632812, 0.160156, 1},
   {0.910156, 0.628906, 0.15625, 1},
   {0.917969, 0.621094, 0.148438, 1},
   {0.921875, 0.605469, 0.136719, 1},
   {0.917969, 0.589844, 0.128906, 1},
   {0.917969, 0.574219, 0.125, 1},
   {0.914062, 0.5625, 0.128906, 1},
   {0.914062, 0.558594, 0.148438, 1},
   {0.910156, 0.5625, 0.183594, 1},
   {0.90625, 0.578125, 0.238281, 1},
   {0.90625, 0.59375, 0.292969, 1},
   {0.902344, 0.597656, 0.320312, 1},
   {0.898438, 0.582031, 0.304688, 1},
   {0.894531, 0.542969, 0.25, 1},
   {0.890625, 0.496094, 0.179688, 1},
   {0.890625, 0.449219, 0.121094, 1},
   {0.886719, 0.417969, 0.082031, 1},
   {0.882812, 0.394531, 0.058594, 1},
   {0.878906, 0.375, 0.046875, 1},
   {0.875, 0.359375, 0.039062, 1},
   {0.867188, 0.34375, 0.03125, 1},
   {0.859375, 0.328125, 0.03125, 1},
   {0.839844, 0.3125, 0.027344, 1},
   {0.804688, 0.289062, 0.023438, 1},
   {0.746094, 0.261719, 0.019531, 1},
   {0.667969, 0.226562, 0.015625, 1},
   {0.59375, 0.195312, 0.011719, 1},
   {0.550781, 0.175781, 0.007812, 1},
   {0.566406, 0.171875, 0.007812, 1},
   {0.625, 0.1875, 0.007812, 1},
   {0.695312, 0.199219, 0.007812, 1},
   {0.757812, 0.210938, 0.007812, 1},
   {0.792969, 0.214844, 0.007812, 1},
   {0.808594, 0.214844, 0.007812, 1},
   {0.816406, 0.207031, 0.007812, 1},
   {0.816406, 0.203125, 0.007812, 1},
   {0.8125, 0.195312, 0.007812, 1},
   {0.808594, 0.195312, 0.011719, 1},
   {0.804688, 0.199219, 0.027344, 1},
   {0.800781, 0.214844, 0.054688, 1},
   {0.796875, 0.242188, 0.097656, 1},
   {0.792969, 0.285156, 0.15625, 1},
   {0.789062, 0.324219, 0.210938, 1},
   {0.785156, 0.339844, 0.234375, 1},
   {0.78125, 0.320312, 0.21875, 1},
   {0.777344, 0.277344, 0.167969, 1},
   {0.769531, 0.222656, 0.105469, 1},
   {0.765625, 0.175781, 0.058594, 1},
   {0.761719, 0.148438, 0.027344, 1},
   {0.757812, 0.128906, 0.011719, 1},
   {0.753906, 0.121094, 0.003906, 1},
   {0.746094, 0.113281, 0, 1},
   {0.738281, 0.105469, 0, 1},
   {0.726562, 0.101562, 0, 1},
   {0.703125, 0.09375, 0, 1},
   {0.664062, 0.085938, 0, 1},
   {0.601562, 0.074219, 0, 1},
   {0.519531, 0.0625, 0, 1},
   {0.445312, 0.050781, 0, 1},
   {0.410156, 0.046875, 0, 1},
   {0.429688, 0.046875, 0, 1},
   {0.488281, 0.050781, 0, 1},
   {0.5625, 0.058594, 0, 1},
   {0.617188, 0.0625, 0, 1},
   {0.648438, 0.0625, 0, 1},
   {0.664062, 0.0625, 0, 1},
   {0.664062, 0.0625, 0, 1},
   {0.664062, 0.0625, 0, 1},
   {0.660156, 0.058594, 0, 1},
   {0.65625, 0.0625, 0.007812, 1},
   {0.648438, 0.070312, 0.019531, 1},
   {0.644531, 0.089844, 0.042969, 1},
   {0.636719, 0.125, 0.082031, 1},
   {0.632812, 0.167969, 0.128906, 1},
   {0.625, 0.203125, 0.167969, 1},
   {0.621094, 0.214844, 0.183594, 1},
});

const Palette BPAL_28 = Palette("drywet",
{
   {0.328125, 0.1875, 0.019531, 1},
   {0.546875, 0.316406, 0.039062, 1},
   {0.746094, 0.503906, 0.175781, 1},
   {0.871094, 0.757812, 0.488281, 1},
   {0.960938, 0.90625, 0.761719, 1},
   {0.957031, 0.957031, 0.957031, 1},
   {0.777344, 0.914062, 0.894531, 1},
   {0.5, 0.800781, 0.753906, 1},
   {0.207031, 0.589844, 0.558594, 1},
   {0.003906, 0.398438, 0.371094, 1},
   {0, 0.234375, 0.1875, 1},
});

const Palette BPAL_29 = Palette("gfdl",
{
   {0.996078, 0.984314, 0.964706, 1},
   {0.92549, 0.929412, 0.945098, 1},
   {0.905882, 0.909804, 0.92549, 1},
   {0.862745, 0.882353, 0.901961, 1},
   {0.835294, 0.854902, 0.87451, 1},
   {0.811765, 0.823529, 0.858824, 1},
   {0.784314, 0.796078, 0.831373, 1},
   {0.74902, 0.772549, 0.811765, 1},
   {0.729412, 0.74902, 0.788235, 1},
   {0.694118, 0.717647, 0.768627, 1},
   {0.670588, 0.690196, 0.741176, 1},
   {0.639216, 0.666667, 0.72549, 1},
   {0.611765, 0.639216, 0.698039, 1},
   {0.580392, 0.607843, 0.666667, 1},
   {0.560784, 0.588235, 0.647059, 1},
   {0.517647, 0.560784, 0.623529, 1},
   {0.490196, 0.537255, 0.596078, 1},
   {0.462745, 0.517647, 0.576471, 1},
   {0.435294, 0.490196, 0.545098, 1},
   {0.4, 0.447059, 0.52549, 1},
   {0.384314, 0.431373, 0.509804, 1},
   {0.352941, 0.407843, 0.486275, 1},
   {0.32549, 0.380392, 0.458824, 1},
   {0.294118, 0.356863, 0.443137, 1},
   {0.270588, 0.329412, 0.415686, 1},
   {0.247059, 0.301961, 0.396078, 1},
   {0.223529, 0.282353, 0.372549, 1},
   {0.196078, 0.254902, 0.360784, 1},
   {0.168627, 0.223529, 0.32549, 1},
   {0.133333, 0.203922, 0.301961, 1},
   {0.113725, 0.180392, 0.27451, 1},
   {0.094118, 0.14902, 0.25098, 1},
   {0.07451, 0.12549, 0.227451, 1},
   {0.05098, 0.109804, 0.203922, 1},
   {0.047059, 0.105882, 0.196078, 1},
   {0.05098, 0.117647, 0.203922, 1},
   {0.062745, 0.129412, 0.219608, 1},
   {0.07451, 0.141176, 0.235294, 1},
   {0.086275, 0.156863, 0.254902, 1},
   {0.094118, 0.176471, 0.258824, 1},
   {0.105882, 0.188235, 0.27451, 1},
   {0.121569, 0.207843, 0.298039, 1},
   {0.133333, 0.219608, 0.309804, 1},
   {0.137255, 0.243137, 0.32549, 1},
   {0.145098, 0.254902, 0.337255, 1},
   {0.160784, 0.270588, 0.356863, 1},
   {0.176471, 0.286275, 0.372549, 1},
   {0.180392, 0.301961, 0.380392, 1},
   {0.196078, 0.313725, 0.396078, 1},
   {0.203922, 0.32549, 0.407843, 1},
   {0.219608, 0.341176, 0.423529, 1},
   {0.223529, 0.360784, 0.427451, 1},
   {0.247059, 0.384314, 0.45098, 1},
   {0.247059, 0.396078, 0.458824, 1},
   {0.262745, 0.415686, 0.478431, 1},
   {0.282353, 0.439216, 0.490196, 1},
   {0.290196, 0.447059, 0.498039, 1},
   {0.298039, 0.462745, 0.513725, 1},
   {0.309804, 0.478431, 0.529412, 1},
   {0.313725, 0.501961, 0.533333, 1},
   {0.329412, 0.517647, 0.54902, 1},
   {0.333333, 0.529412, 0.560784, 1},
   {0.34902, 0.54902, 0.580392, 1},
   {0.356863, 0.564706, 0.592157, 1},
   {0.372549, 0.580392, 0.607843, 1},
   {0.392157, 0.603922, 0.631373, 1},
   {0.403922, 0.615686, 0.643137, 1},
   {0.403922, 0.631373, 0.643137, 1},
   {0.423529, 0.654902, 0.666667, 1},
   {0.431373, 0.662745, 0.67451, 1},
   {0.447059, 0.678431, 0.694118, 1},
   {0.454902, 0.698039, 0.705882, 1},
   {0.47451, 0.717647, 0.72549, 1},
   {0.482353, 0.72549, 0.733333, 1},
   {0.501961, 0.74902, 0.756863, 1},
   {0.505882, 0.772549, 0.752941, 1},
   {0.517647, 0.788235, 0.764706, 1},
   {0.52549, 0.807843, 0.784314, 1},
   {0.541176, 0.819608, 0.8, 1},
   {0.54902, 0.839216, 0.811765, 1},
   {0.564706, 0.858824, 0.831373, 1},
   {0.580392, 0.87451, 0.847059, 1},
   {0.596078, 0.894118, 0.862745, 1},
   {0.596078, 0.905882, 0.862745, 1},
   {0.596078, 0.905882, 0.862745, 1},
   {0.576471, 0.890196, 0.819608, 1},
   {0.564706, 0.878431, 0.811765, 1},
   {0.54902, 0.866667, 0.760784, 1},
   {0.541176, 0.858824, 0.752941, 1},
   {0.529412, 0.847059, 0.729412, 1},
   {0.517647, 0.835294, 0.713725, 1},
   {0.498039, 0.827451, 0.662745, 1},
   {0.478431, 0.807843, 0.643137, 1},
   {0.470588, 0.803922, 0.607843, 1},
   {0.454902, 0.784314, 0.588235, 1},
   {0.443137, 0.776471, 0.556863, 1},
   {0.431373, 0.764706, 0.545098, 1},
   {0.415686, 0.74902, 0.501961, 1},
   {0.407843, 0.741176, 0.494118, 1},
   {0.392157, 0.729412, 0.458824, 1},
   {0.380392, 0.713725, 0.447059, 1},
   {0.368627, 0.701961, 0.415686, 1},
   {0.352941, 0.682353, 0.4, 1},
   {0.345098, 0.678431, 0.360784, 1},
   {0.329412, 0.662745, 0.345098, 1},
   {0.317647, 0.647059, 0.32549, 1},
   {0.305882, 0.635294, 0.313725, 1},
   {0.282353, 0.623529, 0.270588, 1},
   {0.27451, 0.615686, 0.262745, 1},
   {0.262745, 0.592157, 0.223529, 1},
   {0.258824, 0.584314, 0.215686, 1},
   {0.247059, 0.576471, 0.180392, 1},
   {0.243137, 0.572549, 0.176471, 1},
   {0.270588, 0.584314, 0.14902, 1},
   {0.282353, 0.6, 0.160784, 1},
   {0.313725, 0.619608, 0.117647, 1},
   {0.329412, 0.639216, 0.129412, 1},
   {0.372549, 0.654902, 0.098039, 1},
   {0.384314, 0.666667, 0.109804, 1},
   {0.419608, 0.686275, 0.070588, 1},
   {0.435294, 0.701961, 0.086275, 1},
   {0.478431, 0.721569, 0.023529, 1},
   {0.494118, 0.741176, 0.05098, 1},
   {0.529412, 0.756863, 0, 1},
   {0.545098, 0.772549, 0, 1},
   {0.588235, 0.788235, 0, 1},
   {0.603922, 0.807843, 0, 1},
   {0.635294, 0.811765, 0, 1},
   {0.658824, 0.835294, 0, 1},
   {0.698039, 0.85098, 0, 1},
   {0.721569, 0.87451, 0, 1},
   {0.756863, 0.878431, 0, 1},
   {0.780392, 0.905882, 0, 1},
   {0.823529, 0.909804, 0, 1},
   {0.847059, 0.933333, 0, 1},
   {0.878431, 0.945098, 0, 1},
   {0.901961, 0.968627, 0, 1},
   {0.933333, 0.972549, 0, 1},
   {0.960784, 1, 0, 1},
   {1, 1, 0, 1},
   {1, 1, 0, 1},
   {1, 0.984314, 0, 1},
   {1, 0.972549, 0, 1},
   {1, 0.921569, 0, 1},
   {1, 0.905882, 0, 1},
   {1, 0.862745, 0, 1},
   {1, 0.847059, 0, 1},
   {1, 0.803922, 0, 1},
   {1, 0.788235, 0, 1},
   {1, 0.74902, 0, 1},
   {1, 0.733333, 0, 1},
   {1, 0.694118, 0, 1},
   {1, 0.678431, 0, 1},
   {1, 0.631373, 0, 1},
   {1, 0.619608, 0, 1},
   {1, 0.580392, 0, 1},
   {1, 0.568627, 0, 1},
   {1, 0.529412, 0, 1},
   {1, 0.509804, 0, 1},
   {1, 0.466667, 0, 1},
   {1, 0.458824, 0, 1},
   {1, 0.431373, 0, 1},
   {1, 0.407843, 0, 1},
   {1, 0.376471, 0, 1},
   {0.980392, 0.360784, 0, 1},
   {0.952941, 0.333333, 0, 1},
   {0.929412, 0.313725, 0, 1},
   {0.909804, 0.290196, 0, 1},
   {0.886275, 0.270588, 0, 1},
   {0.862745, 0.243137, 0, 1},
   {0.843137, 0.231373, 0, 1},
   {0.819608, 0.203922, 0, 1},
   {0.792157, 0.184314, 0, 1},
   {0.772549, 0.160784, 0, 1},
   {0.74902, 0.145098, 0, 1},
   {0.72549, 0.121569, 0.023529, 1},
   {0.721569, 0.117647, 0.019608, 1},
   {0.686275, 0.12549, 0.023529, 1},
   {0.67451, 0.117647, 0.011765, 1},
   {0.631373, 0.117647, 0.035294, 1},
   {0.627451, 0.117647, 0.031373, 1},
   {0.603922, 0.109804, 0.031373, 1},
   {0.592157, 0.101961, 0.023529, 1},
   {0.54902, 0.105882, 0.035294, 1},
   {0.545098, 0.101961, 0.031373, 1},
   {0.505882, 0.101961, 0.027451, 1},
   {0.501961, 0.098039, 0.023529, 1},
   {0.47451, 0.101961, 0.035294, 1},
   {0.466667, 0.098039, 0.031373, 1},
   {0.431373, 0.094118, 0.039216, 1},
   {0.427451, 0.090196, 0.035294, 1},
   {0.392157, 0.094118, 0.039216, 1},
   {0.388235, 0.090196, 0.035294, 1},
   {0.360784, 0.086275, 0.039216, 1},
   {0.34902, 0.078431, 0.031373, 1},
   {0.313725, 0.086275, 0.047059, 1},
   {0.301961, 0.078431, 0.043137, 1},
   {0.290196, 0.078431, 0.043137, 1},
   {0.278431, 0.070588, 0.039216, 1},
   {0.239216, 0.07451, 0.039216, 1},
   {0.235294, 0.070588, 0.039216, 1},
   {0.215686, 0.066667, 0.043137, 1},
   {0.207843, 0.062745, 0.039216, 1},
   {0.180392, 0.062745, 0.043137, 1},
   {0.160784, 0.05098, 0.031373, 1},
   {0.141176, 0.054902, 0.035294, 1},
   {0.137255, 0.05098, 0.031373, 1},
   {0.113725, 0.05098, 0.035294, 1},
   {0.101961, 0.043137, 0.023529, 1},
   {0.082353, 0.043137, 0.031373, 1},
   {0.070588, 0.031373, 0.019608, 1},
   {0.058824, 0.031373, 0.023529, 1},
   {0.058824, 0.031373, 0.023529, 1},
   {0.054902, 0.031373, 0.019608, 1},
   {0.05098, 0.031373, 0.015686, 1},
   {0.047059, 0.023529, 0.019608, 1},
   {0.05098, 0.027451, 0.023529, 1},
   {0.043137, 0.027451, 0.019608, 1},
   {0.039216, 0.015686, 0, 1},
   {0.035294, 0.019608, 0.015686, 1},
   {0.031373, 0.011765, 0, 1},
   {0.023529, 0.015686, 0, 1},
   {0.023529, 0.015686, 0, 1},
   {0, 0, 0, 1},
   {0, 0, 0, 1},
});

const Palette BPAL_30 = Palette("wbgyr",
{
   {0.996094, 0.996094, 0.996094, 1},
   {0.984375, 0.992188, 0.996094, 1},
   {0.976562, 0.988281, 0.996094, 1},
   {0.964844, 0.984375, 0.992188, 1},
   {0.953125, 0.980469, 0.992188, 1},
   {0.945312, 0.976562, 0.992188, 1},
   {0.933594, 0.972656, 0.992188, 1},
   {0.921875, 0.96875, 0.988281, 1},
   {0.914062, 0.964844, 0.988281, 1},
   {0.902344, 0.960938, 0.988281, 1},
   {0.894531, 0.957031, 0.988281, 1},
   {0.882812, 0.953125, 0.988281, 1},
   {0.871094, 0.949219, 0.984375, 1},
   {0.863281, 0.945312, 0.984375, 1},
   {0.851562, 0.941406, 0.984375, 1},
   {0.839844, 0.9375, 0.984375, 1},
   {0.832031, 0.933594, 0.984375, 1},
   {0.820312, 0.929688, 0.980469, 1},
   {0.808594, 0.925781, 0.980469, 1},
   {0.800781, 0.921875, 0.980469, 1},
   {0.789062, 0.917969, 0.980469, 1},
   {0.777344, 0.914062, 0.976562, 1},
   {0.769531, 0.910156, 0.976562, 1},
   {0.757812, 0.90625, 0.976562, 1},
   {0.746094, 0.902344, 0.976562, 1},
   {0.738281, 0.898438, 0.976562, 1},
   {0.726562, 0.894531, 0.972656, 1},
   {0.714844, 0.890625, 0.972656, 1},
   {0.707031, 0.886719, 0.972656, 1},
   {0.695312, 0.882812, 0.972656, 1},
   {0.6875, 0.878906, 0.972656, 1},
   {0.675781, 0.875, 0.96875, 1},
   {0.664062, 0.871094, 0.96875, 1},
   {0.65625, 0.867188, 0.96875, 1},
   {0.644531, 0.863281, 0.96875, 1},
   {0.632812, 0.859375, 0.964844, 1},
   {0.613281, 0.851562, 0.964844, 1},
   {0.605469, 0.84375, 0.960938, 1},
   {0.59375, 0.835938, 0.957031, 1},
   {0.585938, 0.828125, 0.949219, 1},
   {0.578125, 0.820312, 0.945312, 1},
   {0.570312, 0.8125, 0.941406, 1},
   {0.558594, 0.804688, 0.9375, 1},
   {0.550781, 0.796875, 0.929688, 1},
   {0.542969, 0.789062, 0.925781, 1},
   {0.53125, 0.78125, 0.921875, 1},
   {0.523438, 0.769531, 0.917969, 1},
   {0.515625, 0.761719, 0.914062, 1},
   {0.503906, 0.753906, 0.90625, 1},
   {0.496094, 0.746094, 0.902344, 1},
   {0.488281, 0.738281, 0.898438, 1},
   {0.480469, 0.730469, 0.894531, 1},
   {0.46875, 0.722656, 0.890625, 1},
   {0.460938, 0.714844, 0.882812, 1},
   {0.453125, 0.707031, 0.878906, 1},
   {0.441406, 0.699219, 0.875, 1},
   {0.433594, 0.691406, 0.871094, 1},
   {0.425781, 0.683594, 0.863281, 1},
   {0.414062, 0.675781, 0.859375, 1},
   {0.40625, 0.667969, 0.855469, 1},
   {0.398438, 0.660156, 0.851562, 1},
   {0.390625, 0.652344, 0.847656, 1},
   {0.378906, 0.644531, 0.839844, 1},
   {0.371094, 0.636719, 0.835938, 1},
   {0.363281, 0.625, 0.832031, 1},
   {0.351562, 0.617188, 0.828125, 1},
   {0.34375, 0.609375, 0.824219, 1},
   {0.335938, 0.601562, 0.816406, 1},
   {0.324219, 0.59375, 0.8125, 1},
   {0.316406, 0.585938, 0.808594, 1},
   {0.308594, 0.578125, 0.804688, 1},
   {0.300781, 0.570312, 0.796875, 1},
   {0.28125, 0.554688, 0.789062, 1},
   {0.28125, 0.558594, 0.773438, 1},
   {0.28125, 0.5625, 0.761719, 1},
   {0.28125, 0.566406, 0.746094, 1},
   {0.28125, 0.570312, 0.734375, 1},
   {0.28125, 0.574219, 0.71875, 1},
   {0.28125, 0.578125, 0.707031, 1},
   {0.28125, 0.582031, 0.691406, 1},
   {0.28125, 0.585938, 0.675781, 1},
   {0.28125, 0.589844, 0.664062, 1},
   {0.28125, 0.597656, 0.648438, 1},
   {0.28125, 0.601562, 0.636719, 1},
   {0.28125, 0.605469, 0.621094, 1},
   {0.28125, 0.609375, 0.609375, 1},
   {0.28125, 0.613281, 0.59375, 1},
   {0.28125, 0.617188, 0.578125, 1},
   {0.28125, 0.621094, 0.566406, 1},
   {0.28125, 0.625, 0.550781, 1},
   {0.28125, 0.628906, 0.539062, 1},
   {0.285156, 0.632812, 0.523438, 1},
   {0.285156, 0.636719, 0.511719, 1},
   {0.285156, 0.640625, 0.496094, 1},
   {0.285156, 0.644531, 0.484375, 1},
   {0.285156, 0.648438, 0.46875, 1},
   {0.285156, 0.652344, 0.453125, 1},
   {0.285156, 0.65625, 0.441406, 1},
   {0.285156, 0.660156, 0.425781, 1},
   {0.285156, 0.664062, 0.414062, 1},
   {0.285156, 0.671875, 0.398438, 1},
   {0.285156, 0.675781, 0.386719, 1},
   {0.285156, 0.679688, 0.371094, 1},
   {0.285156, 0.683594, 0.355469, 1},
   {0.285156, 0.6875, 0.34375, 1},
   {0.285156, 0.691406, 0.328125, 1},
   {0.285156, 0.695312, 0.316406, 1},
   {0.285156, 0.699219, 0.300781, 1},
   {0.285156, 0.707031, 0.273438, 1},
   {0.304688, 0.710938, 0.277344, 1},
   {0.324219, 0.71875, 0.277344, 1},
   {0.339844, 0.722656, 0.28125, 1},
   {0.359375, 0.730469, 0.28125, 1},
   {0.378906, 0.734375, 0.285156, 1},
   {0.398438, 0.738281, 0.289062, 1},
   {0.414062, 0.746094, 0.289062, 1},
   {0.433594, 0.75, 0.292969, 1},
   {0.453125, 0.753906, 0.292969, 1},
   {0.472656, 0.761719, 0.296875, 1},
   {0.492188, 0.765625, 0.300781, 1},
   {0.507812, 0.773438, 0.300781, 1},
   {0.527344, 0.777344, 0.304688, 1},
   {0.546875, 0.78125, 0.304688, 1},
   {0.566406, 0.789062, 0.308594, 1},
   {0.585938, 0.792969, 0.3125, 1},
   {0.601562, 0.796875, 0.3125, 1},
   {0.621094, 0.804688, 0.316406, 1},
   {0.640625, 0.808594, 0.316406, 1},
   {0.660156, 0.816406, 0.320312, 1},
   {0.675781, 0.820312, 0.320312, 1},
   {0.695312, 0.824219, 0.324219, 1},
   {0.714844, 0.832031, 0.328125, 1},
   {0.734375, 0.835938, 0.328125, 1},
   {0.753906, 0.839844, 0.332031, 1},
   {0.769531, 0.847656, 0.332031, 1},
   {0.789062, 0.851562, 0.335938, 1},
   {0.808594, 0.859375, 0.339844, 1},
   {0.828125, 0.863281, 0.339844, 1},
   {0.847656, 0.867188, 0.34375, 1},
   {0.863281, 0.875, 0.34375, 1},
   {0.882812, 0.878906, 0.347656, 1},
   {0.902344, 0.882812, 0.351562, 1},
   {0.921875, 0.890625, 0.351562, 1},
   {0.9375, 0.894531, 0.355469, 1},
   {0.957031, 0.902344, 0.355469, 1},
   {0.976562, 0.90625, 0.359375, 1},
   {0.976562, 0.894531, 0.355469, 1},
   {0.976562, 0.878906, 0.347656, 1},
   {0.976562, 0.867188, 0.34375, 1},
   {0.972656, 0.851562, 0.335938, 1},
   {0.972656, 0.839844, 0.332031, 1},
   {0.972656, 0.828125, 0.328125, 1},
   {0.972656, 0.8125, 0.320312, 1},
   {0.972656, 0.800781, 0.316406, 1},
   {0.972656, 0.785156, 0.3125, 1},
   {0.972656, 0.773438, 0.304688, 1},
   {0.972656, 0.761719, 0.300781, 1},
   {0.96875, 0.746094, 0.292969, 1},
   {0.96875, 0.734375, 0.289062, 1},
   {0.96875, 0.71875, 0.285156, 1},
   {0.96875, 0.707031, 0.277344, 1},
   {0.96875, 0.695312, 0.273438, 1},
   {0.96875, 0.679688, 0.269531, 1},
   {0.96875, 0.667969, 0.261719, 1},
   {0.964844, 0.652344, 0.257812, 1},
   {0.964844, 0.640625, 0.25, 1},
   {0.964844, 0.625, 0.246094, 1},
   {0.964844, 0.613281, 0.242188, 1},
   {0.964844, 0.601562, 0.234375, 1},
   {0.964844, 0.585938, 0.230469, 1},
   {0.964844, 0.574219, 0.226562, 1},
   {0.960938, 0.558594, 0.21875, 1},
   {0.960938, 0.546875, 0.214844, 1},
   {0.960938, 0.535156, 0.207031, 1},
   {0.960938, 0.519531, 0.203125, 1},
   {0.960938, 0.507812, 0.199219, 1},
   {0.960938, 0.492188, 0.191406, 1},
   {0.960938, 0.480469, 0.1875, 1},
   {0.960938, 0.46875, 0.183594, 1},
   {0.957031, 0.453125, 0.175781, 1},
   {0.957031, 0.441406, 0.171875, 1},
   {0.957031, 0.414062, 0.160156, 1},
   {0.953125, 0.40625, 0.160156, 1},
   {0.949219, 0.398438, 0.160156, 1},
   {0.945312, 0.390625, 0.160156, 1},
   {0.941406, 0.382812, 0.160156, 1},
   {0.9375, 0.375, 0.160156, 1},
   {0.933594, 0.367188, 0.160156, 1},
   {0.933594, 0.359375, 0.160156, 1},
   {0.929688, 0.351562, 0.160156, 1},
   {0.925781, 0.34375, 0.160156, 1},
   {0.921875, 0.335938, 0.160156, 1},
   {0.917969, 0.328125, 0.160156, 1},
   {0.914062, 0.320312, 0.160156, 1},
   {0.910156, 0.3125, 0.160156, 1},
   {0.90625, 0.304688, 0.160156, 1},
   {0.902344, 0.296875, 0.160156, 1},
   {0.898438, 0.289062, 0.160156, 1},
   {0.894531, 0.28125, 0.160156, 1},
   {0.890625, 0.273438, 0.160156, 1},
   {0.890625, 0.261719, 0.15625, 1},
   {0.886719, 0.253906, 0.15625, 1},
   {0.882812, 0.246094, 0.15625, 1},
   {0.878906, 0.238281, 0.15625, 1},
   {0.875, 0.230469, 0.15625, 1},
   {0.871094, 0.222656, 0.15625, 1},
   {0.867188, 0.214844, 0.15625, 1},
   {0.863281, 0.207031, 0.15625, 1},
   {0.859375, 0.199219, 0.15625, 1},
   {0.855469, 0.191406, 0.15625, 1},
   {0.851562, 0.183594, 0.15625, 1},
   {0.847656, 0.175781, 0.15625, 1},
   {0.847656, 0.167969, 0.15625, 1},
   {0.84375, 0.160156, 0.15625, 1},
   {0.839844, 0.152344, 0.15625, 1},
   {0.835938, 0.144531, 0.15625, 1},
   {0.832031, 0.136719, 0.15625, 1},
   {0.824219, 0.121094, 0.15625, 1},
   {0.816406, 0.121094, 0.15625, 1},
   {0.808594, 0.117188, 0.152344, 1},
   {0.804688, 0.117188, 0.152344, 1},
   {0.796875, 0.117188, 0.148438, 1},
   {0.789062, 0.117188, 0.148438, 1},
   {0.78125, 0.113281, 0.148438, 1},
   {0.777344, 0.113281, 0.144531, 1},
   {0.769531, 0.113281, 0.144531, 1},
   {0.761719, 0.113281, 0.140625, 1},
   {0.753906, 0.109375, 0.140625, 1},
   {0.75, 0.109375, 0.140625, 1},
   {0.742188, 0.109375, 0.136719, 1},
   {0.734375, 0.105469, 0.136719, 1},
   {0.726562, 0.105469, 0.132812, 1},
   {0.722656, 0.105469, 0.132812, 1},
   {0.714844, 0.105469, 0.132812, 1},
   {0.707031, 0.101562, 0.128906, 1},
   {0.699219, 0.101562, 0.128906, 1},
   {0.695312, 0.101562, 0.125, 1},
   {0.6875, 0.101562, 0.125, 1},
   {0.679688, 0.097656, 0.121094, 1},
   {0.671875, 0.097656, 0.121094, 1},
   {0.667969, 0.097656, 0.121094, 1},
   {0.660156, 0.097656, 0.117188, 1},
   {0.652344, 0.09375, 0.117188, 1},
   {0.644531, 0.09375, 0.113281, 1},
   {0.640625, 0.09375, 0.113281, 1},
   {0.632812, 0.089844, 0.113281, 1},
   {0.625, 0.089844, 0.109375, 1},
   {0.617188, 0.089844, 0.109375, 1},
   {0.613281, 0.089844, 0.105469, 1},
   {0.605469, 0.085938, 0.105469, 1},
   {0.597656, 0.085938, 0.105469, 1},
   {0.589844, 0.085938, 0.101562, 1},
   {0.585938, 0.085938, 0.101562, 1},
   {0.570312, 0.082031, 0.097656, 1},
});

const Palette BPAL_31 = Palette("seq25",
{
   {0.597656, 0.058594, 0.058594, 1},
   {0.695312, 0.171875, 0.171875, 1},
   {0.796875, 0.316406, 0.316406, 1},
   {0.894531, 0.492188, 0.492188, 1},
   {0.996094, 0.695312, 0.695312, 1},
   {0.597656, 0.328125, 0.058594, 1},
   {0.695312, 0.433594, 0.171875, 1},
   {0.796875, 0.554688, 0.316406, 1},
   {0.894531, 0.691406, 0.492188, 1},
   {0.996094, 0.84375, 0.695312, 1},
   {0.417969, 0.597656, 0.058594, 1},
   {0.519531, 0.695312, 0.171875, 1},
   {0.636719, 0.796875, 0.316406, 1},
   {0.761719, 0.894531, 0.492188, 1},
   {0.894531, 0.996094, 0.695312, 1},
   {0.058594, 0.417969, 0.597656, 1},
   {0.171875, 0.519531, 0.695312, 1},
   {0.316406, 0.636719, 0.796875, 1},
   {0.492188, 0.761719, 0.894531, 1},
   {0.695312, 0.894531, 0.996094, 1},
   {0.148438, 0.058594, 0.597656, 1},
   {0.257812, 0.171875, 0.695312, 1},
   {0.394531, 0.316406, 0.796875, 1},
   {0.558594, 0.492188, 0.894531, 1},
   {0.746094, 0.695312, 0.996094, 1},
});

const Palette BPAL_32 = Palette("terrain",
{
   {0.194771, 0.210458, 0.610458, 1},
   {0.184314, 0.231373, 0.631373, 1},
   {0.173856, 0.252288, 0.652288, 1},
   {0.163399, 0.273203, 0.673203, 1},
   {0.152941, 0.294118, 0.694118, 1},
   {0.142484, 0.315033, 0.715033, 1},
   {0.132026, 0.335948, 0.735948, 1},
   {0.121569, 0.356863, 0.756863, 1},
   {0.111111, 0.377778, 0.777778, 1},
   {0.105882, 0.388235, 0.788235, 1},
   {0.090196, 0.419608, 0.819608, 1},
   {0.084967, 0.430065, 0.830065, 1},
   {0.069281, 0.461438, 0.861438, 1},
   {0.064052, 0.471895, 0.871895, 1},
   {0.048366, 0.503268, 0.903268, 1},
   {0.043137, 0.513725, 0.913725, 1},
   {0.027451, 0.545098, 0.945098, 1},
   {0.016993, 0.566013, 0.966013, 1},
   {0.011765, 0.576471, 0.976471, 1},
   {0, 0.605882, 0.982353, 1},
   {0, 0.621569, 0.935294, 1},
   {0, 0.637255, 0.888235, 1},
   {0, 0.645098, 0.864706, 1},
   {0, 0.668627, 0.794118, 1},
   {0, 0.684314, 0.747059, 1},
   {0, 0.7, 0.7, 1},
   {0, 0.707843, 0.676471, 1},
   {0, 0.731373, 0.605882, 1},
   {0, 0.747059, 0.558824, 1},
   {0, 0.762745, 0.511765, 1},
   {0, 0.770588, 0.488235, 1},
   {0, 0.794118, 0.417647, 1},
   {0.019608, 0.803922, 0.403922, 1},
   {0.05098, 0.810196, 0.410196, 1},
   {0.082353, 0.816471, 0.416471, 1},
   {0.113725, 0.822745, 0.422745, 1},
   {0.145098, 0.82902, 0.42902, 1},
   {0.160784, 0.832157, 0.432157, 1},
   {0.207843, 0.841569, 0.441569, 1},
   {0.239216, 0.847843, 0.447843, 1},
   {0.270588, 0.854118, 0.454118, 1},
   {0.301961, 0.860392, 0.460392, 1},
   {0.333333, 0.866667, 0.466667, 1},
   {0.364706, 0.872941, 0.472941, 1},
   {0.396078, 0.879216, 0.479216, 1},
   {0.411765, 0.882353, 0.482353, 1},
   {0.458824, 0.891765, 0.491765, 1},
   {0.490196, 0.898039, 0.498039, 1},
   {0.521569, 0.904314, 0.504314, 1},
   {0.552941, 0.910588, 0.510588, 1},
   {0.584314, 0.916863, 0.516863, 1},
   {0.615686, 0.923137, 0.523137, 1},
   {0.647059, 0.929412, 0.529412, 1},
   {0.662745, 0.932549, 0.532549, 1},
   {0.709804, 0.941961, 0.541961, 1},
   {0.741176, 0.948235, 0.548235, 1},
   {0.772549, 0.95451, 0.55451, 1},
   {0.803922, 0.960784, 0.560784, 1},
   {0.835294, 0.967059, 0.567059, 1},
   {0.866667, 0.973333, 0.573333, 1},
   {0.898039, 0.979608, 0.579608, 1},
   {0.913725, 0.982745, 0.582745, 1},
   {0.960784, 0.992157, 0.592157, 1},
   {0.992157, 0.998431, 0.598431, 1},
   {0.988235, 0.984941, 0.593647, 1},
   {0.972549, 0.964863, 0.585176, 1},
   {0.956863, 0.944784, 0.576706, 1},
   {0.941176, 0.924706, 0.568235, 1},
   {0.92549, 0.904627, 0.559765, 1},
   {0.909804, 0.884549, 0.551294, 1},
   {0.894118, 0.864471, 0.542824, 1},
   {0.878431, 0.844392, 0.534353, 1},
   {0.862745, 0.824314, 0.525882, 1},
   {0.847059, 0.804235, 0.517412, 1},
   {0.831373, 0.784157, 0.508941, 1},
   {0.823529, 0.774118, 0.504706, 1},
   {0.8, 0.744, 0.492, 1},
   {0.784314, 0.723922, 0.483529, 1},
   {0.768627, 0.703843, 0.475059, 1},
   {0.752941, 0.683765, 0.466588, 1},
   {0.737255, 0.663686, 0.458118, 1},
   {0.721569, 0.643608, 0.449647, 1},
   {0.705882, 0.623529, 0.441176, 1},
   {0.690196, 0.603451, 0.432706, 1},
   {0.67451, 0.583373, 0.424235, 1},
   {0.658824, 0.563294, 0.415765, 1},
   {0.643137, 0.543216, 0.407294, 1},
   {0.627451, 0.523137, 0.398824, 1},
   {0.611765, 0.503059, 0.390353, 1},
   {0.596078, 0.48298, 0.381882, 1},
   {0.580392, 0.462902, 0.373412, 1},
   {0.572549, 0.452863, 0.369176, 1},
   {0.54902, 0.422745, 0.356471, 1},
   {0.533333, 0.402667, 0.348, 1},
   {0.517647, 0.382588, 0.339529, 1},
   {0.501961, 0.36251, 0.331059, 1},
   {0.513725, 0.377569, 0.348392, 1},
   {0.529412, 0.397647, 0.369412, 1},
   {0.545098, 0.417725, 0.390431, 1},
   {0.560784, 0.437804, 0.411451, 1},
   {0.576471, 0.457882, 0.432471, 1},
   {0.592157, 0.477961, 0.45349, 1},
   {0.607843, 0.498039, 0.47451, 1},
   {0.623529, 0.518118, 0.495529, 1},
   {0.639216, 0.538196, 0.516549, 1},
   {0.654902, 0.558275, 0.537569, 1},
   {0.670588, 0.578353, 0.558588, 1},
   {0.678431, 0.588392, 0.569098, 1},
   {0.701961, 0.61851, 0.600627, 1},
   {0.717647, 0.638588, 0.621647, 1},
   {0.733333, 0.658667, 0.642667, 1},
   {0.74902, 0.678745, 0.663686, 1},
   {0.764706, 0.698824, 0.684706, 1},
   {0.780392, 0.718902, 0.705725, 1},
   {0.796078, 0.73898, 0.726745, 1},
   {0.811765, 0.759059, 0.747765, 1},
   {0.827451, 0.779137, 0.768784, 1},
   {0.843137, 0.799216, 0.789804, 1},
   {0.858824, 0.819294, 0.810824, 1},
   {0.87451, 0.839373, 0.831843, 1},
   {0.890196, 0.859451, 0.852863, 1},
   {0.905882, 0.879529, 0.873882, 1},
   {0.921569, 0.899608, 0.894902, 1},
   {0.929412, 0.909647, 0.905412, 1},
   {0.952941, 0.939765, 0.936941, 1},
   {0.968627, 0.959843, 0.957961, 1},
   {0.984314, 0.979922, 0.97898, 1},
   {1, 1, 1, 1},
});

const Palette BPAL_33 = Palette("bwor",
{
   {0.105469, 0.171875, 0.382812, 1},
   {0.105469, 0.179688, 0.394531, 1},
   {0.109375, 0.1875, 0.40625, 1},
   {0.109375, 0.195312, 0.417969, 1},
   {0.113281, 0.203125, 0.429688, 1},
   {0.113281, 0.207031, 0.4375, 1},
   {0.113281, 0.214844, 0.449219, 1},
   {0.117188, 0.222656, 0.460938, 1},
   {0.117188, 0.230469, 0.472656, 1},
   {0.117188, 0.238281, 0.484375, 1},
   {0.121094, 0.246094, 0.496094, 1},
   {0.121094, 0.253906, 0.507812, 1},
   {0.125, 0.261719, 0.519531, 1},
   {0.125, 0.265625, 0.527344, 1},
   {0.125, 0.273438, 0.539062, 1},
   {0.128906, 0.28125, 0.550781, 1},
   {0.128906, 0.289062, 0.5625, 1},
   {0.128906, 0.296875, 0.574219, 1},
   {0.132812, 0.304688, 0.585938, 1},
   {0.132812, 0.3125, 0.597656, 1},
   {0.136719, 0.320312, 0.609375, 1},
   {0.136719, 0.324219, 0.617188, 1},
   {0.136719, 0.332031, 0.628906, 1},
   {0.140625, 0.347656, 0.652344, 1},
   {0.148438, 0.359375, 0.660156, 1},
   {0.15625, 0.371094, 0.667969, 1},
   {0.164062, 0.382812, 0.675781, 1},
   {0.175781, 0.398438, 0.683594, 1},
   {0.183594, 0.410156, 0.691406, 1},
   {0.191406, 0.421875, 0.699219, 1},
   {0.199219, 0.433594, 0.707031, 1},
   {0.207031, 0.445312, 0.714844, 1},
   {0.214844, 0.457031, 0.722656, 1},
   {0.222656, 0.46875, 0.730469, 1},
   {0.230469, 0.480469, 0.738281, 1},
   {0.242188, 0.496094, 0.75, 1},
   {0.25, 0.507812, 0.757812, 1},
   {0.257812, 0.519531, 0.765625, 1},
   {0.265625, 0.53125, 0.773438, 1},
   {0.273438, 0.542969, 0.78125, 1},
   {0.28125, 0.554688, 0.789062, 1},
   {0.289062, 0.566406, 0.796875, 1},
   {0.296875, 0.578125, 0.804688, 1},
   {0.308594, 0.59375, 0.8125, 1},
   {0.316406, 0.605469, 0.820312, 1},
   {0.324219, 0.617188, 0.828125, 1},
   {0.339844, 0.640625, 0.84375, 1},
   {0.351562, 0.648438, 0.847656, 1},
   {0.363281, 0.660156, 0.855469, 1},
   {0.375, 0.667969, 0.859375, 1},
   {0.386719, 0.675781, 0.863281, 1},
   {0.398438, 0.683594, 0.867188, 1},
   {0.410156, 0.695312, 0.875, 1},
   {0.417969, 0.703125, 0.878906, 1},
   {0.429688, 0.710938, 0.882812, 1},
   {0.441406, 0.71875, 0.890625, 1},
   {0.453125, 0.730469, 0.894531, 1},
   {0.464844, 0.738281, 0.898438, 1},
   {0.476562, 0.746094, 0.90625, 1},
   {0.488281, 0.753906, 0.910156, 1},
   {0.5, 0.765625, 0.914062, 1},
   {0.511719, 0.773438, 0.917969, 1},
   {0.523438, 0.78125, 0.925781, 1},
   {0.535156, 0.789062, 0.929688, 1},
   {0.546875, 0.800781, 0.933594, 1},
   {0.554688, 0.808594, 0.941406, 1},
   {0.566406, 0.816406, 0.945312, 1},
   {0.578125, 0.824219, 0.949219, 1},
   {0.589844, 0.835938, 0.953125, 1},
   {0.613281, 0.851562, 0.964844, 1},
   {0.621094, 0.855469, 0.964844, 1},
   {0.632812, 0.859375, 0.964844, 1},
   {0.640625, 0.863281, 0.964844, 1},
   {0.652344, 0.867188, 0.964844, 1},
   {0.660156, 0.867188, 0.964844, 1},
   {0.671875, 0.871094, 0.96875, 1},
   {0.679688, 0.875, 0.96875, 1},
   {0.6875, 0.878906, 0.96875, 1},
   {0.699219, 0.882812, 0.96875, 1},
   {0.707031, 0.886719, 0.96875, 1},
   {0.71875, 0.890625, 0.96875, 1},
   {0.726562, 0.894531, 0.96875, 1},
   {0.734375, 0.894531, 0.96875, 1},
   {0.746094, 0.898438, 0.96875, 1},
   {0.753906, 0.902344, 0.96875, 1},
   {0.765625, 0.90625, 0.96875, 1},
   {0.773438, 0.910156, 0.96875, 1},
   {0.785156, 0.914062, 0.972656, 1},
   {0.792969, 0.917969, 0.972656, 1},
   {0.800781, 0.921875, 0.972656, 1},
   {0.8125, 0.921875, 0.972656, 1},
   {0.820312, 0.925781, 0.972656, 1},
   {0.839844, 0.933594, 0.972656, 1},
   {0.847656, 0.9375, 0.972656, 1},
   {0.851562, 0.9375, 0.976562, 1},
   {0.859375, 0.941406, 0.976562, 1},
   {0.867188, 0.945312, 0.976562, 1},
   {0.871094, 0.945312, 0.976562, 1},
   {0.878906, 0.949219, 0.980469, 1},
   {0.886719, 0.953125, 0.980469, 1},
   {0.890625, 0.953125, 0.980469, 1},
   {0.898438, 0.957031, 0.980469, 1},
   {0.90625, 0.960938, 0.984375, 1},
   {0.910156, 0.960938, 0.984375, 1},
   {0.917969, 0.964844, 0.984375, 1},
   {0.925781, 0.96875, 0.984375, 1},
   {0.929688, 0.96875, 0.988281, 1},
   {0.9375, 0.972656, 0.988281, 1},
   {0.945312, 0.976562, 0.988281, 1},
   {0.949219, 0.976562, 0.988281, 1},
   {0.957031, 0.980469, 0.992188, 1},
   {0.964844, 0.984375, 0.992188, 1},
   {0.96875, 0.984375, 0.992188, 1},
   {0.976562, 0.988281, 0.992188, 1},
   {0.984375, 0.992188, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.996094, 0.992188, 0.980469, 1},
   {0.996094, 0.988281, 0.964844, 1},
   {0.996094, 0.988281, 0.949219, 1},
   {0.996094, 0.984375, 0.929688, 1},
   {0.992188, 0.980469, 0.914062, 1},
   {0.992188, 0.976562, 0.898438, 1},
   {0.992188, 0.972656, 0.882812, 1},
   {0.992188, 0.96875, 0.867188, 1},
   {0.992188, 0.96875, 0.851562, 1},
   {0.992188, 0.964844, 0.832031, 1},
   {0.992188, 0.960938, 0.816406, 1},
   {0.992188, 0.957031, 0.800781, 1},
   {0.988281, 0.953125, 0.785156, 1},
   {0.988281, 0.949219, 0.769531, 1},
   {0.988281, 0.949219, 0.753906, 1},
   {0.988281, 0.945312, 0.734375, 1},
   {0.988281, 0.941406, 0.71875, 1},
   {0.988281, 0.9375, 0.703125, 1},
   {0.988281, 0.933594, 0.6875, 1},
   {0.988281, 0.929688, 0.671875, 1},
   {0.984375, 0.929688, 0.65625, 1},
   {0.984375, 0.925781, 0.636719, 1},
   {0.984375, 0.917969, 0.605469, 1},
   {0.984375, 0.910156, 0.589844, 1},
   {0.984375, 0.898438, 0.570312, 1},
   {0.984375, 0.890625, 0.554688, 1},
   {0.984375, 0.878906, 0.539062, 1},
   {0.984375, 0.871094, 0.519531, 1},
   {0.988281, 0.859375, 0.503906, 1},
   {0.988281, 0.851562, 0.484375, 1},
   {0.988281, 0.839844, 0.46875, 1},
   {0.988281, 0.832031, 0.453125, 1},
   {0.988281, 0.820312, 0.433594, 1},
   {0.988281, 0.8125, 0.417969, 1},
   {0.988281, 0.804688, 0.402344, 1},
   {0.988281, 0.792969, 0.382812, 1},
   {0.988281, 0.785156, 0.367188, 1},
   {0.988281, 0.773438, 0.347656, 1},
   {0.988281, 0.765625, 0.332031, 1},
   {0.988281, 0.753906, 0.316406, 1},
   {0.992188, 0.746094, 0.296875, 1},
   {0.992188, 0.734375, 0.28125, 1},
   {0.992188, 0.726562, 0.265625, 1},
   {0.992188, 0.714844, 0.246094, 1},
   {0.992188, 0.707031, 0.230469, 1},
   {0.992188, 0.6875, 0.195312, 1},
   {0.992188, 0.675781, 0.195312, 1},
   {0.988281, 0.664062, 0.191406, 1},
   {0.988281, 0.652344, 0.191406, 1},
   {0.988281, 0.640625, 0.191406, 1},
   {0.984375, 0.628906, 0.1875, 1},
   {0.984375, 0.621094, 0.1875, 1},
   {0.980469, 0.609375, 0.183594, 1},
   {0.980469, 0.597656, 0.183594, 1},
   {0.980469, 0.585938, 0.183594, 1},
   {0.976562, 0.574219, 0.179688, 1},
   {0.976562, 0.5625, 0.179688, 1},
   {0.976562, 0.550781, 0.179688, 1},
   {0.972656, 0.539062, 0.175781, 1},
   {0.972656, 0.527344, 0.175781, 1},
   {0.96875, 0.515625, 0.171875, 1},
   {0.96875, 0.503906, 0.171875, 1},
   {0.96875, 0.492188, 0.171875, 1},
   {0.964844, 0.484375, 0.167969, 1},
   {0.964844, 0.472656, 0.167969, 1},
   {0.964844, 0.460938, 0.167969, 1},
   {0.960938, 0.449219, 0.164062, 1},
   {0.960938, 0.4375, 0.164062, 1},
   {0.957031, 0.414062, 0.160156, 1},
   {0.953125, 0.402344, 0.160156, 1},
   {0.945312, 0.390625, 0.160156, 1},
   {0.941406, 0.378906, 0.160156, 1},
   {0.933594, 0.367188, 0.160156, 1},
   {0.929688, 0.351562, 0.160156, 1},
   {0.925781, 0.339844, 0.160156, 1},
   {0.917969, 0.328125, 0.160156, 1},
   {0.914062, 0.316406, 0.160156, 1},
   {0.90625, 0.304688, 0.160156, 1},
   {0.902344, 0.292969, 0.160156, 1},
   {0.894531, 0.28125, 0.160156, 1},
   {0.890625, 0.269531, 0.160156, 1},
   {0.886719, 0.253906, 0.15625, 1},
   {0.878906, 0.242188, 0.15625, 1},
   {0.875, 0.230469, 0.15625, 1},
   {0.867188, 0.21875, 0.15625, 1},
   {0.863281, 0.207031, 0.15625, 1},
   {0.859375, 0.195312, 0.15625, 1},
   {0.851562, 0.183594, 0.15625, 1},
   {0.847656, 0.171875, 0.15625, 1},
   {0.839844, 0.15625, 0.15625, 1},
   {0.835938, 0.144531, 0.15625, 1},
   {0.824219, 0.121094, 0.15625, 1},
   {0.8125, 0.121094, 0.152344, 1},
   {0.804688, 0.117188, 0.152344, 1},
   {0.792969, 0.117188, 0.148438, 1},
   {0.78125, 0.113281, 0.148438, 1},
   {0.769531, 0.113281, 0.144531, 1},
   {0.761719, 0.113281, 0.140625, 1},
   {0.75, 0.109375, 0.140625, 1},
   {0.738281, 0.109375, 0.136719, 1},
   {0.730469, 0.105469, 0.132812, 1},
   {0.71875, 0.105469, 0.132812, 1},
   {0.707031, 0.101562, 0.128906, 1},
   {0.699219, 0.101562, 0.128906, 1},
   {0.6875, 0.101562, 0.125, 1},
   {0.675781, 0.097656, 0.121094, 1},
   {0.664062, 0.097656, 0.121094, 1},
   {0.65625, 0.09375, 0.117188, 1},
   {0.644531, 0.09375, 0.113281, 1},
   {0.632812, 0.09375, 0.113281, 1},
   {0.625, 0.089844, 0.109375, 1},
   {0.613281, 0.089844, 0.109375, 1},
   {0.601562, 0.085938, 0.105469, 1},
   {0.589844, 0.085938, 0.101562, 1},
   {0.570312, 0.082031, 0.097656, 1},
});

const Palette BPAL_34 = Palette("19-lev",
{
   {0.992188, 0.992188, 0.992188, 1},
   {0.992188, 0.992188, 0.625, 1},
   {0.992188, 0.992188, 0.386719, 1},
   {0.953125, 0.953125, 0.429688, 1},
   {0.996094, 0.820312, 0.136719, 1},
   {0.996094, 0.636719, 0.097656, 1},
   {0.996094, 0.347656, 0.097656, 1},
   {0.898438, 0.476562, 0.394531, 1},
   {0.925781, 0.566406, 0.484375, 1},
   {0.933594, 0.695312, 0.570312, 1},
   {0.964844, 0.777344, 0.695312, 1},
   {0.996094, 0.898438, 0.898438, 1},
   {0.839844, 0.878906, 0.996094, 1},
   {0.585938, 0.820312, 0.996094, 1},
   {0.117188, 0.738281, 0.996094, 1},
   {0.078125, 0.621094, 0.996094, 1},
   {0.039062, 0.421875, 0.9375, 1},
   {0.042969, 0.453125, 0.996094, 1},
   {0.039062, 0.40625, 0.78125, 1},
   {0, 0.347656, 0.621094, 1},
});

const Palette BPAL_35 = Palette("lithology",
{
   {0.988281, 0.953125, 0.246094, 1},
   {0.996094, 0.996094, 0.535156, 1},
   {0.996094, 0.824219, 0.269531, 1},
   {0.996094, 0.792969, 0.136719, 1},
   {0.996094, 0.996094, 0.832031, 1},
   {0.921875, 0.703125, 0, 1},
   {0.996094, 0.976562, 0.910156, 1},
   {0.996094, 0.976562, 0.78125, 1},
   {0.996094, 0.996094, 0.714844, 1},
   {0.976562, 0.929688, 0.476562, 1},
   {0.953125, 0.933594, 0.890625, 1},
   {0.941406, 0.894531, 0.871094, 1},
   {0.890625, 0.8125, 0.742188, 1},
   {0.890625, 0.84375, 0.742188, 1},
   {0.996094, 0.960938, 0.847656, 1},
   {0.875, 0.769531, 0.617188, 1},
   {0.875, 0.820312, 0.703125, 1},
   {0.855469, 0.796875, 0.660156, 1},
   {0.957031, 0.878906, 0.738281, 1},
   {0.875, 0.6875, 0.617188, 1},
   {0.808594, 0.730469, 0.558594, 1},
   {0.878906, 0.886719, 0.761719, 1},
   {0.894531, 0.855469, 0.699219, 1},
   {0.859375, 0.832031, 0.703125, 1},
   {0.824219, 0.789062, 0.621094, 1},
   {0.785156, 0.742188, 0.535156, 1},
   {0.734375, 0.683594, 0.421875, 1},
   {0.746094, 0.652344, 0.261719, 1},
   {0.820312, 0.757812, 0.484375, 1},
   {0.996094, 0.929688, 0.746094, 1},
   {0.996094, 0.894531, 0.613281, 1},
   {0.996094, 0.871094, 0.519531, 1},
   {0.992188, 0.898438, 0.4375, 1},
   {0.992188, 0.882812, 0.34375, 1},
   {0.992188, 0.855469, 0.179688, 1},
   {0.964844, 0.949219, 0.628906, 1},
   {0.996094, 0.808594, 0.503906, 1},
   {0.996094, 0.796875, 0.597656, 1},
   {0.996094, 0.886719, 0.535156, 1},
   {0.996094, 0.855469, 0.402344, 1},
   {0.570312, 0.859375, 0.714844, 1},
   {0.847656, 0.988281, 0.824219, 1},
   {0.808594, 0.933594, 0.871094, 1},
   {0.832031, 0.898438, 0.796875, 1},
   {0.75, 0.8125, 0.75, 1},
   {0.671875, 0.890625, 0.78125, 1},
   {0.855469, 0.992188, 0.734375, 1},
   {0.730469, 0.996094, 0.863281, 1},
   {0.878906, 0.9375, 0.84375, 1},
   {0.835938, 0.992188, 0.601562, 1},
   {0.582031, 0.996094, 0.789062, 1},
   {0.800781, 0.996094, 0.847656, 1},
   {0.648438, 0.984375, 0.664062, 1},
   {0.792969, 0.933594, 0.804688, 1},
   {0.601562, 0.804688, 0.992188, 1},
   {0.410156, 0.808594, 0.609375, 1},
   {0.738281, 0.855469, 0.941406, 1},
   {0.71875, 0.914062, 0.761719, 1},
   {0.5625, 0.644531, 0.394531, 1},
   {0.714844, 0.847656, 0.796875, 1},
   {0.652344, 0.726562, 0.523438, 1},
   {0.644531, 0.664062, 0.675781, 1},
   {0.550781, 0.742188, 0.800781, 1},
   {0.730469, 0.75, 0.769531, 1},
   {0.335938, 0.875, 0.984375, 1},
   {0.261719, 0.683594, 0.972656, 1},
   {0.417969, 0.761719, 0.996094, 1},
   {0.21875, 0.703125, 0.691406, 1},
   {0.375, 0.796875, 0.746094, 1},
   {0.746094, 0.886719, 0.859375, 1},
   {0.800781, 0.867188, 0.996094, 1},
   {0.003906, 0.609375, 0.800781, 1},
   {0.601562, 0.746094, 0.75, 1},
   {0.75, 0.679688, 0.710938, 1},
   {0.722656, 0.582031, 0.59375, 1},
   {0.847656, 0.757812, 0.636719, 1},
   {0.507812, 0, 0.253906, 1},
   {0.429688, 0.285156, 0.035156, 1},
   {0.996094, 0.714844, 0.867188, 1},
   {0.996094, 0.761719, 0.890625, 1},
   {0.996094, 0.816406, 0.914062, 1},
   {0.996094, 0.761719, 0.96875, 1},
   {0.996094, 0.894531, 0.949219, 1},
   {0.996094, 0.875, 0.867188, 1},
   {0.972656, 0.824219, 0.824219, 1},
   {0.996094, 0.949219, 0.785156, 1},
   {0.996094, 0.933594, 0.847656, 1},
   {0.996094, 0.894531, 0.761719, 1},
   {0.996094, 0.832031, 0.613281, 1},
   {0.996094, 0.632812, 0.152344, 1},
   {0.996094, 0.753906, 0.433594, 1},
   {0.953125, 0.542969, 0, 1},
   {0.992188, 0.859375, 0.492188, 1},
   {0.992188, 0.796875, 0.40625, 1},
   {0.992188, 0.773438, 0.164062, 1},
   {0.992188, 0.800781, 0.671875, 1},
   {0.992188, 0.714844, 0.523438, 1},
   {0.992188, 0.625, 0.375, 1},
   {0.992188, 0.527344, 0.210938, 1},
   {0.992188, 0.457031, 0.09375, 1},
   {0.917969, 0.375, 0.003906, 1},
   {0.785156, 0.320312, 0.003906, 1},
   {0.691406, 0.28125, 0.003906, 1},
   {0.574219, 0.234375, 0.003906, 1},
   {0.921875, 0.832031, 0.773438, 1},
   {0.863281, 0.699219, 0.589844, 1},
   {0.824219, 0.613281, 0.472656, 1},
   {0.773438, 0.5, 0.3125, 1},
   {0.660156, 0.394531, 0.214844, 1},
   {0.757812, 0.253906, 0, 1},
   {0.371094, 0.222656, 0.121094, 1},
   {0.519531, 0.308594, 0.167969, 1},
   {0.625, 0.207031, 0, 1},
   {0.429688, 0.144531, 0, 1},
   {0.984375, 0.429688, 0.484375, 1},
   {0.996094, 0.753906, 0.714844, 1},
   {0.996094, 0.878906, 0.90625, 1},
   {0.890625, 0.34375, 0.566406, 1},
   {0.996094, 0.933594, 0.949219, 1},
   {0.863281, 0.160156, 0.445312, 1},
   {0.996094, 0.816406, 0.859375, 1},
   {0.996094, 0.503906, 0.621094, 1},
   {0.996094, 0.660156, 0.613281, 1},
   {0.90625, 0.109375, 0, 1},
   {0.996094, 0.199219, 0.089844, 1},
   {0.835938, 0, 0, 1},
   {0.972656, 0.707031, 0.730469, 1},
   {0.96875, 0.742188, 0.679688, 1},
   {0.996094, 0.699219, 0.769531, 1},
   {0.996094, 0.433594, 0.417969, 1},
   {0.984375, 0.320312, 0.382812, 1},
   {0.910156, 0.472656, 0.648438, 1},
   {0.984375, 0.710938, 0.710938, 1},
   {0.996094, 0.652344, 0.734375, 1},
   {0.953125, 0.234375, 0.421875, 1},
   {0.980469, 0.136719, 0.21875, 1},
   {0.953125, 0.101562, 0.527344, 1},
   {0.996094, 0.386719, 0.53125, 1},
   {0.996094, 0.152344, 0.351562, 1},
   {0.671875, 0, 0, 1},
   {0.996094, 0.433594, 0.355469, 1},
   {0.886719, 0.464844, 0.675781, 1},
   {0.925781, 0.652344, 0.789062, 1},
   {0.910156, 0.574219, 0.742188, 1},
   {0.996094, 0.835938, 0.816406, 1},
   {0.996094, 0.746094, 0.804688, 1},
   {0.996094, 0.582031, 0.679688, 1},
   {0.996094, 0.433594, 0.566406, 1},
   {0.996094, 0.105469, 0.316406, 1},
   {0.90625, 0, 0.214844, 1},
   {0.804688, 0, 0.191406, 1},
   {0.6875, 0, 0.164062, 1},
   {0.753906, 0.003906, 0.039062, 1},
   {0.578125, 0, 0.136719, 1},
   {0.636719, 0.003906, 0.035156, 1},
   {0.457031, 0.003906, 0.027344, 1},
   {0.652344, 0.652344, 0.996094, 1},
   {0.914062, 0.683594, 0.996094, 1},
   {0.804688, 0.613281, 0.996094, 1},
   {0.640625, 0.285156, 0.996094, 1},
   {0.503906, 0.011719, 0.996094, 1},
   {0.273438, 0, 0.546875, 1},
   {0, 0.359375, 0, 1},
   {0.488281, 0.996094, 0.488281, 1},
   {0.785156, 0.996094, 0.785156, 1},
   {0.898438, 0.800781, 0.996094, 1},
   {0.621094, 0.996094, 0.621094, 1},
   {0.910156, 0.996094, 0.910156, 1},
   {0, 0, 0.996094, 1},
   {0.996094, 0.339844, 0.996094, 1},
   {0.996094, 0.550781, 0.996094, 1},
   {0.996094, 0.652344, 0.996094, 1},
   {0.992188, 0.402344, 0, 1},
   {0.996094, 0, 0, 1},
   {0.722656, 0.230469, 0.40625, 1},
   {0.527344, 0.167969, 0.296875, 1},
   {0.785156, 0.332031, 0.492188, 1},
   {0, 0.5, 0, 1},
   {0.703125, 0.808594, 0.890625, 1},
   {0.855469, 0.855469, 0.902344, 1},
   {0.925781, 0.925781, 0.949219, 1},
   {0.75, 0.75, 0.75, 1},
   {0.691406, 0.691406, 0.691406, 1},
   {0.789062, 0.789062, 0.859375, 1},
   {0.632812, 0.632812, 0.75, 1},
   {0.710938, 0.710938, 0.804688, 1},
   {0.585938, 0.585938, 0.585938, 1},
   {0.636719, 0.214844, 0.988281, 1},
   {0.921875, 0.835938, 0.992188, 1},
   {0.875, 0.734375, 0.992188, 1},
   {0.832031, 0.640625, 0.992188, 1},
   {0.78125, 0.523438, 0.992188, 1},
   {0.796875, 0.714844, 0.996094, 1},
   {0.699219, 0.582031, 0.996094, 1},
   {0.5625, 0.386719, 0.996094, 1},
   {0.621094, 0, 0.789062, 1},
   {0.480469, 0, 0.609375, 1},
   {0.414062, 0, 0.414062, 1},
   {0.515625, 0.378906, 0.242188, 1},
   {0.8125, 0.792969, 0.6875, 1},
   {0.6875, 0.652344, 0.46875, 1},
   {0.53125, 0.496094, 0.3125, 1},
   {0.671875, 0.496094, 0.3125, 1},
   {0.425781, 0.3125, 0.199219, 1},
   {0.390625, 0.007812, 0.042969, 1},
   {0.53125, 0.496094, 0.3125, 1},
   {0.996094, 0.996094, 0.996094, 1},
   {0.597656, 0.796875, 0.996094, 1},
   {0.996094, 0.832031, 0.613281, 1},
   {0.996094, 0.816406, 0.859375, 1},
   {0.519531, 0.308594, 0.167969, 1},
   {0.417969, 0.761719, 0.996094, 1},
   {0.625, 0.207031, 0, 1},
});

const Palette BPAL_36 = Palette("gray",
{
   {0, 0, 0, 1},
   {0.015873, 0.015873, 0.015873, 1},
   {0.031746, 0.031746, 0.031746, 1},
   {0.047619, 0.047619, 0.047619, 1},
   {0.0634921, 0.0634921, 0.0634921, 1},
   {0.0793651, 0.0793651, 0.0793651, 1},
   {0.0952381, 0.0952381, 0.0952381, 1},
   {0.111111, 0.111111, 0.111111, 1},
   {0.126984, 0.126984, 0.126984, 1},
   {0.142857, 0.142857, 0.142857, 1},
   {0.15873, 0.15873, 0.15873, 1},
   {0.174603, 0.174603, 0.174603, 1},
   {0.190476, 0.190476, 0.190476, 1},
   {0.206349, 0.206349, 0.206349, 1},
   {0.222222, 0.222222, 0.222222, 1},
   {0.238095, 0.238095, 0.238095, 1},
   {0.253968, 0.253968, 0.253968, 1},
   {0.269841, 0.269841, 0.269841, 1},
   {0.285714, 0.285714, 0.285714, 1},
   {0.301587, 0.301587, 0.301587, 1},
   {0.31746, 0.31746, 0.31746, 1},
   {0.333333, 0.333333, 0.333333, 1},
   {0.349206, 0.349206, 0.349206, 1},
   {0.365079, 0.365079, 0.365079, 1},
   {0.380952, 0.380952, 0.380952, 1},
   {0.396825, 0.396825, 0.396825, 1},
   {0.412698, 0.412698, 0.412698, 1},
   {0.428571, 0.428571, 0.428571, 1},
   {0.444444, 0.444444, 0.444444, 1},
   {0.460317, 0.460317, 0.460317, 1},
   {0.47619, 0.47619, 0.47619, 1},
   {0.492063, 0.492063, 0.492063, 1},
   {0.507937, 0.507937, 0.507937, 1},
   {0.52381, 0.52381, 0.52381, 1},
   {0.539683, 0.539683, 0.539683, 1},
   {0.555556, 0.555556, 0.555556, 1},
   {0.571429, 0.571429, 0.571429, 1},
   {0.587302, 0.587302, 0.587302, 1},
   {0.603175, 0.603175, 0.603175, 1},
   {0.619048, 0.619048, 0.619048, 1},
   {0.634921, 0.634921, 0.634921, 1},
   {0.650794, 0.650794, 0.650794, 1},
   {0.666667, 0.666667, 0.666667, 1},
   {0.68254, 0.68254, 0.68254, 1},
   {0.698413, 0.698413, 0.698413, 1},
   {0.714286, 0.714286, 0.714286, 1},
   {0.730159, 0.730159, 0.730159, 1},
   {0.746032, 0.746032, 0.746032, 1},
   {0.761905, 0.761905, 0.761905, 1},
   {0.777778, 0.777778, 0.777778, 1},
   {0.793651, 0.793651, 0.793651, 1},
   {0.809524, 0.809524, 0.809524, 1},
   {0.825397, 0.825397, 0.825397, 1},
   {0.84127, 0.84127, 0.84127, 1},
   {0.857143, 0.857143, 0.857143, 1},
   {0.873016, 0.873016, 0.873016, 1},
   {0.888889, 0.888889, 0.888889, 1},
   {0.904762, 0.904762, 0.904762, 1},
   {0.920635, 0.920635, 0.920635, 1},
   {0.936508, 0.936508, 0.936508, 1},
   {0.952381, 0.952381, 0.952381, 1},
   {0.968254, 0.968254, 0.968254, 1},
   {0.984127, 0.984127, 0.984127, 1},
   {1, 1, 1, 1},
});

const Palette BPAL_37 = Palette("turbo",
{
   {0.18995, 0.07176, 0.23217, 1},
   {0.19483, 0.08339, 0.26149, 1},
   {0.19956, 0.09498, 0.29024, 1},
   {0.20415, 0.10652, 0.31844, 1},
   {0.2086, 0.11802, 0.34607, 1},
   {0.21291, 0.12947, 0.37314, 1},
   {0.21708, 0.14087, 0.39964, 1},
   {0.22111, 0.15223, 0.42558, 1},
   {0.225, 0.16354, 0.45096, 1},
   {0.22875, 0.17481, 0.47578, 1},
   {0.23236, 0.18603, 0.50004, 1},
   {0.23582, 0.1972, 0.52373, 1},
   {0.23915, 0.20833, 0.54686, 1},
   {0.24234, 0.21941, 0.56942, 1},
   {0.24539, 0.23044, 0.59142, 1},
   {0.2483, 0.24143, 0.61286, 1},
   {0.25107, 0.25237, 0.63374, 1},
   {0.25369, 0.26327, 0.65406, 1},
   {0.25618, 0.27412, 0.67381, 1},
   {0.25853, 0.28492, 0.693, 1},
   {0.26074, 0.29568, 0.71162, 1},
   {0.2628, 0.30639, 0.72968, 1},
   {0.26473, 0.31706, 0.74718, 1},
   {0.26652, 0.32768, 0.76412, 1},
   {0.26816, 0.33825, 0.7805, 1},
   {0.26967, 0.34878, 0.79631, 1},
   {0.27103, 0.35926, 0.81156, 1},
   {0.27226, 0.3697, 0.82624, 1},
   {0.27334, 0.38008, 0.84037, 1},
   {0.27429, 0.39043, 0.85393, 1},
   {0.27509, 0.40072, 0.86692, 1},
   {0.27576, 0.41097, 0.87936, 1},
   {0.27628, 0.42118, 0.89123, 1},
   {0.27667, 0.43134, 0.90254, 1},
   {0.27691, 0.44145, 0.91328, 1},
   {0.27701, 0.45152, 0.92347, 1},
   {0.27698, 0.46153, 0.93309, 1},
   {0.2768, 0.47151, 0.94214, 1},
   {0.27648, 0.48144, 0.95064, 1},
   {0.27603, 0.49132, 0.95857, 1},
   {0.27543, 0.50115, 0.96594, 1},
   {0.27469, 0.51094, 0.97275, 1},
   {0.27381, 0.52069, 0.97899, 1},
   {0.27273, 0.5304, 0.98461, 1},
   {0.27106, 0.54015, 0.9893, 1},
   {0.26878, 0.54995, 0.99303, 1},
   {0.26592, 0.55979, 0.99583, 1},
   {0.26252, 0.56967, 0.99773, 1},
   {0.25862, 0.57958, 0.99876, 1},
   {0.25425, 0.5895, 0.99896, 1},
   {0.24946, 0.59943, 0.99835, 1},
   {0.24427, 0.60937, 0.99697, 1},
   {0.23874, 0.61931, 0.99485, 1},
   {0.23288, 0.62923, 0.99202, 1},
   {0.22676, 0.63913, 0.98851, 1},
   {0.22039, 0.64901, 0.98436, 1},
   {0.21382, 0.65886, 0.97959, 1},
   {0.20708, 0.66866, 0.97423, 1},
   {0.20021, 0.67842, 0.96833, 1},
   {0.19326, 0.68812, 0.9619, 1},
   {0.18625, 0.69775, 0.95498, 1},
   {0.17923, 0.70732, 0.94761, 1},
   {0.17223, 0.7168, 0.93981, 1},
   {0.16529, 0.7262, 0.93161, 1},
   {0.15844, 0.73551, 0.92305, 1},
   {0.15173, 0.74472, 0.91416, 1},
   {0.14519, 0.75381, 0.90496, 1},
   {0.13886, 0.76279, 0.8955, 1},
   {0.13278, 0.77165, 0.8858, 1},
   {0.12698, 0.78037, 0.8759, 1},
   {0.12151, 0.78896, 0.86581, 1},
   {0.11639, 0.7974, 0.85559, 1},
   {0.11167, 0.80569, 0.84525, 1},
   {0.10738, 0.81381, 0.83484, 1},
   {0.10357, 0.82177, 0.82437, 1},
   {0.10026, 0.82955, 0.81389, 1},
   {0.0975, 0.83714, 0.80342, 1},
   {0.09532, 0.84455, 0.79299, 1},
   {0.09377, 0.85175, 0.78264, 1},
   {0.09287, 0.85875, 0.7724, 1},
   {0.09267, 0.86554, 0.7623, 1},
   {0.0932, 0.87211, 0.75237, 1},
   {0.09451, 0.87844, 0.74265, 1},
   {0.09662, 0.88454, 0.73316, 1},
   {0.09958, 0.8904, 0.72393, 1},
   {0.10342, 0.896, 0.715, 1},
   {0.10815, 0.90142, 0.70599, 1},
   {0.11374, 0.90673, 0.69651, 1},
   {0.12014, 0.91193, 0.6866, 1},
   {0.12733, 0.91701, 0.67627, 1},
   {0.13526, 0.92197, 0.66556, 1},
   {0.14391, 0.9268, 0.65448, 1},
   {0.15323, 0.93151, 0.64308, 1},
   {0.16319, 0.93609, 0.63137, 1},
   {0.17377, 0.94053, 0.61938, 1},
   {0.18491, 0.94484, 0.60713, 1},
   {0.19659, 0.94901, 0.59466, 1},
   {0.20877, 0.95304, 0.58199, 1},
   {0.22142, 0.95692, 0.56914, 1},
   {0.23449, 0.96065, 0.55614, 1},
   {0.24797, 0.96423, 0.54303, 1},
   {0.2618, 0.96765, 0.52981, 1},
   {0.27597, 0.97092, 0.51653, 1},
   {0.29042, 0.97403, 0.50321, 1},
   {0.30513, 0.97697, 0.48987, 1},
   {0.32006, 0.97974, 0.47654, 1},
   {0.33517, 0.98234, 0.46325, 1},
   {0.35043, 0.98477, 0.45002, 1},
   {0.36581, 0.98702, 0.43688, 1},
   {0.38127, 0.98909, 0.42386, 1},
   {0.39678, 0.99098, 0.41098, 1},
   {0.41229, 0.99268, 0.39826, 1},
   {0.42778, 0.99419, 0.38575, 1},
   {0.44321, 0.99551, 0.37345, 1},
   {0.45854, 0.99663, 0.3614, 1},
   {0.47375, 0.99755, 0.34963, 1},
   {0.48879, 0.99828, 0.33816, 1},
   {0.50362, 0.99879, 0.32701, 1},
   {0.51822, 0.9991, 0.31622, 1},
   {0.53255, 0.99919, 0.30581, 1},
   {0.54658, 0.99907, 0.29581, 1},
   {0.56026, 0.99873, 0.28623, 1},
   {0.57357, 0.99817, 0.27712, 1},
   {0.58646, 0.99739, 0.26849, 1},
   {0.59891, 0.99638, 0.26038, 1},
   {0.61088, 0.99514, 0.2528, 1},
   {0.62233, 0.99366, 0.24579, 1},
   {0.63323, 0.99195, 0.23937, 1},
   {0.64362, 0.98999, 0.23356, 1},
   {0.65394, 0.98775, 0.22835, 1},
   {0.66428, 0.98524, 0.2237, 1},
   {0.67462, 0.98246, 0.2196, 1},
   {0.68494, 0.97941, 0.21602, 1},
   {0.69525, 0.9761, 0.21294, 1},
   {0.70553, 0.97255, 0.21032, 1},
   {0.71577, 0.96875, 0.20815, 1},
   {0.72596, 0.9647, 0.2064, 1},
   {0.7361, 0.96043, 0.20504, 1},
   {0.74617, 0.95593, 0.20406, 1},
   {0.75617, 0.95121, 0.20343, 1},
   {0.76608, 0.94627, 0.20311, 1},
   {0.77591, 0.94113, 0.2031, 1},
   {0.78563, 0.93579, 0.20336, 1},
   {0.79524, 0.93025, 0.20386, 1},
   {0.80473, 0.92452, 0.20459, 1},
   {0.8141, 0.91861, 0.20552, 1},
   {0.82333, 0.91253, 0.20663, 1},
   {0.83241, 0.90627, 0.20788, 1},
   {0.84133, 0.89986, 0.20926, 1},
   {0.8501, 0.89328, 0.21074, 1},
   {0.85868, 0.88655, 0.2123, 1},
   {0.86709, 0.87968, 0.21391, 1},
   {0.8753, 0.87267, 0.21555, 1},
   {0.88331, 0.86553, 0.21719, 1},
   {0.89112, 0.85826, 0.2188, 1},
   {0.8987, 0.85087, 0.22038, 1},
   {0.90605, 0.84337, 0.22188, 1},
   {0.91317, 0.83576, 0.22328, 1},
   {0.92004, 0.82806, 0.22456, 1},
   {0.92666, 0.82025, 0.2257, 1},
   {0.93301, 0.81236, 0.22667, 1},
   {0.93909, 0.80439, 0.22744, 1},
   {0.94489, 0.79634, 0.228, 1},
   {0.95039, 0.78823, 0.22831, 1},
   {0.9556, 0.78005, 0.22836, 1},
   {0.96049, 0.77181, 0.22811, 1},
   {0.96507, 0.76352, 0.22754, 1},
   {0.96931, 0.75519, 0.22663, 1},
   {0.97323, 0.74682, 0.22536, 1},
   {0.97679, 0.73842, 0.22369, 1},
   {0.98, 0.73, 0.22161, 1},
   {0.98289, 0.7214, 0.21918, 1},
   {0.98549, 0.7125, 0.2165, 1},
   {0.98781, 0.7033, 0.21358, 1},
   {0.98986, 0.69382, 0.21043, 1},
   {0.99163, 0.68408, 0.20706, 1},
   {0.99314, 0.67408, 0.20348, 1},
   {0.99438, 0.66386, 0.19971, 1},
   {0.99535, 0.65341, 0.19577, 1},
   {0.99607, 0.64277, 0.19165, 1},
   {0.99654, 0.63193, 0.18738, 1},
   {0.99675, 0.62093, 0.18297, 1},
   {0.99672, 0.60977, 0.17842, 1},
   {0.99644, 0.59846, 0.17376, 1},
   {0.99593, 0.58703, 0.16899, 1},
   {0.99517, 0.57549, 0.16412, 1},
   {0.99419, 0.56386, 0.15918, 1},
   {0.99297, 0.55214, 0.15417, 1},
   {0.99153, 0.54036, 0.1491, 1},
   {0.98987, 0.52854, 0.14398, 1},
   {0.98799, 0.51667, 0.13883, 1},
   {0.9859, 0.50479, 0.13367, 1},
   {0.9836, 0.49291, 0.12849, 1},
   {0.98108, 0.48104, 0.12332, 1},
   {0.97837, 0.4692, 0.11817, 1},
   {0.97545, 0.4574, 0.11305, 1},
   {0.97234, 0.44565, 0.10797, 1},
   {0.96904, 0.43399, 0.10294, 1},
   {0.96555, 0.42241, 0.09798, 1},
   {0.96187, 0.41093, 0.0931, 1},
   {0.95801, 0.39958, 0.08831, 1},
   {0.95398, 0.38836, 0.08362, 1},
   {0.94977, 0.37729, 0.07905, 1},
   {0.94538, 0.36638, 0.07461, 1},
   {0.94084, 0.35566, 0.07031, 1},
   {0.93612, 0.34513, 0.06616, 1},
   {0.93125, 0.33482, 0.06218, 1},
   {0.92623, 0.32473, 0.05837, 1},
   {0.92105, 0.31489, 0.05475, 1},
   {0.91572, 0.3053, 0.05134, 1},
   {0.91024, 0.29599, 0.04814, 1},
   {0.90463, 0.28696, 0.04516, 1},
   {0.89888, 0.27824, 0.04243, 1},
   {0.89298, 0.26981, 0.03993, 1},
   {0.88691, 0.26152, 0.03753, 1},
   {0.88066, 0.25334, 0.03521, 1},
   {0.87422, 0.24526, 0.03297, 1},
   {0.8676, 0.2373, 0.03082, 1},
   {0.86079, 0.22945, 0.02875, 1},
   {0.8538, 0.2217, 0.02677, 1},
   {0.84662, 0.21407, 0.02487, 1},
   {0.83926, 0.20654, 0.02305, 1},
   {0.83172, 0.19912, 0.02131, 1},
   {0.82399, 0.19182, 0.01966, 1},
   {0.81608, 0.18462, 0.01809, 1},
   {0.80799, 0.17753, 0.0166, 1},
   {0.79971, 0.17055, 0.0152, 1},
   {0.79125, 0.16368, 0.01387, 1},
   {0.7826, 0.15693, 0.01264, 1},
   {0.77377, 0.15028, 0.01148, 1},
   {0.76476, 0.14374, 0.01041, 1},
   {0.75556, 0.13731, 0.00942, 1},
   {0.74617, 0.13098, 0.00851, 1},
   {0.73661, 0.12477, 0.00769, 1},
   {0.72686, 0.11867, 0.00695, 1},
   {0.71692, 0.11268, 0.00629, 1},
   {0.7068, 0.1068, 0.00571, 1},
   {0.6965, 0.10102, 0.00522, 1},
   {0.68602, 0.09536, 0.00481, 1},
   {0.67535, 0.0898, 0.00449, 1},
   {0.66449, 0.08436, 0.00424, 1},
   {0.65345, 0.07902, 0.00408, 1},
   {0.64223, 0.0738, 0.00401, 1},
   {0.63082, 0.06868, 0.00401, 1},
   {0.61923, 0.06367, 0.0041, 1},
   {0.60746, 0.05878, 0.00427, 1},
   {0.5955, 0.05399, 0.00453, 1},
   {0.58336, 0.04931, 0.00486, 1},
   {0.57103, 0.04474, 0.00529, 1},
   {0.55852, 0.04028, 0.00579, 1},
   {0.54583, 0.03593, 0.00638, 1},
   {0.53295, 0.03169, 0.00705, 1},
   {0.51989, 0.02756, 0.0078, 1},
   {0.50664, 0.02354, 0.00863, 1},
   {0.49321, 0.01963, 0.00955, 1},
   {0.4796, 0.01583, 0.01055, 1},
});

const Palette BPAL_38 = Palette("viridis",
{
   {0.267004, 0.004874, 0.329415, 1},
   {0.26851, 0.009605, 0.335427, 1},
   {0.269944, 0.014625, 0.341379, 1},
   {0.271305, 0.019942, 0.347269, 1},
   {0.272594, 0.025563, 0.353093, 1},
   {0.273809, 0.031497, 0.358853, 1},
   {0.274952, 0.037752, 0.364543, 1},
   {0.276022, 0.044167, 0.370164, 1},
   {0.277018, 0.050344, 0.375715, 1},
   {0.277941, 0.056324, 0.381191, 1},
   {0.278791, 0.062145, 0.386592, 1},
   {0.279566, 0.067836, 0.391917, 1},
   {0.280267, 0.073417, 0.397163, 1},
   {0.280894, 0.078907, 0.402329, 1},
   {0.281446, 0.08432, 0.407414, 1},
   {0.281924, 0.089666, 0.412415, 1},
   {0.282327, 0.094955, 0.417331, 1},
   {0.282656, 0.100196, 0.42216, 1},
   {0.28291, 0.105393, 0.426902, 1},
   {0.283091, 0.110553, 0.431554, 1},
   {0.283197, 0.11568, 0.436115, 1},
   {0.283229, 0.120777, 0.440584, 1},
   {0.283187, 0.125848, 0.44496, 1},
   {0.283072, 0.130895, 0.449241, 1},
   {0.282884, 0.13592, 0.453427, 1},
   {0.282623, 0.140926, 0.457517, 1},
   {0.28229, 0.145912, 0.46151, 1},
   {0.281887, 0.150881, 0.465405, 1},
   {0.281412, 0.155834, 0.469201, 1},
   {0.280868, 0.160771, 0.472899, 1},
   {0.280255, 0.165693, 0.476498, 1},
   {0.279574, 0.170599, 0.479997, 1},
   {0.278826, 0.17549, 0.483397, 1},
   {0.278012, 0.180367, 0.486697, 1},
   {0.277134, 0.185228, 0.489898, 1},
   {0.276194, 0.190074, 0.493001, 1},
   {0.275191, 0.194905, 0.496005, 1},
   {0.274128, 0.199721, 0.498911, 1},
   {0.273006, 0.20452, 0.501721, 1},
   {0.271828, 0.209303, 0.504434, 1},
   {0.270595, 0.214069, 0.507052, 1},
   {0.269308, 0.218818, 0.509577, 1},
   {0.267968, 0.223549, 0.512008, 1},
   {0.26658, 0.228262, 0.514349, 1},
   {0.265145, 0.232956, 0.516599, 1},
   {0.263663, 0.237631, 0.518762, 1},
   {0.262138, 0.242286, 0.520837, 1},
   {0.260571, 0.246922, 0.522828, 1},
   {0.258965, 0.251537, 0.524736, 1},
   {0.257322, 0.25613, 0.526563, 1},
   {0.255645, 0.260703, 0.528312, 1},
   {0.253935, 0.265254, 0.529983, 1},
   {0.252194, 0.269783, 0.531579, 1},
   {0.250425, 0.27429, 0.533103, 1},
   {0.248629, 0.278775, 0.534556, 1},
   {0.246811, 0.283237, 0.535941, 1},
   {0.244972, 0.287675, 0.53726, 1},
   {0.243113, 0.292092, 0.538516, 1},
   {0.241237, 0.296485, 0.539709, 1},
   {0.239346, 0.300855, 0.540844, 1},
   {0.237441, 0.305202, 0.541921, 1},
   {0.235526, 0.309527, 0.542944, 1},
   {0.233603, 0.313828, 0.543914, 1},
   {0.231674, 0.318106, 0.544834, 1},
   {0.229739, 0.322361, 0.545706, 1},
   {0.227802, 0.326594, 0.546532, 1},
   {0.225863, 0.330805, 0.547314, 1},
   {0.223925, 0.334994, 0.548053, 1},
   {0.221989, 0.339161, 0.548752, 1},
   {0.220057, 0.343307, 0.549413, 1},
   {0.21813, 0.347432, 0.550038, 1},
   {0.21621, 0.351535, 0.550627, 1},
   {0.214298, 0.355619, 0.551184, 1},
   {0.212395, 0.359683, 0.55171, 1},
   {0.210503, 0.363727, 0.552206, 1},
   {0.208623, 0.367752, 0.552675, 1},
   {0.206756, 0.371758, 0.553117, 1},
   {0.204903, 0.375746, 0.553533, 1},
   {0.203063, 0.379716, 0.553925, 1},
   {0.201239, 0.38367, 0.554294, 1},
   {0.19943, 0.387607, 0.554642, 1},
   {0.197636, 0.391528, 0.554969, 1},
   {0.19586, 0.395433, 0.555276, 1},
   {0.1941, 0.399323, 0.555565, 1},
   {0.192357, 0.403199, 0.555836, 1},
   {0.190631, 0.407061, 0.556089, 1},
   {0.188923, 0.41091, 0.556326, 1},
   {0.187231, 0.414746, 0.556547, 1},
   {0.185556, 0.41857, 0.556753, 1},
   {0.183898, 0.422383, 0.556944, 1},
   {0.182256, 0.426184, 0.55712, 1},
   {0.180629, 0.429975, 0.557282, 1},
   {0.179019, 0.433756, 0.55743, 1},
   {0.177423, 0.437527, 0.557565, 1},
   {0.175841, 0.44129, 0.557685, 1},
   {0.174274, 0.445044, 0.557792, 1},
   {0.172719, 0.448791, 0.557885, 1},
   {0.171176, 0.45253, 0.557965, 1},
   {0.169646, 0.456262, 0.55803, 1},
   {0.168126, 0.459988, 0.558082, 1},
   {0.166617, 0.463708, 0.558119, 1},
   {0.165117, 0.467423, 0.558141, 1},
   {0.163625, 0.471133, 0.558148, 1},
   {0.162142, 0.474838, 0.55814, 1},
   {0.160665, 0.47854, 0.558115, 1},
   {0.159194, 0.482237, 0.558073, 1},
   {0.157729, 0.485932, 0.558013, 1},
   {0.15627, 0.489624, 0.557936, 1},
   {0.154815, 0.493313, 0.55784, 1},
   {0.153364, 0.497, 0.557724, 1},
   {0.151918, 0.500685, 0.557587, 1},
   {0.150476, 0.504369, 0.55743, 1},
   {0.149039, 0.508051, 0.55725, 1},
   {0.147607, 0.511733, 0.557049, 1},
   {0.14618, 0.515413, 0.556823, 1},
   {0.144759, 0.519093, 0.556572, 1},
   {0.143343, 0.522773, 0.556295, 1},
   {0.141935, 0.526453, 0.555991, 1},
   {0.140536, 0.530132, 0.555659, 1},
   {0.139147, 0.533812, 0.555298, 1},
   {0.13777, 0.537492, 0.554906, 1},
   {0.136408, 0.541173, 0.554483, 1},
   {0.135066, 0.544853, 0.554029, 1},
   {0.133743, 0.548535, 0.553541, 1},
   {0.132444, 0.552216, 0.553018, 1},
   {0.131172, 0.555899, 0.552459, 1},
   {0.129933, 0.559582, 0.551864, 1},
   {0.128729, 0.563265, 0.551229, 1},
   {0.127568, 0.566949, 0.550556, 1},
   {0.126453, 0.570633, 0.549841, 1},
   {0.125394, 0.574318, 0.549086, 1},
   {0.124395, 0.578002, 0.548287, 1},
   {0.123463, 0.581687, 0.547445, 1},
   {0.122606, 0.585371, 0.546557, 1},
   {0.121831, 0.589055, 0.545623, 1},
   {0.121148, 0.592739, 0.544641, 1},
   {0.120565, 0.596422, 0.543611, 1},
   {0.120092, 0.600104, 0.54253, 1},
   {0.119738, 0.603785, 0.5414, 1},
   {0.119512, 0.607464, 0.540218, 1},
   {0.119423, 0.611141, 0.538982, 1},
   {0.119483, 0.614817, 0.537692, 1},
   {0.119699, 0.61849, 0.536347, 1},
   {0.120081, 0.622161, 0.534946, 1},
   {0.120638, 0.625828, 0.533488, 1},
   {0.12138, 0.629492, 0.531973, 1},
   {0.122312, 0.633153, 0.530398, 1},
   {0.123444, 0.636809, 0.528763, 1},
   {0.12478, 0.640461, 0.527068, 1},
   {0.126326, 0.644107, 0.525311, 1},
   {0.128087, 0.647749, 0.523491, 1},
   {0.130067, 0.651384, 0.521608, 1},
   {0.132268, 0.655014, 0.519661, 1},
   {0.134692, 0.658636, 0.517649, 1},
   {0.137339, 0.662252, 0.515571, 1},
   {0.14021, 0.665859, 0.513427, 1},
   {0.143303, 0.669459, 0.511215, 1},
   {0.146616, 0.67305, 0.508936, 1},
   {0.150148, 0.676631, 0.506589, 1},
   {0.153894, 0.680203, 0.504172, 1},
   {0.157851, 0.683765, 0.501686, 1},
   {0.162016, 0.687316, 0.499129, 1},
   {0.166383, 0.690856, 0.496502, 1},
   {0.170948, 0.694384, 0.493803, 1},
   {0.175707, 0.6979, 0.491033, 1},
   {0.180653, 0.701402, 0.488189, 1},
   {0.185783, 0.704891, 0.485273, 1},
   {0.19109, 0.708366, 0.482284, 1},
   {0.196571, 0.711827, 0.479221, 1},
   {0.202219, 0.715272, 0.476084, 1},
   {0.20803, 0.718701, 0.472873, 1},
   {0.214, 0.722114, 0.469588, 1},
   {0.220124, 0.725509, 0.466226, 1},
   {0.226397, 0.728888, 0.462789, 1},
   {0.232815, 0.732247, 0.459277, 1},
   {0.239374, 0.735588, 0.455688, 1},
   {0.24607, 0.73891, 0.452024, 1},
   {0.252899, 0.742211, 0.448284, 1},
   {0.259857, 0.745492, 0.444467, 1},
   {0.266941, 0.748751, 0.440573, 1},
   {0.274149, 0.751988, 0.436601, 1},
   {0.281477, 0.755203, 0.432552, 1},
   {0.288921, 0.758394, 0.428426, 1},
   {0.296479, 0.761561, 0.424223, 1},
   {0.304148, 0.764704, 0.419943, 1},
   {0.311925, 0.767822, 0.415586, 1},
   {0.319809, 0.770914, 0.411152, 1},
   {0.327796, 0.77398, 0.40664, 1},
   {0.335885, 0.777018, 0.402049, 1},
   {0.344074, 0.780029, 0.397381, 1},
   {0.35236, 0.783011, 0.392636, 1},
   {0.360741, 0.785964, 0.387814, 1},
   {0.369214, 0.788888, 0.382914, 1},
   {0.377779, 0.791781, 0.377939, 1},
   {0.386433, 0.794644, 0.372886, 1},
   {0.395174, 0.797475, 0.367757, 1},
   {0.404001, 0.800275, 0.362552, 1},
   {0.412913, 0.803041, 0.357269, 1},
   {0.421908, 0.805774, 0.35191, 1},
   {0.430983, 0.808473, 0.346476, 1},
   {0.440137, 0.811138, 0.340967, 1},
   {0.449368, 0.813768, 0.335384, 1},
   {0.458674, 0.816363, 0.329727, 1},
   {0.468053, 0.818921, 0.323998, 1},
   {0.477504, 0.821444, 0.318195, 1},
   {0.487026, 0.823929, 0.312321, 1},
   {0.496615, 0.826376, 0.306377, 1},
   {0.506271, 0.828786, 0.300362, 1},
   {0.515992, 0.831158, 0.294279, 1},
   {0.525776, 0.833491, 0.288127, 1},
   {0.535621, 0.835785, 0.281908, 1},
   {0.545524, 0.838039, 0.275626, 1},
   {0.555484, 0.840254, 0.269281, 1},
   {0.565498, 0.84243, 0.262877, 1},
   {0.575563, 0.844566, 0.256415, 1},
   {0.585678, 0.846661, 0.249897, 1},
   {0.595839, 0.848717, 0.243329, 1},
   {0.606045, 0.850733, 0.236712, 1},
   {0.616293, 0.852709, 0.230052, 1},
   {0.626579, 0.854645, 0.223353, 1},
   {0.636902, 0.856542, 0.21662, 1},
   {0.647257, 0.8584, 0.209861, 1},
   {0.657642, 0.860219, 0.203082, 1},
   {0.668054, 0.861999, 0.196293, 1},
   {0.678489, 0.863742, 0.189503, 1},
   {0.688944, 0.865448, 0.182725, 1},
   {0.699415, 0.867117, 0.175971, 1},
   {0.709898, 0.868751, 0.169257, 1},
   {0.720391, 0.87035, 0.162603, 1},
   {0.730889, 0.871916, 0.156029, 1},
   {0.741388, 0.873449, 0.149561, 1},
   {0.751884, 0.874951, 0.143228, 1},
   {0.762373, 0.876424, 0.137064, 1},
   {0.772852, 0.877868, 0.131109, 1},
   {0.783315, 0.879285, 0.125405, 1},
   {0.79376, 0.880678, 0.120005, 1},
   {0.804182, 0.882046, 0.114965, 1},
   {0.814576, 0.883393, 0.110347, 1},
   {0.82494, 0.88472, 0.106217, 1},
   {0.83527, 0.886029, 0.102646, 1},
   {0.845561, 0.887322, 0.099702, 1},
   {0.85581, 0.888601, 0.097452, 1},
   {0.866013, 0.889868, 0.095953, 1},
   {0.876168, 0.891125, 0.09525, 1},
   {0.886271, 0.892374, 0.095374, 1},
   {0.89632, 0.893616, 0.096335, 1},
   {0.906311, 0.894855, 0.098125, 1},
   {0.916242, 0.896091, 0.100717, 1},
   {0.926106, 0.89733, 0.104071, 1},
   {0.935904, 0.89857, 0.108131, 1},
   {0.945636, 0.899815, 0.112838, 1},
   {0.9553, 0.901065, 0.118128, 1},
   {0.964894, 0.902323, 0.123941, 1},
   {0.974417, 0.90359, 0.130215, 1},
   {0.983868, 0.904867, 0.136897, 1},
   {0.993248, 0.906157, 0.143936, 1},
});

const Palette BPAL_39 = Palette("plasma",
{
   {0.050383, 0.029803, 0.527975, 1},
   {0.063536, 0.028426, 0.533124, 1},
   {0.075353, 0.027206, 0.538007, 1},
   {0.086222, 0.026125, 0.542658, 1},
   {0.096379, 0.025165, 0.547103, 1},
   {0.10598, 0.024309, 0.551368, 1},
   {0.115124, 0.023556, 0.555468, 1},
   {0.123903, 0.022878, 0.559423, 1},
   {0.132381, 0.022258, 0.56325, 1},
   {0.140603, 0.021687, 0.566959, 1},
   {0.148607, 0.021154, 0.570562, 1},
   {0.156421, 0.020651, 0.574065, 1},
   {0.16407, 0.020171, 0.577478, 1},
   {0.171574, 0.019706, 0.580806, 1},
   {0.17895, 0.019252, 0.584054, 1},
   {0.186213, 0.018803, 0.587228, 1},
   {0.193374, 0.018354, 0.59033, 1},
   {0.200445, 0.017902, 0.593364, 1},
   {0.207435, 0.017442, 0.596333, 1},
   {0.21435, 0.016973, 0.599239, 1},
   {0.221197, 0.016497, 0.602083, 1},
   {0.227983, 0.016007, 0.604867, 1},
   {0.234715, 0.015502, 0.607592, 1},
   {0.241396, 0.014979, 0.610259, 1},
   {0.248032, 0.014439, 0.612868, 1},
   {0.254627, 0.013882, 0.615419, 1},
   {0.261183, 0.013308, 0.617911, 1},
   {0.267703, 0.012716, 0.620346, 1},
   {0.274191, 0.012109, 0.622722, 1},
   {0.280648, 0.011488, 0.625038, 1},
   {0.287076, 0.010855, 0.627295, 1},
   {0.293478, 0.010213, 0.62949, 1},
   {0.299855, 0.009561, 0.631624, 1},
   {0.30621, 0.008902, 0.633694, 1},
   {0.312543, 0.008239, 0.6357, 1},
   {0.318856, 0.007576, 0.63764, 1},
   {0.32515, 0.006915, 0.639512, 1},
   {0.331426, 0.006261, 0.641316, 1},
   {0.337683, 0.005618, 0.643049, 1},
   {0.343925, 0.004991, 0.64471, 1},
   {0.35015, 0.004382, 0.646298, 1},
   {0.356359, 0.003798, 0.64781, 1},
   {0.362553, 0.003243, 0.649245, 1},
   {0.368733, 0.002724, 0.650601, 1},
   {0.374897, 0.002245, 0.651876, 1},
   {0.381047, 0.001814, 0.653068, 1},
   {0.387183, 0.001434, 0.654177, 1},
   {0.393304, 0.001114, 0.655199, 1},
   {0.399411, 0.000859, 0.656133, 1},
   {0.405503, 0.000678, 0.656977, 1},
   {0.41158, 0.000577, 0.65773, 1},
   {0.417642, 0.000564, 0.65839, 1},
   {0.423689, 0.000646, 0.658956, 1},
   {0.429719, 0.000831, 0.659425, 1},
   {0.435734, 0.001127, 0.659797, 1},
   {0.441732, 0.00154, 0.660069, 1},
   {0.447714, 0.00208, 0.66024, 1},
   {0.453677, 0.002755, 0.66031, 1},
   {0.459623, 0.003574, 0.660277, 1},
   {0.46555, 0.004545, 0.660139, 1},
   {0.471457, 0.005678, 0.659897, 1},
   {0.477344, 0.00698, 0.659549, 1},
   {0.48321, 0.00846, 0.659095, 1},
   {0.489055, 0.010127, 0.658534, 1},
   {0.494877, 0.01199, 0.657865, 1},
   {0.500678, 0.014055, 0.657088, 1},
   {0.506454, 0.016333, 0.656202, 1},
   {0.512206, 0.018833, 0.655209, 1},
   {0.517933, 0.021563, 0.654109, 1},
   {0.523633, 0.024532, 0.652901, 1},
   {0.529306, 0.027747, 0.651586, 1},
   {0.534952, 0.031217, 0.650165, 1},
   {0.54057, 0.03495, 0.64864, 1},
   {0.546157, 0.038954, 0.64701, 1},
   {0.551715, 0.043136, 0.645277, 1},
   {0.557243, 0.047331, 0.643443, 1},
   {0.562738, 0.051545, 0.641509, 1},
   {0.568201, 0.055778, 0.639477, 1},
   {0.573632, 0.060028, 0.637349, 1},
   {0.579029, 0.064296, 0.635126, 1},
   {0.584391, 0.068579, 0.632812, 1},
   {0.589719, 0.072878, 0.630408, 1},
   {0.595011, 0.07719, 0.627917, 1},
   {0.600266, 0.081516, 0.625342, 1},
   {0.605485, 0.085854, 0.622686, 1},
   {0.610667, 0.090204, 0.619951, 1},
   {0.615812, 0.094564, 0.61714, 1},
   {0.620919, 0.098934, 0.614257, 1},
   {0.625987, 0.103312, 0.611305, 1},
   {0.631017, 0.107699, 0.608287, 1},
   {0.636008, 0.112092, 0.605205, 1},
   {0.640959, 0.116492, 0.602065, 1},
   {0.645872, 0.120898, 0.598867, 1},
   {0.650746, 0.125309, 0.595617, 1},
   {0.65558, 0.129725, 0.592317, 1},
   {0.660374, 0.134144, 0.588971, 1},
   {0.665129, 0.138566, 0.585582, 1},
   {0.669845, 0.142992, 0.582154, 1},
   {0.674522, 0.147419, 0.578688, 1},
   {0.67916, 0.151848, 0.575189, 1},
   {0.683758, 0.156278, 0.57166, 1},
   {0.688318, 0.160709, 0.568103, 1},
   {0.69284, 0.165141, 0.564522, 1},
   {0.697324, 0.169573, 0.560919, 1},
   {0.701769, 0.174005, 0.557296, 1},
   {0.706178, 0.178437, 0.553657, 1},
   {0.710549, 0.182868, 0.550004, 1},
   {0.714883, 0.187299, 0.546338, 1},
   {0.719181, 0.191729, 0.542663, 1},
   {0.723444, 0.196158, 0.538981, 1},
   {0.72767, 0.200586, 0.535293, 1},
   {0.731862, 0.205013, 0.531601, 1},
   {0.736019, 0.209439, 0.527908, 1},
   {0.740143, 0.213864, 0.524216, 1},
   {0.744232, 0.218288, 0.520524, 1},
   {0.748289, 0.222711, 0.516834, 1},
   {0.752312, 0.227133, 0.513149, 1},
   {0.756304, 0.231555, 0.509468, 1},
   {0.760264, 0.235976, 0.505794, 1},
   {0.764193, 0.240396, 0.502126, 1},
   {0.76809, 0.244817, 0.498465, 1},
   {0.771958, 0.249237, 0.494813, 1},
   {0.775796, 0.253658, 0.491171, 1},
   {0.779604, 0.258078, 0.487539, 1},
   {0.783383, 0.2625, 0.483918, 1},
   {0.787133, 0.266922, 0.480307, 1},
   {0.790855, 0.271345, 0.476706, 1},
   {0.794549, 0.27577, 0.473117, 1},
   {0.798216, 0.280197, 0.469538, 1},
   {0.801855, 0.284626, 0.465971, 1},
   {0.805467, 0.289057, 0.462415, 1},
   {0.809052, 0.293491, 0.45887, 1},
   {0.812612, 0.297928, 0.455338, 1},
   {0.816144, 0.302368, 0.451816, 1},
   {0.819651, 0.306812, 0.448306, 1},
   {0.823132, 0.311261, 0.444806, 1},
   {0.826588, 0.315714, 0.441316, 1},
   {0.830018, 0.320172, 0.437836, 1},
   {0.833422, 0.324635, 0.434366, 1},
   {0.836801, 0.329105, 0.430905, 1},
   {0.840155, 0.33358, 0.427455, 1},
   {0.843484, 0.338062, 0.424013, 1},
   {0.846788, 0.342551, 0.420579, 1},
   {0.850066, 0.347048, 0.417153, 1},
   {0.853319, 0.351553, 0.413734, 1},
   {0.856547, 0.356066, 0.410322, 1},
   {0.85975, 0.360588, 0.406917, 1},
   {0.862927, 0.365119, 0.403519, 1},
   {0.866078, 0.36966, 0.400126, 1},
   {0.869203, 0.374212, 0.396738, 1},
   {0.872303, 0.378774, 0.393355, 1},
   {0.875376, 0.383347, 0.389976, 1},
   {0.878423, 0.387932, 0.3866, 1},
   {0.881443, 0.392529, 0.383229, 1},
   {0.884436, 0.397139, 0.37986, 1},
   {0.887402, 0.401762, 0.376494, 1},
   {0.89034, 0.406398, 0.37313, 1},
   {0.89325, 0.411048, 0.369768, 1},
   {0.896131, 0.415712, 0.366407, 1},
   {0.898984, 0.420392, 0.363047, 1},
   {0.901807, 0.425087, 0.359688, 1},
   {0.904601, 0.429797, 0.356329, 1},
   {0.907365, 0.434524, 0.35297, 1},
   {0.910098, 0.439268, 0.34961, 1},
   {0.9128, 0.444029, 0.346251, 1},
   {0.915471, 0.448807, 0.34289, 1},
   {0.918109, 0.453603, 0.339529, 1},
   {0.920714, 0.458417, 0.336166, 1},
   {0.923287, 0.463251, 0.332801, 1},
   {0.925825, 0.468103, 0.329435, 1},
   {0.928329, 0.472975, 0.326067, 1},
   {0.930798, 0.477867, 0.322697, 1},
   {0.933232, 0.48278, 0.319325, 1},
   {0.93563, 0.487712, 0.315952, 1},
   {0.93799, 0.492667, 0.312575, 1},
   {0.940313, 0.497642, 0.309197, 1},
   {0.942598, 0.502639, 0.305816, 1},
   {0.944844, 0.507658, 0.302433, 1},
   {0.947051, 0.512699, 0.299049, 1},
   {0.949217, 0.517763, 0.295662, 1},
   {0.951344, 0.52285, 0.292275, 1},
   {0.953428, 0.52796, 0.288883, 1},
   {0.95547, 0.533093, 0.28549, 1},
   {0.957469, 0.53825, 0.282096, 1},
   {0.959424, 0.543431, 0.278701, 1},
   {0.961336, 0.548636, 0.275305, 1},
   {0.963203, 0.553865, 0.271909, 1},
   {0.965024, 0.559118, 0.268513, 1},
   {0.966798, 0.564396, 0.265118, 1},
   {0.968526, 0.5697, 0.261721, 1},
   {0.970205, 0.575028, 0.258325, 1},
   {0.971835, 0.580382, 0.254931, 1},
   {0.973416, 0.585761, 0.25154, 1},
   {0.974947, 0.591165, 0.248151, 1},
   {0.976428, 0.596595, 0.244767, 1},
   {0.977856, 0.602051, 0.241387, 1},
   {0.979233, 0.607532, 0.238013, 1},
   {0.980556, 0.613039, 0.234646, 1},
   {0.981826, 0.618572, 0.231287, 1},
   {0.983041, 0.624131, 0.227937, 1},
   {0.984199, 0.629718, 0.224595, 1},
   {0.985301, 0.63533, 0.221265, 1},
   {0.986345, 0.640969, 0.217948, 1},
   {0.987332, 0.646633, 0.214648, 1},
   {0.98826, 0.652325, 0.211364, 1},
   {0.989128, 0.658043, 0.2081, 1},
   {0.989935, 0.663787, 0.204859, 1},
   {0.990681, 0.669558, 0.201642, 1},
   {0.991365, 0.675355, 0.198453, 1},
   {0.991985, 0.681179, 0.195295, 1},
   {0.992541, 0.68703, 0.19217, 1},
   {0.993032, 0.692907, 0.189084, 1},
   {0.993456, 0.69881, 0.186041, 1},
   {0.993814, 0.704741, 0.183043, 1},
   {0.994103, 0.710698, 0.180097, 1},
   {0.994324, 0.716681, 0.177208, 1},
   {0.994474, 0.722691, 0.174381, 1},
   {0.994553, 0.728728, 0.171622, 1},
   {0.994561, 0.734791, 0.168938, 1},
   {0.994495, 0.74088, 0.166335, 1},
   {0.994355, 0.746995, 0.163821, 1},
   {0.994141, 0.753137, 0.161404, 1},
   {0.993851, 0.759304, 0.159092, 1},
   {0.993482, 0.765499, 0.156891, 1},
   {0.993033, 0.77172, 0.154808, 1},
   {0.992505, 0.777967, 0.152855, 1},
   {0.991897, 0.784239, 0.151042, 1},
   {0.991209, 0.790537, 0.149377, 1},
   {0.990439, 0.796859, 0.14787, 1},
   {0.989587, 0.803205, 0.146529, 1},
   {0.988648, 0.809579, 0.145357, 1},
   {0.987621, 0.815978, 0.144363, 1},
   {0.986509, 0.822401, 0.143557, 1},
   {0.985314, 0.828846, 0.142945, 1},
   {0.984031, 0.835315, 0.142528, 1},
   {0.982653, 0.841812, 0.142303, 1},
   {0.98119, 0.848329, 0.142279, 1},
   {0.979644, 0.854866, 0.142453, 1},
   {0.977995, 0.861432, 0.142808, 1},
   {0.976265, 0.868016, 0.143351, 1},
   {0.974443, 0.874622, 0.144061, 1},
   {0.97253, 0.88125, 0.144923, 1},
   {0.970533, 0.887896, 0.145919, 1},
   {0.968443, 0.894564, 0.147014, 1},
   {0.966271, 0.901249, 0.14818, 1},
   {0.964021, 0.90795, 0.14937, 1},
   {0.961681, 0.914672, 0.15052, 1},
   {0.959276, 0.921407, 0.151566, 1},
   {0.956808, 0.928152, 0.152409, 1},
   {0.954287, 0.934908, 0.152921, 1},
   {0.951726, 0.941671, 0.152925, 1},
   {0.949151, 0.948435, 0.152178, 1},
   {0.946602, 0.95519, 0.150328, 1},
   {0.944152, 0.961916, 0.146861, 1},
   {0.941896, 0.96859, 0.140956, 1},
   {0.940015, 0.975158, 0.131326, 1},
});

const Palette BPAL_40 = Palette("fusion",
{
   {0.152696, 0.0159421, 0.0698888, 1},
   {0.158252, 0.0169861, 0.0744861, 1},
   {0.163816, 0.0180139, 0.079049, 1},
   {0.169388, 0.0190202, 0.0835767, 1},
   {0.174972, 0.02, 0.088068, 1},
   {0.180569, 0.0209485, 0.0925211, 1},
   {0.186181, 0.0218608, 0.0969348, 1},
   {0.19181, 0.0227318, 0.101307, 1},
   {0.197456, 0.0235573, 0.105635, 1},
   {0.203121, 0.0243325, 0.109918, 1},
   {0.208806, 0.0250524, 0.114153, 1},
   {0.214513, 0.0257133, 0.118336, 1},
   {0.220242, 0.0263109, 0.122465, 1},
   {0.225994, 0.0268414, 0.126537, 1},
   {0.23177, 0.0273013, 0.130548, 1},
   {0.237569, 0.0276873, 0.134495, 1},
   {0.243393, 0.0279961, 0.138374, 1},
   {0.249242, 0.0282259, 0.14218, 1},
   {0.255115, 0.0283749, 0.14591, 1},
   {0.261012, 0.028441, 0.149558, 1},
   {0.266933, 0.0284245, 0.153121, 1},
   {0.272878, 0.0283243, 0.156592, 1},
   {0.278844, 0.0281422, 0.159968, 1},
   {0.284833, 0.0278795, 0.163243, 1},
   {0.290841, 0.0275385, 0.166411, 1},
   {0.296869, 0.027123, 0.169468, 1},
   {0.302913, 0.0266377, 0.172408, 1},
   {0.308971, 0.0260884, 0.175227, 1},
   {0.315042, 0.0254817, 0.177918, 1},
   {0.321123, 0.0248258, 0.180478, 1},
   {0.327212, 0.0241301, 0.182903, 1},
   {0.333303, 0.0234051, 0.185188, 1},
   {0.339396, 0.0226616, 0.18733, 1},
   {0.345486, 0.0219129, 0.189327, 1},
   {0.35157, 0.0211716, 0.191175, 1},
   {0.357644, 0.0204524, 0.192875, 1},
   {0.363705, 0.0197698, 0.194425, 1},
   {0.369748, 0.0191391, 0.195825, 1},
   {0.375771, 0.0185759, 0.197077, 1},
   {0.381769, 0.0180955, 0.198181, 1},
   {0.38774, 0.0177135, 0.199142, 1},
   {0.39368, 0.0174451, 0.199962, 1},
   {0.399586, 0.017305, 0.200644, 1},
   {0.405456, 0.0173076, 0.201194, 1},
   {0.411288, 0.0174662, 0.201617, 1},
   {0.417079, 0.0177939, 0.201916, 1},
   {0.422828, 0.0183027, 0.202099, 1},
   {0.428534, 0.0190039, 0.202171, 1},
   {0.434194, 0.019908, 0.202137, 1},
   {0.439808, 0.0210248, 0.202004, 1},
   {0.445377, 0.0223633, 0.201777, 1},
   {0.450898, 0.0239318, 0.201461, 1},
   {0.456372, 0.0257383, 0.201064, 1},
   {0.461799, 0.0277898, 0.200588, 1},
   {0.467178, 0.0300931, 0.200041, 1},
   {0.472511, 0.0326545, 0.199427, 1},
   {0.477797, 0.03548, 0.19875, 1},
   {0.483037, 0.0385751, 0.198014, 1},
   {0.488231, 0.0419048, 0.197225, 1},
   {0.493379, 0.0453336, 0.196385, 1},
   {0.498483, 0.0488556, 0.195499, 1},
   {0.503542, 0.0524602, 0.194569, 1},
   {0.508558, 0.0561379, 0.193599, 1},
   {0.513531, 0.0598808, 0.192592, 1},
   {0.518461, 0.0636817, 0.191551, 1},
   {0.52335, 0.0675346, 0.190477, 1},
   {0.528197, 0.0714341, 0.189374, 1},
   {0.533003, 0.0753755, 0.188244, 1},
   {0.537769, 0.079355, 0.187089, 1},
   {0.542495, 0.0833693, 0.18591, 1},
   {0.547182, 0.0874152, 0.18471, 1},
   {0.55183, 0.0914904, 0.18349, 1},
   {0.55644, 0.0955927, 0.182251, 1},
   {0.561011, 0.0997203, 0.180996, 1},
   {0.565545, 0.103872, 0.179725, 1},
   {0.570042, 0.108045, 0.17844, 1},
   {0.574502, 0.11224, 0.177142, 1},
   {0.578925, 0.116456, 0.175832, 1},
   {0.583312, 0.120691, 0.174511, 1},
   {0.587663, 0.124945, 0.173181, 1},
   {0.591978, 0.129217, 0.171843, 1},
   {0.596257, 0.133508, 0.170497, 1},
   {0.6005, 0.137816, 0.169144, 1},
   {0.604708, 0.142141, 0.167786, 1},
   {0.60888, 0.146484, 0.166423, 1},
   {0.613017, 0.150844, 0.165057, 1},
   {0.617119, 0.15522, 0.163688, 1},
   {0.621185, 0.159614, 0.162317, 1},
   {0.625217, 0.164025, 0.160946, 1},
   {0.629212, 0.168453, 0.159575, 1},
   {0.633173, 0.172897, 0.158205, 1},
   {0.637098, 0.177359, 0.156837, 1},
   {0.640987, 0.181839, 0.155473, 1},
   {0.644841, 0.186335, 0.154114, 1},
   {0.648659, 0.19085, 0.15276, 1},
   {0.652441, 0.195381, 0.151414, 1},
   {0.656187, 0.199931, 0.150076, 1},
   {0.659897, 0.204499, 0.148748, 1},
   {0.66357, 0.209085, 0.147431, 1},
   {0.667206, 0.21369, 0.146127, 1},
   {0.670805, 0.218313, 0.144838, 1},
   {0.674366, 0.222955, 0.143565, 1},
   {0.67789, 0.227616, 0.14231, 1},
   {0.681376, 0.232296, 0.141076, 1},
   {0.684823, 0.236996, 0.139864, 1},
   {0.688232, 0.241716, 0.138677, 1},
   {0.691602, 0.246455, 0.137517, 1},
   {0.694932, 0.251214, 0.136387, 1},
   {0.698222, 0.255994, 0.135289, 1},
   {0.701473, 0.260794, 0.134227, 1},
   {0.704682, 0.265614, 0.133204, 1},
   {0.70785, 0.270455, 0.132223, 1},
   {0.710976, 0.275318, 0.131287, 1},
   {0.714061, 0.280201, 0.1304, 1},
   {0.717103, 0.285105, 0.129567, 1},
   {0.720101, 0.290031, 0.12879, 1},
   {0.723056, 0.294979, 0.128076, 1},
   {0.725967, 0.299948, 0.127427, 1},
   {0.728834, 0.304939, 0.126849, 1},
   {0.731655, 0.309951, 0.126346, 1},
   {0.73443, 0.314986, 0.125925, 1},
   {0.737159, 0.320042, 0.125589, 1},
   {0.739842, 0.32512, 0.125345, 1},
   {0.742477, 0.33022, 0.125198, 1},
   {0.745064, 0.335342, 0.125153, 1},
   {0.747603, 0.340486, 0.125217, 1},
   {0.750093, 0.345651, 0.125394, 1},
   {0.752534, 0.350839, 0.125692, 1},
   {0.754925, 0.356047, 0.126115, 1},
   {0.757266, 0.361278, 0.126669, 1},
   {0.759556, 0.366529, 0.12736, 1},
   {0.761795, 0.371801, 0.128193, 1},
   {0.763983, 0.377095, 0.129174, 1},
   {0.766118, 0.382408, 0.130307, 1},
   {0.768202, 0.387742, 0.131598, 1},
   {0.770233, 0.393096, 0.13305, 1},
   {0.772211, 0.398468, 0.134668, 1},
   {0.774137, 0.40386, 0.136455, 1},
   {0.77601, 0.40927, 0.138415, 1},
   {0.777829, 0.414698, 0.14055, 1},
   {0.779596, 0.420143, 0.142864, 1},
   {0.78131, 0.425604, 0.145358, 1},
   {0.782972, 0.431082, 0.148034, 1},
   {0.784581, 0.436574, 0.150892, 1},
   {0.786138, 0.442081, 0.153935, 1},
   {0.787644, 0.447602, 0.157161, 1},
   {0.789099, 0.453134, 0.160572, 1},
   {0.790503, 0.458679, 0.164165, 1},
   {0.791858, 0.464234, 0.167941, 1},
   {0.793164, 0.469799, 0.171899, 1},
   {0.794423, 0.475372, 0.176036, 1},
   {0.795635, 0.480953, 0.180351, 1},
   {0.796802, 0.48654, 0.184842, 1},
   {0.797925, 0.492132, 0.189506, 1},
   {0.799005, 0.497728, 0.19434, 1},
   {0.800044, 0.503326, 0.199342, 1},
   {0.801044, 0.508926, 0.204509, 1},
   {0.802007, 0.514527, 0.209836, 1},
   {0.802934, 0.520126, 0.215322, 1},
   {0.803828, 0.525723, 0.220961, 1},
   {0.80469, 0.531316, 0.226751, 1},
   {0.805522, 0.536905, 0.232687, 1},
   {0.806328, 0.542487, 0.238765, 1},
   {0.807109, 0.548063, 0.244982, 1},
   {0.807867, 0.55363, 0.251334, 1},
   {0.808605, 0.559187, 0.257815, 1},
   {0.809325, 0.564734, 0.264422, 1},
   {0.81003, 0.57027, 0.271151, 1},
   {0.810723, 0.575793, 0.277997, 1},
   {0.811405, 0.581303, 0.284957, 1},
   {0.81208, 0.586798, 0.292025, 1},
   {0.812749, 0.592278, 0.299198, 1},
   {0.813416, 0.597742, 0.306472, 1},
   {0.814081, 0.60319, 0.313842, 1},
   {0.814749, 0.608621, 0.321305, 1},
   {0.815422, 0.614033, 0.328856, 1},
   {0.8161, 0.619428, 0.336492, 1},
   {0.816788, 0.624804, 0.344208, 1},
   {0.817487, 0.63016, 0.352001, 1},
   {0.818199, 0.635498, 0.359868, 1},
   {0.818926, 0.640815, 0.367804, 1},
   {0.819671, 0.646113, 0.375807, 1},
   {0.820434, 0.651391, 0.383873, 1},
   {0.821219, 0.656648, 0.391998, 1},
   {0.822027, 0.661886, 0.40018, 1},
   {0.822859, 0.667103, 0.408416, 1},
   {0.823717, 0.672299, 0.416702, 1},
   {0.824604, 0.677476, 0.425035, 1},
   {0.825519, 0.682633, 0.433414, 1},
   {0.826466, 0.68777, 0.441835, 1},
   {0.827445, 0.692887, 0.450296, 1},
   {0.828457, 0.697985, 0.458793, 1},
   {0.829505, 0.703063, 0.467326, 1},
   {0.830588, 0.708123, 0.475891, 1},
   {0.831709, 0.713164, 0.484487, 1},
   {0.832868, 0.718186, 0.493111, 1},
   {0.834066, 0.72319, 0.501762, 1},
   {0.835305, 0.728177, 0.510436, 1},
   {0.836585, 0.733146, 0.519133, 1},
   {0.837908, 0.738098, 0.527851, 1},
   {0.839273, 0.743033, 0.536587, 1},
   {0.840682, 0.747952, 0.545342, 1},
   {0.842136, 0.752856, 0.554111, 1},
   {0.843635, 0.757743, 0.562894, 1},
   {0.845181, 0.762616, 0.571691, 1},
   {0.846772, 0.767474, 0.580499, 1},
   {0.848412, 0.772318, 0.589315, 1},
   {0.850099, 0.777148, 0.598141, 1},
   {0.851834, 0.781965, 0.606973, 1},
   {0.853619, 0.786769, 0.615812, 1},
   {0.855453, 0.791561, 0.624655, 1},
   {0.857337, 0.79634, 0.633501, 1},
   {0.859272, 0.801108, 0.64235, 1},
   {0.861257, 0.805865, 0.6512, 1},
   {0.863294, 0.810611, 0.66005, 1},
   {0.865382, 0.815346, 0.6689, 1},
   {0.867523, 0.820072, 0.677746, 1},
   {0.869716, 0.824788, 0.68659, 1},
   {0.871962, 0.829495, 0.69543, 1},
   {0.874261, 0.834194, 0.704264, 1},
   {0.876615, 0.838884, 0.713092, 1},
   {0.879022, 0.843566, 0.721914, 1},
   {0.881484, 0.848241, 0.730727, 1},
   {0.884001, 0.852908, 0.739531, 1},
   {0.886573, 0.857569, 0.748324, 1},
   {0.889202, 0.862223, 0.757107, 1},
   {0.891887, 0.866871, 0.765878, 1},
   {0.894629, 0.871513, 0.774635, 1},
   {0.897428, 0.87615, 0.783378, 1},
   {0.900287, 0.880781, 0.792104, 1},
   {0.903205, 0.885407, 0.800814, 1},
   {0.906183, 0.890027, 0.809505, 1},
   {0.909223, 0.894643, 0.818177, 1},
   {0.912325, 0.899254, 0.826827, 1},
   {0.915492, 0.90386, 0.835453, 1},
   {0.918725, 0.90846, 0.844054, 1},
   {0.922025, 0.913056, 0.852627, 1},
   {0.925397, 0.917646, 0.86117, 1},
   {0.928842, 0.922229, 0.869678, 1},
   {0.932364, 0.926807, 0.878147, 1},
   {0.935968, 0.931376, 0.886572, 1},
   {0.939659, 0.935937, 0.894946, 1},
   {0.943442, 0.940489, 0.903261, 1},
   {0.947325, 0.94503, 0.911504, 1},
   {0.951314, 0.94956, 0.919662, 1},
   {0.955417, 0.954078, 0.927717, 1},
   {0.959638, 0.958584, 0.935645, 1},
   {0.963976, 0.963083, 0.94342, 1},
   {0.968422, 0.967581, 0.951016, 1},
   {0.972955, 0.972089, 0.958415, 1},
   {0.977538, 0.976622, 0.965616, 1},
   {0.982128, 0.981193, 0.972642, 1},
   {0.986687, 0.985816, 0.979537, 1},
   {0.991188, 0.990494, 0.986361, 1},
   {0.995624, 0.995224, 0.993167, 1},
   {1, 1, 1, 1},
   {0.992867, 0.995994, 0.996148, 1},
   {0.985701, 0.992018, 0.99234, 1},
   {0.978505, 0.988071, 0.988577, 1},
   {0.971281, 0.984151, 0.984857, 1},
   {0.96403, 0.980258, 0.981183, 1},
   {0.956754, 0.97639, 0.977554, 1},
   {0.949454, 0.972547, 0.973971, 1},
   {0.942131, 0.968727, 0.970434, 1},
   {0.934784, 0.964931, 0.966943, 1},
   {0.927415, 0.961156, 0.963499, 1},
   {0.920024, 0.957404, 0.960102, 1},
   {0.912611, 0.953672, 0.956752, 1},
   {0.905175, 0.949962, 0.953451, 1},
   {0.897718, 0.946271, 0.950198, 1},
   {0.89024, 0.9426, 0.946994, 1},
   {0.882739, 0.938948, 0.943839, 1},
   {0.875216, 0.935315, 0.940735, 1},
   {0.867672, 0.931699, 0.93768, 1},
   {0.860105, 0.928101, 0.934677, 1},
   {0.852516, 0.924521, 0.931726, 1},
   {0.844904, 0.920957, 0.928827, 1},
   {0.837271, 0.917409, 0.92598, 1},
   {0.829613, 0.913877, 0.923187, 1},
   {0.821934, 0.910359, 0.920447, 1},
   {0.81423, 0.906857, 0.917762, 1},
   {0.806504, 0.903368, 0.915133, 1},
   {0.798754, 0.899893, 0.912559, 1},
   {0.790979, 0.896432, 0.910042, 1},
   {0.783182, 0.892982, 0.907582, 1},
   {0.775361, 0.889545, 0.90518, 1},
   {0.767514, 0.886119, 0.902837, 1},
   {0.759644, 0.882704, 0.900553, 1},
   {0.751751, 0.879298, 0.898329, 1},
   {0.743833, 0.875903, 0.896165, 1},
   {0.735891, 0.872516, 0.894063, 1},
   {0.727925, 0.869137, 0.892023, 1},
   {0.719935, 0.865766, 0.890045, 1},
   {0.711922, 0.862401, 0.888131, 1},
   {0.703886, 0.859043, 0.886281, 1},
   {0.695828, 0.85569, 0.884496, 1},
   {0.687747, 0.852341, 0.882776, 1},
   {0.679645, 0.848996, 0.881122, 1},
   {0.671522, 0.845653, 0.879534, 1},
   {0.66338, 0.842313, 0.878012, 1},
   {0.655219, 0.838973, 0.876558, 1},
   {0.647041, 0.835633, 0.875171, 1},
   {0.638846, 0.832293, 0.873853, 1},
   {0.630638, 0.82895, 0.872602, 1},
   {0.622416, 0.825605, 0.87142, 1},
   {0.614183, 0.822256, 0.870307, 1},
   {0.605942, 0.818901, 0.869261, 1},
   {0.597694, 0.81554, 0.868284, 1},
   {0.589442, 0.812172, 0.867375, 1},
   {0.58119, 0.808796, 0.866533, 1},
   {0.57294, 0.80541, 0.865759, 1},
   {0.564695, 0.802013, 0.865051, 1},
   {0.556459, 0.798604, 0.864409, 1},
   {0.548237, 0.795182, 0.863833, 1},
   {0.540031, 0.791745, 0.863319, 1},
   {0.531847, 0.788293, 0.862868, 1},
   {0.52369, 0.784825, 0.862479, 1},
   {0.515564, 0.781338, 0.862149, 1},
   {0.507475, 0.777832, 0.861876, 1},
   {0.499428, 0.774306, 0.86166, 1},
   {0.491429, 0.770759, 0.861498, 1},
   {0.483484, 0.76719, 0.861387, 1},
   {0.475599, 0.763597, 0.861326, 1},
   {0.46778, 0.75998, 0.861311, 1},
   {0.460035, 0.756338, 0.861341, 1},
   {0.452369, 0.75267, 0.861413, 1},
   {0.44479, 0.748976, 0.861523, 1},
   {0.437305, 0.745254, 0.861669, 1},
   {0.429919, 0.741504, 0.861848, 1},
   {0.422641, 0.737726, 0.862057, 1},
   {0.415477, 0.733919, 0.862293, 1},
   {0.408434, 0.730082, 0.862553, 1},
   {0.401518, 0.726216, 0.862834, 1},
   {0.394737, 0.72232, 0.863132, 1},
   {0.388096, 0.718395, 0.863446, 1},
   {0.381603, 0.714439, 0.863772, 1},
   {0.375262, 0.710453, 0.864108, 1},
   {0.369081, 0.706437, 0.86445, 1},
   {0.363065, 0.702391, 0.864796, 1},
   {0.357219, 0.698315, 0.865144, 1},
   {0.351548, 0.69421, 0.865491, 1},
   {0.346057, 0.690076, 0.865835, 1},
   {0.340751, 0.685912, 0.866174, 1},
   {0.335633, 0.68172, 0.866506, 1},
   {0.330708, 0.6775, 0.866829, 1},
   {0.325978, 0.673251, 0.867141, 1},
   {0.321447, 0.668975, 0.867441, 1},
   {0.317117, 0.664672, 0.867727, 1},
   {0.31299, 0.660343, 0.867997, 1},
   {0.309069, 0.655986, 0.868251, 1},
   {0.305353, 0.651604, 0.868487, 1},
   {0.301845, 0.647196, 0.868704, 1},
   {0.298544, 0.642764, 0.868901, 1},
   {0.29545, 0.638306, 0.869077, 1},
   {0.292562, 0.633824, 0.869232, 1},
   {0.289879, 0.629319, 0.869365, 1},
   {0.287401, 0.624789, 0.869474, 1},
   {0.285123, 0.620237, 0.869561, 1},
   {0.283045, 0.615661, 0.869623, 1},
   {0.281164, 0.611063, 0.86966, 1},
   {0.279475, 0.606442, 0.869673, 1},
   {0.277976, 0.6018, 0.869661, 1},
   {0.276661, 0.597135, 0.869623, 1},
   {0.275528, 0.592449, 0.869559, 1},
   {0.27457, 0.587741, 0.869469, 1},
   {0.273784, 0.583013, 0.869353, 1},
   {0.273163, 0.578263, 0.86921, 1},
   {0.272703, 0.573492, 0.86904, 1},
   {0.272398, 0.568701, 0.868844, 1},
   {0.272241, 0.563888, 0.868621, 1},
   {0.272227, 0.559055, 0.86837, 1},
   {0.272351, 0.554201, 0.868092, 1},
   {0.272605, 0.549327, 0.867787, 1},
   {0.272985, 0.544432, 0.867454, 1},
   {0.273483, 0.539516, 0.867094, 1},
   {0.274094, 0.53458, 0.866706, 1},
   {0.274813, 0.529622, 0.866289, 1},
   {0.275632, 0.524644, 0.865845, 1},
   {0.276547, 0.519645, 0.865372, 1},
   {0.277551, 0.514624, 0.86487, 1},
   {0.278639, 0.509582, 0.86434, 1},
   {0.279807, 0.504518, 0.863781, 1},
   {0.281047, 0.499433, 0.863193, 1},
   {0.282356, 0.494326, 0.862575, 1},
   {0.283728, 0.489196, 0.861928, 1},
   {0.285159, 0.484044, 0.86125, 1},
   {0.286643, 0.478869, 0.860542, 1},
   {0.288177, 0.47367, 0.859803, 1},
   {0.289756, 0.468448, 0.859033, 1},
   {0.291376, 0.463203, 0.858231, 1},
   {0.293032, 0.457932, 0.857397, 1},
   {0.294722, 0.452638, 0.856531, 1},
   {0.296441, 0.447318, 0.855631, 1},
   {0.298186, 0.441972, 0.854697, 1},
   {0.299953, 0.4366, 0.853729, 1},
   {0.30174, 0.431202, 0.852725, 1},
   {0.303542, 0.425776, 0.851685, 1},
   {0.305357, 0.420323, 0.850609, 1},
   {0.307182, 0.414842, 0.849495, 1},
   {0.309014, 0.409332, 0.848342, 1},
   {0.310851, 0.403792, 0.84715, 1},
   {0.31269, 0.398222, 0.845917, 1},
   {0.314528, 0.392622, 0.844642, 1},
   {0.316362, 0.38699, 0.843325, 1},
   {0.318192, 0.381326, 0.841963, 1},
   {0.320013, 0.375629, 0.840556, 1},
   {0.321824, 0.369899, 0.839102, 1},
   {0.323624, 0.364135, 0.837599, 1},
   {0.325408, 0.358335, 0.836047, 1},
   {0.327177, 0.3525, 0.834443, 1},
   {0.328927, 0.346628, 0.832785, 1},
   {0.330656, 0.340718, 0.831072, 1},
   {0.332363, 0.33477, 0.829301, 1},
   {0.334045, 0.328783, 0.827471, 1},
   {0.3357, 0.322756, 0.82558, 1},
   {0.337327, 0.316689, 0.823624, 1},
   {0.338923, 0.310579, 0.821601, 1},
   {0.340487, 0.304427, 0.81951, 1},
   {0.342017, 0.298231, 0.817346, 1},
   {0.343509, 0.291991, 0.815108, 1},
   {0.344963, 0.285706, 0.812791, 1},
   {0.346376, 0.279375, 0.810393, 1},
   {0.347746, 0.272997, 0.80791, 1},
   {0.34907, 0.266572, 0.805338, 1},
   {0.350348, 0.260099, 0.802674, 1},
   {0.351575, 0.253577, 0.799914, 1},
   {0.35275, 0.247006, 0.797053, 1},
   {0.35387, 0.240385, 0.794086, 1},
   {0.354932, 0.233715, 0.791009, 1},
   {0.355934, 0.226995, 0.787817, 1},
   {0.356873, 0.220225, 0.784504, 1},
   {0.357746, 0.213406, 0.781065, 1},
   {0.358549, 0.206539, 0.777494, 1},
   {0.35928, 0.199625, 0.773785, 1},
   {0.359935, 0.192665, 0.769931, 1},
   {0.360509, 0.185662, 0.765925, 1},
   {0.361, 0.178619, 0.76176, 1},
   {0.361403, 0.171539, 0.757428, 1},
   {0.361714, 0.164427, 0.752923, 1},
   {0.361928, 0.15729, 0.748235, 1},
   {0.362041, 0.150135, 0.743357, 1},
   {0.362047, 0.142971, 0.73828, 1},
   {0.36194, 0.13581, 0.732995, 1},
   {0.361716, 0.128666, 0.727494, 1},
   {0.361368, 0.121555, 0.721768, 1},
   {0.36089, 0.1145, 0.715808, 1},
   {0.360275, 0.107524, 0.709606, 1},
   {0.359517, 0.100659, 0.703155, 1},
   {0.358608, 0.0939408, 0.696448, 1},
   {0.357543, 0.0874113, 0.689478, 1},
   {0.356313, 0.0811204, 0.682243, 1},
   {0.354912, 0.0751246, 0.674739, 1},
   {0.353334, 0.0694873, 0.666966, 1},
   {0.351572, 0.0642768, 0.658927, 1},
   {0.349622, 0.0595637, 0.650629, 1},
   {0.34748, 0.0554164, 0.642079, 1},
   {0.345142, 0.0518949, 0.633292, 1},
   {0.342608, 0.0490444, 0.624285, 1},
   {0.339878, 0.0468879, 0.615077, 1},
   {0.336955, 0.0454217, 0.605692, 1},
   {0.333842, 0.044614, 0.596156, 1},
   {0.330547, 0.0444074, 0.586498, 1},
   {0.327077, 0.0447246, 0.576747, 1},
   {0.323441, 0.0454771, 0.566931, 1},
   {0.31965, 0.046573, 0.557078, 1},
   {0.315715, 0.047924, 0.547215, 1},
   {0.311647, 0.0494489, 0.537366, 1},
   {0.307459, 0.0510781, 0.527552, 1},
   {0.303161, 0.052753, 0.517792, 1},
   {0.298765, 0.0544273, 0.508102, 1},
   {0.29428, 0.0560632, 0.498494, 1},
   {0.289717, 0.057632, 0.48898, 1},
   {0.285085, 0.0591125, 0.479568, 1},
   {0.280391, 0.0604899, 0.470264, 1},
   {0.275643, 0.0617545, 0.461072, 1},
   {0.270849, 0.0628987, 0.451995, 1},
   {0.266013, 0.0639185, 0.443035, 1},
   {0.261142, 0.0648119, 0.434193, 1},
   {0.25624, 0.0655797, 0.425468, 1},
   {0.251311, 0.0662222, 0.41686, 1},
   {0.24636, 0.0667412, 0.408367, 1},
   {0.241389, 0.0671388, 0.399988, 1},
   {0.236402, 0.0674182, 0.39172, 1},
   {0.231401, 0.0675826, 0.383562, 1},
   {0.226389, 0.0676358, 0.375509, 1},
   {0.221367, 0.0675794, 0.367561, 1},
   {0.216338, 0.0674178, 0.359714, 1},
   {0.211303, 0.0671538, 0.351965, 1},
   {0.206263, 0.0667908, 0.344311, 1},
   {0.201219, 0.0663307, 0.336751, 1},
   {0.196174, 0.0657776, 0.32928, 1},
   {0.191126, 0.0651338, 0.321895, 1},
   {0.186078, 0.064401, 0.314596, 1},
   {0.18103, 0.0635819, 0.307379, 1},
   {0.175982, 0.0626788, 0.30024, 1},
   {0.170935, 0.0616938, 0.293178, 1},
   {0.16589, 0.0606287, 0.28619, 1},
   {0.160845, 0.0594852, 0.279273, 1},
   {0.155803, 0.0582641, 0.272426, 1},
   {0.150762, 0.0569672, 0.265646, 1},
   {0.145723, 0.0555958, 0.25893, 1},
   {0.140685, 0.0541513, 0.252276, 1},
   {0.135649, 0.0526338, 0.245682, 1},
   {0.130615, 0.0510438, 0.239148, 1},
   {0.125581, 0.0493829, 0.232668, 1},
   {0.120548, 0.0476499, 0.226244, 1},
   {0.115516, 0.0458462, 0.219871, 1},
   {0.110483, 0.0439708, 0.213549, 1},
   {0.10545, 0.042024, 0.207275, 1},
   {0.100416, 0.0399983, 0.201049, 1},
   {0.0953789, 0.037917, 0.194868, 1},
});

const Palette BPAL_41 = Palette("iceburn",
{
   {0.578693, 0.947005, 0.953835, 1},
   {0.573301, 0.942448, 0.952186, 1},
   {0.567904, 0.937906, 0.95055, 1},
   {0.562502, 0.933378, 0.94893, 1},
   {0.557094, 0.928865, 0.947323, 1},
   {0.55168, 0.924365, 0.945732, 1},
   {0.54626, 0.919878, 0.944157, 1},
   {0.540834, 0.915405, 0.942596, 1},
   {0.535401, 0.910945, 0.941053, 1},
   {0.529962, 0.906498, 0.939525, 1},
   {0.524515, 0.902063, 0.938014, 1},
   {0.519061, 0.897641, 0.93652, 1},
   {0.5136, 0.893231, 0.935043, 1},
   {0.508131, 0.888833, 0.933583, 1},
   {0.502653, 0.884447, 0.932141, 1},
   {0.497168, 0.880071, 0.930716, 1},
   {0.491674, 0.875708, 0.92931, 1},
   {0.486172, 0.871355, 0.927922, 1},
   {0.480661, 0.867012, 0.926552, 1},
   {0.475141, 0.86268, 0.925202, 1},
   {0.469611, 0.858358, 0.92387, 1},
   {0.464073, 0.854046, 0.922557, 1},
   {0.458524, 0.849744, 0.921263, 1},
   {0.452966, 0.845451, 0.919989, 1},
   {0.447398, 0.841167, 0.918735, 1},
   {0.441819, 0.836892, 0.9175, 1},
   {0.436231, 0.832626, 0.916285, 1},
   {0.430631, 0.828367, 0.91509, 1},
   {0.425021, 0.824117, 0.913916, 1},
   {0.4194, 0.819875, 0.912761, 1},
   {0.413768, 0.81564, 0.911627, 1},
   {0.408125, 0.811412, 0.910514, 1},
   {0.40247, 0.80719, 0.909421, 1},
   {0.396803, 0.802976, 0.908349, 1},
   {0.391125, 0.798767, 0.907297, 1},
   {0.385435, 0.794565, 0.906267, 1},
   {0.379733, 0.790368, 0.905257, 1},
   {0.374018, 0.786177, 0.904268, 1},
   {0.368292, 0.78199, 0.903301, 1},
   {0.362553, 0.777809, 0.902354, 1},
   {0.356801, 0.773631, 0.901427, 1},
   {0.351037, 0.769458, 0.900522, 1},
   {0.345261, 0.765288, 0.899639, 1},
   {0.339472, 0.761122, 0.898775, 1},
   {0.33367, 0.756959, 0.897933, 1},
   {0.327856, 0.752798, 0.897111, 1},
   {0.322029, 0.74864, 0.896311, 1},
   {0.31619, 0.744484, 0.89553, 1},
   {0.310339, 0.74033, 0.894771, 1},
   {0.304475, 0.736176, 0.894031, 1},
   {0.2986, 0.732024, 0.893312, 1},
   {0.292713, 0.727872, 0.892613, 1},
   {0.286816, 0.72372, 0.891934, 1},
   {0.280907, 0.719568, 0.891274, 1},
   {0.274989, 0.715415, 0.890634, 1},
   {0.269061, 0.711261, 0.890013, 1},
   {0.263125, 0.707106, 0.889411, 1},
   {0.257181, 0.702949, 0.888827, 1},
   {0.25123, 0.698789, 0.888261, 1},
   {0.245275, 0.694626, 0.887714, 1},
   {0.239315, 0.69046, 0.887183, 1},
   {0.233354, 0.686291, 0.886669, 1},
   {0.227392, 0.682117, 0.886172, 1},
   {0.221432, 0.677938, 0.88569, 1},
   {0.215478, 0.673755, 0.885224, 1},
   {0.209532, 0.669566, 0.884772, 1},
   {0.203597, 0.66537, 0.884334, 1},
   {0.197677, 0.661168, 0.883909, 1},
   {0.191778, 0.656959, 0.883495, 1},
   {0.185905, 0.652742, 0.883094, 1},
   {0.180064, 0.648516, 0.882702, 1},
   {0.174262, 0.644282, 0.882319, 1},
   {0.168507, 0.640039, 0.881944, 1},
   {0.16281, 0.635785, 0.881576, 1},
   {0.15718, 0.631522, 0.881213, 1},
   {0.15163, 0.627247, 0.880854, 1},
   {0.146176, 0.62296, 0.880497, 1},
   {0.140831, 0.618661, 0.88014, 1},
   {0.135617, 0.61435, 0.879781, 1},
   {0.130552, 0.610024, 0.879418, 1},
   {0.125662, 0.605685, 0.879049, 1},
   {0.120972, 0.601332, 0.878672, 1},
   {0.116512, 0.596963, 0.878283, 1},
   {0.112313, 0.592578, 0.87788, 1},
   {0.108412, 0.588177, 0.877459, 1},
   {0.104844, 0.583759, 0.877017, 1},
   {0.101649, 0.579324, 0.876551, 1},
   {0.0988651, 0.574871, 0.876055, 1},
   {0.0965299, 0.5704, 0.875526, 1},
   {0.0946801, 0.56591, 0.874958, 1},
   {0.0933459, 0.561401, 0.874347, 1},
   {0.0925535, 0.556873, 0.873686, 1},
   {0.0923194, 0.552325, 0.872968, 1},
   {0.0926524, 0.547757, 0.872188, 1},
   {0.0935519, 0.543171, 0.871338, 1},
   {0.0950067, 0.538564, 0.87041, 1},
   {0.0969974, 0.533939, 0.869394, 1},
   {0.099496, 0.529295, 0.868282, 1},
   {0.102468, 0.524634, 0.867064, 1},
   {0.105875, 0.519956, 0.865728, 1},
   {0.109676, 0.515263, 0.864264, 1},
   {0.113826, 0.510556, 0.862659, 1},
   {0.11828, 0.505837, 0.860902, 1},
   {0.122996, 0.501109, 0.858977, 1},
   {0.127928, 0.496374, 0.856874, 1},
   {0.133035, 0.491636, 0.854577, 1},
   {0.138275, 0.486898, 0.852074, 1},
   {0.143607, 0.482164, 0.849352, 1},
   {0.148994, 0.477439, 0.846399, 1},
   {0.154398, 0.472728, 0.843205, 1},
   {0.159783, 0.468035, 0.839759, 1},
   {0.165116, 0.463365, 0.836057, 1},
   {0.170365, 0.458725, 0.832092, 1},
   {0.175501, 0.454118, 0.827863, 1},
   {0.180497, 0.449549, 0.82337, 1},
   {0.185329, 0.445023, 0.818618, 1},
   {0.189979, 0.440544, 0.813613, 1},
   {0.194429, 0.436115, 0.808363, 1},
   {0.198666, 0.431738, 0.80288, 1},
   {0.202682, 0.427414, 0.797177, 1},
   {0.206469, 0.423147, 0.791267, 1},
   {0.210024, 0.418935, 0.785165, 1},
   {0.213347, 0.414778, 0.778887, 1},
   {0.21644, 0.410677, 0.772449, 1},
   {0.219305, 0.40663, 0.765864, 1},
   {0.221949, 0.402636, 0.75915, 1},
   {0.224376, 0.398693, 0.752318, 1},
   {0.226594, 0.3948, 0.745383, 1},
   {0.22861, 0.390954, 0.738357, 1},
   {0.230432, 0.387154, 0.731252, 1},
   {0.232069, 0.383398, 0.724079, 1},
   {0.233528, 0.379683, 0.716847, 1},
   {0.234816, 0.376008, 0.709566, 1},
   {0.235942, 0.37237, 0.702244, 1},
   {0.236914, 0.368768, 0.694888, 1},
   {0.237739, 0.3652, 0.687506, 1},
   {0.238422, 0.361664, 0.680103, 1},
   {0.238973, 0.358158, 0.672686, 1},
   {0.239395, 0.35468, 0.665259, 1},
   {0.239696, 0.351229, 0.657827, 1},
   {0.239882, 0.347804, 0.650394, 1},
   {0.239957, 0.344403, 0.642964, 1},
   {0.239927, 0.341025, 0.635541, 1},
   {0.239796, 0.337668, 0.628127, 1},
   {0.239569, 0.334331, 0.620726, 1},
   {0.239251, 0.331013, 0.613339, 1},
   {0.238845, 0.327713, 0.60597, 1},
   {0.238356, 0.32443, 0.598619, 1},
   {0.237786, 0.321164, 0.59129, 1},
   {0.237139, 0.317912, 0.583983, 1},
   {0.236419, 0.314674, 0.576701, 1},
   {0.235628, 0.31145, 0.569444, 1},
   {0.234769, 0.308238, 0.562213, 1},
   {0.233844, 0.305038, 0.55501, 1},
   {0.232858, 0.301849, 0.547836, 1},
   {0.231811, 0.298671, 0.540691, 1},
   {0.230706, 0.295502, 0.533576, 1},
   {0.229545, 0.292342, 0.526493, 1},
   {0.22833, 0.289192, 0.519441, 1},
   {0.227063, 0.286049, 0.51242, 1},
   {0.225746, 0.282913, 0.505432, 1},
   {0.224381, 0.279785, 0.498477, 1},
   {0.222969, 0.276663, 0.491555, 1},
   {0.221511, 0.273547, 0.484667, 1},
   {0.22001, 0.270437, 0.477811, 1},
   {0.218466, 0.267331, 0.47099, 1},
   {0.216882, 0.264231, 0.464203, 1},
   {0.215257, 0.261135, 0.457449, 1},
   {0.213593, 0.258043, 0.45073, 1},
   {0.211892, 0.254954, 0.444044, 1},
   {0.210155, 0.251869, 0.437393, 1},
   {0.208382, 0.248786, 0.430775, 1},
   {0.206574, 0.245706, 0.424192, 1},
   {0.204732, 0.242628, 0.417642, 1},
   {0.202858, 0.239552, 0.411127, 1},
   {0.200952, 0.236478, 0.404645, 1},
   {0.199014, 0.233405, 0.398196, 1},
   {0.197046, 0.230332, 0.391781, 1},
   {0.195048, 0.227261, 0.385399, 1},
   {0.193021, 0.224189, 0.37905, 1},
   {0.190966, 0.221118, 0.372733, 1},
   {0.188882, 0.218047, 0.36645, 1},
   {0.186771, 0.214975, 0.360198, 1},
   {0.184633, 0.211902, 0.353979, 1},
   {0.182469, 0.208828, 0.347791, 1},
   {0.180279, 0.205752, 0.341635, 1},
   {0.178063, 0.202675, 0.335511, 1},
   {0.175822, 0.199597, 0.329417, 1},
   {0.173557, 0.196516, 0.323354, 1},
   {0.171267, 0.193432, 0.317321, 1},
   {0.168953, 0.190346, 0.311318, 1},
   {0.166616, 0.187256, 0.305345, 1},
   {0.164255, 0.184164, 0.299401, 1},
   {0.161871, 0.181068, 0.293487, 1},
   {0.159464, 0.177967, 0.287601, 1},
   {0.157034, 0.174863, 0.281743, 1},
   {0.154582, 0.171754, 0.275913, 1},
   {0.152107, 0.168641, 0.270111, 1},
   {0.14961, 0.165522, 0.264336, 1},
   {0.147091, 0.162398, 0.258587, 1},
   {0.14455, 0.159268, 0.252865, 1},
   {0.141987, 0.156132, 0.247169, 1},
   {0.139402, 0.15299, 0.241499, 1},
   {0.136795, 0.149841, 0.235853, 1},
   {0.134167, 0.146684, 0.230232, 1},
   {0.131516, 0.143521, 0.224635, 1},
   {0.128843, 0.140349, 0.219062, 1},
   {0.126149, 0.137169, 0.213511, 1},
   {0.123432, 0.13398, 0.207984, 1},
   {0.120693, 0.130782, 0.202479, 1},
   {0.117932, 0.127575, 0.196995, 1},
   {0.115148, 0.124357, 0.191532, 1},
   {0.112341, 0.121129, 0.18609, 1},
   {0.109511, 0.11789, 0.180668, 1},
   {0.106658, 0.11464, 0.175265, 1},
   {0.103781, 0.111377, 0.169881, 1},
   {0.100881, 0.108101, 0.164514, 1},
   {0.0979553, 0.104812, 0.159166, 1},
   {0.0950053, 0.101509, 0.153833, 1},
   {0.0920299, 0.0981908, 0.148517, 1},
   {0.0890287, 0.0948575, 0.143216, 1},
   {0.0860011, 0.0915079, 0.137929, 1},
   {0.0829463, 0.0881411, 0.132656, 1},
   {0.0798638, 0.0847564, 0.127395, 1},
   {0.0767526, 0.0813528, 0.122146, 1},
   {0.0736121, 0.0779292, 0.116907, 1},
   {0.0704412, 0.0744845, 0.111679, 1},
   {0.0672389, 0.0710177, 0.106458, 1},
   {0.0640041, 0.0675273, 0.101245, 1},
   {0.0607355, 0.0640121, 0.0960382, 1},
   {0.0574318, 0.0604705, 0.0908357, 1},
   {0.0540915, 0.056901, 0.0856362, 1},
   {0.0507128, 0.0533017, 0.0804381, 1},
   {0.047294, 0.0496706, 0.0752398, 1},
   {0.0438329, 0.0460057, 0.070039, 1},
   {0.0403253, 0.0423046, 0.0648337, 1},
   {0.036812, 0.0385588, 0.0596216, 1},
   {0.0334384, 0.0349235, 0.0543999, 1},
   {0.0302066, 0.0314566, 0.0491656, 1},
   {0.0271186, 0.0281589, 0.0439152, 1},
   {0.0241767, 0.0250311, 0.0386383, 1},
   {0.0213832, 0.0220743, 0.0336013, 1},
   {0.0187405, 0.0192895, 0.0289448, 1},
   {0.0162514, 0.016678, 0.024661, 1},
   {0.0139187, 0.0142415, 0.0207421, 1},
   {0.0117457, 0.0119817, 0.0171806, 1},
   {0.00973575, 0.00990088, 0.0139694, 1},
   {0.00789285, 0.0080016, 0.0111019, 1},
   {0.00622148, 0.00628698, 0.00857157, 1},
   {0.00472684, 0.00476083, 0.00637274, 1},
   {0.00341513, 0.0034279, 0.00450037, 1},
   {0.00229394, 0.00229426, 0.00295046, 1},
   {0.00137302, 0.001368, 0.00172056, 1},
   {0.000665757, 0.000660629, 0.000810978, 1},
   {0.000192918, 0.000190603, 0.000227925, 1},
   {0, 0, 0, 1},
   {0.000246148, 0.000174022, 0.000186778, 1},
   {0.000876506, 0.000595218, 0.000645816, 1},
   {0.00186026, 0.00121727, 0.00133402, 1},
   {0.00319002, 0.00201789, 0.00223163, 1},
   {0.00486438, 0.00298218, 0.00332572, 1},
   {0.00688465, 0.004099, 0.00460664, 1},
   {0.0092536, 0.00535941, 0.0060667, 1},
   {0.011975, 0.006756, 0.00769941, 1},
   {0.0150531, 0.00828238, 0.00949915, 1},
   {0.0184928, 0.00993297, 0.0114609, 1},
   {0.0222993, 0.0117028, 0.0135799, 1},
   {0.026478, 0.0135874, 0.0158521, 1},
   {0.0310346, 0.0155826, 0.0182732, 1},
   {0.0359748, 0.0176847, 0.0208395, 1},
   {0.0412853, 0.0198902, 0.0235473, 1},
   {0.0466369, 0.0221957, 0.0263928, 1},
   {0.0519583, 0.0245984, 0.0293725, 1},
   {0.0572533, 0.0270952, 0.032483, 1},
   {0.0625253, 0.0296834, 0.0357208, 1},
   {0.0677771, 0.0323604, 0.0390823, 1},
   {0.0730114, 0.0351237, 0.0424979, 1},
   {0.0782303, 0.037971, 0.0458515, 1},
   {0.083436, 0.040891, 0.0491545, 1},
   {0.0886303, 0.0437692, 0.0524087, 1},
   {0.0938147, 0.0466043, 0.0556155, 1},
   {0.0989907, 0.0493983, 0.0587762, 1},
   {0.10416, 0.0521527, 0.061892, 1},
   {0.109323, 0.0548691, 0.0649637, 1},
   {0.114482, 0.0575492, 0.0679924, 1},
   {0.119637, 0.0601941, 0.0709787, 1},
   {0.124789, 0.0628052, 0.0739234, 1},
   {0.129939, 0.0653837, 0.0768269, 1},
   {0.135089, 0.0679305, 0.0796898, 1},
   {0.140237, 0.0704469, 0.0825125, 1},
   {0.145387, 0.0729337, 0.0852953, 1},
   {0.150537, 0.0753918, 0.0880386, 1},
   {0.155688, 0.0778222, 0.0907425, 1},
   {0.160842, 0.0802256, 0.0934071, 1},
   {0.165997, 0.0826029, 0.0960328, 1},
   {0.171156, 0.0849547, 0.0986194, 1},
   {0.176318, 0.0872819, 0.101167, 1},
   {0.181484, 0.0895851, 0.103676, 1},
   {0.186653, 0.0918649, 0.106145, 1},
   {0.191827, 0.094122, 0.108576, 1},
   {0.197006, 0.0963571, 0.110968, 1},
   {0.202189, 0.0985707, 0.11332, 1},
   {0.207377, 0.100763, 0.115632, 1},
   {0.21257, 0.102936, 0.117905, 1},
   {0.217769, 0.105089, 0.120138, 1},
   {0.222973, 0.107222, 0.122331, 1},
   {0.228183, 0.109337, 0.124484, 1},
   {0.233398, 0.111434, 0.126595, 1},
   {0.238619, 0.113514, 0.128666, 1},
   {0.243847, 0.115576, 0.130696, 1},
   {0.249079, 0.117622, 0.132684, 1},
   {0.254318, 0.119653, 0.13463, 1},
   {0.259563, 0.121668, 0.136533, 1},
   {0.264813, 0.123668, 0.138394, 1},
   {0.27007, 0.125654, 0.140212, 1},
   {0.275332, 0.127626, 0.141986, 1},
   {0.280599, 0.129585, 0.143716, 1},
   {0.285873, 0.131532, 0.145402, 1},
   {0.291151, 0.133466, 0.147043, 1},
   {0.296435, 0.13539, 0.148639, 1},
   {0.301724, 0.137302, 0.150189, 1},
   {0.307018, 0.139205, 0.151693, 1},
   {0.312316, 0.141098, 0.153151, 1},
   {0.317619, 0.142982, 0.154562, 1},
   {0.322926, 0.144857, 0.155925, 1},
   {0.328237, 0.146726, 0.15724, 1},
   {0.333552, 0.148587, 0.158507, 1},
   {0.33887, 0.150442, 0.159726, 1},
   {0.344191, 0.152292, 0.160895, 1},
   {0.349514, 0.154137, 0.162015, 1},
   {0.35484, 0.155979, 0.163084, 1},
   {0.360167, 0.157817, 0.164103, 1},
   {0.365496, 0.159653, 0.165072, 1},
   {0.370826, 0.161487, 0.165989, 1},
   {0.376156, 0.16332, 0.166855, 1},
   {0.381486, 0.165154, 0.167669, 1},
   {0.386815, 0.166989, 0.16843, 1},
   {0.392144, 0.168826, 0.16914, 1},
   {0.39747, 0.170666, 0.169796, 1},
   {0.402795, 0.172509, 0.1704, 1},
   {0.408116, 0.174358, 0.17095, 1},
   {0.413434, 0.176212, 0.171448, 1},
   {0.418748, 0.178073, 0.171891, 1},
   {0.424057, 0.179942, 0.172281, 1},
   {0.429361, 0.18182, 0.172618, 1},
   {0.434658, 0.183708, 0.1729, 1},
   {0.439948, 0.185607, 0.173129, 1},
   {0.445231, 0.187518, 0.173304, 1},
   {0.450505, 0.189442, 0.173426, 1},
   {0.455769, 0.191381, 0.173494, 1},
   {0.461024, 0.193336, 0.173508, 1},
   {0.466268, 0.195307, 0.17347, 1},
   {0.4715, 0.197295, 0.173379, 1},
   {0.47672, 0.199303, 0.173235, 1},
   {0.481926, 0.201331, 0.17304, 1},
   {0.487118, 0.20338, 0.172792, 1},
   {0.492294, 0.205452, 0.172494, 1},
   {0.497455, 0.207547, 0.172144, 1},
   {0.502599, 0.209667, 0.171745, 1},
   {0.507726, 0.211812, 0.171296, 1},
   {0.512834, 0.213985, 0.170799, 1},
   {0.517922, 0.216185, 0.170253, 1},
   {0.52299, 0.218414, 0.169661, 1},
   {0.528038, 0.220673, 0.169022, 1},
   {0.533063, 0.222963, 0.168337, 1},
   {0.538065, 0.225285, 0.167609, 1},
   {0.543044, 0.22764, 0.166836, 1},
   {0.547999, 0.230028, 0.166021, 1},
   {0.552928, 0.232451, 0.165165, 1},
   {0.557832, 0.234909, 0.164268, 1},
   {0.562709, 0.237403, 0.163332, 1},
   {0.567558, 0.239934, 0.162358, 1},
   {0.57238, 0.242502, 0.161348, 1},
   {0.577173, 0.245109, 0.160301, 1},
   {0.581937, 0.247753, 0.15922, 1},
   {0.586672, 0.250437, 0.158107, 1},
   {0.591375, 0.25316, 0.156961, 1},
   {0.596048, 0.255922, 0.155785, 1},
   {0.60069, 0.258725, 0.154579, 1},
   {0.6053, 0.261568, 0.153346, 1},
   {0.609877, 0.264451, 0.152086, 1},
   {0.614422, 0.267376, 0.150801, 1},
   {0.618934, 0.27034, 0.149492, 1},
   {0.623413, 0.273346, 0.14816, 1},
   {0.627858, 0.276393, 0.146807, 1},
   {0.632269, 0.27948, 0.145434, 1},
   {0.636646, 0.282608, 0.144042, 1},
   {0.640989, 0.285776, 0.142633, 1},
   {0.645298, 0.288985, 0.141207, 1},
   {0.649572, 0.292234, 0.139767, 1},
   {0.653811, 0.295523, 0.138313, 1},
   {0.658016, 0.298851, 0.136847, 1},
   {0.662186, 0.302219, 0.13537, 1},
   {0.666321, 0.305626, 0.133883, 1},
   {0.670421, 0.309071, 0.132388, 1},
   {0.674487, 0.312554, 0.130885, 1},
   {0.678518, 0.316075, 0.129376, 1},
   {0.682515, 0.319633, 0.127863, 1},
   {0.686477, 0.323228, 0.126346, 1},
   {0.690405, 0.326859, 0.124827, 1},
   {0.694298, 0.330526, 0.123307, 1},
   {0.698158, 0.334229, 0.121787, 1},
   {0.701983, 0.337966, 0.120269, 1},
   {0.705775, 0.341738, 0.118753, 1},
   {0.709533, 0.345543, 0.117243, 1},
   {0.713258, 0.349382, 0.115738, 1},
   {0.71695, 0.353253, 0.11424, 1},
   {0.720608, 0.357157, 0.112751, 1},
   {0.724234, 0.361093, 0.111272, 1},
   {0.727828, 0.365059, 0.109804, 1},
   {0.731389, 0.369057, 0.10835, 1},
   {0.734918, 0.373085, 0.106912, 1},
   {0.738415, 0.377142, 0.105489, 1},
   {0.741881, 0.381229, 0.104085, 1},
   {0.745315, 0.385344, 0.102702, 1},
   {0.748718, 0.389487, 0.101341, 1},
   {0.752091, 0.393659, 0.100004, 1},
   {0.755433, 0.397857, 0.0986932, 1},
   {0.758744, 0.402083, 0.0974113, 1},
   {0.762026, 0.406335, 0.09616, 1},
   {0.765278, 0.410612, 0.0949418, 1},
   {0.7685, 0.414916, 0.0937593, 1},
   {0.771693, 0.419244, 0.0926146, 1},
   {0.774856, 0.423597, 0.0915105, 1},
   {0.777991, 0.427975, 0.0904495, 1},
   {0.781098, 0.432376, 0.0894347, 1},
   {0.784176, 0.436801, 0.0884686, 1},
   {0.787226, 0.44125, 0.087554, 1},
   {0.790249, 0.445721, 0.0866939, 1},
   {0.793243, 0.450214, 0.0858912, 1},
   {0.796211, 0.45473, 0.0851488, 1},
   {0.799151, 0.459268, 0.0844698, 1},
   {0.802064, 0.463827, 0.0838571, 1},
   {0.804951, 0.468407, 0.0833135, 1},
   {0.807811, 0.473009, 0.0828421, 1},
   {0.810645, 0.477631, 0.0824457, 1},
   {0.813453, 0.482273, 0.0821271, 1},
   {0.816236, 0.486935, 0.0818889, 1},
   {0.818992, 0.491618, 0.0817337, 1},
   {0.821724, 0.49632, 0.0816636, 1},
   {0.82443, 0.501041, 0.081681, 1},
   {0.827111, 0.505782, 0.0817882, 1},
   {0.829767, 0.510541, 0.0819867, 1},
   {0.832399, 0.51532, 0.0822781, 1},
   {0.835007, 0.520116, 0.082664, 1},
   {0.83759, 0.524931, 0.0831455, 1},
   {0.840149, 0.529765, 0.0837231, 1},
   {0.842685, 0.534616, 0.0843981, 1},
   {0.845197, 0.539485, 0.0851702, 1},
   {0.847685, 0.544371, 0.0860403, 1},
   {0.85015, 0.549276, 0.0870075, 1},
   {0.852592, 0.554197, 0.0880721, 1},
   {0.855011, 0.559136, 0.0892328, 1},
   {0.857408, 0.564091, 0.0904897, 1},
   {0.859782, 0.569063, 0.0918411, 1},
   {0.862133, 0.574053, 0.0932862, 1},
   {0.864462, 0.579059, 0.0948235, 1},
   {0.866769, 0.584081, 0.0964514, 1},
   {0.869054, 0.58912, 0.0981688, 1},
   {0.871317, 0.594175, 0.0999735, 1},
   {0.873559, 0.599246, 0.101864, 1},
   {0.875779, 0.604333, 0.103838, 1},
   {0.877978, 0.609437, 0.105894, 1},
   {0.880155, 0.614556, 0.10803, 1},
   {0.882312, 0.619691, 0.110244, 1},
   {0.884447, 0.624842, 0.112534, 1},
   {0.886562, 0.630009, 0.114897, 1},
   {0.888656, 0.635191, 0.117333, 1},
   {0.89073, 0.640389, 0.119839, 1},
   {0.892783, 0.645603, 0.122412, 1},
   {0.894816, 0.650832, 0.125052, 1},
   {0.896829, 0.656076, 0.127756, 1},
   {0.898822, 0.661336, 0.130523, 1},
   {0.900795, 0.666611, 0.13335, 1},
   {0.902748, 0.671901, 0.136236, 1},
   {0.904682, 0.677207, 0.13918, 1},
   {0.906596, 0.682528, 0.142179, 1},
   {0.90849, 0.687864, 0.145233, 1},
   {0.910366, 0.693215, 0.148339, 1},
   {0.912222, 0.698581, 0.151497, 1},
   {0.914059, 0.703963, 0.154705, 1},
   {0.915878, 0.70936, 0.157961, 1},
   {0.917677, 0.714772, 0.161265, 1},
   {0.919458, 0.720199, 0.164615, 1},
   {0.92122, 0.725641, 0.16801, 1},
   {0.922964, 0.731099, 0.171449, 1},
   {0.924689, 0.736571, 0.174931, 1},
   {0.926395, 0.742059, 0.178455, 1},
   {0.928084, 0.747562, 0.18202, 1},
   {0.929754, 0.75308, 0.185625, 1},
   {0.931407, 0.758613, 0.18927, 1},
   {0.933041, 0.764162, 0.192952, 1},
   {0.934657, 0.769726, 0.196672, 1},
   {0.936256, 0.775305, 0.200429, 1},
   {0.937837, 0.780899, 0.204223, 1},
   {0.9394, 0.786509, 0.208051, 1},
   {0.940945, 0.792135, 0.211915, 1},
   {0.942474, 0.797775, 0.215813, 1},
   {0.943984, 0.803432, 0.219744, 1},
   {0.945477, 0.809104, 0.223708, 1},
   {0.946953, 0.814791, 0.227705, 1},
   {0.948411, 0.820494, 0.231734, 1},
   {0.949853, 0.826213, 0.235794, 1},
   {0.951277, 0.831948, 0.239885, 1},
   {0.952684, 0.837698, 0.244007, 1},
   {0.954074, 0.843465, 0.248159, 1},
   {0.955446, 0.849247, 0.252341, 1},
   {0.956802, 0.855046, 0.256552, 1},
   {0.958141, 0.860861, 0.260792, 1},
   {0.959463, 0.866692, 0.265061, 1},
   {0.960767, 0.872539, 0.269358, 1},
});

const Palette BPAL_42 = Palette("viola",
{
   {0.111384, 0.0266995, 0.189946, 1},
   {0.116306, 0.0284327, 0.19596, 1},
   {0.121224, 0.0301701, 0.202004, 1},
   {0.12614, 0.031905, 0.208081, 1},
   {0.131052, 0.0336362, 0.21419, 1},
   {0.135964, 0.0353576, 0.220335, 1},
   {0.140873, 0.0370664, 0.226517, 1},
   {0.145779, 0.038759, 0.232738, 1},
   {0.150684, 0.0404308, 0.239, 1},
   {0.155588, 0.0420315, 0.245305, 1},
   {0.16049, 0.0435692, 0.251654, 1},
   {0.165389, 0.0450443, 0.258051, 1},
   {0.170286, 0.0464568, 0.264497, 1},
   {0.17518, 0.0478068, 0.270993, 1},
   {0.180071, 0.0490944, 0.277544, 1},
   {0.184958, 0.0503191, 0.28415, 1},
   {0.18984, 0.0514805, 0.290816, 1},
   {0.194716, 0.0525801, 0.297542, 1},
   {0.199586, 0.0536168, 0.304333, 1},
   {0.204448, 0.0545915, 0.311189, 1},
   {0.209299, 0.0555038, 0.318116, 1},
   {0.214139, 0.0563556, 0.325114, 1},
   {0.218964, 0.0571477, 0.332187, 1},
   {0.223773, 0.0578815, 0.339338, 1},
   {0.228561, 0.0585596, 0.34657, 1},
   {0.233325, 0.059186, 0.353885, 1},
   {0.23806, 0.0597662, 0.361286, 1},
   {0.242762, 0.0603048, 0.368775, 1},
   {0.247422, 0.0608129, 0.376353, 1},
   {0.252033, 0.0613019, 0.38402, 1},
   {0.256587, 0.0617875, 0.391775, 1},
   {0.261071, 0.0622911, 0.399613, 1},
   {0.265474, 0.0628378, 0.407531, 1},
   {0.269778, 0.0634632, 0.415516, 1},
   {0.273968, 0.0642087, 0.423554, 1},
   {0.278022, 0.0651251, 0.431622, 1},
   {0.281921, 0.0662712, 0.439691, 1},
   {0.285641, 0.0677108, 0.447724, 1},
   {0.289162, 0.0695079, 0.455676, 1},
   {0.292466, 0.0717199, 0.463497, 1},
   {0.29554, 0.0743884, 0.471138, 1},
   {0.298381, 0.0775337, 0.478552, 1},
   {0.300988, 0.0811503, 0.485701, 1},
   {0.303372, 0.0852098, 0.492561, 1},
   {0.305546, 0.0896664, 0.499119, 1},
   {0.307525, 0.0944642, 0.505374, 1},
   {0.309329, 0.0995443, 0.511332, 1},
   {0.310975, 0.10485, 0.517008, 1},
   {0.312479, 0.11033, 0.522417, 1},
   {0.313857, 0.115941, 0.52758, 1},
   {0.315122, 0.121645, 0.532514, 1},
   {0.316286, 0.127412, 0.53724, 1},
   {0.317359, 0.133218, 0.541773, 1},
   {0.31835, 0.139044, 0.546131, 1},
   {0.319268, 0.144874, 0.550328, 1},
   {0.320119, 0.150696, 0.554379, 1},
   {0.320909, 0.156502, 0.558295, 1},
   {0.321643, 0.162285, 0.562089, 1},
   {0.322327, 0.168039, 0.56577, 1},
   {0.322964, 0.173761, 0.569347, 1},
   {0.323559, 0.179447, 0.57283, 1},
   {0.324113, 0.185097, 0.576225, 1},
   {0.324631, 0.19071, 0.579539, 1},
   {0.325115, 0.196283, 0.582779, 1},
   {0.325567, 0.201817, 0.58595, 1},
   {0.32599, 0.207313, 0.589058, 1},
   {0.326385, 0.21277, 0.592107, 1},
   {0.326755, 0.21819, 0.595102, 1},
   {0.327101, 0.223572, 0.598047, 1},
   {0.327424, 0.228918, 0.600944, 1},
   {0.327725, 0.234228, 0.603798, 1},
   {0.328008, 0.239504, 0.606613, 1},
   {0.328271, 0.244745, 0.609389, 1},
   {0.328517, 0.249954, 0.612131, 1},
   {0.328746, 0.255132, 0.61484, 1},
   {0.328959, 0.260279, 0.61752, 1},
   {0.329158, 0.265396, 0.620171, 1},
   {0.329342, 0.270484, 0.622796, 1},
   {0.329514, 0.275545, 0.625397, 1},
   {0.329672, 0.280578, 0.627976, 1},
   {0.329819, 0.285586, 0.630533, 1},
   {0.329955, 0.29057, 0.633071, 1},
   {0.33008, 0.295529, 0.635591, 1},
   {0.330195, 0.300465, 0.638093, 1},
   {0.3303, 0.305379, 0.64058, 1},
   {0.330396, 0.310272, 0.643052, 1},
   {0.330483, 0.315144, 0.64551, 1},
   {0.330562, 0.319997, 0.647956, 1},
   {0.330633, 0.324831, 0.65039, 1},
   {0.330696, 0.329646, 0.652812, 1},
   {0.330752, 0.334444, 0.655225, 1},
   {0.330802, 0.339226, 0.657627, 1},
   {0.330844, 0.343991, 0.660021, 1},
   {0.33088, 0.348742, 0.662406, 1},
   {0.33091, 0.353477, 0.664784, 1},
   {0.330935, 0.358199, 0.667154, 1},
   {0.330953, 0.362907, 0.669517, 1},
   {0.330967, 0.367602, 0.671873, 1},
   {0.330975, 0.372286, 0.674224, 1},
   {0.330978, 0.376957, 0.676568, 1},
   {0.330977, 0.381618, 0.678908, 1},
   {0.330971, 0.386268, 0.681242, 1},
   {0.330961, 0.390909, 0.68357, 1},
   {0.330947, 0.395539, 0.685895, 1},
   {0.33093, 0.400161, 0.688214, 1},
   {0.330908, 0.404775, 0.690529, 1},
   {0.330883, 0.40938, 0.69284, 1},
   {0.330855, 0.413978, 0.695146, 1},
   {0.330824, 0.418568, 0.697447, 1},
   {0.330791, 0.423152, 0.699745, 1},
   {0.330755, 0.42773, 0.702038, 1},
   {0.330716, 0.432302, 0.704326, 1},
   {0.330676, 0.436868, 0.706611, 1},
   {0.330635, 0.441429, 0.70889, 1},
   {0.330592, 0.445985, 0.711165, 1},
   {0.330549, 0.450537, 0.713434, 1},
   {0.330505, 0.455085, 0.715699, 1},
   {0.330461, 0.459629, 0.717958, 1},
   {0.330418, 0.46417, 0.720211, 1},
   {0.330376, 0.468707, 0.722458, 1},
   {0.330335, 0.473242, 0.724699, 1},
   {0.330297, 0.477773, 0.726934, 1},
   {0.330261, 0.482303, 0.729161, 1},
   {0.330229, 0.48683, 0.731381, 1},
   {0.330202, 0.491355, 0.733593, 1},
   {0.33018, 0.495879, 0.735796, 1},
   {0.330165, 0.500401, 0.73799, 1},
   {0.330156, 0.504922, 0.740175, 1},
   {0.330157, 0.509441, 0.74235, 1},
   {0.330166, 0.513959, 0.744514, 1},
   {0.330188, 0.518477, 0.746667, 1},
   {0.330221, 0.522993, 0.748807, 1},
   {0.330269, 0.527509, 0.750935, 1},
   {0.330332, 0.532024, 0.753049, 1},
   {0.330414, 0.536538, 0.755149, 1},
   {0.330515, 0.541051, 0.757233, 1},
   {0.330638, 0.545564, 0.759301, 1},
   {0.330785, 0.550076, 0.761352, 1},
   {0.33096, 0.554588, 0.763385, 1},
   {0.331164, 0.559098, 0.765399, 1},
   {0.3314, 0.563607, 0.767393, 1},
   {0.331673, 0.568115, 0.769365, 1},
   {0.331985, 0.572622, 0.771315, 1},
   {0.33234, 0.577127, 0.773241, 1},
   {0.332742, 0.58163, 0.775142, 1},
   {0.333196, 0.586132, 0.777017, 1},
   {0.333706, 0.59063, 0.778864, 1},
   {0.334277, 0.595125, 0.780683, 1},
   {0.334914, 0.599617, 0.78247, 1},
   {0.335624, 0.604105, 0.784226, 1},
   {0.336412, 0.608589, 0.785948, 1},
   {0.337285, 0.613067, 0.787635, 1},
   {0.338249, 0.617539, 0.789285, 1},
   {0.339312, 0.622005, 0.790896, 1},
   {0.340483, 0.626463, 0.792468, 1},
   {0.341768, 0.630912, 0.793998, 1},
   {0.343177, 0.635352, 0.795485, 1},
   {0.344719, 0.639781, 0.796927, 1},
   {0.346402, 0.644198, 0.798322, 1},
   {0.348238, 0.648602, 0.799669, 1},
   {0.350236, 0.652991, 0.800966, 1},
   {0.352407, 0.657363, 0.802213, 1},
   {0.354761, 0.661717, 0.803407, 1},
   {0.357309, 0.666052, 0.804549, 1},
   {0.360062, 0.670364, 0.805638, 1},
   {0.363031, 0.674653, 0.806672, 1},
   {0.366225, 0.678916, 0.807653, 1},
   {0.369654, 0.683151, 0.808581, 1},
   {0.373329, 0.687356, 0.809456, 1},
   {0.377256, 0.691529, 0.810281, 1},
   {0.381442, 0.695667, 0.811057, 1},
   {0.385892, 0.699768, 0.811788, 1},
   {0.390611, 0.703831, 0.812478, 1},
   {0.395599, 0.707854, 0.81313, 1},
   {0.400855, 0.711835, 0.81375, 1},
   {0.406376, 0.715773, 0.814345, 1},
   {0.412156, 0.719668, 0.814919, 1},
   {0.418188, 0.723517, 0.815481, 1},
   {0.42446, 0.727322, 0.816038, 1},
   {0.430961, 0.731083, 0.816596, 1},
   {0.437675, 0.7348, 0.817164, 1},
   {0.444588, 0.738475, 0.817749, 1},
   {0.451682, 0.742108, 0.818358, 1},
   {0.458941, 0.745703, 0.818998, 1},
   {0.466347, 0.74926, 0.819674, 1},
   {0.473882, 0.752782, 0.820393, 1},
   {0.48153, 0.756272, 0.821159, 1},
   {0.489276, 0.759731, 0.821977, 1},
   {0.497103, 0.763163, 0.822849, 1},
   {0.504998, 0.76657, 0.823779, 1},
   {0.512948, 0.769954, 0.82477, 1},
   {0.520942, 0.773318, 0.825822, 1},
   {0.52897, 0.776664, 0.826937, 1},
   {0.537021, 0.779995, 0.828116, 1},
   {0.545087, 0.783313, 0.829359, 1},
   {0.553163, 0.786619, 0.830667, 1},
   {0.56124, 0.789916, 0.832039, 1},
   {0.569314, 0.793206, 0.833476, 1},
   {0.577381, 0.796489, 0.834976, 1},
   {0.585435, 0.799768, 0.836539, 1},
   {0.593475, 0.803044, 0.838164, 1},
   {0.601496, 0.806319, 0.83985, 1},
   {0.609498, 0.809594, 0.841596, 1},
   {0.617476, 0.812869, 0.843403, 1},
   {0.625431, 0.816147, 0.845267, 1},
   {0.633361, 0.819427, 0.847189, 1},
   {0.641265, 0.822712, 0.849167, 1},
   {0.649142, 0.826002, 0.851201, 1},
   {0.656992, 0.829297, 0.853289, 1},
   {0.664814, 0.832599, 0.85543, 1},
   {0.672609, 0.835909, 0.857624, 1},
   {0.680375, 0.839226, 0.859869, 1},
   {0.688114, 0.842553, 0.862165, 1},
   {0.695825, 0.845888, 0.86451, 1},
   {0.703508, 0.849234, 0.866905, 1},
   {0.711165, 0.85259, 0.869347, 1},
   {0.718794, 0.855957, 0.871836, 1},
   {0.726397, 0.859335, 0.874372, 1},
   {0.733974, 0.862725, 0.876954, 1},
   {0.741526, 0.866128, 0.87958, 1},
   {0.749052, 0.869544, 0.882251, 1},
   {0.756554, 0.872973, 0.884965, 1},
   {0.764032, 0.876416, 0.887722, 1},
   {0.771485, 0.879873, 0.890521, 1},
   {0.778917, 0.883344, 0.893362, 1},
   {0.786325, 0.88683, 0.896245, 1},
   {0.793711, 0.890331, 0.899168, 1},
   {0.801076, 0.893848, 0.902131, 1},
   {0.80842, 0.897381, 0.905134, 1},
   {0.815744, 0.900929, 0.908176, 1},
   {0.823047, 0.904495, 0.911257, 1},
   {0.83033, 0.908077, 0.914376, 1},
   {0.837595, 0.911677, 0.917533, 1},
   {0.844841, 0.915294, 0.920728, 1},
   {0.852069, 0.918928, 0.92396, 1},
   {0.859278, 0.922581, 0.927229, 1},
   {0.866471, 0.926253, 0.930535, 1},
   {0.873646, 0.929943, 0.933877, 1},
   {0.880804, 0.933652, 0.937254, 1},
   {0.887946, 0.93738, 0.940668, 1},
   {0.895072, 0.941129, 0.944117, 1},
   {0.902181, 0.944897, 0.947601, 1},
   {0.909275, 0.948686, 0.951121, 1},
   {0.916352, 0.952495, 0.954675, 1},
   {0.923415, 0.956326, 0.958264, 1},
   {0.930461, 0.960179, 0.961888, 1},
   {0.937492, 0.964053, 0.965546, 1},
   {0.944507, 0.967949, 0.969238, 1},
   {0.951506, 0.971869, 0.972965, 1},
   {0.958488, 0.975812, 0.976725, 1},
   {0.965454, 0.979779, 0.98052, 1},
   {0.972402, 0.983771, 0.984348, 1},
   {0.979332, 0.987788, 0.988211, 1},
   {0.986243, 0.991831, 0.992107, 1},
   {0.993133, 0.995902, 0.996036, 1},
   {1, 1, 1, 1},
   {0.996513, 0.994573, 0.996053, 1},
   {0.992953, 0.989197, 0.99212, 1},
   {0.989324, 0.983869, 0.988222, 1},
   {0.985637, 0.978583, 0.984382, 1},
   {0.981908, 0.973329, 0.980619, 1},
   {0.97816, 0.968099, 0.976942, 1},
   {0.974415, 0.962881, 0.973356, 1},
   {0.970693, 0.957668, 0.969856, 1},
   {0.967008, 0.952456, 0.966435, 1},
   {0.963372, 0.947241, 0.963085, 1},
   {0.95979, 0.94202, 0.959796, 1},
   {0.956263, 0.936793, 0.95656, 1},
   {0.952794, 0.931561, 0.953372, 1},
   {0.949381, 0.926324, 0.950226, 1},
   {0.946024, 0.921082, 0.947119, 1},
   {0.942719, 0.915836, 0.944046, 1},
   {0.939465, 0.910587, 0.941005, 1},
   {0.936261, 0.905335, 0.937995, 1},
   {0.933104, 0.900082, 0.935013, 1},
   {0.929993, 0.894827, 0.93206, 1},
   {0.926926, 0.889572, 0.929132, 1},
   {0.923902, 0.884315, 0.926231, 1},
   {0.920919, 0.879058, 0.923354, 1},
   {0.917978, 0.873801, 0.920502, 1},
   {0.915074, 0.868544, 0.917674, 1},
   {0.91221, 0.863287, 0.914869, 1},
   {0.909381, 0.85803, 0.912087, 1},
   {0.906591, 0.852774, 0.909328, 1},
   {0.903835, 0.847517, 0.90659, 1},
   {0.901115, 0.842261, 0.903875, 1},
   {0.898428, 0.837005, 0.901182, 1},
   {0.895776, 0.831749, 0.898509, 1},
   {0.893157, 0.826493, 0.895858, 1},
   {0.89057, 0.821237, 0.893227, 1},
   {0.888017, 0.815981, 0.890617, 1},
   {0.885495, 0.810724, 0.888027, 1},
   {0.883003, 0.805467, 0.885457, 1},
   {0.880544, 0.800209, 0.882907, 1},
   {0.878115, 0.794951, 0.880376, 1},
   {0.875716, 0.789691, 0.877864, 1},
   {0.873347, 0.78443, 0.875371, 1},
   {0.871008, 0.779167, 0.872897, 1},
   {0.868698, 0.773903, 0.870441, 1},
   {0.866418, 0.768636, 0.868003, 1},
   {0.864166, 0.763367, 0.865583, 1},
   {0.861943, 0.758096, 0.863181, 1},
   {0.859748, 0.752823, 0.860795, 1},
   {0.857581, 0.747546, 0.858427, 1},
   {0.855443, 0.742265, 0.856075, 1},
   {0.853331, 0.736981, 0.85374, 1},
   {0.851247, 0.731693, 0.85142, 1},
   {0.84919, 0.726401, 0.849116, 1},
   {0.847161, 0.721104, 0.846828, 1},
   {0.845158, 0.715802, 0.844555, 1},
   {0.843182, 0.710495, 0.842297, 1},
   {0.841232, 0.705183, 0.840053, 1},
   {0.839309, 0.699864, 0.837823, 1},
   {0.837411, 0.694539, 0.835607, 1},
   {0.835539, 0.689207, 0.833404, 1},
   {0.833693, 0.683868, 0.831214, 1},
   {0.831873, 0.678521, 0.829036, 1},
   {0.830078, 0.673167, 0.826871, 1},
   {0.828308, 0.667804, 0.824717, 1},
   {0.826563, 0.662432, 0.822574, 1},
   {0.824842, 0.65705, 0.820443, 1},
   {0.823147, 0.65166, 0.818321, 1},
   {0.821475, 0.646259, 0.816209, 1},
   {0.819828, 0.640847, 0.814106, 1},
   {0.818206, 0.635423, 0.812012, 1},
   {0.816608, 0.629988, 0.809926, 1},
   {0.815033, 0.624541, 0.807848, 1},
   {0.813481, 0.619082, 0.805776, 1},
   {0.811953, 0.613608, 0.803711, 1},
   {0.810449, 0.608121, 0.801652, 1},
   {0.808967, 0.602619, 0.799597, 1},
   {0.807508, 0.597103, 0.797546, 1},
   {0.806072, 0.59157, 0.795499, 1},
   {0.804659, 0.586022, 0.793454, 1},
   {0.803267, 0.580456, 0.791411, 1},
   {0.801898, 0.574873, 0.789369, 1},
   {0.800551, 0.569272, 0.787327, 1},
   {0.799225, 0.563651, 0.785284, 1},
   {0.797921, 0.558011, 0.783238, 1},
   {0.796637, 0.552351, 0.781189, 1},
   {0.795375, 0.546669, 0.779136, 1},
   {0.794133, 0.540966, 0.777078, 1},
   {0.792912, 0.535241, 0.775012, 1},
   {0.791711, 0.529491, 0.772939, 1},
   {0.790529, 0.523718, 0.770855, 1},
   {0.789367, 0.51792, 0.768761, 1},
   {0.788224, 0.512096, 0.766654, 1},
   {0.787099, 0.506246, 0.764533, 1},
   {0.785993, 0.500368, 0.762395, 1},
   {0.784905, 0.494462, 0.76024, 1},
   {0.783834, 0.488527, 0.758064, 1},
   {0.78278, 0.482562, 0.755867, 1},
   {0.781742, 0.476567, 0.753645, 1},
   {0.780721, 0.470539, 0.751397, 1},
   {0.779714, 0.46448, 0.749119, 1},
   {0.778721, 0.458388, 0.74681, 1},
   {0.777742, 0.452261, 0.744466, 1},
   {0.776777, 0.4461, 0.742084, 1},
   {0.775823, 0.439904, 0.739662, 1},
   {0.77488, 0.433672, 0.737195, 1},
   {0.773947, 0.427403, 0.734681, 1},
   {0.773023, 0.421098, 0.732116, 1},
   {0.772107, 0.414755, 0.729495, 1},
   {0.771196, 0.408375, 0.726814, 1},
   {0.77029, 0.401957, 0.72407, 1},
   {0.769387, 0.395502, 0.721257, 1},
   {0.768485, 0.38901, 0.71837, 1},
   {0.767582, 0.382481, 0.715405, 1},
   {0.766676, 0.375916, 0.712355, 1},
   {0.765763, 0.369316, 0.709216, 1},
   {0.764843, 0.362683, 0.705982, 1},
   {0.76391, 0.356018, 0.702647, 1},
   {0.762963, 0.349324, 0.699205, 1},
   {0.761998, 0.342604, 0.695649, 1},
   {0.761011, 0.33586, 0.691974, 1},
   {0.759998, 0.329097, 0.688174, 1},
   {0.758955, 0.322318, 0.684242, 1},
   {0.757876, 0.31553, 0.680173, 1},
   {0.756758, 0.308738, 0.675962, 1},
   {0.755595, 0.301947, 0.671604, 1},
   {0.754383, 0.295165, 0.667095, 1},
   {0.753115, 0.2884, 0.66243, 1},
   {0.751786, 0.281658, 0.657608, 1},
   {0.750392, 0.274949, 0.652627, 1},
   {0.748928, 0.26828, 0.647486, 1},
   {0.747387, 0.261661, 0.642186, 1},
   {0.745767, 0.255099, 0.636729, 1},
   {0.744062, 0.248604, 0.631117, 1},
   {0.74227, 0.242182, 0.625354, 1},
   {0.740387, 0.235842, 0.619445, 1},
   {0.738412, 0.229591, 0.613397, 1},
   {0.736341, 0.223434, 0.607216, 1},
   {0.734175, 0.217376, 0.60091, 1},
   {0.731913, 0.211423, 0.594487, 1},
   {0.729555, 0.205578, 0.587954, 1},
   {0.727102, 0.199844, 0.581321, 1},
   {0.724554, 0.194222, 0.574596, 1},
   {0.721914, 0.188714, 0.567788, 1},
   {0.719182, 0.183321, 0.560904, 1},
   {0.716362, 0.178043, 0.553954, 1},
   {0.713455, 0.172878, 0.546945, 1},
   {0.710465, 0.167827, 0.539885, 1},
   {0.707393, 0.162888, 0.53278, 1},
   {0.704242, 0.158059, 0.525637, 1},
   {0.701015, 0.153339, 0.518463, 1},
   {0.697715, 0.148725, 0.511264, 1},
   {0.694345, 0.144216, 0.504044, 1},
   {0.690906, 0.139809, 0.49681, 1},
   {0.687402, 0.135503, 0.489565, 1},
   {0.683834, 0.131295, 0.482314, 1},
   {0.680205, 0.127184, 0.475062, 1},
   {0.676518, 0.123167, 0.467812, 1},
   {0.672774, 0.119243, 0.460568, 1},
   {0.668975, 0.115409, 0.453333, 1},
   {0.665124, 0.111665, 0.446109, 1},
   {0.661221, 0.108009, 0.438901, 1},
   {0.657269, 0.10444, 0.431709, 1},
   {0.653269, 0.100957, 0.424538, 1},
   {0.649222, 0.0975588, 0.41739, 1},
   {0.64513, 0.0942451, 0.410265, 1},
   {0.640994, 0.0910154, 0.403168, 1},
   {0.636815, 0.0878697, 0.396098, 1},
   {0.632594, 0.084808, 0.38906, 1},
   {0.628332, 0.0818307, 0.382054, 1},
   {0.624029, 0.0789384, 0.375081, 1},
   {0.619687, 0.0761319, 0.368145, 1},
   {0.615307, 0.0734123, 0.361246, 1},
   {0.610887, 0.0707809, 0.354387, 1},
   {0.606431, 0.0682393, 0.347568, 1},
   {0.601936, 0.0657895, 0.340791, 1},
   {0.597405, 0.0634334, 0.334059, 1},
   {0.592837, 0.0611733, 0.327372, 1},
   {0.588232, 0.0590117, 0.320733, 1},
   {0.583591, 0.0569514, 0.314143, 1},
   {0.578913, 0.054995, 0.307604, 1},
   {0.5742, 0.0531455, 0.301118, 1},
   {0.569449, 0.0514059, 0.294686, 1},
   {0.564662, 0.0497789, 0.288311, 1},
   {0.559839, 0.0482675, 0.281994, 1},
   {0.554978, 0.0468742, 0.275738, 1},
   {0.55008, 0.0456016, 0.269546, 1},
   {0.545145, 0.0444516, 0.263419, 1},
   {0.540172, 0.043426, 0.25736, 1},
   {0.535161, 0.0425257, 0.251372, 1},
   {0.530112, 0.0417513, 0.245457, 1},
   {0.525023, 0.0411026, 0.239619, 1},
   {0.519896, 0.0405785, 0.23386, 1},
   {0.514728, 0.0401731, 0.228185, 1},
   {0.509521, 0.0398886, 0.222596, 1},
   {0.504274, 0.0397224, 0.217097, 1},
   {0.498986, 0.0396687, 0.211692, 1},
   {0.493657, 0.0397217, 0.206385, 1},
   {0.488288, 0.039875, 0.201179, 1},
   {0.482879, 0.0401218, 0.196078, 1},
   {0.47743, 0.0404548, 0.191088, 1},
   {0.471941, 0.040858, 0.18621, 1},
   {0.466413, 0.0413265, 0.18145, 1},
   {0.460847, 0.0418505, 0.176811, 1},
   {0.455244, 0.0424193, 0.172295, 1},
   {0.449607, 0.0430223, 0.167906, 1},
   {0.443935, 0.0436486, 0.163646, 1},
   {0.438232, 0.0442876, 0.159516, 1},
   {0.4325, 0.0449288, 0.155518, 1},
   {0.426741, 0.0455621, 0.151652, 1},
   {0.420958, 0.0461778, 0.147917, 1},
   {0.415153, 0.0467671, 0.144313, 1},
   {0.409329, 0.0473218, 0.140836, 1},
   {0.403489, 0.0478344, 0.137485, 1},
   {0.397635, 0.0482986, 0.134256, 1},
   {0.391771, 0.0487086, 0.131144, 1},
   {0.385899, 0.0490598, 0.128146, 1},
   {0.380022, 0.049348, 0.125256, 1},
   {0.374142, 0.0495704, 0.122469, 1},
   {0.36826, 0.0497247, 0.119779, 1},
   {0.362379, 0.049809, 0.117181, 1},
   {0.3565, 0.0498221, 0.114668, 1},
   {0.350626, 0.0497638, 0.112235, 1},
   {0.344757, 0.0496336, 0.109877, 1},
   {0.338894, 0.0494318, 0.107588, 1},
   {0.333039, 0.0491588, 0.105361, 1},
   {0.327191, 0.0488154, 0.103193, 1},
   {0.321353, 0.0484026, 0.101078, 1},
   {0.315523, 0.0479213, 0.0990101, 1},
   {0.309704, 0.0473722, 0.0969858, 1},
   {0.303894, 0.0467573, 0.0950006, 1},
   {0.298094, 0.046077, 0.0930498, 1},
   {0.292304, 0.0453329, 0.0911297, 1},
   {0.286524, 0.0445263, 0.0892364, 1},
   {0.280754, 0.0436583, 0.0873662, 1},
   {0.274993, 0.0427298, 0.0855157, 1},
   {0.269242, 0.0417418, 0.0836816, 1},
   {0.2635, 0.0406954, 0.0818606, 1},
   {0.257767, 0.0395824, 0.0800499, 1},
   {0.252042, 0.0384269, 0.0782466, 1},
   {0.246325, 0.0372374, 0.0764482, 1},
   {0.240616, 0.0360173, 0.0746518, 1},
   {0.234913, 0.0347695, 0.0728549, 1},
   {0.229216, 0.0334984, 0.0710553, 1},
   {0.223525, 0.0322065, 0.0692504, 1},
   {0.217838, 0.030898, 0.0674383, 1},
   {0.212156, 0.0295752, 0.0656162, 1},
   {0.206477, 0.0282423, 0.0637826, 1},
   {0.2008, 0.0269023, 0.0619351, 1},
   {0.195126, 0.0255579, 0.0600714, 1},
   {0.189451, 0.0242126, 0.0581897, 1},
   {0.183777, 0.0228696, 0.056288, 1},
   {0.1781, 0.0215317, 0.0543642, 1},
   {0.172422, 0.0202021, 0.0524161, 1},
   {0.166739, 0.0188837, 0.0504418, 1},
   {0.161051, 0.0175793, 0.048439, 1},
   {0.155356, 0.016292, 0.0464056, 1},
});

const Palette BPAL_43 = Palette("pride",
{
   {0.0875279, 0.0544501, 0.156334, 1},
   {0.092047, 0.0563932, 0.162039, 1},
   {0.0965089, 0.0582961, 0.167869, 1},
   {0.100909, 0.0601633, 0.173825, 1},
   {0.10524, 0.062, 0.179908, 1},
   {0.109498, 0.063812, 0.186117, 1},
   {0.113674, 0.0656057, 0.192451, 1},
   {0.117762, 0.0673882, 0.198907, 1},
   {0.121754, 0.0691672, 0.205478, 1},
   {0.125644, 0.0709512, 0.212159, 1},
   {0.129423, 0.0727489, 0.218942, 1},
   {0.133084, 0.0745692, 0.225815, 1},
   {0.136622, 0.0764216, 0.232769, 1},
   {0.14003, 0.0783153, 0.239789, 1},
   {0.143301, 0.0802594, 0.246861, 1},
   {0.146433, 0.0822624, 0.253972, 1},
   {0.14942, 0.0843326, 0.261106, 1},
   {0.152259, 0.0864773, 0.268248, 1},
   {0.154948, 0.088703, 0.275382, 1},
   {0.157486, 0.0910153, 0.282494, 1},
   {0.159869, 0.0934188, 0.28957, 1},
   {0.162099, 0.0959172, 0.296595, 1},
   {0.164175, 0.0985131, 0.303559, 1},
   {0.166097, 0.101208, 0.310448, 1},
   {0.167866, 0.104003, 0.317252, 1},
   {0.169484, 0.106898, 0.323962, 1},
   {0.17095, 0.109892, 0.330567, 1},
   {0.172267, 0.112984, 0.337062, 1},
   {0.173437, 0.116171, 0.343437, 1},
   {0.174461, 0.11945, 0.349688, 1},
   {0.175341, 0.12282, 0.355808, 1},
   {0.176079, 0.126276, 0.361793, 1},
   {0.176677, 0.129815, 0.367639, 1},
   {0.177138, 0.133433, 0.373341, 1},
   {0.177464, 0.137125, 0.378898, 1},
   {0.177658, 0.140888, 0.384306, 1},
   {0.177721, 0.144717, 0.389565, 1},
   {0.177657, 0.148608, 0.394671, 1},
   {0.177468, 0.152556, 0.399625, 1},
   {0.177157, 0.156558, 0.404426, 1},
   {0.176728, 0.160608, 0.409073, 1},
   {0.176182, 0.164703, 0.413567, 1},
   {0.175524, 0.168839, 0.417908, 1},
   {0.174757, 0.173011, 0.422096, 1},
   {0.173883, 0.177216, 0.426134, 1},
   {0.172907, 0.18145, 0.430022, 1},
   {0.171832, 0.185709, 0.433761, 1},
   {0.170663, 0.189989, 0.437354, 1},
   {0.169402, 0.194288, 0.440802, 1},
   {0.168055, 0.198602, 0.444107, 1},
   {0.166625, 0.202928, 0.447273, 1},
   {0.165118, 0.207262, 0.450301, 1},
   {0.163538, 0.211603, 0.453194, 1},
   {0.161889, 0.215948, 0.455955, 1},
   {0.160178, 0.220293, 0.458587, 1},
   {0.158409, 0.224637, 0.461093, 1},
   {0.156588, 0.228977, 0.463475, 1},
   {0.15472, 0.233311, 0.465738, 1},
   {0.152813, 0.237638, 0.467885, 1},
   {0.150871, 0.241955, 0.469918, 1},
   {0.148903, 0.246261, 0.471842, 1},
   {0.146913, 0.250554, 0.473659, 1},
   {0.144911, 0.254833, 0.475373, 1},
   {0.142903, 0.259096, 0.476988, 1},
   {0.140896, 0.263342, 0.478508, 1},
   {0.138899, 0.267571, 0.479934, 1},
   {0.136921, 0.27178, 0.481273, 1},
   {0.134969, 0.275969, 0.482525, 1},
   {0.133052, 0.280138, 0.483696, 1},
   {0.13118, 0.284285, 0.484789, 1},
   {0.129362, 0.28841, 0.485806, 1},
   {0.127608, 0.292512, 0.486752, 1},
   {0.125926, 0.296592, 0.48763, 1},
   {0.124327, 0.300648, 0.488442, 1},
   {0.12282, 0.30468, 0.489192, 1},
   {0.121416, 0.308688, 0.489883, 1},
   {0.120124, 0.312672, 0.490519, 1},
   {0.118953, 0.316632, 0.491102, 1},
   {0.117913, 0.320568, 0.491635, 1},
   {0.117013, 0.324479, 0.492121, 1},
   {0.116259, 0.328366, 0.492562, 1},
   {0.115661, 0.332229, 0.492962, 1},
   {0.115225, 0.336067, 0.493323, 1},
   {0.114957, 0.339882, 0.493648, 1},
   {0.114862, 0.343674, 0.493938, 1},
   {0.114945, 0.347442, 0.494197, 1},
   {0.115208, 0.351187, 0.494426, 1},
   {0.115653, 0.354909, 0.494628, 1},
   {0.116282, 0.358609, 0.494805, 1},
   {0.117095, 0.362287, 0.494958, 1},
   {0.118089, 0.365944, 0.49509, 1},
   {0.119263, 0.369579, 0.495203, 1},
   {0.120614, 0.373194, 0.495298, 1},
   {0.122137, 0.376788, 0.495376, 1},
   {0.123829, 0.380363, 0.495441, 1},
   {0.125683, 0.383918, 0.495492, 1},
   {0.127694, 0.387455, 0.495532, 1},
   {0.129855, 0.390973, 0.495561, 1},
   {0.13216, 0.394474, 0.495581, 1},
   {0.134601, 0.397957, 0.495594, 1},
   {0.137173, 0.401424, 0.4956, 1},
   {0.139867, 0.404874, 0.4956, 1},
   {0.142676, 0.408309, 0.495595, 1},
   {0.145594, 0.411729, 0.495587, 1},
   {0.148615, 0.415134, 0.495576, 1},
   {0.15173, 0.418525, 0.495562, 1},
   {0.154934, 0.421902, 0.495547, 1},
   {0.158221, 0.425267, 0.495531, 1},
   {0.161584, 0.428619, 0.495514, 1},
   {0.165018, 0.43196, 0.495498, 1},
   {0.168518, 0.435289, 0.495482, 1},
   {0.172079, 0.438607, 0.495466, 1},
   {0.175695, 0.441915, 0.495452, 1},
   {0.179363, 0.445213, 0.49544, 1},
   {0.183077, 0.448501, 0.495428, 1},
   {0.186835, 0.451781, 0.495419, 1},
   {0.190632, 0.455053, 0.495411, 1},
   {0.194464, 0.458317, 0.495405, 1},
   {0.19833, 0.461574, 0.4954, 1},
   {0.202225, 0.464823, 0.495397, 1},
   {0.206147, 0.468067, 0.495395, 1},
   {0.210093, 0.471304, 0.495395, 1},
   {0.214062, 0.474536, 0.495395, 1},
   {0.218051, 0.477763, 0.495396, 1},
   {0.222057, 0.480985, 0.495397, 1},
   {0.22608, 0.484203, 0.495398, 1},
   {0.230118, 0.487417, 0.495398, 1},
   {0.234168, 0.490628, 0.495397, 1},
   {0.238231, 0.493836, 0.495394, 1},
   {0.242305, 0.497041, 0.495388, 1},
   {0.246388, 0.500243, 0.495379, 1},
   {0.25048, 0.503444, 0.495367, 1},
   {0.254581, 0.506642, 0.49535, 1},
   {0.258689, 0.50984, 0.495327, 1},
   {0.262804, 0.513036, 0.495298, 1},
   {0.266926, 0.516231, 0.495262, 1},
   {0.271055, 0.519426, 0.495218, 1},
   {0.27519, 0.52262, 0.495166, 1},
   {0.279331, 0.525814, 0.495103, 1},
   {0.283478, 0.529008, 0.495029, 1},
   {0.287632, 0.532203, 0.494943, 1},
   {0.291793, 0.535397, 0.494845, 1},
   {0.29596, 0.538592, 0.494732, 1},
   {0.300136, 0.541788, 0.494604, 1},
   {0.304319, 0.544984, 0.494459, 1},
   {0.30851, 0.548181, 0.494298, 1},
   {0.312711, 0.551379, 0.494117, 1},
   {0.316921, 0.554578, 0.493917, 1},
   {0.321142, 0.557778, 0.493696, 1},
   {0.325374, 0.560979, 0.493453, 1},
   {0.329619, 0.56418, 0.493186, 1},
   {0.333876, 0.567383, 0.492895, 1},
   {0.338148, 0.570586, 0.492578, 1},
   {0.342435, 0.57379, 0.492235, 1},
   {0.346739, 0.576994, 0.491863, 1},
   {0.351059, 0.580199, 0.491462, 1},
   {0.355399, 0.583405, 0.491031, 1},
   {0.359758, 0.58661, 0.490569, 1},
   {0.364137, 0.589816, 0.490075, 1},
   {0.368539, 0.593022, 0.489546, 1},
   {0.372964, 0.596227, 0.488984, 1},
   {0.377413, 0.599432, 0.488385, 1},
   {0.381888, 0.602636, 0.48775, 1},
   {0.38639, 0.605839, 0.487078, 1},
   {0.390919, 0.609041, 0.486367, 1},
   {0.395478, 0.612241, 0.485617, 1},
   {0.400067, 0.61544, 0.484827, 1},
   {0.404688, 0.618637, 0.483996, 1},
   {0.409342, 0.621831, 0.483123, 1},
   {0.414029, 0.625024, 0.482208, 1},
   {0.41875, 0.628213, 0.48125, 1},
   {0.423508, 0.631399, 0.480247, 1},
   {0.428302, 0.634582, 0.4792, 1},
   {0.433135, 0.637761, 0.478108, 1},
   {0.438005, 0.640937, 0.476971, 1},
   {0.442915, 0.644108, 0.475788, 1},
   {0.447865, 0.647274, 0.474558, 1},
   {0.452857, 0.650436, 0.47328, 1},
   {0.45789, 0.653593, 0.471955, 1},
   {0.462966, 0.656744, 0.470581, 1},
   {0.468084, 0.65989, 0.46916, 1},
   {0.473246, 0.66303, 0.46769, 1},
   {0.478452, 0.666164, 0.466171, 1},
   {0.483703, 0.669291, 0.464602, 1},
   {0.488999, 0.672412, 0.462984, 1},
   {0.49434, 0.675526, 0.461315, 1},
   {0.499727, 0.678632, 0.459597, 1},
   {0.505159, 0.681731, 0.457828, 1},
   {0.510638, 0.684823, 0.456008, 1},
   {0.516163, 0.687907, 0.454137, 1},
   {0.521735, 0.690983, 0.452214, 1},
   {0.527353, 0.69405, 0.45024, 1},
   {0.533018, 0.697109, 0.448214, 1},
   {0.53873, 0.70016, 0.446137, 1},
   {0.544489, 0.703202, 0.444006, 1},
   {0.550294, 0.706234, 0.441823, 1},
   {0.556146, 0.709258, 0.439588, 1},
   {0.562044, 0.712272, 0.4373, 1},
   {0.567989, 0.715277, 0.434958, 1},
   {0.57398, 0.718273, 0.432562, 1},
   {0.580018, 0.721259, 0.430111, 1},
   {0.586101, 0.724235, 0.427606, 1},
   {0.592231, 0.7272, 0.425046, 1},
   {0.598406, 0.730156, 0.42243, 1},
   {0.604626, 0.733102, 0.419759, 1},
   {0.610891, 0.736038, 0.417032, 1},
   {0.617202, 0.738963, 0.414247, 1},
   {0.623557, 0.741877, 0.411404, 1},
   {0.629957, 0.744781, 0.408503, 1},
   {0.6364, 0.747675, 0.405543, 1},
   {0.642887, 0.750558, 0.402524, 1},
   {0.649419, 0.75343, 0.399444, 1},
   {0.655994, 0.756291, 0.396301, 1},
   {0.662611, 0.759141, 0.393097, 1},
   {0.669271, 0.76198, 0.38983, 1},
   {0.675974, 0.764809, 0.386497, 1},
   {0.68272, 0.767626, 0.383097, 1},
   {0.689506, 0.770432, 0.379633, 1},
   {0.696335, 0.773226, 0.376099, 1},
   {0.703206, 0.77601, 0.372494, 1},
   {0.710117, 0.778782, 0.368819, 1},
   {0.717069, 0.781543, 0.365071, 1},
   {0.724063, 0.784292, 0.361246, 1},
   {0.731096, 0.78703, 0.357345, 1},
   {0.73817, 0.789757, 0.353364, 1},
   {0.745284, 0.792471, 0.349301, 1},
   {0.752437, 0.795175, 0.345155, 1},
   {0.75963, 0.797867, 0.340922, 1},
   {0.766863, 0.800546, 0.336597, 1},
   {0.774133, 0.803215, 0.332182, 1},
   {0.781444, 0.805871, 0.327668, 1},
   {0.788793, 0.808516, 0.323055, 1},
   {0.79618, 0.811149, 0.318337, 1},
   {0.803607, 0.81377, 0.313509, 1},
   {0.811071, 0.816379, 0.30857, 1},
   {0.818574, 0.818976, 0.303509, 1},
   {0.826113, 0.821562, 0.298326, 1},
   {0.833692, 0.824135, 0.293009, 1},
   {0.841308, 0.826696, 0.287555, 1},
   {0.848961, 0.829244, 0.281953, 1},
   {0.856652, 0.831781, 0.276196, 1},
   {0.86438, 0.834305, 0.270275, 1},
   {0.872146, 0.836817, 0.264175, 1},
   {0.879948, 0.839317, 0.257889, 1},
   {0.887788, 0.841804, 0.251398, 1},
   {0.895665, 0.844279, 0.244689, 1},
   {0.903579, 0.846741, 0.23774, 1},
   {0.911529, 0.849191, 0.230535, 1},
   {0.919517, 0.851628, 0.223043, 1},
   {0.927541, 0.854052, 0.215238, 1},
   {0.935602, 0.856464, 0.207084, 1},
   {0.9437, 0.858862, 0.198538, 1},
   {0.951834, 0.861248, 0.189549, 1},
   {0.960006, 0.863621, 0.180051, 1},
   {0.968214, 0.865981, 0.169965, 1},
   {0.97646, 0.868327, 0.159177, 1},
   {0.976779, 0.862386, 0.155111, 1},
   {0.97706, 0.856459, 0.15107, 1},
   {0.977303, 0.850545, 0.147055, 1},
   {0.977509, 0.844644, 0.143066, 1},
   {0.977678, 0.838756, 0.139106, 1},
   {0.97781, 0.832881, 0.135175, 1},
   {0.977906, 0.827018, 0.131276, 1},
   {0.977966, 0.821169, 0.12741, 1},
   {0.977991, 0.815331, 0.123579, 1},
   {0.977979, 0.809507, 0.119784, 1},
   {0.977933, 0.803695, 0.116029, 1},
   {0.977852, 0.797895, 0.112316, 1},
   {0.977735, 0.792107, 0.108647, 1},
   {0.977584, 0.786332, 0.105026, 1},
   {0.977399, 0.780569, 0.101454, 1},
   {0.97718, 0.774818, 0.0979368, 1},
   {0.976926, 0.76908, 0.0944766, 1},
   {0.976639, 0.763353, 0.0910778, 1},
   {0.976318, 0.757639, 0.0877449, 1},
   {0.975963, 0.751936, 0.0844825, 1},
   {0.975575, 0.746246, 0.0812957, 1},
   {0.975153, 0.740568, 0.0781901, 1},
   {0.974698, 0.734901, 0.0751715, 1},
   {0.97421, 0.729247, 0.0722466, 1},
   {0.97369, 0.723604, 0.0694222, 1},
   {0.973136, 0.717974, 0.0667052, 1},
   {0.972549, 0.712355, 0.0641031, 1},
   {0.97193, 0.706749, 0.0616239, 1},
   {0.971278, 0.701154, 0.0592756, 1},
   {0.970593, 0.695572, 0.0570672, 1},
   {0.969876, 0.690001, 0.055007, 1},
   {0.969127, 0.684443, 0.053103, 1},
   {0.968345, 0.678896, 0.0513632, 1},
   {0.96753, 0.673362, 0.0497955, 1},
   {0.966684, 0.667839, 0.0484082, 1},
   {0.965805, 0.662329, 0.0472061, 1},
   {0.964894, 0.656831, 0.0461945, 1},
   {0.963951, 0.651345, 0.0453783, 1},
   {0.962976, 0.645871, 0.0447602, 1},
   {0.961969, 0.640409, 0.0443399, 1},
   {0.96093, 0.63496, 0.0441182, 1},
   {0.959859, 0.629523, 0.0440931, 1},
   {0.958756, 0.624098, 0.0442594, 1},
   {0.957621, 0.618686, 0.0446138, 1},
   {0.956454, 0.613286, 0.0451486, 1},
   {0.955256, 0.607899, 0.0458558, 1},
   {0.954026, 0.602524, 0.0467287, 1},
   {0.952763, 0.597162, 0.0477554, 1},
   {0.95147, 0.591812, 0.0489289, 1},
   {0.950145, 0.586475, 0.0502368, 1},
   {0.948788, 0.581151, 0.0516707, 1},
   {0.947399, 0.57584, 0.0532196, 1},
   {0.945979, 0.570541, 0.0548746, 1},
   {0.944527, 0.565256, 0.0566254, 1},
   {0.943044, 0.559984, 0.0584642, 1},
   {0.941529, 0.554724, 0.060381, 1},
   {0.939983, 0.549478, 0.0623701, 1},
   {0.938406, 0.544245, 0.0644216, 1},
   {0.936797, 0.539025, 0.0665308, 1},
   {0.935157, 0.533818, 0.06869, 1},
   {0.933486, 0.528625, 0.0708935, 1},
   {0.931783, 0.523445, 0.0731374, 1},
   {0.930049, 0.518279, 0.075415, 1},
   {0.928284, 0.513127, 0.0777229, 1},
   {0.926488, 0.507987, 0.0800575, 1},
   {0.924661, 0.502862, 0.0824143, 1},
   {0.922803, 0.497751, 0.0847901, 1},
   {0.920914, 0.492653, 0.0871832, 1},
   {0.918994, 0.487569, 0.0895898, 1},
   {0.917043, 0.482499, 0.0920077, 1},
   {0.915061, 0.477443, 0.0944346, 1},
   {0.913049, 0.472401, 0.0968695, 1},
   {0.911006, 0.467373, 0.0993103, 1},
   {0.908932, 0.462359, 0.101755, 1},
   {0.906828, 0.45736, 0.104203, 1},
   {0.904693, 0.452375, 0.106652, 1},
   {0.902527, 0.447404, 0.109102, 1},
   {0.900332, 0.442447, 0.111551, 1},
   {0.898106, 0.437505, 0.114, 1},
   {0.895849, 0.432578, 0.116447, 1},
   {0.893563, 0.427665, 0.118891, 1},
   {0.891246, 0.422766, 0.121333, 1},
   {0.888899, 0.417883, 0.12377, 1},
   {0.886523, 0.413014, 0.126204, 1},
   {0.884116, 0.408159, 0.128634, 1},
   {0.88168, 0.40332, 0.131059, 1},
   {0.879213, 0.398495, 0.133479, 1},
   {0.876718, 0.393685, 0.135893, 1},
   {0.874192, 0.38889, 0.138303, 1},
   {0.871637, 0.384109, 0.140708, 1},
   {0.869053, 0.379344, 0.143107, 1},
   {0.866439, 0.374593, 0.1455, 1},
   {0.863796, 0.369858, 0.147888, 1},
   {0.861124, 0.365137, 0.15027, 1},
   {0.858423, 0.360431, 0.152646, 1},
   {0.855693, 0.35574, 0.155017, 1},
   {0.852934, 0.351064, 0.157382, 1},
   {0.850146, 0.346403, 0.159741, 1},
   {0.84733, 0.341757, 0.162094, 1},
   {0.844485, 0.337126, 0.164442, 1},
   {0.841612, 0.33251, 0.166785, 1},
   {0.83871, 0.327908, 0.169121, 1},
   {0.83578, 0.323321, 0.171453, 1},
   {0.832822, 0.318749, 0.173779, 1},
   {0.829835, 0.314192, 0.176099, 1},
   {0.826821, 0.309649, 0.178415, 1},
   {0.823779, 0.305121, 0.180725, 1},
   {0.82071, 0.300608, 0.18303, 1},
   {0.817612, 0.296109, 0.18533, 1},
   {0.814487, 0.291624, 0.187624, 1},
   {0.811335, 0.287154, 0.189914, 1},
   {0.808155, 0.282698, 0.192198, 1},
   {0.804948, 0.278255, 0.194478, 1},
   {0.801715, 0.273827, 0.196753, 1},
   {0.798454, 0.269413, 0.199022, 1},
   {0.795166, 0.265012, 0.201287, 1},
   {0.791851, 0.260625, 0.203547, 1},
   {0.78851, 0.256251, 0.205802, 1},
   {0.785142, 0.251891, 0.208052, 1},
   {0.781748, 0.247544, 0.210297, 1},
   {0.778327, 0.243209, 0.212537, 1},
   {0.774881, 0.238887, 0.214772, 1},
   {0.771408, 0.234578, 0.217002, 1},
   {0.767908, 0.230281, 0.219226, 1},
   {0.764383, 0.225997, 0.221446, 1},
   {0.760832, 0.221724, 0.22366, 1},
   {0.757255, 0.217462, 0.225869, 1},
   {0.753653, 0.213212, 0.228073, 1},
   {0.750025, 0.208973, 0.23027, 1},
   {0.746371, 0.204745, 0.232462, 1},
   {0.742691, 0.200527, 0.234648, 1},
   {0.738986, 0.19632, 0.236827, 1},
   {0.735256, 0.192122, 0.239001, 1},
   {0.731501, 0.187934, 0.241167, 1},
   {0.72772, 0.183755, 0.243327, 1},
   {0.723913, 0.179585, 0.24548, 1},
   {0.720082, 0.175423, 0.247626, 1},
   {0.716225, 0.17127, 0.249764, 1},
   {0.712343, 0.167123, 0.251895, 1},
   {0.708436, 0.162985, 0.254017, 1},
   {0.704504, 0.158852, 0.25613, 1},
   {0.700546, 0.154727, 0.258234, 1},
   {0.696564, 0.150607, 0.26033, 1},
   {0.692555, 0.146492, 0.262415, 1},
   {0.688522, 0.142382, 0.26449, 1},
   {0.684463, 0.138276, 0.266555, 1},
   {0.680379, 0.134175, 0.268608, 1},
   {0.676269, 0.130076, 0.270649, 1},
   {0.672134, 0.12598, 0.272678, 1},
   {0.667973, 0.121887, 0.274694, 1},
   {0.663786, 0.117795, 0.276696, 1},
   {0.659574, 0.113703, 0.278684, 1},
   {0.655335, 0.109612, 0.280657, 1},
   {0.65107, 0.105521, 0.282614, 1},
   {0.646778, 0.101429, 0.284554, 1},
   {0.64246, 0.0973356, 0.286476, 1},
   {0.638115, 0.09324, 0.288379, 1},
   {0.633743, 0.0891415, 0.290263, 1},
   {0.629343, 0.0850398, 0.292126, 1},
   {0.624916, 0.0809343, 0.293967, 1},
   {0.620462, 0.0768243, 0.295785, 1},
   {0.615978, 0.0727095, 0.297579, 1},
   {0.611467, 0.0685895, 0.299346, 1},
   {0.606927, 0.0644639, 0.301086, 1},
   {0.602357, 0.0603325, 0.302798, 1},
   {0.597758, 0.0561952, 0.304478, 1},
   {0.593128, 0.0520523, 0.306127, 1},
   {0.588469, 0.0479042, 0.307741, 1},
   {0.583778, 0.0437515, 0.309318, 1},
   {0.579056, 0.0395863, 0.310858, 1},
   {0.574303, 0.0355383, 0.312357, 1},
   {0.569517, 0.0317435, 0.313813, 1},
   {0.564698, 0.0281999, 0.315223, 1},
   {0.559846, 0.0249054, 0.316585, 1},
   {0.55496, 0.0218586, 0.317896, 1},
   {0.550039, 0.0190572, 0.319153, 1},
   {0.545084, 0.0164999, 0.320353, 1},
   {0.540094, 0.0141845, 0.321492, 1},
   {0.535067, 0.0121097, 0.322568, 1},
   {0.530004, 0.0102732, 0.323575, 1},
   {0.524904, 0.00867329, 0.324512, 1},
   {0.519767, 0.00730801, 0.325372, 1},
   {0.514592, 0.00617496, 0.326154, 1},
   {0.509379, 0.00527169, 0.326851, 1},
   {0.504128, 0.0045955, 0.327459, 1},
   {0.498838, 0.00414334, 0.327975, 1},
   {0.49351, 0.00391176, 0.328392, 1},
   {0.488143, 0.00389685, 0.328707, 1},
   {0.482737, 0.00409419, 0.328915, 1},
   {0.477294, 0.00449875, 0.32901, 1},
   {0.471812, 0.00510487, 0.328987, 1},
   {0.466293, 0.00590618, 0.328842, 1},
   {0.460738, 0.00689559, 0.328571, 1},
   {0.455146, 0.00806527, 0.328168, 1},
   {0.449521, 0.0094063, 0.327629, 1},
   {0.443862, 0.010909, 0.32695, 1},
   {0.438172, 0.0125631, 0.326128, 1},
   {0.432451, 0.0143571, 0.325158, 1},
   {0.426703, 0.0162788, 0.324038, 1},
   {0.42093, 0.0183152, 0.322767, 1},
   {0.415133, 0.0204528, 0.321341, 1},
   {0.409315, 0.0226772, 0.31976, 1},
   {0.40348, 0.0249737, 0.318022, 1},
   {0.397629, 0.0273272, 0.31613, 1},
   {0.391766, 0.0297224, 0.314082, 1},
   {0.385894, 0.0321439, 0.31188, 1},
   {0.380016, 0.0345764, 0.309526, 1},
   {0.374134, 0.037005, 0.307024, 1},
   {0.368253, 0.0394147, 0.304375, 1},
   {0.362374, 0.0417565, 0.301584, 1},
   {0.356502, 0.0439693, 0.298655, 1},
   {0.350638, 0.0460614, 0.295593, 1},
   {0.344785, 0.0480321, 0.292402, 1},
   {0.338946, 0.0498808, 0.289087, 1},
   {0.333124, 0.0516078, 0.285654, 1},
   {0.32732, 0.0532134, 0.282108, 1},
   {0.321536, 0.0546986, 0.278455, 1},
   {0.315775, 0.0560643, 0.2747, 1},
   {0.310038, 0.0573117, 0.27085, 1},
   {0.304327, 0.0584426, 0.26691, 1},
   {0.298643, 0.0594588, 0.262884, 1},
   {0.292987, 0.0603617, 0.25878, 1},
   {0.287361, 0.0611539, 0.254601, 1},
   {0.281764, 0.061837, 0.250354, 1},
   {0.276199, 0.0624134, 0.246042, 1},
   {0.270665, 0.0628854, 0.241671, 1},
   {0.265163, 0.0632551, 0.237245, 1},
   {0.259693, 0.0635247, 0.232769, 1},
   {0.254256, 0.0636966, 0.228247, 1},
   {0.248852, 0.0637729, 0.223682, 1},
   {0.243481, 0.063756, 0.219079, 1},
   {0.238142, 0.063648, 0.21444, 1},
   {0.232836, 0.0634509, 0.209769, 1},
   {0.227563, 0.0631668, 0.20507, 1},
   {0.222321, 0.0627979, 0.200345, 1},
   {0.217111, 0.0623461, 0.195597, 1},
   {0.211933, 0.0618131, 0.190828, 1},
   {0.206786, 0.0612009, 0.186041, 1},
   {0.20167, 0.0605113, 0.181237, 1},
   {0.196583, 0.0597458, 0.17642, 1},
   {0.191525, 0.058906, 0.171591, 1},
   {0.186497, 0.0579937, 0.166751, 1},
   {0.181496, 0.0570099, 0.161903, 1},
   {0.176523, 0.0559563, 0.157047, 1},
   {0.171576, 0.054834, 0.152185, 1},
   {0.166655, 0.0536444, 0.147319, 1},
   {0.161759, 0.0523882, 0.142448, 1},
   {0.156887, 0.0510668, 0.137575, 1},
   {0.152038, 0.0496809, 0.1327, 1},
   {0.147211, 0.0482316, 0.127823, 1},
   {0.142405, 0.0467194, 0.122945, 1},
   {0.13762, 0.0451451, 0.118067, 1},
   {0.132854, 0.0435092, 0.113189, 1},
   {0.128105, 0.0418123, 0.108311, 1},
   {0.123374, 0.040049, 0.103433, 1},
});

// Init the base palettes
PaletteRegistry BasePalettes(
{
   BPAL_1, BPAL_2, BPAL_3, BPAL_4, BPAL_5,
   BPAL_6, BPAL_7, BPAL_8, BPAL_9, BPAL_10,
   BPAL_11, BPAL_12, BPAL_13, BPAL_14, BPAL_15,
   BPAL_16, BPAL_17, BPAL_18, BPAL_19, BPAL_20,
   BPAL_21, BPAL_22, BPAL_23, BPAL_24, BPAL_25,
   BPAL_26, BPAL_27, BPAL_28, BPAL_29, BPAL_30,
   BPAL_31, BPAL_32, BPAL_33, BPAL_34, BPAL_35,
   BPAL_36, BPAL_37, BPAL_38, BPAL_39, BPAL_40,
   BPAL_41, BPAL_42, BPAL_43
});