enable_language(C)

set (${PYTHON}_FIND_IMPLEMENTATIONS PyPy)

if(PYTHON STREQUAL "Python")
  set(PyPy_VERSION "PyPy ${Python_REQUESTED_VERSION}")
elseif(PYTHON STREQUAL "Python2")
  set(PyPy_VERSION "PyPy2")
else()
  set(PyPy_VERSION "PyPy3")
endif()

find_package(${PYTHON} ${Python_REQUESTED_VERSION} COMPONENTS Interpreter Development)
if (NOT ${PYTHON}_FOUND)
  message (FATAL_ERROR "Failed to find Python ${PyPy_VERSION}")
endif()

if (NOT ${PYTHON}_Interpreter_FOUND)
  message (FATAL_ERROR "Failed to find Python ${PyPy_VERSION} Interpreter")
endif()
if (NOT ${PYTHON}_INTERPRETER_ID STREQUAL "PyPy")
  message (FATAL_ERROR "Erroneous interpreter ID (${${PYTHON}_INTERPRETER_ID})")
endif()

if (NOT ${PYTHON}_Development.Module_FOUND)
  message (FATAL_ERROR "Failed to find Python ${PyPy_VERSION} Development.Module")
endif()
if (NOT ${PYTHON}_Development.Embed_FOUND)
  message (FATAL_ERROR "Failed to find Python ${PyPy_VERSION} Development.Embed")
endif()
if (NOT ${PYTHON}_Development_FOUND)
  message (FATAL_ERROR "Failed to find Python ${PyPy_VERSION} Development")
endif()

if(NOT TARGET ${PYTHON}::Interpreter)
  message(SEND_ERROR "${PYTHON}::Interpreter not found")
endif()
if(NOT TARGET ${PYTHON}::Module)
  message(SEND_ERROR "${PYTHON}::Module not found")
endif()
if(NOT TARGET ${PYTHON}::Python)
  message(SEND_ERROR "${PYTHON}::Python not found")
endif()
