#ifndef GUI_QUALITY__FREQUENCYPLOTPAGE_H
#define GUI_QUALITY__FREQUENCYPLOTPAGE_H

#include "twodimensionalplotpage.h"

#include <gtkmm/togglebutton.h>

#include "controllers/frequencypagecontroller.h"

#include "../quality/statisticscollection.h"
#include "../quality/statisticsderivator.h"

class FrequencyPlotPage : public TwoDimensionalPlotPage {
 public:
  explicit FrequencyPlotPage(FrequencyPageController* controller)
      : TwoDimensionalPlotPage(controller),
        _controller(controller),
        _ftButton("FT") {}

  void addCustomPlotButtons(Gtk::Box& container) final {
    _ftButton.signal_clicked().connect(
        sigc::mem_fun(*this, &FrequencyPlotPage::onFTButtonClicked));
    container.append(_ftButton);
    _ftButton.show();
  }

 private:
  void onFTButtonClicked() {
    _controller->SetPerformFT(_ftButton.get_active());
    _controller->UpdatePlot();
  }

  FrequencyPageController* _controller;
  Gtk::ToggleButton _ftButton;
};

#endif
